/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.v7.data.Validator;
import com.vaadin.v7.data.validator.EmailValidator;
import com.vaadin.v7.ui.AbstractField;
import com.vaadin.v7.ui.TextField;
import com.vaadin.v7.ui.VerticalLayout;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.apache.commons.mail.EmailException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.gwt.CmsVfsService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.security.CmsUserLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsHasButtons;
import org.opencms.ui.Messages;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.ui.login.CmsLoginOuSelector;
import org.opencms.ui.login.CmsLoginUI;
import org.opencms.ui.login.CmsPasswordChangeNotification;
import org.opencms.ui.login.CmsTokenValidator;
import org.opencms.util.CmsStringUtil;

public class CmsForgotPasswordDialog
extends VerticalLayout
implements I_CmsHasButtons {
    private static final Log LOG = CmsLog.getLog(CmsForgotPasswordDialog.class);
    private static final long serialVersionUID = 1L;
    protected TextField m_emailField;
    protected TextField m_userField;
    protected CmsLoginOuSelector m_ouSelect;
    protected Button m_mailButton;
    protected Button m_cancelButton;

    public CmsForgotPasswordDialog() {
        Locale locale = A_CmsUI.get().getLocale();
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, OpenCms.getWorkplaceManager().getMessages(locale), null);
        List<CmsOrganizationalUnit> ouList = CmsLoginHelper.getOrgUnitsForLoginDialog(A_CmsUI.getCmsObject(), null);
        this.m_ouSelect.initOrgUnits(ouList, false);
        String notEmptyMessage = CmsVaadinUtils.getMessageText("GUI_VALIDATION_FIELD_EMPTY_0", new Object[0]);
        this.m_userField.setRequired(true);
        this.m_userField.setRequiredError(notEmptyMessage);
        this.m_emailField.setRequired(true);
        this.m_emailField.setRequiredError(notEmptyMessage);
        this.m_emailField.addValidator((Validator)new EmailValidator(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_INVALID_EMAIL_0")));
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsForgotPasswordDialog.this.cancel();
            }
        });
        this.m_mailButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                boolean valid = true;
                for (AbstractField abstractField : Arrays.asList(CmsForgotPasswordDialog.this.m_userField, CmsForgotPasswordDialog.this.m_emailField)) {
                    try {
                        abstractField.validate();
                    }
                    catch (Validator.InvalidValueException e) {
                        valid = false;
                    }
                }
                if (!valid) {
                    return;
                }
                String selectedOu = CmsForgotPasswordDialog.this.m_ouSelect.getValue();
                selectedOu = selectedOu != null ? selectedOu : "";
                String string = CmsStringUtil.joinPaths(selectedOu, (String)CmsForgotPasswordDialog.this.m_userField.getValue());
                if (CmsForgotPasswordDialog.sendPasswordResetLink(CmsLoginUI.m_adminCms, string, (String)CmsForgotPasswordDialog.this.m_emailField.getValue())) {
                    CmsUserLog.logPasswordResetRequest(A_CmsUI.getCmsObject(), string);
                    CmsVaadinUtils.showAlert(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_MAILSENT_HEADER_0"), Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_MAILSENT_MESSAGE_0"), new Runnable(){

                        @Override
                        public void run() {
                            A_CmsUI.get().getPage().setLocation(OpenCms.getLinkManager().substituteLinkForUnknownTarget(CmsLoginUI.m_adminCms, "/system/login", false));
                        }
                    });
                }
            }
        });
    }

    public static boolean sendPasswordResetLink(CmsObject cms, String fullUserName, String email) {
        LOG.info((Object)("Trying to find user for email " + email));
        email = email.trim();
        try {
            CmsUser foundUser = null;
            try {
                foundUser = cms.readUser(fullUserName);
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (foundUser == null || CmsStringUtil.isEmptyOrWhitespaceOnly(email) || !email.equals(foundUser.getEmail()) || foundUser.isManaged() || foundUser.isWebuser()) {
                Notification.show((String)CmsVaadinUtils.getMessageText("GUI_PWCHANGE_EMAIL_MISMATCH_0", new Object[0]), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                return false;
            }
            long now = System.currentTimeMillis();
            long expiration = OpenCms.getLoginManager().getTokenLifetime() + now;
            String expirationStr = CmsVfsService.formatDateTime(cms, expiration);
            String token = CmsTokenValidator.createToken(cms, foundUser, now);
            String link = OpenCms.getLinkManager().getWorkplaceLink(cms, "/system/login", false) + "?at=" + token;
            LOG.info((Object)("Sending password reset link to user " + foundUser.getName() + ": " + link));
            CmsPasswordChangeNotification notification = new CmsPasswordChangeNotification(cms, foundUser, link, expirationStr);
            try {
                notification.send();
            }
            catch (EmailException e) {
                Notification.show((String)Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_MAIL_SEND_ERROR_0"), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            Notification.show((String)e.getLocalizedMessage(), (Notification.Type)Notification.Type.ERROR_MESSAGE);
            return false;
        }
        return true;
    }

    public void cancel() {
        CmsObject cms = A_CmsUI.getCmsObject();
        String link = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, "/system/login", false);
        A_CmsUI.get().getPage().setLocation(link);
    }

    @Override
    public List<Button> getButtons() {
        return Arrays.asList(this.m_mailButton, this.m_cancelButton);
    }
}

