/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.server.Page;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinServletRequest;
import com.vaadin.server.VaadinServletResponse;
import com.vaadin.ui.Component;
import com.vaadin.ui.UI;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.db.CmsLoginMessage;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsUser;
import org.opencms.i18n.CmsMessageContainer;
import org.opencms.i18n.CmsResourceBundleLoader;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.jsp.CmsJspLoginBean;
import org.opencms.main.CmsBroadcast;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsCustomLoginException;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsUserLog;
import org.opencms.ui.A_CmsDialogContext;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.Messages;
import org.opencms.ui.apps.CmsAppWorkplaceUi;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.dialogs.CmsUserDataDialog;
import org.opencms.ui.login.CmsChangePasswordDialog;
import org.opencms.ui.login.CmsInactiveUserMessages;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.ui.login.CmsLoginUI;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsLoginUserAgreement;
import org.opencms.workplace.CmsWorkplaceSettings;

public class CmsLoginController {
    public static final String KEY_ACCOUNT_LOCKED = "accountLocked";
    private static final Log LOG = CmsLog.getLog(CmsLoginController.class);
    CmsLoginUI m_ui;
    private CmsObject m_adminCms;
    private CmsLoginHelper.LoginParameters m_params;

    public CmsLoginController(CmsObject adminCms, CmsLoginHelper.LoginParameters params) {
        this.m_params = params;
        this.m_adminCms = adminCms;
    }

    public static String getFormLink(CmsObject cms) {
        return OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, "/system/login", false);
    }

    public static String getLoginTarget(CmsObject currentCms, CmsWorkplaceSettings settings, String requestedResource) throws CmsException {
        String directEditPath = CmsLoginHelper.getDirectEditPath(currentCms, settings.getUserSettings(), false);
        String target = "";
        boolean checkRole = false;
        String fragment = UI.getCurrent() != null ? UI.getCurrent().getPage().getUriFragment() : "";
        boolean workplace2 = false;
        if (requestedResource == null && directEditPath != null) {
            target = directEditPath;
        } else if (requestedResource != null && !"/system/workplace/views/workplace.jsp".equals(requestedResource)) {
            target = requestedResource;
        } else {
            workplace2 = true;
            target = CmsVaadinUtils.getWorkplaceLink();
            checkRole = true;
        }
        UserAgreementHelper userAgreementHelper = new UserAgreementHelper(currentCms, settings);
        boolean showUserAgreement = userAgreementHelper.isShowUserAgreement();
        if (showUserAgreement) {
            target = userAgreementHelper.getConfigurationVfsPath() + "?" + "wpres" + "=" + target;
        }
        if (checkRole && !OpenCms.getRoleManager().hasRole(currentCms, CmsRole.WORKPLACE_USER)) {
            workplace2 = false;
            target = CmsLoginHelper.getDirectEditPath(currentCms, settings.getUserSettings(), true);
            if (target == null) {
                throw new CmsCustomLoginException(org.opencms.workplace.Messages.get().container("GUI_LOGIN_FAILED_NO_WORKPLACE_PERMISSIONS_0"));
            }
        }
        if (!workplace2) {
            target = OpenCms.getLinkManager().substituteLink(currentCms, target);
        }
        if (workplace2 && CmsStringUtil.isEmptyOrWhitespaceOnly(fragment)) {
            if (settings.getUserSettings().getStartView().startsWith("/")) {
                if ("/system/workplace/views/explorer/explorer_fs.jsp".equals(settings.getUserSettings().getStartView())) {
                    fragment = "explorer";
                } else if ("/system/workplace/views/admin/admin-fs.jsp".equals(settings.getUserSettings().getStartView())) {
                    fragment = "launchpad";
                }
            } else {
                fragment = settings.getUserSettings().getStartView();
            }
        }
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(fragment)) {
            target = "sitemapeditor".equals(fragment) ? OpenCms.getLinkManager().substituteLink(currentCms, "/system/workplace/commons/sitemap.jsp") + "?path=" + settings.getUserSettings().getStartFolder() : target + "#" + fragment;
        }
        return target;
    }

    public static void logout() {
        CmsObject cms = A_CmsUI.getCmsObject();
        if (UI.getCurrent() instanceof CmsAppWorkplaceUi) {
            ((CmsAppWorkplaceUi)UI.getCurrent()).onWindowClose();
        }
        String loggedInUser = cms.getRequestContext().getCurrentUser().getName();
        UI.getCurrent().getSession().close();
        String logoutUri = OpenCms.getLoginManager().getLogoutUri();
        if (logoutUri != null) {
            String target = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, logoutUri, false);
            Page.getCurrent().open(target, "_top", false);
        } else {
            String loginLink = OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, "/system/login", false);
            VaadinService.getCurrentRequest().getWrappedSession().invalidate();
            Page.getCurrent().setLocation(loginLink);
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)org.opencms.jsp.Messages.get().getBundle().key("LOG_LOGOUT_SUCCESFUL_3", loggedInUser, "{workplace logout option}", cms.getRequestContext().getRemoteAddress()));
            }
            CmsUserLog.logLogout(cms);
        }
    }

    public static void logout(CmsObject cms, HttpServletRequest request, HttpServletResponse response) throws IOException {
        CmsUserLog.logLogout(cms);
        String loggedInUser = cms.getRequestContext().getCurrentUser().getName();
        HttpSession session = request.getSession(false);
        String logoutUri = OpenCms.getLoginManager().getLogoutUri();
        if (logoutUri == null) {
            if (session != null) {
                session.invalidate();
                cms.getRequestContext().setUpdateSessionEnabled(false);
            }
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)org.opencms.jsp.Messages.get().getBundle().key("LOG_LOGOUT_SUCCESFUL_3", loggedInUser, cms.getRequestContext().addSiteRoot(cms.getRequestContext().getUri()), cms.getRequestContext().getRemoteAddress()));
            }
            response.sendRedirect(CmsLoginController.getFormLink(cms));
        } else {
            response.sendRedirect(OpenCms.getLinkManager().substituteLinkForUnknownTarget(cms, logoutUri, false));
        }
    }

    public String getPcType() {
        String result = this.m_params.getPcType();
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(result)) {
            result = "public";
        }
        return result;
    }

    public String getResetPasswordLink() {
        return OpenCms.getLinkManager().substituteLinkForUnknownTarget(CmsLoginUI.m_adminCms, "/system/login", false) + "?" + "reset";
    }

    public boolean isShowSecure() {
        return OpenCms.getLoginManager().isEnableSecurity();
    }

    public void onClickForgotPassword() {
        A_CmsUI.get().getPage().setLocation(this.getResetPasswordLink());
    }

    public void onClickLogin() {
        String ou;
        String user = this.m_ui.getUser();
        String password = this.m_ui.getPassword();
        CmsMessageContainer message = CmsLoginHelper.validateUserAndPasswordNotEmpty(user, password);
        CmsLoginMessage loginMessage = OpenCms.getLoginManager().getLoginMessage();
        String storedMessage = null;
        CmsBroadcast.ContentMode messageMode = CmsBroadcast.ContentMode.html;
        if (loginMessage != null && !loginMessage.isLoginCurrentlyForbidden() && loginMessage.isActive()) {
            storedMessage = loginMessage.getMessage();
        }
        if ("OU_NONE".equals(ou = this.m_ui.getOrgUnit())) {
            this.displayError(CmsVaadinUtils.getMessageText("GUI_LOGIN_NO_OU_SELECTED_WARNING_0", new Object[0]) + "\n\n", false, false);
            return;
        }
        if (message != null) {
            String errorMessage = message.key(this.m_params.getLocale());
            this.displayError(errorMessage, true, false);
            return;
        }
        String realUser = CmsStringUtil.joinPaths(ou, user);
        String pcType = this.m_ui.getPcType();
        CmsObject currentCms = A_CmsUI.getCmsObject();
        CmsUser userObj = null;
        try {
            try {
                userObj = currentCms.readUser(realUser);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                message = org.opencms.workplace.Messages.get().container("GUI_LOGIN_FAILED_0");
                this.displayError(message.key(this.m_params.getLocale()), true, true);
                CmsUserLog.logLoginFailure(currentCms, realUser);
                return;
            }
            if (OpenCms.getLoginManager().canLockBecauseOfInactivity(currentCms, userObj)) {
                boolean locked;
                boolean bl = locked = null != userObj.getAdditionalInfo().get(KEY_ACCOUNT_LOCKED);
                if (locked) {
                    this.displayError(CmsInactiveUserMessages.getLockoutText(A_CmsUI.get().getLocale()), false, false);
                    CmsUserLog.logLoginFailure(currentCms, realUser);
                    return;
                }
            }
            CmsObject cloneCms = OpenCms.initCmsObject(currentCms);
            cloneCms.loginUser(realUser, password);
            String messageToChange = "";
            if (OpenCms.getLoginManager().isPasswordReset(currentCms, userObj)) {
                messageToChange = CmsVaadinUtils.getMessageText("GUI_PWCHANGE_RESET_0", new Object[0]);
            }
            if (OpenCms.getLoginManager().requiresPasswordChange(currentCms, userObj)) {
                messageToChange = this.getPasswordChangeMessage();
            }
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(messageToChange)) {
                CmsChangePasswordDialog passwordDialog = new CmsChangePasswordDialog(currentCms, userObj, A_CmsUI.get().getLocale());
                passwordDialog.setAdditionalMessage(messageToChange);
                A_CmsUI.get().setContentToDialog(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_HEADER_0") + userObj.getSimpleName(), passwordDialog);
                return;
            }
            CmsWorkplaceSettings settings = CmsLoginHelper.initSiteAndProject(cloneCms);
            final String loginTarget = CmsLoginController.getLoginTarget(cloneCms, settings, this.m_params.getRequestedResource());
            HttpSession session = ((HttpServletRequest)VaadinService.getCurrentRequest()).getSession(false);
            if (session != null) {
                session.invalidate();
            }
            session = ((HttpServletRequest)VaadinService.getCurrentRequest()).getSession(true);
            currentCms.loginUser(realUser, password);
            CmsUserLog.logLogin(currentCms, realUser);
            if (LOG.isInfoEnabled()) {
                CmsRequestContext context = currentCms.getRequestContext();
                LOG.info((Object)org.opencms.jsp.Messages.get().getBundle().key("LOG_LOGIN_SUCCESSFUL_3", context.getCurrentUser().getName(), "{workplace login dialog}", context.getRemoteAddress()));
            }
            settings = CmsLoginHelper.initSiteAndProject(currentCms);
            OpenCms.getSessionManager().updateSessionInfo(currentCms, (HttpServletRequest)VaadinService.getCurrentRequest());
            if (loginMessage != null && loginMessage.isLoginCurrentlyForbidden()) {
                if (loginMessage.getTimeEnd() == CmsLoginMessage.DEFAULT_TIME_END) {
                    storedMessage = org.opencms.workplace.Messages.get().container("GUI_LOGIN_SUCCESS_WITH_MESSAGE_WITHOUT_TIME_1", loginMessage.getMessage(), new Date(loginMessage.getTimeEnd())).key(A_CmsUI.get().getLocale());
                    messageMode = CmsBroadcast.ContentMode.html;
                } else {
                    storedMessage = org.opencms.workplace.Messages.get().container("GUI_LOGIN_SUCCESS_WITH_MESSAGE_2", loginMessage.getMessage(), new Date(loginMessage.getTimeEnd())).key(A_CmsUI.get().getLocale());
                    messageMode = CmsBroadcast.ContentMode.html;
                }
            }
            if (storedMessage != null) {
                OpenCms.getSessionManager().sendBroadcast(null, storedMessage, currentCms.getRequestContext().getCurrentUser(), messageMode);
            }
            CmsLoginHelper.setCookieData(pcType, user, ou, (HttpServletRequest)((VaadinServletRequest)VaadinService.getCurrentRequest()), (HttpServletResponse)((VaadinServletResponse)VaadinService.getCurrentResponse()));
            VaadinService.getCurrentRequest().getWrappedSession().setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)settings);
            final boolean isPublicPC = "public".equals(pcType);
            if (OpenCms.getLoginManager().requiresUserDataCheck(currentCms, userObj)) {
                A_CmsDialogContext context = new A_CmsDialogContext("", I_CmsDialogContext.ContextType.appToolbar, null){

                    @Override
                    public void finish(CmsProject project, String siteRoot) {
                        this.finish(null);
                    }

                    @Override
                    public void finish(Collection<CmsUUID> result) {
                        CmsLoginController.this.m_ui.openLoginTarget(loginTarget, isPublicPC);
                    }

                    @Override
                    public void focus(CmsUUID structureId) {
                    }

                    @Override
                    public List<CmsUUID> getAllStructureIdsInView() {
                        return null;
                    }

                    @Override
                    public void start(String title, Component dialog, CmsBasicDialog.DialogWidth style) {
                        if (dialog != null) {
                            this.m_window = CmsBasicDialog.prepareWindow(style);
                            this.m_window.setCaption(title);
                            this.m_window.setContent(dialog);
                            UI.getCurrent().addWindow(this.m_window);
                            if (dialog instanceof CmsBasicDialog) {
                                ((CmsBasicDialog)dialog).initActionHandler(this.m_window);
                            }
                        }
                    }

                    @Override
                    public void updateUserInfo() {
                    }
                };
                CmsUser u = currentCms.readUser(userObj.getId());
                u.setAdditionalInfo("ADDITIONAL_INFO_LAST_USER_DATA_CHECK", Long.toString(System.currentTimeMillis()));
                currentCms.writeUser(u);
                CmsUserDataDialog dialog = new CmsUserDataDialog(context, true);
                context.start(dialog.getTitle(UI.getCurrent().getLocale()), (Component)dialog);
            } else {
                this.m_ui.openLoginTarget(loginTarget, isPublicPC);
            }
        }
        catch (Exception e) {
            if (e instanceof CmsException) {
                CmsLoginMessage loginMessage2;
                CmsMessageContainer exceptionMessage = ((CmsException)e).getMessageContainer();
                if ("ERR_LOGIN_FAILED_DISABLED_2" == exceptionMessage.getKey()) {
                    message = org.opencms.workplace.Messages.get().container("GUI_LOGIN_FAILED_DISABLED_0");
                } else if ("ERR_LOGIN_FAILED_TEMP_DISABLED_4" == exceptionMessage.getKey()) {
                    message = org.opencms.workplace.Messages.get().container("GUI_LOGIN_FAILED_TEMP_DISABLED_0");
                } else if ("ERR_LOGIN_FAILED_WITH_MESSAGE_1" == exceptionMessage.getKey() && (loginMessage2 = OpenCms.getLoginManager().getLoginMessage()) != null) {
                    message = org.opencms.workplace.Messages.get().container("GUI_LOGIN_FAILED_WITH_MESSAGE_1", loginMessage2.getMessage().replace("\n", ""));
                }
            }
            if (message == null) {
                if (e instanceof CmsCustomLoginException) {
                    message = ((CmsCustomLoginException)e).getMessageContainer();
                } else {
                    message = org.opencms.workplace.Messages.get().container("GUI_LOGIN_FAILED_0");
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    this.displayError(message.key(this.m_params.getLocale()), true, true);
                    return;
                }
            }
            if (e instanceof CmsException) {
                CmsJspLoginBean.logLoginException(currentCms.getRequestContext(), user, (CmsException)e);
                CmsUserLog.logLoginFailure(currentCms, user);
            } else {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            this.displayError(message.key(this.m_params.getLocale()), false, false);
            return;
        }
    }

    public void onInit() {
        String authToken = this.m_params.getAuthToken();
        if (authToken != null) {
            this.m_ui.showForgotPasswordView(authToken);
        } else if (this.m_params.isReset()) {
            this.m_ui.showPasswordResetDialog();
        } else {
            boolean loggedIn = !A_CmsUI.getCmsObject().getRequestContext().getCurrentUser().isGuestUser();
            this.m_ui.setSelectableOrgUnits(CmsLoginHelper.getOrgUnitsForLoginDialog(A_CmsUI.getCmsObject(), null));
            if (loggedIn) {
                if (this.m_params.isLogout()) {
                    CmsLoginController.logout();
                } else {
                    this.m_ui.showAlreadyLoggedIn();
                }
            } else {
                this.m_ui.showLoginView(this.m_params.getOufqn());
            }
        }
    }

    public void setUi(CmsLoginUI ui) {
        this.m_ui = ui;
    }

    protected String getPasswordChangeMessage() {
        ResourceBundle bundle = null;
        try {
            bundle = CmsResourceBundleLoader.getBundle("org.opencms.passwordchange.custom", A_CmsUI.get().getLocale());
            return bundle.getString("passwordchange.text");
        }
        catch (MissingResourceException e) {
            return CmsVaadinUtils.getMessageText("GUI_PWCHANGE_INTERVAL_EXPIRED_0", new Object[0]);
        }
    }

    CmsObject getCms() {
        return this.m_adminCms;
    }

    private void displayError(String message, boolean showForgotPassword, boolean showTime) {
        message = message.replace("\n", "<br />");
        if (showForgotPassword) {
            message = message + "<br /><br /><a href=\"" + this.getResetPasswordLink() + "\">" + CmsVaadinUtils.getMessageText("GUI_FORGOT_PASSWORD_0", new Object[0]) + "</a>";
        }
        if (showTime) {
            SimpleDateFormat sdf = new SimpleDateFormat("HH:mm:ss");
            message = message + "<div style=\"position:absolute;right:6px;bottom:5px;\">" + CmsVaadinUtils.getMessageText("GUI_TIME_1", sdf.format(new Date())) + "</div>";
        }
        this.m_ui.showLoginError(message);
    }

    protected static class UserAgreementHelper
    extends CmsLoginUserAgreement {
        private CmsObject m_cms;
        private CmsWorkplaceSettings m_wpSettings;

        public UserAgreementHelper(CmsObject cms, CmsWorkplaceSettings wpSettings) {
            super(null);
            this.m_cms = cms;
            this.m_wpSettings = wpSettings;
            this.initAcceptData();
        }

        @Override
        public CmsObject getCms() {
            return this.m_cms;
        }

        @Override
        public CmsWorkplaceSettings getSettings() {
            return this.m_wpSettings;
        }

        @Override
        protected void initWorkplaceMembers(CmsJspActionElement jsp) {
        }
    }

    public static class CmsLoginTargetInfo {
        private String m_password;
        private String m_target;
        private String m_user;

        public CmsLoginTargetInfo(String target, String user, String password) {
            this.m_target = target;
            this.m_user = user;
            this.m_password = password;
        }

        public String getPassword() {
            return this.m_password;
        }

        public String getTarget() {
            return this.m_target;
        }

        public String getUser() {
            return this.m_user;
        }
    }
}

