/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.annotations.Theme;
import com.vaadin.server.ErrorHandler;
import com.vaadin.server.VaadinRequest;
import com.vaadin.server.VaadinService;
import com.vaadin.server.VaadinSession;
import com.vaadin.shared.Version;
import com.vaadin.ui.AbstractComponent;
import com.vaadin.ui.Alignment;
import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.ui.Notification;
import com.vaadin.ui.Window;
import com.vaadin.v7.ui.Label;
import com.vaadin.v7.ui.VerticalLayout;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.opencms.crypto.CmsEncryptionException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.flex.CmsFlexController;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsOrganizationalUnit;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinErrorHandler;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.Messages;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.extensions.CmsPollServerExtension;
import org.opencms.ui.login.CmsForgotPasswordDialog;
import org.opencms.ui.login.CmsLoginController;
import org.opencms.ui.login.CmsLoginForm;
import org.opencms.ui.login.CmsLoginHelper;
import org.opencms.ui.login.CmsLoginTargetOpener;
import org.opencms.ui.login.CmsSetPasswordDialog;
import org.opencms.ui.login.CmsTokenValidator;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;

@Theme(value="opencms")
public class CmsLoginUI
extends A_CmsUI {
    public static final String INIT_DATA_SESSION_ATTR = "CmsLoginUI_initData";
    static CmsObject m_adminCms;
    private static final Log LOG;
    private static final long serialVersionUID = 1L;
    private CmsLoginController m_controller;
    private CmsLoginForm m_loginForm;
    private CmsLoginTargetOpener m_targetOpener;

    public static String displayVaadinLoginDialog(HttpServletRequest request, HttpServletResponse response) throws IOException, CmsException {
        CmsFlexController controller = CmsFlexController.getController((ServletRequest)request);
        if (controller == null) {
            throw new CmsRuntimeException(org.opencms.jsp.Messages.get().container("ERR_MISSING_CMS_CONTROLLER_1", CmsLoginUI.class.getName()));
        }
        CmsRequestUtil.disableCrossSiteFrameEmbedding(response);
        CmsObject cms = controller.getCmsObject();
        if (OpenCms.getSiteManager().getSites().size() > 1 && !OpenCms.getSiteManager().isWorkplaceRequest(request)) {
            response.sendError(404);
            return null;
        }
        String logout = request.getParameter("logout");
        if (Boolean.valueOf(logout).booleanValue()) {
            CmsLoginController.logout(cms, request, response);
            return null;
        }
        if (!cms.getRequestContext().getCurrentUser().isGuestUser()) {
            String encryptedTarget = request.getParameter("loginRedirect");
            String target = null;
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(encryptedTarget)) {
                target = CmsLoginController.getLoginTarget(cms, CmsLoginUI.getWorkplaceSettings(cms, request.getSession()), null);
            } else {
                try {
                    target = OpenCms.getDefaultTextEncryption().decrypt(encryptedTarget);
                }
                catch (CmsEncryptionException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
            response.sendRedirect(target);
            return null;
        }
        CmsLoginHelper.LoginParameters params = CmsLoginHelper.getLoginParameters(cms, request, false);
        request.getSession().setAttribute(INIT_DATA_SESSION_ATTR, (Object)params);
        try {
            byte[] pageBytes = CmsFileUtil.readFully(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/opencms/ui/login/login-page.html"));
            String page = new String(pageBytes, "UTF-8");
            CmsMacroResolver resolver = new CmsMacroResolver();
            String context = OpenCms.getSystemInfo().getContextPath();
            String vaadinDir = CmsStringUtil.joinPaths(context, "VAADIN/");
            String vaadinVersion = Version.getFullVersion();
            String vaadinServlet = CmsStringUtil.joinPaths(context, "workplace/dialogs/");
            String vaadinBootstrap = CmsStringUtil.joinPaths(context, "VAADIN/vaadinBootstrap.js?v=" + OpenCms.getSystemInfo().getVersionNumber());
            String autocomplete = params.isPrivatePc() ? "on" : "off";
            StringBuffer workplaceCssBuffer = null;
            if (!OpenCms.getWorkplaceAppManager().getWorkplaceCssUris().isEmpty()) {
                workplaceCssBuffer = new StringBuffer();
                workplaceCssBuffer.append("\n<style type=\"text/css\">\n");
                for (String cssURI : OpenCms.getWorkplaceAppManager().getWorkplaceCssUris()) {
                    workplaceCssBuffer.append("@import url(\"").append(CmsWorkplace.getResourceUri(cssURI)).append("\");\n");
                }
                workplaceCssBuffer.append("</style>\n");
            }
            String cmsLogo = OpenCms.getSystemInfo().getContextPath() + "/resources/" + "commons/login_logo.png";
            resolver.addMacro("workplaceCss", workplaceCssBuffer != null ? workplaceCssBuffer.toString() : "");
            resolver.addMacro("loadingHtml", "<div class='o-loading-indicator opencms-font'><div class=\"oc-spin-center\">\n<span class=\"oc-spinner-bg\"></span>\n<span class=\"oc-spinner oc-spin-outer\"></span><br>\n<span class=\"oc-spinner-circle oc-spin-inner\"></span><br>\n<span class=\"oc-spinner-dots oc-spin-dots\"></span>\n</div></div>");
            resolver.addMacro("vaadinDir", vaadinDir);
            resolver.addMacro("vaadinVersion", vaadinVersion);
            resolver.addMacro("vaadinServlet", vaadinServlet);
            resolver.addMacro("vaadinBootstrap", vaadinBootstrap);
            resolver.addMacro("cmsLogo", cmsLogo);
            resolver.addMacro("autocomplete", autocomplete);
            resolver.addMacro("title", CmsLoginHelper.getTitle(params.getLocale()));
            if (params.isPrivatePc()) {
                resolver.addMacro("hiddenPasswordField", "      <input type=\"password\" id=\"hidden-password\" name=\"ocPword\" autocomplete=\"%(autocomplete)\" >");
            }
            if (params.getUsername() != null) {
                resolver.addMacro("predefUser", "value=\"" + CmsEncoder.escapeXml(params.getUsername()) + "\"");
            }
            page = resolver.resolveMacros(page);
            return page;
        }
        catch (Exception e) {
            LOG.error((Object)"Failed to display login dialog.", (Throwable)e);
            return "<!--Error-->";
        }
    }

    public static String generateLoginHtmlFragment(CmsObject cms, VaadinRequest request) throws IOException {
        CmsLoginHelper.LoginParameters parameters = CmsLoginHelper.getLoginParameters(cms, (HttpServletRequest)request, true);
        request.getWrappedSession().setAttribute(INIT_DATA_SESSION_ATTR, (Object)parameters);
        byte[] pageBytes = CmsFileUtil.readFully(Thread.currentThread().getContextClassLoader().getResourceAsStream("org/opencms/ui/login/login-fragment.html"));
        String html = new String(pageBytes, "UTF-8");
        String autocomplete = parameters.getPcType() == null || parameters.getPcType().equals("private") ? "on" : "off";
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.addMacro("autocompplete", autocomplete);
        if (parameters.getPcType() == null || parameters.getPcType().equals("private")) {
            resolver.addMacro("hiddenPasswordField", "      <input type=\"password\" id=\"hidden-password\" name=\"ocPword\" autocomplete=\"%(autocomplete)\" >");
        }
        if (parameters.getUsername() != null) {
            resolver.addMacro("predefUser", "value=\"" + CmsEncoder.escapeXml(parameters.getUsername()) + "\"");
        }
        html = resolver.resolveMacros(html);
        return html;
    }

    public static void setAdminCmsObject(CmsObject cms) {
        m_adminCms = cms;
    }

    private static CmsWorkplaceSettings getWorkplaceSettings(CmsObject cms, HttpSession session) {
        CmsWorkplaceSettings settings = (CmsWorkplaceSettings)session.getAttribute("__CmsWorkplace.WORKPLACE_SETTINGS");
        if (settings == null) {
            settings = CmsLoginHelper.initSiteAndProject(cms);
            if (VaadinService.getCurrentRequest() != null) {
                VaadinService.getCurrentRequest().getWrappedSession().setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)settings);
            } else {
                session.setAttribute("__CmsWorkplace.WORKPLACE_SETTINGS", (Object)settings);
            }
        }
        return settings;
    }

    public String getOrgUnit() {
        String result = this.m_loginForm.getOrgUnit();
        if (result == null) {
            result = "";
        }
        return result;
    }

    public String getPassword() {
        return this.m_loginForm.getPassword();
    }

    public String getPcType() {
        String result = this.m_loginForm.getPcType();
        if (result == null) {
            result = "public";
        }
        return result;
    }

    public String getUser() {
        return this.m_loginForm.getUser();
    }

    public void openLoginTarget(String loginTarget, boolean isPublicPC) {
        VaadinService.getCurrentRequest().getWrappedSession().removeAttribute(INIT_DATA_SESSION_ATTR);
        this.m_targetOpener.openTarget(loginTarget, isPublicPC);
    }

    public void setSelectableOrgUnits(List<CmsOrganizationalUnit> ous) {
        this.m_loginForm.setSelectableOrgUnits(ous);
    }

    public void showAlreadyLoggedIn() {
        Notification.show((String)"You are already logged in");
    }

    public void showForgotPasswordView(String authToken) {
        try {
            CmsTokenValidator validator = new CmsTokenValidator();
            String validationResult = validator.validateToken(A_CmsUI.getCmsObject(), authToken, OpenCms.getLoginManager().getTokenLifetime());
            if (validationResult == null) {
                CmsUser user = validator.getUser();
                if (!user.isManaged()) {
                    CmsSetPasswordDialog dlg = new CmsSetPasswordDialog(m_adminCms, user, this.getLocale());
                    A_CmsUI.get().setContentToDialog(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_HEADER_0") + user.getName(), dlg);
                } else {
                    Notification.show((String)CmsVaadinUtils.getMessageText("ERR_USER_NOT_SELF_MANAGED_1", user.getName()), (Notification.Type)Notification.Type.ERROR_MESSAGE);
                }
            } else {
                A_CmsUI.get().setError(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_INVALID_TOKEN_0"));
                LOG.info((Object)("Invalid authorization token: " + authToken + " / " + validationResult));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public void showLoginError(String messageHtml) {
        this.m_loginForm.displayError(messageHtml);
        this.m_loginForm.resetPassword();
    }

    public void showLoginView(String preselectedOu) {
        VerticalLayout content = new VerticalLayout();
        content.setSizeFull();
        this.m_targetOpener = new CmsLoginTargetOpener(A_CmsUI.get());
        content.addComponent((Component)this.m_loginForm);
        content.setComponentAlignment((Component)this.m_loginForm, Alignment.MIDDLE_CENTER);
        content.setExpandRatio((Component)this.m_loginForm, 1.0f);
        this.setContent((Component)content);
        this.m_loginForm.selectOrgUnit(preselectedOu);
    }

    public void showPasswordResetDialog() {
        String caption = CmsVaadinUtils.getMessageText("GUI_PWCHANGE_FORGOT_PASSWORD_0", new Object[0]);
        A_CmsUI r = A_CmsUI.get();
        r.setContent((Component)new Label());
        Window window = CmsBasicDialog.prepareWindow(CmsBasicDialog.DialogWidth.narrow);
        CmsBasicDialog dialog = new CmsBasicDialog();
        VerticalLayout result = new VerticalLayout();
        dialog.setContent((Component)result);
        window.setContent((Component)dialog);
        window.setCaption(caption);
        window.setClosable(true);
        final CmsForgotPasswordDialog forgotPassword = new CmsForgotPasswordDialog();
        window.addCloseListener(new Window.CloseListener(){
            private static final long serialVersionUID = 1L;

            public void windowClose(Window.CloseEvent e) {
                forgotPassword.cancel();
            }
        });
        for (Button button : forgotPassword.getButtons()) {
            dialog.addButton((Component)button);
        }
        r.addWindow(window);
        window.center();
        VerticalLayout vl = result;
        vl.addComponent((Component)forgotPassword);
    }

    @Override
    protected void init(VaadinRequest request) {
        this.addStyleName("login-dialog");
        CmsLoginHelper.LoginParameters params = (CmsLoginHelper.LoginParameters)request.getWrappedSession().getAttribute(INIT_DATA_SESSION_ATTR);
        if (params == null) {
            params = CmsLoginHelper.getLoginParameters(CmsLoginUI.getCmsObject(), (HttpServletRequest)request, true);
            request.getWrappedSession().setAttribute(INIT_DATA_SESSION_ATTR, (Object)params);
        }
        VaadinSession.getCurrent().setErrorHandler((ErrorHandler)new CmsVaadinErrorHandler());
        this.m_controller = new CmsLoginController(m_adminCms, params);
        this.m_controller.setUi(this);
        this.setLocale(params.getLocale());
        this.m_loginForm = new CmsLoginForm(this.m_controller, params.getLocale());
        this.m_controller.onInit();
        this.getPage().setTitle("OpenCms - " + CmsVaadinUtils.getMessageText("GUI_LOGIN_HEADLINE_0", new Object[0]));
        new CmsPollServerExtension((AbstractComponent)this);
    }

    static {
        LOG = CmsLog.getLog(CmsLoginUI.class);
    }

    public static class Parameters
    implements Serializable {
        private static final long serialVersionUID = -4885232184680664315L;
        public Locale m_locale;
        public String m_pcType;
        public String m_preselectedOu;
        public String m_requestedResource;
        public String m_requestedWorkplaceApp;

        public Parameters(String pcType, String preselectedOu, Locale locale, String requestedResource, String requestedWorkplaceApp) {
            this.m_pcType = pcType;
            this.m_preselectedOu = preselectedOu;
            this.m_locale = locale;
            this.m_requestedResource = requestedResource;
            this.m_requestedWorkplaceApp = requestedWorkplaceApp;
        }

        public Locale getLocale() {
            return this.m_locale;
        }

        public String getPcType() {
            return this.m_pcType;
        }

        public String getPreselectedOu() {
            return this.m_preselectedOu;
        }

        public String getRequestedResource() {
            return this.m_requestedResource;
        }

        public String getRequestedWorkplaceApp() {
            return this.m_requestedWorkplaceApp;
        }
    }
}

