/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.login;

import com.vaadin.server.UserError;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsUser;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsUserLog;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.Messages;
import org.opencms.ui.login.CmsChangePasswordDialog;
import org.opencms.ui.login.CmsLoginUI;
import org.opencms.ui.login.CmsTokenValidator;

public class CmsSetPasswordDialog
extends CmsChangePasswordDialog {
    private static final Log LOG = CmsLog.getLog(CmsSetPasswordDialog.class);
    private static final long serialVersionUID = 1L;

    public CmsSetPasswordDialog(CmsObject cms, CmsUser user, Locale locale) {
        super(cms, user, locale);
        this.m_form.hideOldPassword();
    }

    @Override
    void submit() {
        if (this.m_user == null || this.m_user.isManaged()) {
            return;
        }
        String password1 = this.m_form.getPassword1();
        String password2 = this.m_form.getPassword2();
        String error = null;
        if (this.validatePasswords(password1, password2)) {
            try {
                this.m_cms.setPassword(this.m_user.getName(), password1);
                CmsUserLog.logPasswordChange(this.m_cms, this.m_user.getName());
                CmsTokenValidator.clearToken(CmsLoginUI.m_adminCms, this.m_user);
            }
            catch (CmsException e) {
                error = e.getLocalizedMessage(this.m_locale);
                LOG.debug((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            catch (Exception e) {
                error = e.getLocalizedMessage();
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
            if (error != null) {
                this.m_form.setErrorPassword1(new UserError(error), "o-security-invalid");
            } else {
                CmsVaadinUtils.showAlert(Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_SUCCESS_HEADER_0"), Messages.get().getBundle(A_CmsUI.get().getLocale()).key("GUI_PWCHANGE_GUI_PWCHANGE_SUCCESS_CONTENT_0"), new Runnable(){

                    @Override
                    public void run() {
                        A_CmsUI.get().getPage().setLocation(OpenCms.getLinkManager().substituteLinkForUnknownTarget(CmsLoginUI.m_adminCms, "/system/login", false));
                    }
                });
            }
        }
    }
}

