/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.report;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import org.opencms.i18n.CmsEncoder;
import org.opencms.ui.report.CmsReportWidget;
import org.opencms.ui.shared.rpc.I_CmsReportClientRpc;

public class CmsStreamReportWidget
extends CmsReportWidget {
    private static final long serialVersionUID = 1L;
    private OutputStream m_delegateStream;
    private boolean m_finish;
    private StringBuilder m_buffer = new StringBuilder();
    private PrintStream m_out;

    public CmsStreamReportWidget() {
        try {
            this.m_out = new PrintStream((OutputStream)new ReportStream(), true, "UTF-8");
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void finish() {
        this.m_finish = true;
    }

    public PrintStream getStream() {
        return this.m_out;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void requestReportUpdate() {
        String html;
        String content = "";
        StringBuilder stringBuilder = this.m_buffer;
        synchronized (stringBuilder) {
            content = this.m_buffer.toString();
            this.m_buffer.setLength(0);
        }
        if (content.length() == 0 && this.m_finish) {
            html = null;
            try {
                this.runReportFinishedHandlers();
            }
            catch (Exception exception) {}
        } else {
            html = this.convertOutputToHtml(content);
        }
        ((I_CmsReportClientRpc)this.getRpcProxy(I_CmsReportClientRpc.class)).handleReportUpdate(html);
    }

    public void setDelegateStream(OutputStream stream) {
        this.m_delegateStream = stream;
    }

    private String convertOutputToHtml(String content) {
        if (content.length() == 0) {
            return "";
        }
        StringBuilder buffer = new StringBuilder();
        for (String line : content.split("\n")) {
            buffer.append(CmsEncoder.escapeXml(line) + "<br>");
        }
        return buffer.toString();
    }

    private void writeToDelegate(byte[] data) {
        if (this.m_delegateStream != null) {
            try {
                this.m_delegateStream.write(data);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public class ReportStream
    extends ByteArrayOutputStream {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            StringBuilder stringBuilder = CmsStreamReportWidget.this.m_buffer;
            synchronized (stringBuilder) {
                String content = "";
                byte[] data = this.toByteArray();
                try {
                    content = new String(data, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                CmsStreamReportWidget.this.m_buffer.append(content);
                this.reset();
                CmsStreamReportWidget.this.writeToDelegate(data);
            }
        }
    }
}

