/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.sitemap;

import com.vaadin.ui.Button;
import com.vaadin.ui.Component;
import com.vaadin.v7.ui.HorizontalLayout;
import com.vaadin.v7.ui.Label;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.i18n.CmsLocaleGroupService;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.A_CmsUI;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.ui.I_CmsDialogContext;
import org.opencms.ui.components.CmsBasicDialog;
import org.opencms.ui.components.CmsResourceInfo;
import org.opencms.ui.sitemap.I_CmsLocaleCompareContext;
import org.opencms.util.CmsUUID;

public class CmsUnlinkDialog
extends CmsBasicDialog {
    private static final Log LOG = CmsLog.getLog(CmsUnlinkDialog.class);
    private static final long serialVersionUID = 1L;
    protected Button m_cancelButton;
    protected I_CmsDialogContext m_context;
    protected I_CmsLocaleCompareContext m_localeContext;
    protected Label m_messageLabel;
    protected Button m_okButton;
    protected CmsResource m_otherResource;
    protected HorizontalLayout m_resourceBoxContainer;

    public CmsUnlinkDialog(I_CmsDialogContext context, CmsResource otherResource) {
        CmsVaadinUtils.readAndLocalizeDesign((Component)this, CmsVaadinUtils.getWpMessagesForCurrentLocale(), null);
        this.m_context = context;
        this.m_otherResource = otherResource;
        CmsResource leftResource = this.m_context.getResources().get(0);
        try {
            CmsResource defaultFile;
            if (leftResource.isFolder() && (defaultFile = context.getCms().readDefaultFile(leftResource, CmsResourceFilter.IGNORE_EXPIRATION)) != null) {
                leftResource = defaultFile;
            }
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CmsResource rightResource = this.m_otherResource;
        CmsResourceInfo left = new CmsResourceInfo(leftResource);
        CmsResourceInfo right = new CmsResourceInfo(rightResource);
        Locale leftLocale = OpenCms.getLocaleManager().getDefaultLocale(context.getCms(), leftResource);
        Locale rightLocale = OpenCms.getLocaleManager().getDefaultLocale(context.getCms(), rightResource);
        left.getTopLine().setValue("[" + leftLocale.toString().toUpperCase() + "] " + left.getTopLine().getValue());
        right.getTopLine().setValue("[" + rightLocale.toString().toUpperCase() + "] " + right.getTopLine().getValue());
        this.m_resourceBoxContainer.addComponent((Component)left);
        this.m_resourceBoxContainer.addComponent((Component)right);
        this.m_okButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUnlinkDialog.this.onClickOk();
            }
        });
        this.m_cancelButton.addClickListener(new Button.ClickListener(){
            private static final long serialVersionUID = 1L;

            public void buttonClick(Button.ClickEvent event) {
                CmsUnlinkDialog.this.onClickCancel();
            }
        });
    }

    protected void onClickCancel() {
        this.m_context.finish(new ArrayList<CmsUUID>());
    }

    protected void onClickOk() {
        CmsResource res1 = this.m_context.getResources().get(0);
        CmsResource res2 = this.m_otherResource;
        try {
            CmsObject cms = A_CmsUI.getCmsObject();
            CmsLocaleGroupService groupService = cms.getLocaleGroupService();
            groupService.detachLocaleGroup(res1, res2);
            this.m_context.finish(Arrays.asList(this.m_context.getResources().get(0).getStructureId()));
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage());
            this.m_context.error(e);
        }
    }
}

