/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ui.util;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsPropertyDefinition;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.gwt.CmsPropertyEditorHelper;
import org.opencms.gwt.CmsTemplateFinder;
import org.opencms.gwt.shared.CmsListInfoBean;
import org.opencms.gwt.shared.property.CmsPropertiesBean;
import org.opencms.gwt.shared.property.CmsPropertyChangeSet;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;

public class CmsNewResourceBuilder {
    private static final Log LOG = CmsLog.getLog(CmsNewResourceBuilder.class);
    CmsObject m_cms;
    String m_type;
    private List<I_Callback> m_callbacks = Lists.newArrayList();
    private CmsResource m_createdResource;
    private boolean m_explorerNameGeneration;
    private CmsResource m_modelResource;
    private String m_pathWithPattern;
    private CmsPropertyChangeSet m_propChanges;

    public CmsNewResourceBuilder(CmsObject cms) throws CmsException {
        this.m_cms = OpenCms.initCmsObject(cms);
    }

    public void addCallback(I_Callback callback) {
        this.m_callbacks.add(callback);
    }

    public CmsResource createResource() throws CmsException {
        String path = OpenCms.getResourceManager().getNameGenerator().getNewFileName(this.m_cms, this.m_pathWithPattern, 5, this.m_explorerNameGeneration);
        Locale contentLocale = OpenCms.getLocaleManager().getDefaultLocale(this.m_cms, CmsResource.getFolderPath(path));
        CmsRequestContext context = this.m_cms.getRequestContext();
        if (this.m_modelResource != null) {
            context.setAttribute(CmsRequestContext.ATTRIBUTE_MODEL, this.m_modelResource.getRootPath());
        }
        context.setAttribute(CmsRequestContext.ATTRIBUTE_NEW_RESOURCE_LOCALE, contentLocale);
        CmsResource res = this.m_cms.createResource(path, OpenCms.getResourceManager().getResourceType(this.m_type), null, new ArrayList<CmsProperty>());
        if (this.m_propChanges != null) {
            CmsPropertyEditorHelper helper = new CmsPropertyEditorHelper(this.m_cms);
            helper.overrideStructureId(res.getStructureId());
            helper.saveProperties(this.m_propChanges);
        }
        this.m_createdResource = this.m_cms.readResource(res.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION);
        try {
            this.m_cms.unlockResource(this.m_createdResource);
        }
        catch (CmsException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        for (I_Callback callback : this.m_callbacks) {
            callback.onResourceCreated(this);
        }
        return this.m_createdResource;
    }

    public CmsResource getCreatedResource() {
        return this.m_createdResource;
    }

    public CmsPropertiesBean getPropertyData() {
        PropertyEditorHelper helper = new PropertyEditorHelper(this.m_cms);
        try {
            CmsPropertiesBean data = ((CmsPropertyEditorHelper)helper).loadPropertyData(CmsUUID.getNullUUID());
            return data;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public CmsResource safeCreateResource() {
        try {
            return this.createResource();
        }
        catch (Exception e) {
            for (I_Callback callback : this.m_callbacks) {
                callback.onError(e);
            }
            return null;
        }
    }

    public void setExplorerNameGeneration(boolean explorerNameGenerationMode) {
        this.m_explorerNameGeneration = explorerNameGenerationMode;
    }

    public void setLocale(Locale locale) {
        this.m_cms.getRequestContext().setLocale(locale);
    }

    public void setModel(CmsResource modelResource) {
        this.m_modelResource = modelResource;
    }

    public void setPatternPath(String destination) {
        this.m_pathWithPattern = destination;
    }

    public void setPropertyChanges(CmsPropertyChangeSet propertyChanges) {
        this.m_propChanges = propertyChanges;
    }

    public void setSiteRoot(String siteRoot) {
        this.m_cms.getRequestContext().setSiteRoot(siteRoot);
    }

    public void setType(String type) {
        this.m_type = type;
    }

    public class PropertyEditorHelper
    extends CmsPropertyEditorHelper {
        public PropertyEditorHelper(CmsObject cms) {
            super(cms);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public CmsPropertiesBean loadPropertyData(CmsUUID id) throws CmsException {
            Map<String, CmsXmlContentProperty> mergedConfig;
            CmsObject cms = CmsNewResourceBuilder.this.m_cms;
            String originalSiteRoot = cms.getRequestContext().getSiteRoot();
            CmsPropertiesBean result = new CmsPropertiesBean();
            result.setReadOnly(false);
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(CmsNewResourceBuilder.this.m_type);
            List<CmsProperty> typeDefaultProperties = type.getConfiguredDefaultProperties();
            result.setFolder(type.isFolder());
            result.setContainerPage(CmsNewResourceBuilder.this.m_type.equals(CmsResourceTypeXmlContainerPage.getStaticTypeName()));
            String sitePath = OpenCms.getResourceManager().getNameGenerator().getNewFileName(CmsNewResourceBuilder.this.m_cms, CmsNewResourceBuilder.this.m_pathWithPattern, 5, CmsNewResourceBuilder.this.m_explorerNameGeneration);
            String rootPath = CmsNewResourceBuilder.this.m_cms.getRequestContext().addSiteRoot(sitePath);
            Map<String, CmsXmlContentProperty> defaultProperties = this.getDefaultPropertiesForType(CmsNewResourceBuilder.this.m_type);
            Map<String, CmsXmlContentProperty> propertyConfig = mergedConfig = OpenCms.getADEManager().lookupConfiguration(cms, rootPath).getPropertyConfiguration(defaultProperties);
            propertyConfig = CmsXmlContentPropertyHelper.resolveMacrosInProperties(propertyConfig, CmsMacroResolver.newWorkplaceLocaleResolver(cms));
            CmsPropertyEditorHelper.updateWysiwygConfig(propertyConfig, cms, null);
            result.setPropertyDefinitions(new LinkedHashMap<String, CmsXmlContentProperty>(propertyConfig));
            try {
                cms.getRequestContext().setSiteRoot("");
                String parentPath = CmsResource.getParentFolder(rootPath);
                CmsResource parent = cms.readResource(parentPath, CmsResourceFilter.IGNORE_EXPIRATION);
                List<CmsProperty> parentProperties = cms.readPropertyObjects(parent, true);
                List<CmsProperty> ownProperties = typeDefaultProperties;
                result.setOwnProperties(this.convertProperties(ownProperties));
                result.setInheritedProperties(this.convertProperties(parentProperties));
                result.setPageInfo(this.getPageInfo(sitePath));
                List<CmsPropertyDefinition> propDefs = cms.readAllPropertyDefinitions();
                ArrayList<String> propNames = new ArrayList<String>();
                for (CmsPropertyDefinition propDef : propDefs) {
                    propNames.add(propDef.getName());
                }
                CmsTemplateFinder templateFinder = new CmsTemplateFinder(cms);
                result.setTemplates(templateFinder.getTemplates());
                result.setAllProperties(propNames);
                result.setStructureId(id);
                result.setSitePath(sitePath);
                CmsPropertiesBean cmsPropertiesBean = result;
                return cmsPropertiesBean;
            }
            finally {
                cms.getRequestContext().setSiteRoot(originalSiteRoot);
            }
        }

        private CmsListInfoBean getPageInfo(String sitePath) {
            CmsListInfoBean listInfo = new CmsListInfoBean();
            listInfo.setResourceState(CmsResource.STATE_NEW);
            listInfo.setTitle(CmsResource.getName(sitePath));
            listInfo.setSubTitle(sitePath);
            String key = OpenCms.getWorkplaceManager().getExplorerTypeSetting(CmsNewResourceBuilder.this.m_type).getKey();
            Locale currentLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(CmsNewResourceBuilder.this.m_cms);
            CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(currentLocale);
            String resTypeNiceName = messages.key(key);
            listInfo.addAdditionalInfo(messages.key("GUI_LABEL_TYPE_0"), resTypeNiceName);
            listInfo.setBigIconClasses(CmsIconUtil.getIconClasses(CmsNewResourceBuilder.this.m_type, sitePath, false));
            listInfo.setResourceType(CmsNewResourceBuilder.this.m_type);
            return listInfo;
        }
    }

    public static interface I_Callback {
        public void onError(Exception var1);

        public void onResourceCreated(CmsNewResourceBuilder var1);
    }
}

