/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.util;

import java.util.Random;
import org.apache.commons.logging.Log;
import org.apache.oro.text.PatternCache;
import org.apache.oro.text.PatternCacheFIFO;
import org.apache.oro.text.perl.MalformedPerl5PatternException;
import org.apache.oro.text.perl.Perl5Util;
import org.apache.oro.text.regex.MalformedPatternException;
import org.opencms.main.CmsLog;
import org.opencms.util.Messages;

public class CmsResourceTranslator {
    private static final Log LOG = CmsLog.getLog(CmsResourceTranslator.class);
    private Perl5Util[] m_perl5Utils = new Perl5Util[32];
    private boolean m_continueMatching;
    private String[] m_translations;
    private Random m_random = new Random(42L);

    public CmsResourceTranslator(String[] translations, boolean continueMatching) {
        this.m_translations = translations;
        this.m_continueMatching = continueMatching;
        for (int i = 0; i < this.m_perl5Utils.length; ++i) {
            this.m_perl5Utils[i] = new Perl5Util(this.buildPatternCache());
        }
        if (LOG.isInfoEnabled()) {
            LOG.info((Object)Messages.get().getBundle().key("LOG_NUM_TRANSLATION_RULES_INITIALIZED_1", new Integer(translations.length)));
        }
    }

    public String[] getTranslations() {
        String[] copy = new String[this.m_translations.length];
        System.arraycopy(this.m_translations, 0, copy, 0, this.m_translations.length);
        return copy;
    }

    public String translateResource(String resourceName) {
        if (this.m_translations.length == 0) {
            return resourceName;
        }
        if (resourceName == null) {
            return null;
        }
        String current = resourceName;
        int size = current.length() * 2;
        Perl5Util perl5Util = this.getPerl5Util();
        for (int i = 0; i < this.m_translations.length; ++i) {
            StringBuffer result = new StringBuffer(size);
            try {
                if (perl5Util.substitute(result, this.m_translations[i], current) == 0) continue;
                if (this.m_continueMatching) {
                    current = result.toString();
                    continue;
                }
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_TRANSLATION_MATCH_3", new Integer(i), resourceName, result));
                }
                return result.toString();
            }
            catch (MalformedPerl5PatternException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_MALFORMED_TRANSLATION_RULE_1", this.m_translations[i]), (Throwable)e);
            }
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TRANSLATION_MATCH_2", resourceName, current));
        }
        return current;
    }

    private PatternCache buildPatternCache() {
        PatternCacheFIFO cache = new PatternCacheFIFO(this.m_translations.length + 1);
        for (int i = 0; i < this.m_translations.length; ++i) {
            try {
                cache.addPattern(this.m_translations[i]);
                continue;
            }
            catch (MalformedPatternException e) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_MALFORMED_TRANSLATION_RULE_1", this.m_translations[i]), (Throwable)e);
            }
        }
        return cache;
    }

    private Perl5Util getPerl5Util() {
        int index = this.m_random.nextInt(this.m_perl5Utils.length);
        return this.m_perl5Utils[index];
    }
}

