/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.widgets.serialdate;

import java.util.Calendar;
import java.util.Date;
import java.util.SortedSet;
import org.opencms.acacia.shared.I_CmsSerialDateValue;
import org.opencms.widgets.serialdate.A_CmsSerialDateBean;

public class CmsSerialDateBeanYearly
extends A_CmsSerialDateBean {
    private int m_dayOfMonth;
    private I_CmsSerialDateValue.Month m_month;

    public CmsSerialDateBeanYearly(Date startDate, Date endDate, boolean isWholeDay, I_CmsSerialDateValue.EndType endType, Date serialEndDate, int occurrences, SortedSet<Date> exceptions, int dayOfMonth, I_CmsSerialDateValue.Month month) {
        super(startDate, endDate, isWholeDay, endType, serialEndDate, occurrences, exceptions);
        this.m_dayOfMonth = dayOfMonth;
        this.m_month = month;
    }

    @Override
    protected Calendar getFirstDate() {
        Calendar date = (Calendar)this.getStartDate().clone();
        int month = date.get(2);
        if (month > this.m_month.ordinal() || month == this.m_month.ordinal() && this.m_dayOfMonth < date.get(5)) {
            date.set(2, 0);
            date.set(5, 1);
            date.add(1, 1);
        }
        date.set(5, 1);
        date.set(2, this.m_month.ordinal());
        this.setCorrectDay(date);
        return date;
    }

    @Override
    protected boolean isAnyDatePossible() {
        return this.m_month.getMaximalDay() >= this.m_dayOfMonth;
    }

    @Override
    protected void toNextDate(Calendar date) {
        date.set(5, 1);
        date.add(1, 1);
        this.setCorrectDay(date);
    }

    private boolean monthHasNotDay(Calendar date) {
        return date.getActualMaximum(5) < this.m_dayOfMonth;
    }

    private void setCorrectDay(Calendar date) {
        if (this.monthHasNotDay(date)) {
            date.set(5, date.getActualMaximum(5));
        } else {
            date.set(5, this.m_dayOfMonth);
        }
    }
}

