/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypePlain;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.workplace.editors.CmsWorkplaceEditorManager;
import org.opencms.workplace.editors.I_CmsEditorHandler;

public class CmsEditorHandler
implements I_CmsEditorHandler {
    private static final Log LOG = CmsLog.getLog(CmsEditorHandler.class);

    @Override
    public String getEditorUri(CmsObject cms, String resourceType, String userAgent, boolean loadDefault) {
        String editorUri = null;
        editorUri = loadDefault ? OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getDefaultEditorUri(cms.getRequestContext(), resourceType, userAgent) : OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getEditorUri(cms.getRequestContext(), resourceType, userAgent);
        try {
            cms.readResource(editorUri);
        }
        catch (Throwable t) {
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)t);
            }
            editorUri = OpenCms.getWorkplaceManager().getWorkplaceEditorManager().getDefaultEditorUri(cms.getRequestContext(), resourceType, userAgent);
        }
        Object resObj = cms.getRequestContext().getAttribute("EDITORHANDLER_RESOURCE");
        if (resObj != null) {
            CmsResource resource = (CmsResource)resObj;
            if (editorUri != null && editorUri.contains("acacia") && CmsResourceTypeXmlContent.isXmlContent(resource)) {
                String fallback = "/system/workplace/editors/xmlcontent/editor.jsp";
                if (!CmsWorkplaceEditorManager.checkAcaciaEditorAvailable(cms, resource)) {
                    editorUri = fallback;
                }
            }
        }
        return editorUri;
    }

    @Override
    public String getEditorUri(String resource, CmsJspActionElement jsp) throws CmsException {
        boolean editAsText = Boolean.valueOf(jsp.getRequest().getParameter("editastext"));
        boolean loadDefault = Boolean.valueOf(jsp.getRequest().getParameter("loaddefault"));
        int resTypeId = -1;
        String resourceType = "";
        if (editAsText) {
            resTypeId = OpenCms.getResourceManager().getResourceType(CmsResourceTypePlain.getStaticTypeName()).getTypeId();
        } else {
            CmsResource res = jsp.getCmsObject().readResource(resource, CmsResourceFilter.ALL);
            jsp.getRequestContext().setAttribute("EDITORHANDLER_RESOURCE", res);
            resTypeId = res.getTypeId();
        }
        resourceType = OpenCms.getResourceManager().getResourceType(resTypeId).getTypeName();
        String userAgent = jsp.getRequest().getHeader("user-agent");
        return this.getEditorUri(jsp.getCmsObject(), resourceType, userAgent, loadDefault);
    }
}

