/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsRoleViolationException;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsDialog;
import org.opencms.workplace.editors.I_CmsPreEditorActionDefinition;

public class CmsPreEditorAction
extends CmsDialog {
    private static final Log LOG = CmsLog.getLog(CmsPreEditorAction.class);
    private String m_originalParams;

    public CmsPreEditorAction(CmsJspActionElement jsp) {
        super(jsp);
    }

    public CmsPreEditorAction(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    public static boolean isPreEditorMode(CmsDialog dialog) {
        return CmsStringUtil.isNotEmpty(dialog.getParamOriginalParams());
    }

    public static void sendForwardToEditor(CmsDialog dialog) {
        CmsPreEditorAction.sendForwardToEditor(dialog, null);
    }

    public static void sendForwardToEditor(CmsDialog dialog, Map<String, String[]> additionalParams) {
        block3: {
            Map<String, String[]> params = CmsRequestUtil.createParameterMap(dialog.getParamOriginalParams());
            params.put("preactiondone", new String[]{CmsStringUtil.TRUE});
            if (additionalParams != null) {
                params.putAll(additionalParams);
            }
            try {
                dialog.sendForward("/system/workplace/editors/editor.jsp", params);
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block3;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public boolean doPreAction() {
        block4: {
            String resourceName = this.getParamResource();
            try {
                boolean preActionDone = Boolean.valueOf(this.getParamPreActionDone());
                if (!preActionDone) {
                    CmsResource resource = this.getCms().readResource(resourceName, CmsResourceFilter.ALL);
                    I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource.getTypeId());
                    I_CmsPreEditorActionDefinition preAction = OpenCms.getWorkplaceManager().getPreEditorConditionDefinition(type);
                    if (preAction != null) {
                        return preAction.doPreAction(resource, this, this.getOriginalParams());
                    }
                }
            }
            catch (Exception e) {
                if (!LOG.isErrorEnabled()) break block4;
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return false;
    }

    public String getOriginalParams() {
        if (this.m_originalParams == null) {
            this.m_originalParams = CmsEncoder.decode(CmsRequestUtil.encodeParams(this.getJsp().getRequest()));
        }
        return this.m_originalParams;
    }

    @Override
    protected void checkRole() throws CmsRoleViolationException {
        OpenCms.getRoleManager().checkRole(this.getCms(), CmsRole.EDITOR);
    }
}

