/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.i18n.CmsEncoder;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsEditor;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.content.CmsXmlContent;

public class CmsSimpleEditor
extends CmsEditor {
    private static final String EDITOR_TYPE = "simple";
    private static final Log LOG = CmsLog.getLog(CmsSimpleEditor.class);

    public CmsSimpleEditor(CmsJspActionElement jsp) {
        super(jsp);
    }

    @Override
    public void actionClear(boolean forceUnlock) {
        block3: {
            boolean modified = Boolean.valueOf(this.getParamModified());
            if (forceUnlock || !modified) {
                try {
                    this.getCms().unlockResource(this.getParamResource());
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public void actionExit() throws IOException, JspException, ServletException {
        if (this.getAction() == 4) {
            return;
        }
        this.actionClear(false);
        this.actionClose();
    }

    @Override
    public void actionSave() throws JspException {
        CmsFile editFile = null;
        try {
            editFile = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.ALL);
            String decodedContent = this.decodeContentParameter(this.getParamContent(), this.getFileEncoding(), editFile);
            try {
                editFile.setContents(decodedContent.getBytes(this.getFileEncoding()));
            }
            catch (UnsupportedEncodingException e) {
                throw new CmsException(Messages.get().container("ERR_INVALID_CONTENT_ENC_1", this.getParamResource()), (Throwable)e);
            }
            if (OpenCms.getWorkplaceManager().isXmlContentAutoCorrect() && CmsResourceTypeXmlContent.isXmlContent(editFile)) {
                this.getCms().getRequestContext().setAttribute(CmsXmlContent.AUTO_CORRECTION_ATTRIBUTE, Boolean.TRUE);
            }
            CmsFile writtenFile = this.getCms().writeFile(editFile);
            decodedContent = CmsEncoder.createString(writtenFile.getContents(), this.getFileEncoding());
            this.setParamContent(this.encodeContent(decodedContent));
            this.setParamModified(Boolean.TRUE.toString());
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
        if (this.getAction() != 4) {
            this.setAction(121);
        }
    }

    @Override
    public String getEditorResourceUri() {
        return CmsSimpleEditor.getSkinUri() + "editors/" + EDITOR_TYPE + "/";
    }

    protected String decodeContentParameter(String encodedContent, String encoding, CmsFile originalFile) {
        return this.decodeContent(encodedContent);
    }

    @Override
    protected void initContent() {
        String content;
        block5: {
            this.getJsp().getRequest().setAttribute("__CmsWorkplace.WORKPLACE_CLASS", (Object)this);
            content = this.getParamContent();
            if (CmsStringUtil.isNotEmpty(content)) {
                this.setParamContent(this.decodeContent(content));
                return;
            }
            content = "";
            try {
                this.checkLock(this.getParamResource());
                CmsFile editFile = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.ALL);
                content = CmsEncoder.createString(editFile.getContents(), this.getFileEncoding());
            }
            catch (CmsException e) {
                try {
                    this.showErrorPage(this, e);
                }
                catch (JspException exc) {
                    if (!LOG.isInfoEnabled()) break block5;
                    LOG.info((Object)exc);
                }
            }
        }
        this.setParamContent(content);
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        this.fillParamValues(request);
        this.setParamDialogtype(EDITOR_TYPE);
        if ("save".equals(this.getParamAction())) {
            this.setAction(121);
        } else if ("saveexit".equals(this.getParamAction())) {
            this.setAction(123);
        } else if ("exit".equals(this.getParamAction())) {
            this.setAction(122);
        } else if ("show".equals(this.getParamAction())) {
            this.setAction(125);
        } else if ("error".equals(this.getParamAction())) {
            this.setAction(127);
        } else {
            this.setAction(0);
            this.initContent();
        }
        this.setParamContent(this.encodeContent(this.getParamContent()));
    }
}

