/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.workplace.editors;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.jsp.JspException;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMultiMessages;
import org.opencms.json.JSONArray;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspActionElement;
import org.opencms.lock.CmsLockType;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.A_CmsWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.widgets.I_CmsWidgetDialog;
import org.opencms.widgets.I_CmsWidgetParameter;
import org.opencms.workplace.CmsWorkplace;
import org.opencms.workplace.CmsWorkplaceSettings;
import org.opencms.workplace.editors.CmsEditor;
import org.opencms.workplace.editors.CmsXmlContentWidgetVisitor;
import org.opencms.workplace.editors.I_CmsEditorActionHandler;
import org.opencms.workplace.editors.Messages;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentTab;
import org.opencms.xml.content.CmsXmlContentValueSequence;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlContentEditor
extends CmsEditor
implements I_CmsWidgetDialog {
    public static final int ACTION_CHECK = 151;
    public static final int ACTION_CONFIRMCORRECTION = 152;
    public static final int ACTION_COPYLOCALE = 141;
    public static final int ACTION_CORRECTIONCONFIRMED = 153;
    public static final int ACTION_ELEMENT_ADD = 154;
    public static final int ACTION_ELEMENT_MOVE_DOWN = 155;
    public static final int ACTION_ELEMENT_MOVE_UP = 156;
    public static final int ACTION_ELEMENT_REMOVE = 157;
    public static final int ACTION_NEW = 158;
    public static final int ACTION_SUBCHOICES = 159;
    public static final String ATTRIBUTE_EDITCONTEXT = CmsXmlContentEditor.class.getName() + ".ATTRIBUTE_EDITCONTEXT";
    public static final String EDITOR_ACTION_CHECK = "check";
    public static final String EDITOR_ACTION_CONFIRMCORRECTION = "confirmcorrect";
    public static final String EDITOR_ACTION_ELEMENT_ADD = "addelement";
    public static final String EDITOR_ACTION_ELEMENT_MOVE_DOWN = "elementdown";
    public static final String EDITOR_ACTION_ELEMENT_MOVE_UP = "elementup";
    public static final String EDITOR_ACTION_ELEMENT_REMOVE = "removeelement";
    public static final String EDITOR_ACTION_NEW = "new";
    public static final String EDITOR_ACTION_SUBCHOICES = "subchoices";
    public static final String EDITOR_COPYLOCALE = "copylocale";
    public static final String EDITOR_CORRECTIONCONFIRMED = "correctconfirmed";
    public static final String PARAM_CHOICEELEMENT = "choiceelement";
    public static final String PARAM_CHOICETYPE = "choicetype";
    public static final String PARAM_EDITCONTEXT = "editcontext";
    public static final String PARAM_ELEMENTINDEX = "elementindex";
    public static final String PARAM_ELEMENTNAME = "elementname";
    public static final String PARAM_NEWLINK = "newlink";
    private static final String EDITOR_TYPE = "xmlcontent";
    private static final Log LOG = CmsLog.getLog(CmsXmlContentEditor.class);
    private CmsXmlContent m_content;
    private CmsXmlContentTab m_currentTab;
    private int m_currentTabIndex;
    private Locale m_elementLocale;
    private List<CmsXmlContentTab> m_errorTabs;
    private CmsFile m_file;
    private Set<String> m_helpMessageIds;
    private String m_mode;
    private boolean m_optionalElementPresent;
    private String m_paramChoiceElement;
    private String m_paramChoiceType;
    private String m_paramEditContext;
    private String m_paramElementIndex;
    private String m_paramElementName;
    private String m_paramModelFile;
    private String m_paramNewLink;
    private String m_postCreateHandler;
    private CmsXmlContentErrorHandler m_validationHandler;
    private List<CmsXmlContentTab> m_warningTabs;
    private CmsXmlContentWidgetVisitor m_widgetCollector;

    public CmsXmlContentEditor(CmsJspActionElement jsp) {
        super(jsp);
    }

    public void actionChangeElementLanguage() {
        block11: {
            Locale oldLocale = CmsLocaleManager.getLocale(this.getParamOldelementlanguage());
            Locale newLocale = this.getElementLocale();
            try {
                this.setEditorValues(oldLocale);
                if (!this.m_content.validate(this.getCms()).hasErrors(oldLocale)) {
                    block10: {
                        if (!this.m_content.hasLocale(newLocale)) {
                            boolean addNew = true;
                            List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(this.getCms(), this.getParamResource());
                            if (locales.size() > 1) {
                                try {
                                    this.m_content.copyLocale(locales, newLocale);
                                    addNew = false;
                                }
                                catch (CmsXmlException cmsXmlException) {
                                    // empty catch block
                                }
                            }
                            if (addNew) {
                                try {
                                    this.m_content.addLocale(this.getCms(), newLocale);
                                }
                                catch (CmsXmlException e) {
                                    if (!LOG.isErrorEnabled()) break block10;
                                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                                }
                            }
                        }
                    }
                    this.writeContent();
                    this.setAction(0);
                    break block11;
                }
                this.setParamElementlanguage(this.getParamOldelementlanguage());
                this.m_elementLocale = null;
            }
            catch (Exception e) {
                if (!LOG.isInfoEnabled()) break block11;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void actionClear(boolean forceUnlock) {
        block3: {
            this.deleteTempFile();
            boolean directEditMode = Boolean.valueOf(this.getParamDirectedit());
            boolean modified = Boolean.valueOf(this.getParamModified());
            if (directEditMode || forceUnlock || !modified) {
                try {
                    this.getCms().unlockResource(this.getParamResource());
                }
                catch (CmsException e) {
                    if (!LOG.isInfoEnabled()) break block3;
                    LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    public void actionCopyElementLocale() throws JspException {
        try {
            this.setEditorValues(this.getElementLocale());
            if (!this.hasValidationErrors()) {
                this.writeContent();
                CmsObject cloneCms = this.getCloneCms();
                CmsUUID tempProjectId = OpenCms.getWorkplaceManager().getTempFileProjectId();
                cloneCms.getRequestContext().setCurrentProject(this.getCms().readProject(tempProjectId));
                cloneCms.setDateReleased(this.getParamTempfile(), 0L, false);
                cloneCms.setDateExpired(this.getParamTempfile(), Long.MAX_VALUE, false);
            }
        }
        catch (CmsException e) {
            this.showErrorPage(this, e);
        }
    }

    public void actionDeleteElementLocale() throws JspException {
        block6: {
            try {
                Locale loc = this.getElementLocale();
                this.m_content.removeLocale(loc);
                this.writeContent();
                List<Locale> locales = this.m_content.getLocales();
                if (locales.size() > 0) {
                    Locale newLoc = locales.get(0);
                    this.setParamElementlanguage(newLoc.toString());
                    this.m_elementLocale = newLoc;
                } else if (LOG.isErrorEnabled()) {
                    LOG.error((Object)Messages.get().getBundle().key("LOG_GET_LOCALES_1", this.getParamResource()));
                }
            }
            catch (CmsXmlException e) {
                this.showErrorPage(e);
            }
            catch (CmsException e) {
                if (!LOG.isInfoEnabled()) break block6;
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
    }

    public void actionDirectEdit() throws IOException, JspException, ServletException {
        I_CmsEditorActionHandler actionClass = OpenCms.getWorkplaceManager().getEditorActionHandler();
        if (actionClass == null) {
            this.actionSave();
            this.actionExit();
        } else {
            actionClass.editorAction(this, this.getJsp());
        }
    }

    @Override
    public void actionExit() throws IOException, JspException, ServletException {
        if (this.getAction() == 4) {
            return;
        }
        this.actionClear(false);
        this.actionClose();
    }

    public void actionMoveElement() throws JspException {
        try {
            this.setEditorValues(this.getElementLocale());
        }
        catch (CmsXmlException e) {
            this.showErrorPage(e);
            return;
        }
        int index = 0;
        try {
            index = Integer.parseInt(this.getParamElementIndex());
        }
        catch (Exception exception) {
            // empty catch block
        }
        I_CmsXmlContentValue value = this.m_content.getValue(this.getParamElementName(), this.getElementLocale(), index);
        if (this.getAction() == 155) {
            value.moveDown();
        } else {
            value.moveUp();
        }
        if (this.getValidationHandler().hasWarnings(this.getElementLocale())) {
            this.resetErrorHandler();
        }
        try {
            this.writeContent();
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
    }

    public void actionNew() throws JspException {
        String newFileName = "";
        try {
            newFileName = A_CmsResourceCollector.createResourceForCollector(this.getCms(), this.m_paramNewLink, this.getElementLocale(), this.getParamResource(), this.getParamModelFile(), this.getParamMode(), this.getParamPostCreateHandler());
            this.setParamNewLink(null);
            this.setParamAction(null);
            this.setParamResource(newFileName);
            this.setAction(0);
            this.setParamTempfile(this.createTempFile());
            this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
            this.m_content = CmsStringUtil.isNotEmptyOrWhitespaceOnly(this.getParamModelFile()) ? CmsXmlContentFactory.unmarshal(this.getCms(), this.getCms().readFile(newFileName, CmsResourceFilter.ALL)) : CmsXmlContentFactory.unmarshal(this.getCms(), this.m_file);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)Messages.get().getBundle().key("LOG_CREATE_XML_CONTENT_ITEM_1", this.m_paramNewLink), (Throwable)e);
            }
            throw new JspException((Throwable)e);
        }
        finally {
            try {
                this.getCms().deleteResource(newFileName, CmsResource.DELETE_REMOVE_SIBLINGS);
            }
            catch (CmsException cmsException) {}
        }
    }

    public void actionPreview() throws IOException, JspException {
        try {
            this.setEditorValues(this.getElementLocale());
            this.writeContent();
            CmsObject cloneCms = this.getCloneCms();
            CmsUUID tempProjectId = OpenCms.getWorkplaceManager().getTempFileProjectId();
            cloneCms.getRequestContext().setCurrentProject(this.getCms().readProject(tempProjectId));
            cloneCms.setDateReleased(this.getParamTempfile(), 0L, false);
            cloneCms.setDateExpired(this.getParamTempfile(), Long.MAX_VALUE, false);
        }
        catch (CmsException e) {
            this.showErrorPage(this, e);
        }
        String previewUri = this.m_content.getHandler().getPreview(this.getCms(), this.m_content, this.getParamTempfile());
        StringBuffer param = new StringBuffer(8);
        if (previewUri.indexOf(63) != -1) {
            param.append("&");
        } else {
            param.append("?");
        }
        param.append("__locale");
        param.append("=");
        param.append(this.getParamElementlanguage());
        this.sendCmsRedirect(previewUri + param);
    }

    @Override
    public void actionSave() throws JspException {
        this.actionSave(this.getElementLocale());
        if (this.getAction() != 4) {
            this.setAction(121);
        }
    }

    public void actionSave(Locale locale) throws JspException {
        try {
            this.setEditorValues(locale);
            if (!this.hasValidationErrors()) {
                this.writeContent();
                this.commitTempFile();
                this.setParamModified(Boolean.TRUE.toString());
                OpenCms.getSearchManager().updateOfflineIndexes();
            }
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
    }

    public void actionToggleElement() throws JspException {
        try {
            this.setEditorValues(this.getElementLocale());
        }
        catch (CmsXmlException e) {
            this.showErrorPage(e);
            return;
        }
        int index = 0;
        try {
            index = Integer.parseInt(this.getParamElementIndex());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.getAction() == 157) {
            I_CmsXmlContentValue value = this.m_content.getValue(this.getParamElementName(), this.getElementLocale(), index);
            this.m_content.removeValue(this.getParamElementName(), this.getElementLocale(), index);
            if (value.isChoiceOption() && this.m_content.getSubValues(CmsXmlUtils.removeLastXpathElement(this.getParamElementName()), this.getElementLocale()).size() == 0) {
                String xpath = CmsXmlUtils.removeLastXpathElement(this.getParamElementName());
                this.m_content.removeValue(xpath, this.getElementLocale(), CmsXmlUtils.getXpathIndexInt(xpath) - 1);
            }
        } else {
            if (this.m_content.hasValue(this.getParamElementName(), this.getElementLocale())) {
                ++index;
            }
            String elementPath = this.getParamElementName();
            if (CmsStringUtil.isNotEmpty(this.getParamChoiceElement())) {
                boolean choiceType = Boolean.valueOf(this.getParamChoiceType());
                I_CmsXmlSchemaType elemType = this.m_content.getContentDefinition().getSchemaType(elementPath);
                if (!choiceType || elemType.isChoiceOption() && elemType.isChoiceType()) {
                    elementPath = CmsXmlUtils.removeLastXpathElement(elementPath);
                } else {
                    this.m_content.addValue(this.getCms(), elementPath, this.getElementLocale(), index);
                    elementPath = CmsXmlUtils.createXpathElement(elementPath, index + 1);
                    index = 0;
                }
                if (CmsXmlUtils.isDeepXpath(this.getParamChoiceElement())) {
                    String pathToChoice = CmsXmlUtils.removeLastXpathElement(this.getParamChoiceElement());
                    String newPath = elementPath;
                    while (CmsStringUtil.isNotEmpty(pathToChoice)) {
                        String createElement = CmsXmlUtils.getFirstXpathElement(pathToChoice);
                        newPath = CmsXmlUtils.concatXpath(newPath, createElement);
                        pathToChoice = CmsXmlUtils.isDeepXpath(pathToChoice) ? CmsXmlUtils.removeFirstXpathElement(pathToChoice) : null;
                        I_CmsXmlContentValue newVal = this.m_content.addValue(this.getCms(), newPath, this.getElementLocale(), index);
                        newPath = newVal.getPath();
                        index = 0;
                    }
                    elementPath = CmsXmlUtils.concatXpath(newPath, CmsXmlUtils.getLastXpathElement(this.getParamChoiceElement()));
                } else {
                    elementPath = elementPath + "/" + this.getParamChoiceElement();
                }
            }
            this.m_content.addValue(this.getCms(), elementPath, this.getElementLocale(), index);
        }
        if (this.getValidationHandler().hasWarnings(this.getElementLocale())) {
            this.resetErrorHandler();
        }
        try {
            this.writeContent();
        }
        catch (CmsException e) {
            this.showErrorPage(e);
        }
    }

    public JSONArray buildElementChoices(String elementName, boolean choiceType, boolean checkChoice) {
        JSONArray choiceElements = new JSONArray();
        String choiceName = elementName;
        I_CmsXmlSchemaType elemType = this.m_content.getContentDefinition().getSchemaType(elementName);
        if (checkChoice && elemType.isChoiceOption() && elemType.isChoiceType()) {
            choiceName = CmsXmlUtils.removeLastXpathElement(elementName);
        }
        if (this.m_content.hasChoiceOptions(choiceName, this.getElementLocale())) {
            JSONObject info = new JSONObject();
            try {
                info.put(PARAM_CHOICETYPE, choiceType);
                choiceElements.put(info);
                List<I_CmsXmlSchemaType> options = this.m_content.getChoiceOptions(choiceName, this.getElementLocale());
                for (I_CmsXmlSchemaType type : options) {
                    JSONObject option = new JSONObject();
                    String key = "label." + type.getContentDefinition().getInnerName() + "." + type.getName();
                    option.put("name", type.getName());
                    option.put("label", this.keyDefault(key, type.getName()));
                    option.put("help", this.keyDefault(key + ".help", ""));
                    option.put("subchoice", type.isChoiceType());
                    choiceElements.put(option);
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        return choiceElements;
    }

    public String buildSelectElementLanguage(String attributes) {
        return this.buildSelectElementLanguage(attributes, this.getParamResource(), this.getElementLocale());
    }

    public String buildSubChoices() {
        String elementPath = this.getParamElementName();
        boolean choiceType = Boolean.valueOf(this.getParamChoiceType());
        I_CmsXmlSchemaType elemType = this.m_content.getContentDefinition().getSchemaType(elementPath);
        if (!choiceType || elemType.isChoiceOption() && elemType.isChoiceType()) {
            elementPath = CmsXmlUtils.removeLastXpathElement(elementPath);
        }
        elementPath = CmsXmlUtils.concatXpath(elementPath, this.getParamChoiceElement());
        return this.buildElementChoices(elementPath, choiceType, false).toString();
    }

    @Override
    public int getButtonStyle() {
        return this.getSettings().getUserSettings().getEditorButtonStyle();
    }

    @Override
    public String getEditorResourceUri() {
        return CmsXmlContentEditor.getSkinUri() + "editors/" + EDITOR_TYPE + "/";
    }

    public Locale getElementLocale() {
        if (this.m_elementLocale == null) {
            if (CmsStringUtil.isNotEmpty(this.getParamElementlanguage()) && !"null".equals(this.getParamElementlanguage())) {
                this.m_elementLocale = CmsLocaleManager.getLocale(this.getParamElementlanguage());
            } else {
                this.initElementLanguage();
                this.m_elementLocale = CmsLocaleManager.getLocale(this.getParamElementlanguage());
            }
        }
        return this.m_elementLocale;
    }

    @Override
    public Set<String> getHelpMessageIds() {
        if (this.m_helpMessageIds == null) {
            this.m_helpMessageIds = new HashSet<String>();
        }
        return this.m_helpMessageIds;
    }

    public String getParamChoiceElement() {
        return this.m_paramChoiceElement;
    }

    public String getParamChoiceType() {
        return this.m_paramChoiceType;
    }

    public String getParamEditContext() {
        return this.m_paramEditContext;
    }

    public String getParamElementIndex() {
        return this.m_paramElementIndex;
    }

    public String getParamElementName() {
        return this.m_paramElementName;
    }

    public String getParamMode() {
        return this.m_mode;
    }

    public String getParamModelFile() {
        return this.m_paramModelFile;
    }

    public String getParamNewLink() {
        return this.m_paramNewLink;
    }

    public String getParamPostCreateHandler() {
        return this.m_postCreateHandler;
    }

    @Override
    public String getUserAgent() {
        return this.getJsp().getRequest().getHeader("user-agent");
    }

    public CmsXmlContentWidgetVisitor getWidgetCollector() {
        if (this.m_widgetCollector == null) {
            this.m_widgetCollector = new CmsXmlContentWidgetVisitor(null, this.getElementLocale());
            this.m_content.visitAllValuesWith(this.m_widgetCollector);
        }
        return this.m_widgetCollector;
    }

    public String getXmlEditorForm() {
        this.getCms().getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_EDITOR, Boolean.TRUE);
        this.addMessages(this.m_content.getHandler().getMessages(this.getLocale()));
        ((CmsMultiMessages)this.getMessages()).setFallbackHandler(this.m_content.getHandler().getMessageKeyHandler());
        this.m_errorTabs = new ArrayList<CmsXmlContentTab>();
        this.m_warningTabs = new ArrayList<CmsXmlContentTab>();
        return this.getXmlEditorForm(this.m_content.getContentDefinition(), "", true, false).toString();
    }

    public String getXmlEditorHtmlEnd() throws JspException {
        StringBuffer result = new StringBuffer(16384);
        if (this.m_optionalElementPresent) {
            this.resetWidgetCollector();
        }
        try {
            for (String key : this.getWidgetCollector().getWidgets().keySet()) {
                I_CmsXmlContentValue value = this.getWidgetCollector().getValues().get(key);
                I_CmsWidget widget = this.getWidgetCollector().getWidgets().get(key);
                result.append(widget.getDialogHtmlEnd(this.getCms(), this, (I_CmsWidgetParameter)((Object)value)));
            }
            result.append("<div class=\"help\" id=\"helpText\" ");
            result.append("onmouseover=\"showHelpText();\" onmouseout=\"hideHelpText();\"></div>\n");
            result.append("<div class=\"xmlButtons\" id=\"xmlElementButtons\" ");
            result.append("onmouseover=\"checkElementButtons(true);\" onmouseout=\"checkElementButtons(false);\"></div>\n");
            return result.toString();
        }
        catch (Exception e) {
            this.showErrorPage(e);
            return "";
        }
    }

    public String getXmlEditorIncludes() throws JspException {
        StringBuffer result = new StringBuffer(1024);
        result.append("<script  src=\"");
        result.append(CmsWorkplace.getSkinUri()).append("jquery/packed/jquery.js");
        result.append("\"></script>\n");
        result.append("<script  src=\"");
        result.append(CmsWorkplace.getSkinUri()).append("jquery/packed/jquery.ui.js");
        result.append("\"></script>\n");
        result.append("<script  src=\"");
        result.append(CmsWorkplace.getSkinUri()).append("components/widgets/dialog-helper.js");
        result.append("\"></script>\n");
        result.append("<script  src=\"");
        result.append(CmsWorkplace.getSkinUri()).append("commons/json2.js");
        result.append("\"></script>\n");
        result.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        result.append(CmsWorkplace.getSkinUri()).append("jquery/css/ui-ocms/jquery.ui.css");
        result.append("\">\n");
        result.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"");
        result.append(CmsWorkplace.getSkinUri()).append("jquery/css/ui-ocms/jquery.ui.ocms.css");
        result.append("\">\n");
        try {
            for (I_CmsWidget widget : this.getWidgetCollector().getUniqueWidgets()) {
                result.append(widget.getDialogIncludes(this.getCms(), this));
                result.append("\n");
            }
        }
        catch (Exception e) {
            this.showErrorPage(e);
        }
        return result.toString();
    }

    public String getXmlEditorInitCalls() throws JspException {
        StringBuffer result = new StringBuffer(512);
        try {
            for (I_CmsWidget widget : this.getWidgetCollector().getUniqueWidgets()) {
                result.append(widget.getDialogInitCall(this.getCms(), this));
            }
        }
        catch (Exception e) {
            this.showErrorPage(e);
        }
        return result.toString();
    }

    public String getXmlEditorInitMethods() throws JspException {
        StringBuffer result = new StringBuffer(1024);
        StringBuffer tabs = new StringBuffer(512);
        if (this.m_content.getHandler().getTabs().size() > 0) {
            result.append("var xmlSelectedTab = 0;\n");
            result.append("var xmlErrorTabs = new Array();\n");
            result.append("var xmlWarningTabs = new Array();\n");
            tabs.append("\t$xmltabs = $(\"#xmltabs\").tabs({});\n");
            tabs.append("\t$xmltabs.tabs(\"select\", xmlSelectedTab);\n");
            tabs.append("\tfor (var i=0; i<xmlErrorTabs.length; i++) {\n");
            tabs.append("\t\t$(\"#OcmsTabTab\" + xmlErrorTabs[i]).addClass(\"ui-state-error\");\n");
            tabs.append("\t}\n");
            tabs.append("\tfor (var i=0; i<xmlWarningTabs.length; i++) {\n");
            tabs.append("\t\t$(\"#OcmsTabTab\" + xmlWarningTabs[i]).addClass(\"ui-state-warning\");\n");
            tabs.append("\t}\n");
        }
        result.append("var dialogTitleAddChoice = \"");
        result.append(this.key("GUI_EDITOR_XMLCONTENT_CHOICE_ADD_HL_0"));
        result.append("\";\n");
        result.append("var dialogTitleAddSubChoice = \"");
        result.append(this.key("GUI_EDITOR_XMLCONTENT_CHOICE_SUB_ADD_HL_0"));
        result.append("\";\n");
        result.append("var vfsPathEditorForm = \"");
        result.append(this.getJsp().link("/system/workplace/editors/xmlcontent/editor_form.jsp"));
        result.append("\";\n");
        result.append("if (jQuery) {\n");
        result.append("$(document).ready(function(){\n");
        result.append(tabs);
        result.append("\t$(\"#xmladdelementdialog\").dialog({\n");
        result.append("\t\ttitle: \"");
        result.append(this.key("GUI_EDITOR_XMLCONTENT_CHOICE_ADD_HL_0"));
        result.append("\",\n");
        result.append("\t\tautoOpen: false,\n");
        result.append("\t\tbgiframe: true,\n");
        result.append("\t\tminHeight: 150,\n");
        result.append("\t\tminWidth: 300,\n");
        result.append("\t\twidth: 360,\n");
        result.append("\t\tmodal: true,\n");
        result.append("\t\tbuttons: {  \"");
        result.append(this.key("GUI_DIALOG_BUTTON_CANCEL_0"));
        result.append("\": function() { $(this).dialog(\"close\"); } }\n");
        result.append("\t});\n");
        result.append("});\n");
        result.append("}\n");
        try {
            for (I_CmsWidget widget : this.getWidgetCollector().getUniqueWidgets()) {
                result.append(widget.getDialogInitMethod(this.getCms(), this));
                result.append("\n");
            }
        }
        catch (Exception e) {
            this.showErrorPage(e);
        }
        return result.toString();
    }

    public boolean hasValidationErrors() {
        return this.getValidationHandler().hasErrors();
    }

    public boolean isPreviewEnabled() {
        try {
            CmsFile file = this.getCms().readFile(this.getParamResource(), CmsResourceFilter.ALL);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), file);
            return content.getHandler().getPreview(this.getCms(), this.m_content, this.getParamResource()) != null;
        }
        catch (Exception e) {
            return false;
        }
    }

    public void setEditorValues(Locale locale) throws CmsXmlException {
        List<String> names = this.m_content.getNames(locale);
        for (String path : names) {
            I_CmsXmlContentValue value = this.m_content.getValue(path, locale);
            if (!value.isSimpleType()) continue;
            I_CmsWidget widget = value.getContentDefinition().getContentHandler().getWidget(value);
            widget.setEditorValue(this.getCms(), this.getJsp().getRequest().getParameterMap(), this, (I_CmsWidgetParameter)((Object)value));
        }
    }

    public void setParamChoiceElement(String choiceElement) {
        this.m_paramChoiceElement = choiceElement;
    }

    public void setParamChoiceType(String paramChoiceType) {
        this.m_paramChoiceType = paramChoiceType;
    }

    public void setParamEditContext(String editContext) {
        this.m_paramEditContext = editContext;
        CmsObject cms = this.getCms();
        if (cms != null && editContext != null) {
            cms.getRequestContext().setAttribute(ATTRIBUTE_EDITCONTEXT, editContext);
        }
    }

    public void setParamElementIndex(String elementIndex) {
        this.m_paramElementIndex = elementIndex;
    }

    public void setParamElementName(String elementName) {
        this.m_paramElementName = elementName;
    }

    public void setParamMode(String mode) {
        this.m_mode = mode;
    }

    public void setParamModelFile(String paramMasterFile) {
        this.m_paramModelFile = paramMasterFile;
    }

    public void setParamNewLink(String paramNewLink) {
        this.m_paramNewLink = CmsEncoder.decode(paramNewLink);
    }

    public void setParamPostCreateHandler(String handler) {
        this.m_postCreateHandler = handler;
    }

    public boolean showElementLanguageSelector() {
        List<Locale> locales = OpenCms.getLocaleManager().getAvailableLocales(this.getCms(), this.getParamResource());
        return locales != null && locales.size() >= 2;
    }

    @Override
    public boolean useNewStyle() {
        return false;
    }

    @Override
    protected void commitTempFile() throws CmsException {
        super.commitTempFile();
        this.m_file = this.getCloneCms().readFile(this.getParamResource());
        this.m_content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), this.m_file);
    }

    protected Locale ensureLocale(Locale locale) {
        List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(this.getCms(), this.getParamResource());
        if (this.m_content != null) {
            if (!this.m_content.hasLocale(locale)) {
                try {
                    if (this.m_content.getLocales().size() > 0) {
                        try {
                            this.m_content.copyLocale(locales, locale);
                        }
                        catch (CmsException e) {
                            this.m_content.addLocale(this.getCms(), locale);
                        }
                    } else {
                        this.m_content.addLocale(this.getCms(), locale);
                    }
                    this.writeContent();
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getMessageContainer(), (Throwable)e);
                }
            }
            if (!this.m_content.hasLocale(locale)) {
                locale = this.m_content.getLocales().get(0);
            }
        }
        return locale;
    }

    @Override
    protected void initContent() {
    }

    protected void initElementLanguage() {
        List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(this.getCms(), this.getParamResource());
        Locale locale = locales.get(0);
        locale = this.ensureLocale(locale);
        this.setParamElementlanguage(locale.toString());
    }

    @Override
    protected void initWorkplaceRequestValues(CmsWorkplaceSettings settings, HttpServletRequest request) {
        block70: {
            block68: {
                this.fillParamValues(request);
                this.setParamDialogtype(EDITOR_TYPE);
                if (this.getParamNewLink() != null) {
                    this.setParamAction(EDITOR_ACTION_NEW);
                } else if (this.getParamTempfile() != null && !"null".equals(this.getParamTempfile())) {
                    try {
                        this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
                        this.m_content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), this.m_file);
                    }
                    catch (CmsException e) {
                        try {
                            this.showErrorPage(this, e);
                        }
                        catch (JspException exc) {
                            if (!LOG.isInfoEnabled()) break block68;
                            LOG.info((Object)exc);
                        }
                    }
                }
            }
            if ("save".equals(this.getParamAction())) {
                this.setAction(121);
            } else if ("saveexit".equals(this.getParamAction())) {
                this.setAction(123);
            } else if ("exit".equals(this.getParamAction())) {
                this.setAction(122);
            } else if (EDITOR_ACTION_SUBCHOICES.equals(this.getParamAction())) {
                this.setAction(159);
            } else {
                if ("closebrowser".equals(this.getParamAction())) {
                    this.actionClear(true);
                    return;
                }
                if (EDITOR_ACTION_CHECK.equals(this.getParamAction())) {
                    this.setAction(151);
                } else if ("saveaction".equals(this.getParamAction())) {
                    block69: {
                        this.setAction(130);
                        try {
                            this.actionDirectEdit();
                        }
                        catch (Exception e) {
                            if (!LOG.isInfoEnabled()) break block69;
                            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                    this.setAction(122);
                } else if (EDITOR_COPYLOCALE.equals(this.getParamAction())) {
                    this.setAction(141);
                } else if ("deletelocale".equals(this.getParamAction())) {
                    this.setAction(140);
                } else if ("show".equals(this.getParamAction())) {
                    this.setAction(125);
                } else if ("error".equals(this.getParamAction())) {
                    this.setAction(127);
                } else if ("changeelement".equals(this.getParamAction())) {
                    this.setAction(125);
                    this.actionChangeElementLanguage();
                } else {
                    if (EDITOR_ACTION_ELEMENT_ADD.equals(this.getParamAction())) {
                        this.setAction(154);
                        try {
                            this.actionToggleElement();
                        }
                        catch (JspException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                            }
                            break block70;
                        }
                    }
                    if (EDITOR_ACTION_ELEMENT_REMOVE.equals(this.getParamAction())) {
                        this.setAction(157);
                        try {
                            this.actionToggleElement();
                        }
                        catch (JspException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                            }
                            break block70;
                        }
                    }
                    if (EDITOR_ACTION_ELEMENT_MOVE_DOWN.equals(this.getParamAction())) {
                        this.setAction(155);
                        try {
                            this.actionMoveElement();
                        }
                        catch (JspException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                            }
                            break block70;
                        }
                    }
                    if (EDITOR_ACTION_ELEMENT_MOVE_UP.equals(this.getParamAction())) {
                        this.setAction(156);
                        try {
                            this.actionMoveElement();
                        }
                        catch (JspException e) {
                            if (LOG.isErrorEnabled()) {
                                LOG.error((Object)org.opencms.workplace.Messages.get().getBundle().key("LOG_INCLUDE_ERRORPAGE_FAILED_0"));
                            }
                            break block70;
                        }
                    }
                    if (EDITOR_ACTION_NEW.equals(this.getParamAction())) {
                        this.setAction(158);
                        return;
                    }
                    if ("preview".equals(this.getParamAction())) {
                        this.setAction(126);
                    } else {
                        block71: {
                            if (EDITOR_CORRECTIONCONFIRMED.equals(this.getParamAction())) {
                                this.setAction(125);
                                try {
                                    this.correctXmlStructure();
                                }
                                catch (CmsException e) {
                                    try {
                                        this.showErrorPage(this, e);
                                        break block70;
                                    }
                                    catch (JspException exc) {
                                        if (LOG.isInfoEnabled()) {
                                            LOG.info((Object)exc);
                                        }
                                        break block70;
                                    }
                                }
                            }
                            this.setAction(0);
                            try {
                                if (Boolean.valueOf(this.getParamDirectedit()).booleanValue()) {
                                    this.checkLock(this.getParamResource(), CmsLockType.TEMPORARY);
                                } else {
                                    this.checkLock(this.getParamResource());
                                }
                                this.setParamTempfile(this.createTempFile());
                                this.m_file = this.getCms().readFile(this.getParamTempfile(), CmsResourceFilter.ALL);
                                this.m_content = CmsXmlContentFactory.unmarshal(this.getCloneCms(), this.m_file);
                                try {
                                    this.m_content.validateXmlStructure(new CmsXmlEntityResolver(this.getCms()));
                                }
                                catch (CmsXmlException eXml) {
                                    if (OpenCms.getWorkplaceManager().isXmlContentAutoCorrect()) {
                                        this.correctXmlStructure();
                                        break block71;
                                    }
                                    this.setAction(152);
                                }
                            }
                            catch (CmsException e) {
                                try {
                                    this.showErrorPage(this, e);
                                }
                                catch (JspException exc) {
                                    if (!LOG.isInfoEnabled()) break block71;
                                    LOG.info((Object)exc);
                                }
                            }
                        }
                        if (this.getParamElementlanguage() == null) {
                            this.initElementLanguage();
                        } else {
                            Locale locale = CmsLocaleManager.getLocale(this.getParamElementlanguage());
                            this.ensureLocale(locale);
                        }
                    }
                }
            }
        }
    }

    private String buildElementButtons(I_CmsXmlContentValue value, boolean addElement, boolean removeElement) {
        String result;
        StringBuffer jsCall = new StringBuffer(512);
        String elementName = CmsXmlUtils.removeXpathIndex(value.getPath());
        boolean buttonPresent = false;
        int index = value.getIndex();
        jsCall.append("showElementButtons('");
        jsCall.append(elementName);
        jsCall.append("', ");
        jsCall.append(index);
        jsCall.append(", ");
        if (removeElement) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(", ");
        if (index > 0) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(", ");
        int indexCount = this.m_content.getIndexCount(elementName, this.getElementLocale());
        if (index < indexCount - 1) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(", ");
        if (addElement) {
            jsCall.append(Boolean.TRUE);
            buttonPresent = true;
        } else {
            jsCall.append(Boolean.FALSE);
        }
        jsCall.append(", ");
        JSONArray newElements = this.buildElementChoices(elementName, value.isChoiceType(), true);
        jsCall.append("'").append(CmsEncoder.escape(newElements.toString(), "UTF-8")).append("'");
        jsCall.append(");");
        if (buttonPresent) {
            StringBuffer action;
            String btIcon = "xmledit.png";
            String btAction = jsCall.toString();
            if (addElement && removeElement) {
                btIcon = "xmledit_del_add.png";
            } else if (addElement) {
                btIcon = "xmledit_add.png";
                action = new StringBuffer(128);
                action.append("addElement('");
                action.append(elementName);
                action.append("', ");
                action.append(index);
                action.append(", '").append(CmsEncoder.escape(newElements.toString(), "UTF-8")).append("'");
                action.append(");");
                btAction = action.toString();
            } else if (removeElement) {
                btIcon = "xmledit_del.png";
                action = new StringBuffer(128);
                action.append("removeElement('");
                action.append(elementName);
                action.append("', ");
                action.append(index);
                action.append(");");
                btAction = action.toString();
            }
            StringBuffer href = new StringBuffer(512);
            href.append("javascript:");
            href.append(btAction);
            href.append("\" onmouseover=\"");
            href.append(jsCall);
            href.append("checkElementButtons(true);\" onmouseout=\"checkElementButtons(false);\" id=\"btimg.");
            href.append(elementName).append(".").append(index);
            result = this.button(href.toString(), null, btIcon, "GUI_EDITOR_XMLCONTENT_ELEMENT_BUTTONS_0", 0);
        } else {
            result = this.buttonBarSpacer(1);
        }
        return result;
    }

    private void correctXmlStructure() throws CmsException {
        this.m_content.setAutoCorrectionEnabled(true);
        this.m_content.correctXmlStructure(this.getCms());
        this.writeContent();
    }

    private CmsXmlContentErrorHandler getValidationHandler() {
        if (this.m_validationHandler == null) {
            this.m_validationHandler = this.m_content.validate(this.getCms());
        }
        return this.m_validationHandler;
    }

    private StringBuffer getXmlEditorForm(CmsXmlContentDefinition contentDefinition, String pathPrefix, boolean showHelpBubble, boolean superTabOpened) {
        StringBuffer result = new StringBuffer(1024);
        boolean showErrors = this.getAction() != 158 && this.getAction() != 0 && this.getAction() != 154 && this.getAction() != 157 && this.getAction() != 155 && this.getAction() != 156;
        try {
            Iterator<I_CmsXmlSchemaType> it;
            boolean nested = CmsStringUtil.isNotEmpty(pathPrefix);
            boolean useTabs = false;
            boolean tabOpened = false;
            StringBuffer selectedTabScript = new StringBuffer(64);
            boolean collapseLabel = false;
            boolean firstElement = true;
            if (!nested && showErrors && this.getValidationHandler().hasErrors()) {
                result.append("<div class=\"ui-widget\">");
                result.append("<div class=\"ui-state-error ui-corner-all\" style=\"padding: 0pt 0.7em;\"><div style=\"padding: 3px 0;\">");
                result.append("<span class=\"ui-icon ui-icon-alert\" style=\"float: left; margin-right: 0.3em;\"></span>");
                boolean differentLocaleErrors = false;
                if (this.getValidationHandler().getErrors(this.getElementLocale()) == null || this.getValidationHandler().getErrors().size() > this.getValidationHandler().getErrors(this.getElementLocale()).size()) {
                    differentLocaleErrors = true;
                    result.append("<span id=\"xmlerrordialogbutton\" class=\"ui-icon ui-icon-newwin\" style=\"float: left; margin-right: 0.3em;\"></span>");
                }
                result.append(this.key("ERR_EDITOR_XMLCONTENT_VALIDATION_ERROR_TITLE_0"));
                result.append("</div>");
                if (differentLocaleErrors) {
                    result.append("<div id=\"xmlerrordialog\" style=\"display: none;\">");
                    Map<Locale, Map<String, String>> locErrors = this.getValidationHandler().getErrors();
                    for (Map.Entry<Locale, Map<String, String>> locEntry : locErrors.entrySet()) {
                        Locale locale = locEntry.getKey();
                        if (this.getElementLocale().equals(locale)) continue;
                        result.append("<div style=\"padding: 3px;\"><strong>");
                        result.append(this.key("ERR_EDITOR_XMLCONTENT_VALIDATION_ERROR_LANG_1", new Object[]{locale.getLanguage()}));
                        result.append("</strong></div>\n");
                        result.append("<ul>");
                        Map<String, String> elErrors = locEntry.getValue();
                        for (Map.Entry<String, String> elEntry : elErrors.entrySet()) {
                            String nodeName = elEntry.getKey();
                            String errorMsg = elEntry.getValue();
                            result.append("<li>");
                            result.append(nodeName);
                            result.append(": ");
                            result.append(errorMsg);
                            result.append("</li>\n");
                        }
                        result.append("</ul>");
                    }
                    result.append("</div>\n");
                    result.append("<script >\n");
                    result.append("$(\"#xmlerrordialog\").dialog({\n");
                    result.append("\tautoOpen: true,\n");
                    result.append("\tbgiframe: true,\n");
                    result.append("\twidth: 500,\n");
                    result.append("\tposition: 'center',\n");
                    result.append("\tdialogClass: 'ui-state-error',\n");
                    result.append("\ttitle: '").append(this.key("ERR_EDITOR_XMLCONTENT_VALIDATION_ERROR_TITLE_0")).append("',\n");
                    result.append("\tmaxHeight: 600\n");
                    result.append("});\n");
                    result.append("$(\"#xmlerrordialogbutton\").bind(\"click\", function(e) {$(\"#xmlerrordialog\").dialog(\"open\");});\n");
                    result.append("</script>");
                }
                result.append("</div></div>");
            }
            if (!nested) {
                boolean bl = useTabs = contentDefinition.getContentHandler().getTabs().size() > 0;
                if (useTabs) {
                    result.append("<div id=\"xmltabs\" class=\"ui-tabs\">\n<ul>\n");
                    for (CmsXmlContentTab tab : contentDefinition.getContentHandler().getTabs()) {
                        result.append("\t<li id=\"OcmsTabTab").append(tab.getIdName()).append("\"><a href=\"#OcmsTab");
                        result.append(tab.getIdName());
                        result.append("\"><span>");
                        result.append(this.keyDefault("label." + contentDefinition.getInnerName() + "." + tab.getTabName(), tab.getTabName()));
                        result.append("</span></a></li>\n");
                    }
                    result.append("</ul>\n");
                }
            }
            Iterator<I_CmsXmlSchemaType> iterator = it = contentDefinition.getChoiceMaxOccurs() > 0 ? contentDefinition.getTypeSequence().subList(0, 1).iterator() : contentDefinition.getTypeSequence().iterator();
            while (it.hasNext()) {
                CmsXmlContentValueSequence elementSequence;
                int elementCount;
                I_CmsXmlSchemaType type = it.next();
                boolean tabCurrentlyOpened = false;
                if (useTabs) {
                    for (int tabIndex = 0; tabIndex < contentDefinition.getContentHandler().getTabs().size(); ++tabIndex) {
                        CmsXmlContentTab checkTab = contentDefinition.getContentHandler().getTabs().get(tabIndex);
                        if (!checkTab.getStartName().equals(type.getName())) continue;
                        if (tabOpened) {
                            result.append("</table>\n</div>\n");
                        }
                        result.append("<div id=\"OcmsTab");
                        result.append(checkTab.getIdName());
                        result.append("\" class=\"ui-tabs-hide\">\n");
                        tabOpened = true;
                        tabCurrentlyOpened = true;
                        collapseLabel = checkTab.isCollapsed();
                        this.m_currentTab = checkTab;
                        this.m_currentTabIndex = tabIndex;
                        break;
                    }
                }
                if (firstElement || tabCurrentlyOpened) {
                    result.append("<table class=\"xmlTable");
                    if (nested && !superTabOpened) {
                        result.append("Nested");
                    }
                    result.append("\">\n");
                    firstElement = false;
                }
                boolean addValue = (elementCount = (elementSequence = this.m_content.getValueSequence(pathPrefix + type.getName(), this.getElementLocale())).getElementCount()) < elementSequence.getMaxOccurs();
                boolean removeValue = elementCount > elementSequence.getMinOccurs();
                boolean disabledElement = false;
                if (contentDefinition.getChoiceMaxOccurs() == 0 && elementCount < 1) {
                    elementCount = 1;
                    elementSequence.addValue(this.getCms(), 0);
                    disabledElement = true;
                    this.m_optionalElementPresent = true;
                }
                for (int j = 0; j < elementCount; ++j) {
                    String elemName;
                    I_CmsXmlContentValue value = elementSequence.getValue(j);
                    String key = value.getPath();
                    if (this.m_currentTab != null && CmsStringUtil.isNotEmpty(this.getParamElementName()) && key.startsWith(this.getParamElementName()) && selectedTabScript.length() == 0) {
                        selectedTabScript.append("<script >\n\txmlSelectedTab = ").append(this.m_currentTabIndex).append(";\n</script>\n");
                    }
                    if (showErrors && this.getValidationHandler().hasErrors(this.getElementLocale()) && this.getValidationHandler().getErrors(this.getElementLocale()).containsKey(key)) {
                        if (collapseLabel) {
                            result.append("<tr><td class=\"xmlTdError\"><img src=\"");
                            result.append(this.getEditorResourceUri());
                            result.append("error.png\" border=\"0\" alt=\"\" align=\"left\" hspace=\"5\">");
                            result.append(this.resolveMacros(this.getValidationHandler().getErrors(this.getElementLocale()).get(key)));
                            result.append("</td><td></td></tr>\n");
                        } else {
                            result.append("<tr><td></td><td><img src=\"");
                            result.append(this.getEditorResourceUri());
                            result.append("error.png");
                            result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdError\">");
                            result.append(this.resolveMacros(this.getValidationHandler().getErrors(this.getElementLocale()).get(key)));
                            result.append("</td><td></td></tr>\n");
                        }
                        elemName = CmsXmlUtils.getFirstXpathElement(value.getPath());
                        if (this.m_currentTab != null && !this.m_errorTabs.contains(this.m_currentTab) && (elemName.equals(this.m_currentTab.getStartName()) || !CmsXmlUtils.isDeepXpath(value.getPath()) && value.getName().equals(elemName))) {
                            this.m_errorTabs.add(this.m_currentTab);
                        }
                    }
                    if (showErrors && this.getValidationHandler().hasWarnings(this.getElementLocale()) && this.getValidationHandler().getWarnings(this.getElementLocale()).containsKey(key)) {
                        if (collapseLabel) {
                            result.append("<tr><td class=\"xmlTdError\"><img src=\"");
                            result.append(this.getEditorResourceUri());
                            result.append("warning.png\" border=\"0\" alt=\"\" align=\"left\" hspace=\"5\">");
                            result.append(this.resolveMacros(this.getValidationHandler().getWarnings(this.getElementLocale()).get(key)));
                            result.append("</td><td></td></tr>\n");
                        } else {
                            result.append("<tr><td></td><td><img src=\"");
                            result.append(this.getEditorResourceUri());
                            result.append("warning.png");
                            result.append("\" border=\"0\" alt=\"\"></td><td class=\"xmlTdWarning\">");
                            result.append(this.resolveMacros(this.getValidationHandler().getWarnings(this.getElementLocale()).get(key)));
                            result.append("</td><td></td></tr>\n");
                        }
                        elemName = CmsXmlUtils.getFirstXpathElement(value.getPath());
                        if (this.m_currentTab != null && !this.m_warningTabs.contains(this.m_currentTab) && (elemName.equals(this.m_currentTab.getStartName()) || !CmsXmlUtils.isDeepXpath(value.getPath()) && value.getName().equals(elemName))) {
                            this.m_warningTabs.add(this.m_currentTab);
                        }
                    }
                    I_CmsWidget widget = value.isSimpleType() ? contentDefinition.getContentHandler().getWidget(value) : null;
                    int index = value.getIndex();
                    result.append("<tr>");
                    if (!collapseLabel) {
                        result.append("<td class=\"xmlLabel");
                        if (disabledElement) {
                            result.append("Disabled");
                        }
                        result.append("\">");
                        result.append(this.keyDefault(A_CmsWidget.getLabelKey((I_CmsWidgetParameter)((Object)value)), value.getName()));
                        if (elementCount > 1) {
                            result.append(" [").append(index + 1).append("]");
                        }
                        result.append(": </td>");
                        if (showHelpBubble && widget != null && CmsXmlUtils.getXpathIndexInt(value.getPath()) == 1) {
                            result.append(widget.getHelpBubble(this.getCms(), this, (I_CmsWidgetParameter)((Object)value)));
                        } else {
                            result.append(this.buttonBarSpacer(16));
                        }
                    }
                    if (disabledElement) {
                        result.append("<td class=\"xmlTdDisabled maxwidth\">");
                        result.append(this.key("GUI_EDITOR_XMLCONTENT_OPTIONALELEMENT_0"));
                        result.append("</td>");
                    } else if (widget != null && value.isSimpleType()) {
                        result.append(widget.getDialogWidget(this.getCms(), this, (I_CmsWidgetParameter)((Object)value)));
                    } else {
                        result.append("<td class=\"maxwidth\">");
                        boolean showHelp = j == 0;
                        superTabOpened = !nested && tabOpened && collapseLabel;
                        result.append(this.getXmlEditorForm(((CmsXmlNestedContentDefinition)value).getNestedContentDefinition(), value.getPath() + "/", showHelp, superTabOpened));
                        result.append("</td>");
                    }
                    result.append(this.buildElementButtons(value, addValue, removeValue));
                    result.append("</tr>\n");
                    if (!disabledElement) continue;
                    elementSequence.removeValue(0);
                }
            }
            result.append("</table>\n");
            if (tabOpened) {
                result.append("</div>\n");
            }
            if (!nested && useTabs) {
                result.append("</div>\n");
                result.append("<script >\n");
                for (CmsXmlContentTab checkTab : this.m_warningTabs) {
                    if (this.m_errorTabs.contains(checkTab)) continue;
                    result.append("\txmlWarningTabs[xmlWarningTabs.length] = \"").append(checkTab.getIdName()).append("\";\n");
                }
                for (CmsXmlContentTab checkTab : this.m_errorTabs) {
                    result.append("\txmlErrorTabs[xmlErrorTabs.length] = \"").append(checkTab.getIdName()).append("\";\n");
                }
                result.append("</script>\n");
            }
            if (selectedTabScript.length() > 0) {
                result.append(selectedTabScript);
            }
        }
        catch (Throwable t) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_XML_EDITOR_0"), t);
        }
        return result;
    }

    private void resetErrorHandler() {
        this.m_validationHandler = null;
    }

    private void resetWidgetCollector() {
        this.m_widgetCollector = null;
    }

    private void writeContent() throws CmsException {
        String decodedContent = this.m_content.toString();
        try {
            this.m_file.setContents(decodedContent.getBytes(this.getFileEncoding()));
        }
        catch (UnsupportedEncodingException e) {
            throw new CmsException(Messages.get().container("ERR_INVALID_CONTENT_ENC_1", this.getParamResource()), (Throwable)e);
        }
        CmsObject cloneCms = this.getCloneCms();
        CmsUUID tempProjectId = OpenCms.getWorkplaceManager().getTempFileProjectId();
        cloneCms.getRequestContext().setCurrentProject(this.getCms().readProject(tempProjectId));
        this.m_file = cloneCms.writeFile(this.m_file);
        this.m_content = CmsXmlContentFactory.unmarshal(cloneCms, this.m_file);
    }
}

