/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.formatters.CmsSettingConfiguration;
import org.opencms.ade.configuration.plugins.CmsTemplatePlugin;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsMetaMapping;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsFormatterBean
implements I_CmsFormatterBean,
Cloneable {
    public static final int DEFAULT_CONFIGURATION_RANK = 1000;
    public static final int DEFAULT_SCHEMA_RANK = 10000;
    public static final String PREVIEW_TYPE = "_PREVIEW_";
    public static final int PREVIEW_WIDTH = 640;
    public static final String WILDCARD_TYPE = "*";
    private static final Log LOG = CmsLog.getLog(CmsFormatterBean.class);
    protected Set<String> m_containerTypes;
    protected Set<String> m_cssHeadIncludes = new LinkedHashSet<String>();
    protected String m_description;
    protected Set<String> m_aliasKeys = new HashSet<String>();
    private Set<String> m_allKeys = new HashSet<String>();
    protected String m_displayType;
    protected String m_id;
    protected String m_inlineCss;
    protected String m_inlineJavascript;
    protected boolean m_isAutoEnabled;
    protected boolean m_isDetail;
    protected boolean m_isFromFormatterConfigFile;
    protected boolean m_isPreviewFormatter;
    protected List<String> m_javascriptHeadIncludes = new ArrayList<String>();
    protected String m_jspRootPath;
    protected CmsUUID m_jspStructureId;
    protected String m_key;
    protected String m_location;
    protected boolean m_matchAll;
    protected int m_maxWidth;
    protected List<CmsMetaMapping> m_metaMappings;
    protected int m_minWidth;
    protected boolean m_nestedFormatterSettings;
    protected String m_niceName;
    protected List<CmsTemplatePlugin> m_plugins = Collections.emptyList();
    protected int m_rank;
    protected Collection<String> m_resourceTypeNames;
    protected boolean m_search;
    protected boolean m_strictContainers;
    protected boolean m_useMetaMappingsForNormalElements;
    private Map<String, String> m_attributes = Collections.emptyMap();
    private boolean m_isAllowsSettingsInEditor;
    private CmsSettingConfiguration m_settingConfig;

    public CmsFormatterBean(Set<String> containerTypes, String jspRootPath, CmsUUID jspStructureId, String key, Set<String> aliasKeys, int minWidth, int maxWidth, boolean preview, boolean searchContent, String location, List<String> cssHeadIncludes, String inlineCss, List<String> javascriptHeadIncludes, String inlineJavascript, List<CmsTemplatePlugin> plugins, String niceName, String description, Collection<String> resourceTypeNames, int rank, String id, CmsSettingConfiguration settingConfig, boolean isFromConfigFile, boolean isAutoEnabled, boolean isDetail, String displayType, boolean isAllowsSettingsInEditor, boolean strictContainers, boolean nestedFormatterSettings, List<CmsMetaMapping> metaMappings, Map<String, String> attributes, boolean useMetaMappingsForNormalElements) {
        this.m_jspRootPath = jspRootPath;
        this.m_jspStructureId = jspStructureId;
        this.m_key = key;
        if (this.m_key != null) {
            this.m_key = this.m_key.trim();
            this.m_allKeys.add(this.m_key);
        }
        if (aliasKeys != null) {
            this.m_aliasKeys.addAll(aliasKeys);
            this.m_allKeys.addAll(aliasKeys);
        }
        this.m_containerTypes = containerTypes;
        this.m_minWidth = minWidth;
        this.m_maxWidth = maxWidth;
        this.m_isPreviewFormatter = preview;
        this.m_search = searchContent;
        this.m_location = location;
        this.m_description = description;
        this.m_id = id;
        this.m_niceName = niceName;
        this.m_resourceTypeNames = resourceTypeNames;
        this.m_rank = rank;
        this.m_inlineCss = inlineCss;
        this.m_inlineJavascript = inlineJavascript;
        this.m_javascriptHeadIncludes.addAll(javascriptHeadIncludes);
        this.m_cssHeadIncludes.addAll(cssHeadIncludes);
        this.m_plugins = new ArrayList<CmsTemplatePlugin>(plugins);
        this.m_settingConfig = settingConfig;
        this.m_isFromFormatterConfigFile = isFromConfigFile;
        this.m_isAutoEnabled = isAutoEnabled;
        this.m_isDetail = isDetail;
        this.m_displayType = displayType;
        this.m_nestedFormatterSettings = nestedFormatterSettings;
        this.m_strictContainers = strictContainers;
        this.m_metaMappings = metaMappings;
        this.m_useMetaMappingsForNormalElements = useMetaMappingsForNormalElements;
        this.m_isAllowsSettingsInEditor = isAllowsSettingsInEditor;
        this.m_attributes = attributes != null ? attributes : Collections.emptyMap();
    }

    public CmsFormatterBean(String containerType, String rootPath, CmsUUID structureId, int minWidth, int maxWidth, boolean preview, boolean searchContent, String location) {
        this(CmsFormatterBean.isWildcardType(containerType) ? Collections.emptySet() : Collections.singleton(containerType), rootPath, structureId, null, new HashSet<String>(), minWidth, maxWidth, preview, searchContent, location, Collections.emptyList(), "", Collections.emptyList(), "", new ArrayList<CmsTemplatePlugin>(), null, rootPath, Collections.emptySet(), 1000, null, new CmsSettingConfiguration(), false, false, true, null, false, false, false, null, null, false);
    }

    public CmsFormatterBean(String containerType, String jspRootPath, String minWidthStr, String maxWidthStr, String preview, String searchContent, String location) {
        this.m_jspRootPath = jspRootPath;
        this.m_containerTypes = Collections.singleton(containerType);
        if (CmsFormatterBean.isWildcardType(containerType)) {
            this.m_containerTypes = Collections.emptySet();
        }
        this.m_minWidth = -1;
        this.m_maxWidth = Integer.MAX_VALUE;
        if (this.m_containerTypes.isEmpty()) {
            try {
                this.m_minWidth = Integer.parseInt(minWidthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            try {
                this.m_maxWidth = Integer.parseInt(maxWidthStr);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        this.m_isPreviewFormatter = Boolean.valueOf(preview);
        this.m_search = CmsStringUtil.isEmptyOrWhitespaceOnly(searchContent) ? true : Boolean.valueOf(searchContent);
        this.m_location = location;
        this.m_rank = 10000;
    }

    CmsFormatterBean(String jspRootPath, CmsUUID jspStructureId, String location, boolean preview) {
        this(Collections.emptySet(), jspRootPath, jspStructureId, null, new HashSet<String>(), -1, Integer.MAX_VALUE, preview, false, location, Collections.emptyList(), "", Collections.emptyList(), "", new ArrayList<CmsTemplatePlugin>(), null, jspRootPath, Collections.emptySet(), 10000, null, new CmsSettingConfiguration(), false, false, true, null, false, false, false, null, Collections.emptyMap(), false);
        this.m_matchAll = true;
    }

    public static boolean isPreviewType(String containerType) {
        return PREVIEW_TYPE.equals(containerType);
    }

    private static boolean isWildcardType(String containerType) {
        return CmsStringUtil.isEmptyOrWhitespaceOnly(containerType) || WILDCARD_TYPE.equals(containerType);
    }

    @Override
    public Set<String> getAliasKeys() {
        return Collections.unmodifiableSet(this.m_aliasKeys);
    }

    @Override
    public Set<String> getAllKeys() {
        return Collections.unmodifiableSet(this.m_allKeys);
    }

    @Override
    public Map<String, String> getAttributes() {
        return this.m_attributes;
    }

    @Override
    public Set<String> getContainerTypes() {
        return this.m_containerTypes == null ? Collections.emptySet() : Collections.unmodifiableSet(this.m_containerTypes);
    }

    @Override
    public Set<String> getCssHeadIncludes() {
        return Collections.unmodifiableSet(this.m_cssHeadIncludes);
    }

    @Override
    public String getDescription(Locale locale) {
        if (locale == null) {
            return this.m_description;
        }
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        return resolver.resolveMacros(this.m_description);
    }

    @Override
    public String getDisplayType() {
        return this.m_displayType;
    }

    @Override
    public String getId() {
        return this.m_id;
    }

    @Override
    public String getInlineCss() {
        return this.m_inlineCss;
    }

    @Override
    public String getInlineJavascript() {
        return this.m_inlineJavascript;
    }

    @Override
    public List<String> getJavascriptHeadIncludes() {
        return Collections.unmodifiableList(this.m_javascriptHeadIncludes);
    }

    @Override
    public String getJspRootPath() {
        return this.m_jspRootPath;
    }

    @Override
    public CmsUUID getJspStructureId() {
        return this.m_jspStructureId;
    }

    @Override
    public String getKey() {
        return this.m_key;
    }

    @Override
    public String getLocation() {
        return this.m_location;
    }

    @Override
    public int getMaxWidth() {
        return this.m_maxWidth;
    }

    @Override
    public List<CmsMetaMapping> getMetaMappings() {
        return this.m_metaMappings;
    }

    @Override
    public int getMinWidth() {
        return this.m_minWidth;
    }

    @Override
    public String getNiceName(Locale locale) {
        if (locale == null) {
            return this.m_niceName;
        }
        CmsMacroResolver resolver = new CmsMacroResolver();
        resolver.setMessages(OpenCms.getWorkplaceManager().getMessages(locale));
        return resolver.resolveMacros(this.m_niceName);
    }

    @Override
    public int getRank() {
        return this.m_rank;
    }

    @Override
    public Collection<String> getResourceTypeNames() {
        return this.m_resourceTypeNames;
    }

    @Override
    public Map<String, CmsXmlContentProperty> getSettings(CmsADEConfigData config) {
        ImmutableList<CmsUUID> sharedSettingOverrides = config.getSharedSettingOverrides();
        return this.m_settingConfig.getSettings(sharedSettingOverrides);
    }

    @Override
    public List<CmsTemplatePlugin> getTemplatePlugins() {
        return Collections.unmodifiableList(this.m_plugins);
    }

    public int hashCode() {
        return this.getContainerTypes().hashCode() ^ (this.m_minWidth * 33 ^ this.m_maxWidth);
    }

    @Override
    public boolean hasNestedFormatterSettings() {
        return this.m_nestedFormatterSettings;
    }

    @Override
    public boolean isAllowsSettingsInEditor() {
        return this.m_isAllowsSettingsInEditor;
    }

    @Override
    public boolean isAutoEnabled() {
        return this.m_isAutoEnabled;
    }

    @Override
    public boolean isDetailFormatter() {
        return this.m_isDetail;
    }

    @Override
    public boolean isDisplayFormatter() {
        return this.m_displayType != null;
    }

    @Override
    public boolean isFromFormatterConfigFile() {
        return this.m_isFromFormatterConfigFile;
    }

    @Override
    public boolean isMatchAll() {
        return this.m_matchAll || this.m_containerTypes != null && this.m_containerTypes.contains(WILDCARD_TYPE);
    }

    @Override
    public boolean isPreviewFormatter() {
        return this.m_isPreviewFormatter;
    }

    @Override
    public boolean isSearchContent() {
        return this.m_search;
    }

    public boolean isStrictContainers() {
        return this.m_strictContainers;
    }

    @Override
    public boolean isTypeFormatter() {
        return !this.getContainerTypes().isEmpty();
    }

    @Override
    public void setJspStructureId(CmsUUID jspStructureId) {
        this.m_jspStructureId = jspStructureId;
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    @Override
    public boolean useMetaMappingsForNormalElements() {
        return this.m_useMetaMappingsForNormalElements;
    }

    @Override
    public Optional<I_CmsFormatterBean> withKeys(Collection<String> keys) {
        if (this.getKey() != null && !this.getAllKeys().equals(keys)) {
            HashSet<String> newAllKeys = new HashSet<String>(keys);
            newAllKeys.add(this.getKey());
            HashSet<String> newAliases = new HashSet<String>(keys);
            newAliases.remove(this.getKey());
            try {
                CmsFormatterBean clonedBean = (CmsFormatterBean)this.clone();
                clonedBean.m_aliasKeys = newAliases;
                clonedBean.m_allKeys = new HashSet<String>(keys);
                return Optional.of(clonedBean);
            }
            catch (CloneNotSupportedException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return Optional.empty();
            }
        }
        return Optional.of(this);
    }
}

