/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Collections2;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeJsp;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.containerpage.Messages;

public final class CmsFormatterConfiguration {
    public static final CmsFormatterConfiguration EMPTY_CONFIGURATION = new CmsFormatterConfiguration(null, null);
    public static final Log LOG = CmsLog.getLog(CmsFormatterConfiguration.class);
    public static final int MATCH_ALL_CONTAINER_WIDTH = -2;
    private static CmsObject m_adminCms;
    private List<I_CmsFormatterBean> m_allFormatters;
    private List<I_CmsFormatterBean> m_displayFormatters;
    private Map<CmsUUID, Boolean> m_searchContent = Maps.newHashMap();

    private CmsFormatterConfiguration(CmsObject cms, List<I_CmsFormatterBean> formatters) {
        this.m_allFormatters = formatters == null ? Collections.emptyList() : new ArrayList<I_CmsFormatterBean>(formatters);
        this.init(cms, m_adminCms);
    }

    public static CmsFormatterConfiguration create(CmsObject cms, List<I_CmsFormatterBean> formatters) {
        if (formatters != null && formatters.size() > 0 && cms != null) {
            return new CmsFormatterConfiguration(cms, formatters);
        }
        return EMPTY_CONFIGURATION;
    }

    public static void initialize(CmsObject cms) throws CmsException {
        OpenCms.getRoleManager().checkRole(cms, CmsRole.ADMINISTRATOR);
        try {
            m_adminCms = OpenCms.initCmsObject(cms);
            m_adminCms.getRequestContext().setSiteRoot("");
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
    }

    public static boolean matchFormatter(I_CmsFormatterBean formatter, Set<String> types, int width) {
        if (formatter.isMatchAll()) {
            return true;
        }
        if (formatter.isTypeFormatter()) {
            return !Sets.intersection(types, formatter.getContainerTypes()).isEmpty();
        }
        return width == -2 || formatter.getMinWidth() <= width && width <= formatter.getMaxWidth();
    }

    public static boolean matchFormatter(I_CmsFormatterBean formatter, String types, int width) {
        return new MatchesTypeOrWidth(types, width).apply(formatter);
    }

    public List<I_CmsFormatterBean> getAllFormatters() {
        return new ArrayList<I_CmsFormatterBean>(this.m_allFormatters);
    }

    public List<I_CmsFormatterBean> getAllMatchingFormatters(String containerTypes, int containerWidth) {
        return new ArrayList<I_CmsFormatterBean>(Collections2.filter(this.m_allFormatters, (Predicate)new MatchesTypeOrWidth(containerTypes, containerWidth)));
    }

    public I_CmsFormatterBean getDefaultFormatter(String containerTypes, int containerWidth) {
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)new MatchesTypeOrWidth(containerTypes, containerWidth));
        return (I_CmsFormatterBean)result.orNull();
    }

    public I_CmsFormatterBean getDefaultSchemaFormatter(String containerTypes, int containerWidth) {
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)Predicates.and((Predicate)new IsSchemaFormatter(), (Predicate)new MatchesTypeOrWidth(containerTypes, containerWidth)));
        return (I_CmsFormatterBean)result.orNull();
    }

    public I_CmsFormatterBean getDetailFormatter(String types, int containerWidth) {
        Predicate checkValidDetailFormatter = Predicates.and((Predicate)new MatchesTypeOrWidth(types, containerWidth), (Predicate)new IsDetail());
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)checkValidDetailFormatter);
        return (I_CmsFormatterBean)result.orNull();
    }

    public Collection<I_CmsFormatterBean> getDetailFormatters() {
        return Collections.unmodifiableCollection(Collections2.filter(this.m_allFormatters, (Predicate)new IsDetail()));
    }

    public I_CmsFormatterBean getDisplayFormatter() {
        if (!this.getDisplayFormatters().isEmpty()) {
            return this.getDisplayFormatters().get(0);
        }
        return null;
    }

    public List<I_CmsFormatterBean> getDisplayFormatters() {
        if (this.m_displayFormatters == null) {
            ArrayList formatters = new ArrayList(Collections2.filter(this.m_allFormatters, (Predicate)new IsDisplay()));
            if (formatters.size() > 1) {
                Collections.sort(formatters, new Comparator<I_CmsFormatterBean>(){

                    @Override
                    public int compare(I_CmsFormatterBean o1, I_CmsFormatterBean o2) {
                        return o1.getRank() == o2.getRank() ? 0 : (o1.getRank() < o2.getRank() ? -1 : 1);
                    }
                });
            }
            this.m_displayFormatters = Collections.unmodifiableList(formatters);
        }
        return this.m_displayFormatters;
    }

    public Map<String, I_CmsFormatterBean> getFormatterSelection(String containerTypes, int containerWidth) {
        LinkedHashMap<String, I_CmsFormatterBean> result = new LinkedHashMap<String, I_CmsFormatterBean>();
        for (I_CmsFormatterBean formatter : Collections2.filter(this.m_allFormatters, (Predicate)new MatchesTypeOrWidth(containerTypes, containerWidth))) {
            if (formatter.isFromFormatterConfigFile()) {
                result.put(formatter.getId(), formatter);
                continue;
            }
            result.put("schema_formatter" + formatter.getJspStructureId().toString(), formatter);
        }
        return result;
    }

    public Map<String, I_CmsFormatterBean> getFormatterSelectionByKeyOrId(String containerTypes, int containerWidth) {
        LinkedHashMap<String, I_CmsFormatterBean> result = new LinkedHashMap<String, I_CmsFormatterBean>();
        for (I_CmsFormatterBean formatter : Collections2.filter(this.m_allFormatters, (Predicate)new MatchesTypeOrWidth(containerTypes, containerWidth))) {
            if (formatter.isFromFormatterConfigFile()) {
                result.put(formatter.getId(), formatter);
                if (formatter.getKey() == null) continue;
                result.put(formatter.getKey(), formatter);
                continue;
            }
            result.put("schema_formatter" + formatter.getJspStructureId().toString(), formatter);
        }
        return result;
    }

    public List<I_CmsFormatterBean> getFormattersForKey(String key) {
        if (key == null) {
            return new ArrayList<I_CmsFormatterBean>();
        }
        ArrayList<I_CmsFormatterBean> result = new ArrayList<I_CmsFormatterBean>();
        if (key.startsWith("schema_formatter")) {
            String idStr = key.substring("schema_formatter".length());
            try {
                CmsUUID id = new CmsUUID(idStr);
                for (I_CmsFormatterBean formatter : this.m_allFormatters) {
                    if (formatter.isFromFormatterConfigFile() || !formatter.getJspStructureId().equals(id)) continue;
                    result.add(formatter);
                }
            }
            catch (NumberFormatException id) {
                // empty catch block
            }
        }
        for (I_CmsFormatterBean formatter : this.m_allFormatters) {
            if (formatter.getKey() != null && key.equals(formatter.getKey())) {
                result.add(formatter);
                continue;
            }
            if (formatter.getId() == null || !key.equals(formatter.getId().toString())) continue;
            result.add(formatter);
        }
        return result;
    }

    public I_CmsFormatterBean getPreviewFormatter() {
        Optional result = Iterables.tryFind(this.m_allFormatters, (Predicate)new Predicate<I_CmsFormatterBean>(){

            public boolean apply(I_CmsFormatterBean formatter) {
                return formatter.isPreviewFormatter();
            }
        });
        if (!result.isPresent()) {
            result = Iterables.tryFind(this.m_allFormatters, (Predicate)new Predicate<I_CmsFormatterBean>(){

                public boolean apply(I_CmsFormatterBean formatter) {
                    if (formatter.isTypeFormatter()) {
                        return formatter.getContainerTypes().contains("_PREVIEW_");
                    }
                    return formatter.getMinWidth() <= 640 && 640 <= formatter.getMaxWidth();
                }
            });
        }
        if (!result.isPresent()) {
            result = Iterables.tryFind(this.m_allFormatters, (Predicate)new Predicate<I_CmsFormatterBean>(){

                public boolean apply(I_CmsFormatterBean formatter) {
                    return !formatter.isTypeFormatter() && formatter.getMaxWidth() >= 640;
                }
            });
        }
        if (!result.isPresent() && !this.m_allFormatters.isEmpty()) {
            result = Optional.fromNullable((Object)this.m_allFormatters.iterator().next());
        }
        return (I_CmsFormatterBean)result.orNull();
    }

    public boolean hasFormatter(String containerTypes, int containerWidth) {
        return this.getDefaultFormatter(containerTypes, containerWidth) != null;
    }

    public boolean hasFormatters() {
        return !this.m_allFormatters.isEmpty();
    }

    public boolean isSearchContent(CmsUUID formatterStructureId) {
        if (EMPTY_CONFIGURATION == this) {
            return false;
        }
        Boolean result = this.m_searchContent.get(formatterStructureId);
        if (result == null) {
            for (I_CmsFormatterBean formatter : this.m_allFormatters) {
                if (!formatter.getJspStructureId().equals(formatterStructureId)) continue;
                result = formatter.isSearchContent();
                break;
            }
            if (result == null) {
                result = Boolean.FALSE;
            }
            this.m_searchContent.put(formatterStructureId, result);
        }
        return result;
    }

    private void init(CmsObject userCms, CmsObject adminCms) {
        ArrayList<I_CmsFormatterBean> filteredFormatters = new ArrayList<I_CmsFormatterBean>();
        for (I_CmsFormatterBean formatter : this.m_allFormatters) {
            if (formatter.getJspStructureId() == null) {
                CmsResource res = null;
                try {
                    CmsObject cmsCopy = OpenCms.initCmsObject(adminCms);
                    cmsCopy.getRequestContext().setCurrentProject(userCms.getRequestContext().getCurrentProject());
                    cmsCopy.getRequestContext().setSiteRoot("");
                    res = cmsCopy.readResource(formatter.getJspRootPath());
                }
                catch (CmsException cmsException) {
                    // empty catch block
                }
                if (res == null || !CmsResourceTypeJsp.isJsp(res)) {
                    LOG.error((Object)Messages.get().getBundle().key("ERR_FORMATTER_JSP_DONT_EXIST_1", formatter.getJspRootPath()));
                } else {
                    formatter.setJspStructureId(res.getStructureId());
                }
            }
            if (formatter.getJspStructureId() != null) {
                filteredFormatters.add(formatter);
                continue;
            }
            LOG.warn((Object)("Invalid formatter: " + formatter.getJspRootPath()));
        }
        Collections.sort(filteredFormatters, new FormatterComparator());
        this.m_allFormatters = Collections.unmodifiableList(filteredFormatters);
    }

    private static class MatchesTypeOrWidth
    implements Predicate<I_CmsFormatterBean> {
        private Set<String> m_types = Sets.newHashSet();
        private int m_width;

        public MatchesTypeOrWidth(String type, int width) {
            if (!CmsStringUtil.isEmptyOrWhitespaceOnly(type)) {
                this.m_types.addAll(Arrays.asList(type.trim().split(" *, *")));
            }
            this.m_width = width;
        }

        public boolean apply(I_CmsFormatterBean formatter) {
            return CmsFormatterConfiguration.matchFormatter(formatter, this.m_types, this.m_width);
        }
    }

    public static class IsSchemaFormatter
    implements Predicate<I_CmsFormatterBean> {
        public boolean apply(I_CmsFormatterBean formatter) {
            return !formatter.isFromFormatterConfigFile();
        }
    }

    public static class IsDisplay
    implements Predicate<I_CmsFormatterBean> {
        public boolean apply(I_CmsFormatterBean formatter) {
            return formatter.isDisplayFormatter();
        }
    }

    public static class IsDetail
    implements Predicate<I_CmsFormatterBean> {
        public boolean apply(I_CmsFormatterBean formatter) {
            return formatter.isDetailFormatter();
        }
    }

    public static class FormatterComparator
    implements Comparator<I_CmsFormatterBean> {
        @Override
        public int compare(I_CmsFormatterBean first, I_CmsFormatterBean second) {
            return ComparisonChain.start().compare(second.getRank(), first.getRank()).compare(second.isTypeFormatter() ? 1 : 0, first.isTypeFormatter() ? 1 : 0).compare(second.getMinWidth(), first.getMinWidth()).result();
        }
    }
}

