/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.containerpage;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.history.I_CmsHistoryResource;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.i18n.CmsEncoder;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.OpenCms;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.containerpage.CmsADECache;
import org.opencms.xml.containerpage.CmsXmlContainerPage;
import org.opencms.xml.content.Messages;
import org.xml.sax.EntityResolver;

public final class CmsXmlContainerPageFactory {
    private CmsXmlContainerPageFactory() {
    }

    public static CmsXmlContainerPage createDocument(CmsObject cms, Locale locale, String modelUri) throws CmsException {
        CmsXmlContainerPage content = new CmsXmlContainerPage(cms, locale, modelUri);
        return (CmsXmlContainerPage)content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlContainerPage createDocument(CmsObject cms, Locale locale, String encoding, CmsXmlContentDefinition contentDefinition) {
        CmsXmlContainerPage content = new CmsXmlContainerPage(cms, locale, encoding, contentDefinition);
        return (CmsXmlContainerPage)content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, byte[] xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlContainerPageFactory.unmarshal(cms, CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding, resolver);
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, CmsFile file) throws CmsXmlException {
        return CmsXmlContainerPageFactory.unmarshal(cms, file, true);
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, CmsFile file, boolean keepEncoding) throws CmsXmlException {
        return CmsXmlContainerPageFactory.unmarshal(cms, file, keepEncoding, false);
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, CmsFile file, boolean keepEncoding, boolean noCache) throws CmsXmlException {
        CmsXmlContainerPage content = null;
        if (!noCache && (content = CmsXmlContainerPageFactory.getCache(cms, file, keepEncoding)) != null) {
            return content;
        }
        byte[] contentBytes = file.getContents();
        String filename = cms.getSitePath(file);
        String encoding = null;
        try {
            encoding = cms.readPropertyObject(filename, "content-encoding", true).getValue();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
        } else if ((encoding = CmsEncoder.lookupEncoding(encoding, null)) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ENC_1", filename));
        }
        if (contentBytes.length > 0) {
            if (keepEncoding) {
                content = CmsXmlContainerPageFactory.unmarshal(cms, contentBytes, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
            } else {
                try {
                    String contentStr = new String(contentBytes, encoding);
                    content = CmsXmlContainerPageFactory.unmarshal(cms, contentStr, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_ENC_1", filename));
                }
            }
        } else {
            content = new CmsXmlContainerPage(cms, DocumentHelper.createDocument(), encoding, new CmsXmlEntityResolver(cms));
        }
        content.setFile(file);
        content.initDocument(cms);
        CmsXmlContainerPage xmlCntPage = (CmsXmlContainerPage)content.getHandler().prepareForUse(cms, content);
        if (!noCache) {
            CmsXmlContainerPageFactory.setCache(cms, xmlCntPage, keepEncoding);
        }
        return xmlCntPage;
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, CmsResource resource) throws CmsException {
        CmsXmlContainerPage content = CmsXmlContainerPageFactory.getCache(cms, resource, true);
        if (content != null) {
            return content;
        }
        content = CmsXmlContainerPageFactory.unmarshal(cms, cms.readFile(resource), true);
        CmsXmlContainerPageFactory.setCache(cms, content, true);
        return content;
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, CmsResource resource, ServletRequest req) throws CmsXmlException, CmsLoaderException, CmsException {
        String rootPath = resource.getRootPath();
        if (!CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            throw new CmsXmlException(Messages.get().container("ERR_XMLCONTENT_INVALID_TYPE_1", resource.getRootPath()));
        }
        CmsXmlContainerPage content = (CmsXmlContainerPage)req.getAttribute(rootPath);
        if (content == null) {
            content = CmsXmlContainerPageFactory.unmarshal(cms, resource);
            req.setAttribute(rootPath, (Object)content);
        }
        return content;
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, Document document, String encoding, EntityResolver resolver) {
        CmsXmlContainerPage content = new CmsXmlContainerPage(cms, document, encoding, resolver);
        return (CmsXmlContainerPage)content.getHandler().prepareForUse(cms, content);
    }

    public static CmsXmlContainerPage unmarshal(CmsObject cms, String xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return CmsXmlContainerPageFactory.unmarshal(cms, CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding, resolver);
    }

    private static CmsADECache getCache() {
        return OpenCms.getADEManager().getCache();
    }

    private static CmsXmlContainerPage getCache(CmsObject cms, CmsResource resource, boolean keepEncoding) {
        if (resource instanceof I_CmsHistoryResource) {
            return null;
        }
        return CmsXmlContainerPageFactory.getCache().getCacheContainerPage(CmsXmlContainerPageFactory.getCache().getCacheKey(resource.getStructureId(), keepEncoding), cms.getRequestContext().getCurrentProject().isOnlineProject());
    }

    private static void setCache(CmsObject cms, CmsXmlContainerPage xmlCntPage, boolean keepEncoding) {
        if (xmlCntPage.getFile() instanceof I_CmsHistoryResource) {
            return;
        }
        boolean online = cms.getRequestContext().getCurrentProject().isOnlineProject();
        CmsXmlContainerPageFactory.getCache().setCacheContainerPage(CmsXmlContainerPageFactory.getCache().getCacheKey(xmlCntPage.getFile().getStructureId(), keepEncoding), xmlCntPage, online);
    }
}

