/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.content;

import java.util.Optional;
import org.apache.commons.logging.Log;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.I_CmsXmlContentEditorChangeHandler;

public class CmsChangeHandlerConfig {
    private static final Log LOG = CmsLog.getLog(CmsChangeHandlerConfig.class);
    private String m_field;
    private String m_className;
    private String m_config;

    public CmsChangeHandlerConfig(String field, String className, String config) {
        this.m_field = field;
        this.m_className = className.trim();
        this.m_config = config;
    }

    public String getClassName() {
        return this.m_className;
    }

    public String getConfig() {
        return this.m_config;
    }

    public String getField() {
        return this.m_field;
    }

    public Optional<I_CmsXmlContentEditorChangeHandler> newHandler(String scope) {
        try {
            Class<?> cls = Class.forName(this.m_className, false, this.getClass().getClassLoader());
            if (I_CmsXmlContentEditorChangeHandler.class.isAssignableFrom(cls)) {
                I_CmsXmlContentEditorChangeHandler handler = (I_CmsXmlContentEditorChangeHandler)cls.newInstance();
                handler.setConfiguration(this.m_config);
                handler.setScope(scope);
                return Optional.of(handler);
            }
            throw new Exception("Incompatible class for editor change handler: " + this.m_className);
        }
        catch (Exception e) {
            LOG.error((Object)("Could not create editor change handler: " + e.getLocalizedMessage()), (Throwable)e);
            return Optional.empty();
        }
    }
}

