/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.page;

import java.io.UnsupportedEncodingException;
import java.util.Locale;
import javax.servlet.ServletRequest;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.CmsResourceTypeXmlPage;
import org.opencms.i18n.CmsEncoder;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.page.CmsXmlPage;
import org.opencms.xml.page.Messages;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.EntityResolver;

public final class CmsXmlPageFactory {
    private static final Log LOG = CmsLog.getLog(CmsXmlPageFactory.class);

    private CmsXmlPageFactory() {
    }

    public static Document createDocument(Locale locale) {
        Document doc = DocumentHelper.createDocument();
        Element pages = doc.addElement("pages");
        pages.add(I_CmsXmlSchemaType.XSI_NAMESPACE);
        pages.addAttribute(I_CmsXmlSchemaType.XSI_NAMESPACE_ATTRIBUTE_NO_SCHEMA_LOCATION, "http://www.opencms.org/dtd/6.0/xmlpage.xsd");
        Element page = pages.addElement("page");
        page.addAttribute("language", locale.toString());
        return doc;
    }

    public static String createDocument(Locale locale, String encoding) {
        try {
            return CmsXmlUtils.marshal(CmsXmlPageFactory.createDocument(locale), encoding);
        }
        catch (CmsXmlException e) {
            LOG.error((Object)Messages.get().getBundle().key("ERR_XML_PAGE_FACT_CREATE_DOC_0"), (Throwable)e);
            return null;
        }
    }

    public static CmsXmlPage unmarshal(byte[] xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return new CmsXmlPage(CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding);
    }

    public static CmsXmlPage unmarshal(CmsObject cms, CmsFile file) throws CmsXmlException {
        return CmsXmlPageFactory.unmarshal(cms, file, true);
    }

    public static CmsXmlPage unmarshal(CmsObject cms, CmsFile file, boolean keepEncoding) throws CmsXmlException {
        CmsXmlPage newPage;
        byte[] content = file.getContents();
        String fileName = cms.getSitePath(file);
        boolean allowRelative = false;
        try {
            allowRelative = Boolean.valueOf(cms.readPropertyObject(fileName, "allowRelativeLinks", false).getValue());
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        String encoding = null;
        try {
            encoding = cms.readPropertyObject(fileName, "content-encoding", true).getValue();
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (encoding == null) {
            encoding = OpenCms.getSystemInfo().getDefaultEncoding();
        } else if ((encoding = CmsEncoder.lookupEncoding(encoding, null)) == null) {
            throw new CmsXmlException(Messages.get().container("ERR_XML_PAGE_FACT_INVALID_ENC_1", fileName));
        }
        if (content.length > 0) {
            if (keepEncoding) {
                newPage = CmsXmlPageFactory.unmarshal(content, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
            } else {
                try {
                    String contentStr = new String(content, encoding);
                    newPage = CmsXmlPageFactory.unmarshal(contentStr, encoding, (EntityResolver)new CmsXmlEntityResolver(cms));
                }
                catch (UnsupportedEncodingException e) {
                    throw new CmsXmlException(Messages.get().container("ERR_XML_PAGE_FACT_INVALID_ENC_1", fileName), (Throwable)e);
                }
            }
        } else {
            newPage = new CmsXmlPage(cms.getRequestContext().getLocale(), encoding);
        }
        newPage.setFile(file);
        newPage.setAllowRelativeLinks(allowRelative);
        return newPage;
    }

    public static CmsXmlPage unmarshal(CmsObject cms, CmsResource resource, ServletRequest req) throws CmsException {
        String rootPath = resource.getRootPath();
        if (!CmsResourceTypeXmlPage.isXmlPage(resource)) {
            throw new CmsXmlException(Messages.get().container("ERR_XML_PAGE_FACT_NO_XMLPAGE_TYPE_1", cms.getSitePath(resource)));
        }
        CmsXmlPage page = (CmsXmlPage)req.getAttribute(rootPath);
        if (page == null) {
            page = CmsXmlPageFactory.unmarshal(cms, cms.readFile(resource));
            req.setAttribute(rootPath, (Object)page);
        }
        return page;
    }

    public static I_CmsXmlDocument unmarshal(CmsObject cms, String filename, ServletRequest req) throws CmsException {
        String rootPath = cms.getRequestContext().addSiteRoot(filename);
        I_CmsXmlDocument doc = (I_CmsXmlDocument)req.getAttribute(rootPath);
        if (doc != null) {
            return doc;
        }
        CmsFile file = cms.readFile(filename, CmsResourceFilter.IGNORE_EXPIRATION);
        if (CmsResourceTypeXmlPage.isXmlPage(file)) {
            doc = CmsXmlPageFactory.unmarshal(cms, file);
        } else if (CmsResourceTypeXmlContent.isXmlContent(file)) {
            doc = CmsXmlContentFactory.unmarshal(cms, file);
        } else {
            throw new CmsXmlException(Messages.get().container("ERR_XML_PAGE_FACT_NO_XML_DOCUMENT_1", file));
        }
        req.setAttribute(rootPath, (Object)doc);
        return doc;
    }

    public static CmsXmlPage unmarshal(String xmlData, String encoding, EntityResolver resolver) throws CmsXmlException {
        return new CmsXmlPage(CmsXmlUtils.unmarshalHelper(xmlData, resolver), encoding);
    }
}

