/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.templatemapper;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.compress.utils.Lists;
import org.apache.commons.logging.Log;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsTemplateMapperConfiguration {
    public static final String A_ENABLED = "enabled";
    public static final String A_NEW = "new";
    public static final String A_OLD = "old";
    public static final CmsTemplateMapperConfiguration EMPTY_CONFIG = new CmsTemplateMapperConfiguration();
    public static final String N_FORMATTER_CONFIG = "formatter-config";
    public static final String N_FORMATTER_JSP = "formatter-jsp";
    public static final String N_ELEMENT_GROUP_TYPE = "element-group-type";
    public static final String N_PATH = "path";
    private static final Log LOG = CmsLog.getLog(CmsTemplateMapperConfiguration.class);
    private Map<CmsUUID, CmsUUID> m_formatterConfigMap = new HashMap<CmsUUID, CmsUUID>();
    private Map<CmsUUID, CmsUUID> m_formatterJspMap = new HashMap<CmsUUID, CmsUUID>();
    private Map<String, String> m_groupTypeMap = new HashMap<String, String>();
    private List<String> m_paths = Lists.newArrayList();

    public CmsTemplateMapperConfiguration() {
    }

    public CmsTemplateMapperConfiguration(CmsObject cms, Document doc) throws CmsException {
        cms = OpenCms.initCmsObject(cms);
        cms.getRequestContext().setSiteRoot("");
        Element root = doc.getRootElement();
        String enabledStr = root.attributeValue(A_ENABLED);
        boolean enabled = Boolean.parseBoolean(enabledStr);
        if (enabled) {
            CmsResource newFormatter;
            CmsResource oldFormatter;
            String newPath;
            String oldPath;
            Element formatterElem;
            for (Node node : root.selectNodes("//formatter-config")) {
                formatterElem = (Element)node;
                oldPath = formatterElem.attributeValue(A_OLD);
                newPath = formatterElem.attributeValue(A_NEW);
                try {
                    oldFormatter = cms.readResource(oldPath, CmsResourceFilter.IGNORE_EXPIRATION);
                    newFormatter = cms.readResource(newPath, CmsResourceFilter.IGNORE_EXPIRATION);
                    this.m_formatterConfigMap.put(oldFormatter.getStructureId(), newFormatter.getStructureId());
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (Node node : root.selectNodes("//formatter-jsp")) {
                formatterElem = (Element)node;
                oldPath = formatterElem.attributeValue(A_OLD);
                newPath = formatterElem.attributeValue(A_NEW);
                try {
                    oldFormatter = cms.readResource(oldPath, CmsResourceFilter.IGNORE_EXPIRATION);
                    newFormatter = cms.readResource(newPath, CmsResourceFilter.IGNORE_EXPIRATION);
                    this.m_formatterJspMap.put(oldFormatter.getStructureId(), newFormatter.getStructureId());
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
            for (Node node : root.selectNodes("//element-group-type")) {
                Element groupElem = (Element)node;
                String oldType = groupElem.attributeValue(A_OLD);
                String newType = groupElem.attributeValue(A_NEW);
                this.m_groupTypeMap.put(oldType, newType);
            }
            for (Node node : root.selectNodes("//path")) {
                Element pathElem = (Element)node;
                this.m_paths.add(pathElem.getText());
            }
        }
    }

    public String getMappedElementGroupType(String type) {
        return this.m_groupTypeMap.get(type);
    }

    public String getMappedFormatterConfiguration(String id) {
        CmsUUID resultId = this.m_formatterConfigMap.get(new CmsUUID(id));
        if (resultId == null) {
            return null;
        }
        return resultId.toString();
    }

    public CmsUUID getMappedFormatterJspId(CmsUUID formatterId) {
        return this.m_formatterJspMap.get(formatterId);
    }

    public boolean isEnabledForPath(String rootPath) {
        for (String path : this.m_paths) {
            if (!CmsStringUtil.isPrefixPath(path, rootPath)) continue;
            return true;
        }
        return false;
    }
}

