/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.types;

import java.util.Locale;
import org.dom4j.Element;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.types.A_CmsXmlValueTextBase;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsXmlDisplayFormatterValue
extends A_CmsXmlValueTextBase {
    public static final String SEPARATOR = ":";
    private static final String TYPE_NAME = "OpenCmsDisplayFormatter";

    public CmsXmlDisplayFormatterValue() {
    }

    public CmsXmlDisplayFormatterValue(I_CmsXmlDocument document, Element element, Locale locale, I_CmsXmlSchemaType type) {
        super(document, element, locale, type);
    }

    public CmsXmlDisplayFormatterValue(String name, String minOccurs, String maxOccurs) {
        super(name, minOccurs, maxOccurs);
    }

    @Override
    public I_CmsXmlContentValue createValue(I_CmsXmlDocument document, Element element, Locale locale) {
        return new CmsXmlDisplayFormatterValue(document, element, locale, this);
    }

    public String getDisplayType() {
        String value = this.getStringValue(null);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value)) {
            return value.split(SEPARATOR)[0];
        }
        return null;
    }

    public String getFormatterId() {
        String[] parts;
        String value = this.getStringValue(null);
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(value) && (parts = value.split(SEPARATOR)).length == 2) {
            return parts[1];
        }
        return null;
    }

    @Override
    public String getSchemaDefinition() {
        return "<xsd:simpleType name=\"OpenCmsDisplayFormatter\"><xsd:restriction base=\"xsd:string\" /></xsd:simpleType>";
    }

    @Override
    public String getStringValue(CmsObject cms) throws CmsRuntimeException {
        CmsXmlContent content;
        I_CmsXmlDocument doc = this.getDocument();
        if (doc != null && doc instanceof CmsXmlContent && (content = (CmsXmlContent)doc).getFile() != null) {
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(cms, content.getFile().getRootPath());
            String internalValue = super.getStringValue(cms);
            if (internalValue == null) {
                return null;
            }
            int colonPos = internalValue.indexOf(58);
            if (colonPos == -1) {
                return internalValue;
            }
            String keyOrId = internalValue.substring(colonPos + 1);
            I_CmsFormatterBean formatter = config.findFormatter(keyOrId);
            if (formatter != null) {
                return internalValue.substring(0, colonPos + 1) + formatter.getKeyOrId();
            }
        }
        return super.getStringValue(cms);
    }

    @Override
    public String getTypeName() {
        return TYPE_NAME;
    }

    @Override
    public I_CmsXmlSchemaType newInstance(String name, String minOccurs, String maxOccurs) {
        return new CmsXmlDisplayFormatterValue(name, minOccurs, maxOccurs);
    }

    @Override
    public void setStringValue(CmsObject cms, String value) {
        CmsXmlContent content;
        I_CmsXmlDocument doc = this.getDocument();
        if (!CmsStringUtil.isEmpty(value) && doc != null && doc instanceof CmsXmlContent && (content = (CmsXmlContent)doc).getFile() != null) {
            String keyOrId;
            I_CmsFormatterBean formatter;
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfigurationWithCache(cms, content.getFile().getRootPath());
            int colonPos = value.indexOf(SEPARATOR);
            if (colonPos > -1 && (formatter = config.findFormatter(keyOrId = value.substring(colonPos + 1))) != null) {
                String newId = config.isUseFormatterKeys() ? formatter.getKeyOrId() : formatter.getId();
                value = value.substring(0, colonPos) + SEPARATOR + newId;
            }
        }
        super.setStringValue(cms, value);
    }
}

