/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.TreeMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.opencms.cache.CmsVfsMemoryObjectCache;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.I_CmsNeedsAdminCmsObject;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.flex.CmsFlexController;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsResourceInitException;
import org.opencms.main.I_CmsResourceInit;
import org.opencms.main.OpenCms;
import org.opencms.relations.I_CmsCustomLinkRenderer;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.xml2json.CmsDefaultJsonHandlers;
import org.opencms.xml.xml2json.CmsJsonAccessPolicy;
import org.opencms.xml.xml2json.CmsJsonResult;
import org.opencms.xml.xml2json.I_CmsApiAuthorizationHandler;
import org.opencms.xml.xml2json.I_CmsJsonHandlerProvider;
import org.opencms.xml.xml2json.handler.CmsExceptionSafeHandlerWrapper;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.I_CmsJsonHandler;

public class CmsJsonResourceHandler
implements I_CmsResourceInit,
I_CmsNeedsAdminCmsObject {
    public static final String ATTR_CONTEXT = "jsonHandlerContext";
    public static final String PARAM_AUTHORIZATION = "authorization";
    public static final String PREFIX = "/json";
    private static final Log LOG = CmsLog.getLog(CmsJsonResourceHandler.class);
    public static final Object PARAM_LINKREWRITE_REFID = "linkrewrite.refid";
    private CmsObject m_adminCms;
    private CmsParameterConfiguration m_config = new CmsParameterConfiguration();
    private ServiceLoader<I_CmsJsonHandlerProvider> m_serviceLoader = ServiceLoader.load(I_CmsJsonHandlerProvider.class);

    public CmsJsonResourceHandler() {
        CmsFlexController.registerUncacheableAttribute(ATTR_CONTEXT);
    }

    public static I_CmsCustomLinkRenderer getLinkRenderer(CmsObject cms) {
        Object linkRewriterObj;
        String linkRewriterKey;
        Object context = cms.getRequestContext().getAttribute(ATTR_CONTEXT);
        if (context instanceof CmsJsonHandlerContext && (linkRewriterKey = ((CmsJsonHandlerContext)context).getHandlerConfig().get(PARAM_LINKREWRITE_REFID)) != null && (linkRewriterObj = OpenCms.getRuntimeProperty(linkRewriterKey)) instanceof I_CmsCustomLinkRenderer) {
            return (I_CmsCustomLinkRenderer)linkRewriterObj;
        }
        return null;
    }

    public static String link(CmsObject cms, CmsResource res) {
        String result;
        I_CmsCustomLinkRenderer linkRenderer = CmsJsonResourceHandler.getLinkRenderer(cms);
        if (linkRenderer != null && (result = linkRenderer.getLink(cms, res)) != null) {
            return result;
        }
        return OpenCms.getLinkManager().substituteLink(cms, res);
    }

    private static CmsObject authorize(CmsObject adminCms, CmsObject defaultCms, HttpServletRequest request, String authChain) {
        if (authChain == null) {
            return defaultCms;
        }
        for (String token : authChain.split(",")) {
            if ("default".equals(token = token.trim())) {
                LOG.info((Object)"Using default CmsObject");
                return defaultCms;
            }
            if ("guest".equals(token)) {
                try {
                    return OpenCms.initCmsObject(OpenCms.getDefaultUsers().getUserGuest());
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            }
            I_CmsApiAuthorizationHandler handler = OpenCms.getApiAuthorization(token);
            if (handler == null) {
                LOG.error((Object)("Could not find API authorization handler " + token));
                return null;
            }
            try {
                CmsObject cms = handler.initCmsObject(adminCms, request);
                if (cms == null) continue;
                LOG.info((Object)("Succeeded with authorization handler: " + token));
                return cms;
            }
            catch (CmsException e) {
                LOG.error((Object)("Error evaluating authorization handler " + token));
                return null;
            }
        }
        LOG.info((Object)"Authentication unsusccessful");
        return null;
    }

    public List<I_CmsJsonHandler> getSubHandlers() {
        List<I_CmsJsonHandler> result = new ArrayList<I_CmsJsonHandler>(CmsDefaultJsonHandlers.getHandlers());
        for (I_CmsJsonHandlerProvider provider : this.m_serviceLoader) {
            try {
                result.addAll(provider.getJsonHandlers());
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        result.sort((h1, h2) -> Double.compare(h1.getOrder(), h2.getOrder()));
        result = result.stream().map(h -> new CmsExceptionSafeHandlerWrapper((I_CmsJsonHandler)h)).collect(Collectors.toList());
        return result;
    }

    @Override
    public void initParameters(CmsParameterConfiguration params) {
        this.m_config = CmsParameterConfiguration.unmodifiableVersion(params);
    }

    @Override
    public CmsResource initResource(CmsResource origRes, CmsObject cms, HttpServletRequest req, HttpServletResponse res) throws CmsResourceInitException {
        CmsJsonAccessPolicy accessPolicy;
        String output;
        int status;
        block27: {
            String uri = cms.getRequestContext().getUri();
            if (origRes != null) {
                return origRes;
            }
            if (res == null) {
                return origRes;
            }
            if (!CmsStringUtil.isPrefixPath(PREFIX, uri)) {
                return null;
            }
            String path = uri.substring(PREFIX.length());
            if (path.isEmpty()) {
                path = "/";
            } else if (path.length() > 1) {
                path = CmsFileUtil.removeTrailingSeparator(path);
            }
            TreeMap<String, String> singleParams = new TreeMap<String, String>();
            for (Map.Entry entry : req.getParameterMap().entrySet()) {
                String[] data = (String[])entry.getValue();
                String value = null;
                if (data.length > 0) {
                    value = data[0];
                }
                singleParams.put((String)entry.getKey(), value);
            }
            CmsObject origCms = cms;
            String authorizationParam = this.m_config.get(PARAM_AUTHORIZATION);
            if ((cms = CmsJsonResourceHandler.authorize(this.m_adminCms, origCms, req, authorizationParam)) != null && cms != origCms) {
                origCms.getRequestContext().setAttribute("resourceinit.alternativeCmsObject", cms);
                cms.getRequestContext().setSiteRoot(origCms.getRequestContext().getSiteRoot());
                cms.getRequestContext().setUri(origCms.getRequestContext().getUri());
            }
            status = 200;
            output = "";
            accessPolicy = null;
            try {
                if (cms == null) {
                    status = 401;
                    output = JSONObject.quote("unauthorized");
                    break block27;
                }
                CmsObject rootCms = OpenCms.initCmsObject(cms);
                rootCms.getRequestContext().setSiteRoot("");
                boolean resourcePermissionDenied = false;
                CmsResource resource = null;
                try {
                    resource = rootCms.readResource(path);
                }
                catch (CmsSecurityException e) {
                    LOG.info((Object)("Read permission denied for " + path + ", user=" + rootCms.getRequestContext().getCurrentUser().getName()));
                    resourcePermissionDenied = true;
                }
                catch (CmsException e) {
                    // empty catch block
                }
                accessPolicy = this.getAccessPolicy(rootCms);
                CmsJsonHandlerContext context = new CmsJsonHandlerContext(cms, rootCms, path, resource, singleParams, this.m_config, accessPolicy);
                cms.getRequestContext().setAttribute(ATTR_CONTEXT, context);
                String encoding = "UTF-8";
                res.setContentType("application/json; charset=" + encoding);
                if (!accessPolicy.checkAccess(context.getCms(), context.getPath())) {
                    LOG.info((Object)("JSON access to path'" + context.getPath() + "' denied by access policy."));
                    status = 403;
                    output = JSONObject.quote("forbidden");
                    break block27;
                }
                if (resourcePermissionDenied) {
                    if (cms.getRequestContext().getCurrentUser().getName().equals(OpenCms.getDefaultUsers().getUserGuest())) {
                        status = 401;
                        output = JSONObject.quote("unauthorized");
                    } else {
                        status = 403;
                        output = JSONObject.quote("forbidden");
                    }
                    break block27;
                }
                boolean foundHandler = false;
                for (I_CmsJsonHandler handler : this.getSubHandlers()) {
                    if (!handler.matches(context)) continue;
                    CmsJsonResult result = handler.renderJson(context);
                    if (result.getNextResource() != null) {
                        req.setAttribute(ATTR_CONTEXT, (Object)context);
                        return result.getNextResource();
                    }
                    try {
                        status = result.getStatus();
                        output = JSONObject.valueToString(result.getJson(), 4, 0);
                    }
                    catch (Exception e) {
                        status = 500;
                        output = JSONObject.quote(e.getLocalizedMessage());
                    }
                    foundHandler = true;
                    break;
                }
                if (!foundHandler) {
                    LOG.info((Object)("No JSON handler found for path: " + path));
                    status = 404;
                    output = JSONObject.quote("");
                }
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                status = 500;
                output = JSONObject.quote(e.getLocalizedMessage());
            }
        }
        res.setStatus(status);
        if (accessPolicy != null) {
            accessPolicy.setCorsHeaders(res);
        }
        try {
            PrintWriter writer = res.getWriter();
            writer.write(output);
            writer.flush();
        }
        catch (IOException ioe) {
            LOG.error((Object)ioe.getLocalizedMessage(), (Throwable)ioe);
        }
        CmsResourceInitException ex = new CmsResourceInitException(CmsJsonResourceHandler.class);
        ex.setClearErrors(true);
        throw ex;
    }

    @Override
    public void setAdminCmsObject(CmsObject adminCms) {
        this.m_adminCms = adminCms;
    }

    protected CmsJsonAccessPolicy getAccessPolicy(CmsObject cms) {
        String accessConfigPath = this.m_config.getString("access-policy", null);
        if (accessConfigPath == null) {
            return new CmsJsonAccessPolicy(true);
        }
        CmsVfsMemoryObjectCache cache = CmsVfsMemoryObjectCache.getVfsMemoryObjectCache();
        CmsJsonAccessPolicy result = (CmsJsonAccessPolicy)cache.loadVfsObject(cms, accessConfigPath, obj -> {
            try {
                CmsFile file = cms.readFile(accessConfigPath);
                CmsJsonAccessPolicy policy = CmsJsonAccessPolicy.parse(file.getContents());
                return policy;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return new CmsJsonAccessPolicy(false);
            }
        });
        return result;
    }
}

