/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.document;

import org.opencms.file.CmsResource;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.json.JSONException;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsException;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.CmsResourceDataJsonHelper;
import org.opencms.xml.xml2json.document.A_CmsJsonDocument;
import org.opencms.xml.xml2json.document.I_CmsJsonDocument;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerException;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerXmlContent;

public class CmsJsonDocumentResource
extends A_CmsJsonDocument
implements I_CmsJsonDocument {
    protected CmsResourceDataJsonHelper m_helper;
    protected CmsResource m_resource;

    public CmsJsonDocumentResource(CmsJsonRequest jsonRequest, CmsResource resource) {
        super(jsonRequest);
        this.m_resource = resource;
        this.initHelper();
    }

    @Override
    public Object getJson() throws JSONException, CmsException, CmsJsonHandlerException, CmsJsonHandlerXmlContent.PathNotFoundException, Exception {
        this.insertJsonResource();
        return this.m_json;
    }

    protected void insertJsonResource() throws JSONException, CmsException {
        this.insertJsonResourceAttributes();
        this.insertJsonResourceFile();
        this.insertJsonResourceParams();
        this.insertJsonResourcePathAndLink();
        this.insertJsonResourceProperties();
    }

    protected void insertJsonResourceAttributes() throws JSONException {
        this.m_json.put("attributes", this.m_helper.attributes());
    }

    protected void insertJsonResourceFile() throws JSONException {
        boolean isContent = !this.m_resource.isFolder() && CmsResourceTypeXmlContent.isXmlContent(this.m_resource);
        this.m_json.put("isFolder", this.m_resource.isFolder());
        this.m_json.put("isXmlContent", (Object)isContent);
    }

    protected void insertJsonResourceParams() throws JSONException {
        JSONObject json = new JSONObject(true);
        for (String key : this.m_context.getParameters().keySet()) {
            json.put(key, this.m_context.getParameters().get(key));
        }
        this.m_json.put("requestParams", json);
    }

    protected void insertJsonResourcePathAndLink() throws JSONException {
        this.m_helper.addPathAndLink(this.m_json);
    }

    protected void insertJsonResourceProperties() throws JSONException, CmsException {
        this.m_helper.addProperties(this.m_json);
    }

    private void initHelper() {
        this.m_helper = new CmsResourceDataJsonHelper(this.m_context.getCms(), this.m_resource, this.m_context.getAccessPolicy()::checkPropertyAccess);
    }
}

