/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.handler;

import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.xml2json.CmsJsonAccessPolicy;

public class CmsJsonHandlerContext {
    private static final Log LOG = CmsLog.getLog(CmsJsonHandlerContext.class);
    private CmsJsonAccessPolicy m_accessPolicy;
    private CmsObject m_cms;
    private CmsXmlContent m_content;
    private CmsFile m_file;
    private CmsParameterConfiguration m_handlerConfig;
    private Map<String, String> m_parameters;
    private String m_path;
    private CmsResource m_resource;
    private CmsObject m_rootCms;
    private Map<String, Object> m_tempData = new LinkedHashMap<String, Object>();

    public CmsJsonHandlerContext(CmsObject cms, CmsObject rootCms, String path, CmsResource resource, Map<String, String> params, CmsParameterConfiguration handlerConfig, CmsJsonAccessPolicy policy) {
        this.m_cms = cms;
        this.m_resource = resource;
        this.m_rootCms = rootCms;
        this.m_path = path;
        this.m_parameters = params;
        this.m_handlerConfig = handlerConfig;
        if (this.m_parameters == null) {
            this.m_parameters = Collections.emptyMap();
        }
        if (this.m_handlerConfig == null) {
            this.m_handlerConfig = new CmsParameterConfiguration();
        }
        this.m_accessPolicy = policy;
    }

    public CmsJsonAccessPolicy getAccessPolicy() {
        return this.m_accessPolicy;
    }

    public CmsObject getCms() {
        return this.m_cms;
    }

    public CmsXmlContent getContent() throws CmsException {
        if (this.m_content == null) {
            this.m_content = CmsXmlContentFactory.unmarshal(this.m_cms, this.getFile());
        }
        return this.m_content;
    }

    public CmsFile getFile() throws CmsException {
        if (this.m_file == null) {
            this.m_file = this.m_cms.readFile(this.getResource());
        }
        return this.m_file;
    }

    public CmsParameterConfiguration getHandlerConfig() {
        return this.m_handlerConfig;
    }

    public Key getKey() {
        return new Key(this);
    }

    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.m_parameters);
    }

    public String getPath() {
        return this.m_path;
    }

    public CmsResource getResource() {
        return this.m_resource;
    }

    public CmsObject getRootCms() {
        return this.m_rootCms;
    }

    public Map<String, Object> getTempStorage() {
        return this.m_tempData;
    }

    public static class Key {
        WeakReference<CmsJsonHandlerContext> m_contextRef;
        private String m_keyString;

        public Key(CmsJsonHandlerContext context) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(context.getCms().getRequestContext().getCurrentProject().getId());
            buffer.append("|");
            buffer.append(context.getCms().getRequestContext().getSiteRoot());
            buffer.append("|");
            buffer.append(context.getCms().getRequestContext().getCurrentUser().getId());
            buffer.append("|");
            buffer.append(context.getPath());
            buffer.append("|");
            buffer.append(context.getParameters());
            this.m_keyString = buffer.toString();
            this.m_contextRef = new WeakReference<CmsJsonHandlerContext>(context);
        }

        public boolean equals(Object obj) {
            return obj instanceof Key && ((Key)obj).m_keyString.equals(this.m_keyString);
        }

        public int hashCode() {
            return this.m_keyString.hashCode();
        }

        CmsJsonHandlerContext getContext() {
            return (CmsJsonHandlerContext)this.m_contextRef.get();
        }
    }
}

