/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.xml.xml2json.handler;

import org.apache.commons.logging.Log;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.xml.xml2json.CmsJsonRequest;
import org.opencms.xml.xml2json.CmsJsonResult;
import org.opencms.xml.xml2json.document.CmsJsonDocumentResource;
import org.opencms.xml.xml2json.handler.CmsJsonHandlerContext;
import org.opencms.xml.xml2json.handler.I_CmsJsonHandler;

public class CmsJsonHandlerResource
implements I_CmsJsonHandler {
    private static final Log LOG = CmsLog.getLog(CmsJsonHandlerResource.class);

    @Override
    public double getOrder() {
        return 600.0;
    }

    @Override
    public boolean matches(CmsJsonHandlerContext context) {
        return true;
    }

    @Override
    public CmsJsonResult renderJson(CmsJsonHandlerContext context) {
        try {
            CmsJsonRequest jsonRequest = new CmsJsonRequest(context, this);
            jsonRequest.validate();
            if (jsonRequest.hasErrors()) {
                return new CmsJsonResult(jsonRequest.getErrorsAsJson(), 400);
            }
            CmsJsonDocumentResource jsonDocument = new CmsJsonDocumentResource(jsonRequest, context.getResource());
            return new CmsJsonResult(jsonDocument.getJson(), 200);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return new CmsJsonResult(JSONObject.quote(e.getLocalizedMessage()), 500);
        }
    }
}

