/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.acacia.shared;

import java.util.Date;
import java.util.SortedSet;
import org.opencms.util.CmsUUID;

public interface I_CmsSerialDateValue {
    public static final long DAY_IN_MILLIS = 86400000L;
    public static final int NUM_OF_WEEKDAYS = 7;

    public boolean endsAtMidNight();

    public DateType getDateType();

    public int getDayOfMonth();

    public Date getEnd();

    public EndType getEndType();

    public SortedSet<Date> getExceptions();

    public SortedSet<Date> getIndividualDates();

    public int getInterval();

    public Month getMonth();

    public int getOccurrences();

    public CmsUUID getParentSeriesId();

    public PatternType getPatternType();

    public Date getSeriesEndDate();

    public Date getStart();

    public WeekDay getWeekDay();

    public SortedSet<WeekDay> getWeekDays();

    public WeekOfMonth getWeekOfMonth();

    public SortedSet<WeekOfMonth> getWeeksOfMonth();

    public boolean isCurrentTillEnd();

    public boolean isEveryWorkingDay();

    public boolean isFromOtherSeries();

    public boolean isValid();

    public boolean isWholeDay();

    public static enum WeekOfMonth {
        FIRST,
        SECOND,
        THIRD,
        FOURTH,
        LAST;

    }

    public static enum WeekDay {
        SUNDAY,
        MONDAY,
        TUESDAY,
        WEDNESDAY,
        THURSDAY,
        FRIDAY,
        SATURDAY;


        public static WeekDay fromInt(int i) {
            switch (i) {
                case 1: {
                    return SUNDAY;
                }
                case 2: {
                    return MONDAY;
                }
                case 3: {
                    return TUESDAY;
                }
                case 4: {
                    return WEDNESDAY;
                }
                case 5: {
                    return THURSDAY;
                }
                case 6: {
                    return FRIDAY;
                }
                case 7: {
                    return SATURDAY;
                }
            }
            throw new IllegalArgumentException();
        }

        public int toInt() {
            return this.ordinal() + 1;
        }
    }

    public static enum PatternType {
        NONE,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARLY,
        INDIVIDUAL;

    }

    public static enum Month {
        JANUARY,
        FEBRUARY,
        MARCH,
        APRIL,
        MAY,
        JUNE,
        JULY,
        AUGUST,
        SEPTEMBER,
        OCTOBER,
        NOVEMBER,
        DECEMBER;


        public int getMaximalDay() {
            switch (this) {
                case JANUARY: {
                    return 31;
                }
                case FEBRUARY: {
                    return 29;
                }
                case MARCH: {
                    return 31;
                }
                case APRIL: {
                    return 30;
                }
                case MAY: {
                    return 31;
                }
                case JUNE: {
                    return 30;
                }
                case JULY: {
                    return 31;
                }
                case AUGUST: {
                    return 31;
                }
                case SEPTEMBER: {
                    return 30;
                }
                case OCTOBER: {
                    return 31;
                }
                case NOVEMBER: {
                    return 30;
                }
                case DECEMBER: {
                    return 31;
                }
            }
            throw new IllegalArgumentException();
        }
    }

    public static final class JsonKey {
        public static final String START = "from";
        public static final String END = "to";
        public static final String WHOLE_DAY = "wholeday";
        public static final String PATTERN = "pattern";
        public static final String PATTERN_TYPE = "type";
        public static final String PATTERN_INTERVAL = "interval";
        public static final String PATTERN_EVERYWORKINGDAY = "everyworkingday";
        public static final String PATTERN_WEEKDAYS = "weekdays";
        public static final String PATTERN_DAY_OF_MONTH = "day";
        public static final String PATTERN_WEEKS_OF_MONTH = "weeks";
        public static final String PATTERN_DATES = "dates";
        public static final String PATTERN_MONTH = "month";
        public static final String EXCEPTIONS = "exceptions";
        public static final String SERIES_ENDDATE = "enddate";
        public static final String SERIES_OCCURRENCES = "occurrences";
        public static final String PARENT_SERIES = "parentseries";
        public static final String CURRENT_TILL_END = "currenttillend";
    }

    public static enum EndType {
        SINGLE,
        DATE,
        TIMES;

    }

    public static enum DateType {
        SINGLE,
        EXTRACTED,
        SERIES;

    }
}

