/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.ade.configuration.CmsADEConfigurationSequence;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.CmsSitemapAttributeEditorConfiguration;
import org.opencms.ade.configuration.plugins.CmsSitePlugin;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsADEConfigCacheState {
    private static final Log LOG = CmsLog.getLog(CmsADEConfigCacheState.class);
    private CmsObject m_cms;
    private Map<String, List<String>> m_detailPageCache;
    private Supplier<Set<CmsUUID>> m_detailPageIdCache;
    private volatile Set<String> m_detailPageTypes;
    private Map<CmsUUID, CmsElementView> m_elementViews;
    private Map<String, String> m_folderTypes = new HashMap<String, String>();
    private CmsADEConfigDataInternal m_moduleConfiguration;
    private List<CmsADEConfigDataInternal> m_moduleConfigurations;
    private Map<CmsUUID, CmsADEConfigDataInternal> m_siteConfigurations = new HashMap<CmsUUID, CmsADEConfigDataInternal>();
    private Map<String, CmsADEConfigDataInternal> m_siteConfigurationsByPath = new HashMap<String, CmsADEConfigDataInternal>();
    private Map<CmsUUID, CmsSitemapAttributeEditorConfiguration> m_sitemapAttributeEditorConfigurations;
    private Map<CmsUUID, CmsSitePlugin> m_sitePlugins;
    private volatile List<String> m_subsitesForSiteSelector;
    private volatile Set<String> m_contentTypes;

    public CmsADEConfigCacheState(CmsObject cms, Map<CmsUUID, CmsADEConfigDataInternal> siteConfigurations, List<CmsADEConfigDataInternal> moduleConfigs, Map<CmsUUID, CmsElementView> elementViews, Map<CmsUUID, CmsSitePlugin> sitePlugins, Map<CmsUUID, CmsSitemapAttributeEditorConfiguration> attributeEditorConfigurations) {
        this.m_cms = cms;
        this.m_siteConfigurations = siteConfigurations;
        this.m_moduleConfigurations = moduleConfigs;
        this.m_elementViews = elementViews;
        this.m_sitePlugins = sitePlugins;
        this.m_sitemapAttributeEditorConfigurations = attributeEditorConfigurations;
        for (CmsADEConfigDataInternal data : siteConfigurations.values()) {
            if (data.getBasePath() != null) {
                this.m_siteConfigurationsByPath.put(data.getBasePath(), data);
                continue;
            }
            LOG.info((Object)("Empty base path for sitemap configuration: " + data.getResource().getRootPath()));
        }
        this.m_moduleConfiguration = this.mergeConfigurations(moduleConfigs);
        try {
            this.m_folderTypes = this.computeFolderTypes();
        }
        catch (Exception e) {
            this.m_folderTypes = Maps.newHashMap();
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        CacheBuilder detailPageCacheBuilder = CacheBuilder.newBuilder().concurrencyLevel(8).expireAfterWrite(30L, TimeUnit.SECONDS);
        this.m_detailPageCache = detailPageCacheBuilder.build().asMap();
        this.m_detailPageIdCache = Suppliers.memoize(this::collectDetailPageIds);
    }

    public static CmsADEConfigCacheState emptyState(CmsObject cms) {
        return new CmsADEConfigCacheState(cms, Collections.emptyMap(), Collections.emptyList(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap());
    }

    public Map<String, String> computeFolderTypes() throws CmsException {
        HashMap folderTypes = Maps.newHashMap();
        if (this.m_moduleConfiguration != null) {
            folderTypes.putAll(this.wrap(this.m_moduleConfiguration).getFolderTypes());
        }
        ArrayList<CmsADEConfigDataInternal> configDataObjects = new ArrayList<CmsADEConfigDataInternal>(this.m_siteConfigurationsByPath.values());
        for (CmsADEConfigDataInternal configData : configDataObjects) {
            folderTypes.putAll(this.wrap(configData).getFolderTypes());
        }
        return folderTypes;
    }

    public CmsADEConfigCacheState createUpdatedCopy(Map<CmsUUID, CmsADEConfigDataInternal> sitemapUpdates, List<CmsADEConfigDataInternal> moduleUpdates, Map<CmsUUID, CmsElementView> elementViewUpdates, Map<CmsUUID, CmsSitePlugin> sitePluginUpdates, Map<CmsUUID, CmsSitemapAttributeEditorConfiguration> attributeEditorConfigurations) {
        HashMap newSitemapConfigs = Maps.newHashMap(this.m_siteConfigurations);
        if (sitemapUpdates != null) {
            for (Map.Entry<CmsUUID, CmsADEConfigDataInternal> entry : sitemapUpdates.entrySet()) {
                CmsUUID key = entry.getKey();
                CmsADEConfigDataInternal value = entry.getValue();
                if (value != null) {
                    newSitemapConfigs.put(key, value);
                    continue;
                }
                newSitemapConfigs.remove(key);
            }
        }
        List<CmsADEConfigDataInternal> newModuleConfigs = this.m_moduleConfigurations;
        if (moduleUpdates != null) {
            newModuleConfigs = moduleUpdates;
        }
        Map<CmsUUID, CmsElementView> newElementViews = this.m_elementViews;
        if (elementViewUpdates != null) {
            newElementViews = elementViewUpdates;
        }
        Map<CmsUUID, CmsSitePlugin> newSitePlugins = this.m_sitePlugins;
        if (sitePluginUpdates != null) {
            newSitePlugins = sitePluginUpdates;
        }
        Map<CmsUUID, CmsSitemapAttributeEditorConfiguration> newAttributeEditorConfigs = this.m_sitemapAttributeEditorConfigurations;
        if (attributeEditorConfigurations != null) {
            newAttributeEditorConfigs = attributeEditorConfigurations;
        }
        return new CmsADEConfigCacheState(this.m_cms, newSitemapConfigs, newModuleConfigs, newElementViews, newSitePlugins, newAttributeEditorConfigs);
    }

    public CmsSitemapAttributeEditorConfiguration getAttributeEditorConfiguration(CmsUUID id) {
        return this.m_sitemapAttributeEditorConfigurations.get(id);
    }

    public Set<String> getContentTypes() {
        if (this.m_contentTypes == null) {
            HashSet<String> contentTypes = new HashSet<String>();
            for (CmsADEConfigDataInternal config : this.m_siteConfigurations.values()) {
                for (CmsResourceTypeConfig typeConfig : config.getOwnResourceTypes()) {
                    contentTypes.add(typeConfig.getTypeName());
                }
            }
            for (CmsResourceTypeConfig typeConfig : this.m_moduleConfiguration.getOwnResourceTypes()) {
                contentTypes.add(typeConfig.getTypeName());
            }
            this.m_contentTypes = Collections.unmodifiableSet(contentTypes);
        }
        return this.m_contentTypes;
    }

    public List<CmsADEConfigData.DetailInfo> getDetailInfosForSubsites(CmsObject cms) {
        ArrayList result = Lists.newArrayList();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            List<CmsADEConfigData.DetailInfo> infosForSubsite = this.wrap(configData).getDetailInfos(cms);
            result.addAll(infosForSubsite);
        }
        return result;
    }

    public Set<String> getDetailPageTypes() {
        if (this.m_detailPageTypes != null) {
            return this.m_detailPageTypes;
        }
        HashSet<String> result = new HashSet<String>();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            List<CmsDetailPageInfo> detailPageInfos = configData.getOwnDetailPages();
            for (CmsDetailPageInfo info : detailPageInfos) {
                result.add(info.getType());
            }
        }
        this.m_detailPageTypes = result;
        return result;
    }

    public Map<CmsUUID, CmsElementView> getElementViews() {
        return Collections.unmodifiableMap(this.m_elementViews);
    }

    public Map<String, String> getFolderTypes() {
        return Collections.unmodifiableMap(this.m_folderTypes);
    }

    public String getParentFolderType(String rootPath) {
        String parent = CmsResource.getParentFolder(rootPath);
        if (parent == null) {
            return null;
        }
        String type = this.m_folderTypes.get(parent);
        return type;
    }

    public List<CmsDetailPageInfo> getRawDetailPages() {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsADEConfigDataInternal config : this.m_siteConfigurationsByPath.values()) {
            result.addAll(config.getOwnDetailPages());
        }
        return result;
    }

    public Set<String> getSiteConfigurationPaths() {
        return this.m_siteConfigurationsByPath.keySet();
    }

    public Map<CmsUUID, CmsSitePlugin> getSitePlugins() {
        return this.m_sitePlugins;
    }

    public List<String> getSubsitesForSiteSelector() {
        if (this.m_subsitesForSiteSelector == null) {
            List paths = this.m_siteConfigurations.values().stream().filter(conf -> conf.isIncludeInSiteSelector()).map(conf -> conf.getBasePath()).collect(Collectors.toList());
            this.m_subsitesForSiteSelector = Collections.unmodifiableList(paths);
        }
        return this.m_subsitesForSiteSelector;
    }

    public CmsADEConfigData lookupConfiguration(String rootPath) {
        CmsADEConfigDataInternal internalSiteConfig = this.getSiteConfigData(rootPath);
        CmsADEConfigData result = internalSiteConfig == null ? this.wrap(this.m_moduleConfiguration) : this.wrap(internalSiteConfig);
        return result;
    }

    protected List<CmsDetailPageInfo> getAllDetailPages() {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            result.addAll(this.wrap(configData).getAllDetailPages(true));
        }
        return result;
    }

    protected CmsObject getCms() {
        return this.m_cms;
    }

    protected List<String> getDetailPages(String type) {
        List<String> result = this.m_detailPageCache.get(type);
        if (result == null) {
            result = new ArrayList<String>();
            for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
                for (CmsDetailPageInfo pageInfo : this.wrap(configData).getDetailPagesForType(type)) {
                    result.add(pageInfo.getUri());
                }
            }
            this.m_detailPageCache.put(type, result);
        }
        return Collections.unmodifiableList(result);
    }

    protected CmsADEConfigData getModuleConfiguration() {
        return this.wrap(this.m_moduleConfiguration);
    }

    protected CmsADEConfigDataInternal getSiteConfigData(String path) {
        if (path == null) {
            return null;
        }
        List<String> prefixes = this.getSiteConfigPaths(path);
        if (prefixes.size() == 0) {
            return null;
        }
        return this.m_siteConfigurationsByPath.get(prefixes.get(prefixes.size() - 1));
    }

    protected List<String> getSiteConfigPaths(String path) {
        String normalizedPath = CmsStringUtil.joinPaths("/", path, "/");
        ArrayList<String> prefixes = new ArrayList<String>();
        ArrayList<String> parents = new ArrayList<String>();
        String currentPath = normalizedPath;
        while (currentPath != null) {
            parents.add(currentPath);
            currentPath = CmsResource.getParentFolder(currentPath);
        }
        for (String parent : parents) {
            if (!this.m_siteConfigurationsByPath.containsKey(parent)) continue;
            prefixes.add(parent);
        }
        Collections.sort(prefixes);
        return prefixes;
    }

    protected boolean isDetailPage(CmsObject cms, CmsResource resource) {
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            Set detailPageIds = (Set)this.m_detailPageIdCache.get();
            if (detailPageIds.contains(resource.getStructureId())) {
                return true;
            }
            try {
                CmsResource parent = this.getCms().readResource(CmsResource.getParentFolder(resource.getRootPath()), CmsResourceFilter.ALL);
                return detailPageIds.contains(parent.getStructureId());
            }
            catch (Exception e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
                return false;
            }
        }
        if (resource.isFolder()) {
            return ((Set)this.m_detailPageIdCache.get()).contains(resource.getStructureId());
        }
        return false;
    }

    protected CmsADEConfigDataInternal mergeConfigurations(List<CmsADEConfigDataInternal> configurations) {
        if (configurations.isEmpty()) {
            return new CmsADEConfigDataInternal(null);
        }
        for (int i = 0; i < configurations.size() - 1; ++i) {
            configurations.get(i + 1).mergeParent(configurations.get(i));
        }
        CmsADEConfigDataInternal result = configurations.get(configurations.size() - 1);
        result.processModuleOrdering();
        return result;
    }

    private Set<CmsUUID> collectDetailPageIds() {
        ArrayList<CmsDetailPageInfo> allDetailPages = new ArrayList<CmsDetailPageInfo>();
        for (CmsADEConfigDataInternal configData : this.m_siteConfigurationsByPath.values()) {
            List<CmsDetailPageInfo> detailPageInfos = configData.getOwnDetailPages();
            allDetailPages.addAll(detailPageInfos);
        }
        HashSet<CmsUUID> detailPageOrDetailPageFolderIds = new HashSet<CmsUUID>();
        for (CmsDetailPageInfo detailPageInfo : allDetailPages) {
            try {
                CmsResource detailPageRes = this.getCms().readResource(detailPageInfo.getId(), CmsResourceFilter.ALL);
                detailPageOrDetailPageFolderIds.add(detailPageInfo.getId());
                if (detailPageRes.isFile()) {
                    CmsResource parent = this.getCms().readParentFolder(detailPageInfo.getId());
                    detailPageOrDetailPageFolderIds.add(parent.getStructureId());
                    continue;
                }
                CmsResource defaultfile = this.getCms().readDefaultFile("" + detailPageInfo.getId());
                if (defaultfile == null) continue;
                detailPageOrDetailPageFolderIds.add(defaultfile.getStructureId());
            }
            catch (Exception e) {
                LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return Collections.unmodifiableSet(detailPageOrDetailPageFolderIds);
    }

    private void fillMasterConfigurations(List<CmsADEConfigDataInternal.ConfigReferenceInstance> result, CmsADEConfigDataInternal.ConfigReferenceInstance current, Set<CmsUUID> seen) {
        CmsUUID currentId = current.getConfig().getResource().getStructureId();
        if (seen.contains(currentId)) {
            LOG.warn((Object)("Loop in sitemap configuration references, target = " + current.getConfig().getBasePath()));
            return;
        }
        seen.add(currentId);
        for (CmsADEConfigDataInternal.ConfigReference configRef : current.getConfig().getMasterConfigs()) {
            CmsADEConfigDataInternal config = this.m_siteConfigurations.get(configRef.getId());
            if (config != null) {
                CmsADEConfigDataInternal.ConfigReferenceMeta combinedMeta = current.getMeta().combine(configRef.getMeta());
                CmsADEConfigDataInternal.ConfigReferenceInstance combinedRef = new CmsADEConfigDataInternal.ConfigReferenceInstance(config, combinedMeta);
                this.fillMasterConfigurations(result, combinedRef, seen);
                continue;
            }
            LOG.warn((Object)("Master configuration with id " + configRef.getId() + " not found, referenced by " + current.getConfig().getResource().getRootPath()));
        }
        result.add(current);
        seen.remove(currentId);
    }

    private CmsADEConfigData wrap(CmsADEConfigDataInternal data) {
        String path = data.getBasePath();
        ArrayList configList = Lists.newArrayList();
        configList.add(new CmsADEConfigDataInternal.ConfigReferenceInstance(this.m_moduleConfiguration));
        if (path != null) {
            List<String> siteConfigPaths = this.getSiteConfigPaths(path);
            for (String siteConfigPath : siteConfigPaths) {
                CmsADEConfigDataInternal currentConfig = this.m_siteConfigurationsByPath.get(siteConfigPath);
                this.fillMasterConfigurations(configList, new CmsADEConfigDataInternal.ConfigReferenceInstance(currentConfig), new HashSet<CmsUUID>());
            }
        }
        return new CmsADEConfigData(data, this, new CmsADEConfigurationSequence(configList));
    }
}

