/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import com.google.common.base.Optional;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsADEConfigCacheState;
import org.opencms.ade.configuration.CmsADEConfigDataInternal;
import org.opencms.ade.configuration.CmsADEConfigurationSequence;
import org.opencms.ade.configuration.CmsFunctionAvailability;
import org.opencms.ade.configuration.CmsFunctionReference;
import org.opencms.ade.configuration.CmsGalleryDisabledTypesMode;
import org.opencms.ade.configuration.CmsModelPageConfig;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.CmsResourceTypeConfig;
import org.opencms.ade.configuration.CmsSitemapAttributeEditorConfiguration;
import org.opencms.ade.configuration.CmsTypeOrderingMode;
import org.opencms.ade.configuration.I_CmsConfigurationObject;
import org.opencms.ade.configuration.formatters.CmsFormatterBeanParser;
import org.opencms.ade.configuration.formatters.CmsFormatterChangeSet;
import org.opencms.ade.configuration.formatters.CmsFormatterConfigurationCacheState;
import org.opencms.ade.configuration.formatters.CmsFormatterIndex;
import org.opencms.ade.configuration.formatters.CmsSharedSettingKey;
import org.opencms.ade.configuration.plugins.CmsSitePlugin;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.detailpage.CmsDetailPageInfo;
import org.opencms.ade.galleries.CmsAddContentRestriction;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.CmsResourceTypeFolder;
import org.opencms.file.types.CmsResourceTypeFunctionConfig;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.jsp.util.CmsFunctionRenderer;
import org.opencms.loader.CmsLoaderException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.main.OpenCmsServlet;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.workplace.editors.directedit.CmsAdvancedDirectEditProvider;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsADEConfigData {
    public static final String ATTR_BINARY_UPLOAD_TARGET = "binary.upload.target";
    public static final String REQ_LOG_PREFIX = "[CmsADEConfigData] ";
    public static final String REQUEST_LOG_CHANNEL = "org.opencms.ade.configuration.CmsADEConfigData.request";
    private static final Log LOG = CmsLog.getLog(CmsADEConfigData.class);
    private static final HashSet<String> systemSettingPrefixes = new HashSet<String>(Arrays.asList("element", "model", "source", "use", "cms", "is"));
    protected CmsADEConfigDataInternal m_data;
    private Map<CmsUUID, I_CmsFormatterBean> m_activeFormatters;
    private Multimap<String, I_CmsFormatterBean> m_activeFormattersByKey;
    private Map<String, CmsADEConfigDataInternal.AttributeValue> m_attributes;
    private CmsADEConfigCacheState m_cache;
    private CmsFormatterConfigurationCacheState m_cachedFormatters;
    private CmsADEConfigurationSequence m_configSequence;
    private Map<String, List<I_CmsFormatterBean>> m_formattersByContainerType = new HashMap<String, List<I_CmsFormatterBean>>();
    private Map<String, List<I_CmsFormatterBean>> m_formattersByDisplayType = new HashMap<String, List<I_CmsFormatterBean>>();
    private Multimap<CmsUUID, I_CmsFormatterBean> m_formattersByJspId;
    private Multimap<String, I_CmsFormatterBean> m_formattersByKey;
    private LoadingCache<String, List<I_CmsFormatterBean>> m_formattersByTypeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<String, List<I_CmsFormatterBean>>(){

        public List<I_CmsFormatterBean> load(String typeName) throws Exception {
            ArrayList<I_CmsFormatterBean> result = new ArrayList<I_CmsFormatterBean>();
            for (I_CmsFormatterBean formatter : CmsADEConfigData.this.getActiveFormatters().values()) {
                if (!formatter.getResourceTypeNames().contains(typeName)) continue;
                result.add(formatter);
            }
            return result;
        }
    });
    private volatile ImmutableList<CmsUUID> m_sharedSettingOverrides;
    private Set<String> m_typesAddable;
    private Map<String, CmsResourceTypeConfig> m_typesByName;
    private Set<String> m_typesInAncestors;

    public CmsADEConfigData(CmsADEConfigDataInternal data, CmsADEConfigCacheState cache, CmsADEConfigurationSequence configSequence) {
        this.m_data = data;
        this.m_cache = cache;
        this.m_configSequence = configSequence;
    }

    public static <C extends I_CmsConfigurationObject<C>> List<C> combineConfigurationElements(List<C> parentConfigs, List<C> childConfigs, boolean preserveDisabled) {
        ArrayList<Object> result = new ArrayList();
        LinkedHashMap<String, I_CmsConfigurationObject> map = new LinkedHashMap<String, I_CmsConfigurationObject>();
        if (parentConfigs != null) {
            for (I_CmsConfigurationObject parent : Lists.reverse(parentConfigs)) {
                map.put(parent.getKey(), parent);
            }
        }
        if (childConfigs == null) {
            childConfigs = Collections.emptyList();
        }
        for (I_CmsConfigurationObject child : Lists.reverse(childConfigs)) {
            String childKey = child.getKey();
            if (child.isDisabled() && !preserveDisabled) {
                map.remove(childKey);
                continue;
            }
            I_CmsConfigurationObject parent = (I_CmsConfigurationObject)map.get(childKey);
            map.remove(childKey);
            I_CmsConfigurationObject newValue = parent != null ? parent.merge(child) : child;
            map.put(childKey, newValue);
        }
        result = new ArrayList(map.values());
        Collections.reverse(result);
        return result;
    }

    public static final String getParentFormatterKey(String key) {
        if (key == null) {
            return null;
        }
        int separatorPos = key.lastIndexOf("#");
        if (separatorPos == -1) {
            return null;
        }
        return key.substring(0, separatorPos);
    }

    public void applyAllFormatterChanges(CmsFormatterIndex formatterIndex, CmsFormatterConfigurationCacheState formatterCacheState) {
        for (CmsFormatterChangeSet changeSet : this.getFormatterChangeSets()) {
            changeSet.applyToFormatters(formatterIndex, formatterCacheState);
        }
    }

    public I_CmsFormatterBean findFormatter(CmsUUID id) {
        return this.findFormatter(id, false);
    }

    public I_CmsFormatterBean findFormatter(CmsUUID id, boolean noWarn) {
        if (id == null) {
            return null;
        }
        CmsFormatterConfigurationCacheState formatterState = this.getCachedFormatters();
        I_CmsFormatterBean originalResult = formatterState.getFormatters().get(id);
        I_CmsFormatterBean result = originalResult;
        if (result != null && result.getKey() != null) {
            String key = result.getKey();
            I_CmsFormatterBean resultForKey = this.getFormatterAndWarnIfAmbiguous(this.getActiveFormattersByKey(), key, noWarn);
            if (resultForKey != null) {
                result = resultForKey;
            } else {
                String parentKey = CmsADEConfigData.getParentFormatterKey(key);
                if (parentKey != null && (resultForKey = this.getFormatterAndWarnIfAmbiguous(this.getActiveFormattersByKey(), parentKey, noWarn)) != null) {
                    result = resultForKey;
                }
            }
        }
        if (result != originalResult) {
            String message = "Using substitute formatter " + this.getFormatterLabel(result) + " instead of " + this.getFormatterLabel(originalResult) + " because of matching key.";
            LOG.debug((Object)message);
            OpenCmsServlet.withRequestCache(reqCache -> reqCache.addLog(REQUEST_LOG_CHANNEL, "debug", REQ_LOG_PREFIX + message));
        }
        return result;
    }

    public I_CmsFormatterBean findFormatter(String name) {
        return this.findFormatter(name, false);
    }

    public I_CmsFormatterBean findFormatter(String name, boolean noWarn) {
        Multimap<String, I_CmsFormatterBean> all;
        if (name == null) {
            return null;
        }
        if (systemSettingPrefixes.contains(name) || name.startsWith("SYSTEM::")) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("System setting prefix used: " + name), (Throwable)new Exception());
            }
            return null;
        }
        if (CmsUUID.isValidUUID(name)) {
            return this.findFormatter(new CmsUUID(name), noWarn);
        }
        if (name.startsWith("schema_formatter")) {
            return null;
        }
        Multimap<String, I_CmsFormatterBean> active = this.getActiveFormattersByKey();
        I_CmsFormatterBean result = this.getFormatterAndWarnIfAmbiguous(active, name, noWarn);
        if (result != null) {
            return result;
        }
        String parentName = CmsADEConfigData.getParentFormatterKey(name);
        if (parentName != null && (result = this.getFormatterAndWarnIfAmbiguous(active, parentName, noWarn)) != null) {
            return result;
        }
        if (!noWarn) {
            String message1 = "No local formatter found for key '" + name + "' at '" + this.getBasePath() + "', trying inactive formatters";
            LOG.warn((Object)message1);
            OpenCmsServlet.withRequestCache(rc -> rc.addLog(REQUEST_LOG_CHANNEL, "warn", REQ_LOG_PREFIX + message1));
        }
        if ((result = this.getFormatterAndWarnIfAmbiguous(all = this.getFormattersByKey(), name, noWarn)) != null) {
            return result;
        }
        if (parentName != null && (result = this.getFormatterAndWarnIfAmbiguous(all, parentName, noWarn)) != null) {
            return result;
        }
        if (!noWarn) {
            OpenCmsServlet.withRequestCache(rc -> rc.addLog(REQUEST_LOG_CHANNEL, "warn", "[CmsADEConfigData] No formatter found for key '" + name + "' at '" + this.getBasePath() + "'"));
        }
        return null;
    }

    public Map<CmsUUID, I_CmsFormatterBean> getActiveFormatters() {
        if (this.m_activeFormatters == null) {
            CmsFormatterIndex formatterIndex = new CmsFormatterIndex();
            for (I_CmsFormatterBean formatter : this.getCachedFormatters().getAutoEnabledFormatters().values()) {
                formatterIndex.addFormatter(formatter);
            }
            this.applyAllFormatterChanges(formatterIndex, this.getCachedFormatters());
            this.m_activeFormatters = Collections.unmodifiableMap(formatterIndex.getFormattersWithAdditionalKeys());
        }
        return this.m_activeFormatters;
    }

    public List<I_CmsFormatterBean> getActiveFormattersWithContainerType(String containerType) {
        return this.m_formattersByContainerType.computeIfAbsent(containerType, type -> Collections.unmodifiableList(this.getActiveFormatters().values().stream().filter(formatter -> formatter.getContainerTypes().contains(type)).collect(Collectors.toList())));
    }

    public List<I_CmsFormatterBean> getActiveFormattersWithDisplayType(String displayType) {
        return this.m_formattersByDisplayType.computeIfAbsent(displayType, type -> Collections.unmodifiableList(this.getActiveFormatters().values().stream().filter(formatter -> Objects.equals(type, formatter.getDisplayType())).collect(Collectors.toList())));
    }

    public Set<String> getAddableTypeNames() {
        Set<String> result = this.m_typesAddable;
        if (result != null) {
            return result;
        }
        HashSet<String> mutableResult = new HashSet<String>();
        for (CmsResourceTypeConfig typeConfig : this.internalGetResourceTypes(true)) {
            if (typeConfig.isAddDisabled()) continue;
            mutableResult.add(typeConfig.getTypeName());
        }
        this.m_typesAddable = result = Collections.unmodifiableSet(mutableResult);
        return result;
    }

    public CmsAddContentRestriction getAddContentRestriction() {
        this.getAncestorTypeNames();
        CmsADEConfigData parentConfig = this.parent();
        if (parentConfig == null) {
            return this.m_data.getAddContentRestriction();
        }
        return parentConfig.getAddContentRestriction().merge(this.m_data.getAddContentRestriction());
    }

    public List<CmsDetailPageInfo> getAllDetailPages() {
        return this.getAllDetailPages(true);
    }

    public List<CmsDetailPageInfo> getAllDetailPages(boolean update) {
        CmsADEConfigData parentData = this.parent();
        List<CmsDetailPageInfo> parentDetailPages = parentData != null ? parentData.getAllDetailPages(false) : Collections.emptyList();
        List<CmsDetailPageInfo> result = this.mergeDetailPages(parentDetailPages, this.m_data.getOwnDetailPages());
        if (update) {
            result = this.updateUris(result);
        }
        return result;
    }

    public Set<String> getAncestorTypeNames() {
        Set<String> result = this.m_typesInAncestors;
        if (result != null) {
            return result;
        }
        HashSet<String> mutableResult = new HashSet<String>();
        for (CmsResourceTypeConfig typeConfig : this.internalGetResourceTypes(false)) {
            mutableResult.add(typeConfig.getTypeName());
        }
        this.m_typesInAncestors = result = Collections.unmodifiableSet(mutableResult);
        return result;
    }

    public String getAttribute(String key, String defaultValue) {
        CmsADEConfigDataInternal.AttributeValue value = this.getAttributes().get(key);
        if (value != null) {
            return value.getValue();
        }
        return defaultValue;
    }

    public CmsSitemapAttributeEditorConfiguration getAttributeEditorConfiguration() {
        CmsUUID id = this.getAttributeEditorConfigurationId();
        CmsSitemapAttributeEditorConfiguration result = this.m_cache.getAttributeEditorConfiguration(id);
        if (result == null) {
            result = CmsSitemapAttributeEditorConfiguration.EMPTY;
        }
        return result;
    }

    public CmsUUID getAttributeEditorConfigurationId() {
        CmsADEConfigData parent = this.parent();
        CmsUUID result = this.m_data.getAttributeEditorConfigId();
        if (result == null && parent != null) {
            result = parent.getAttributeEditorConfigurationId();
        }
        return result;
    }

    public Map<String, CmsADEConfigDataInternal.AttributeValue> getAttributes() {
        if (this.m_attributes != null) {
            return this.m_attributes;
        }
        CmsADEConfigData parentConfig = this.parent();
        HashMap<String, CmsADEConfigDataInternal.AttributeValue> result = new HashMap<String, CmsADEConfigDataInternal.AttributeValue>();
        if (parentConfig != null) {
            result.putAll(parentConfig.getAttributes());
        }
        for (Map.Entry<String, CmsADEConfigDataInternal.AttributeValue> entry : this.m_data.getAttributes().entrySet()) {
            result.put(entry.getKey(), entry.getValue());
        }
        Map<String, CmsADEConfigDataInternal.AttributeValue> immutableResult = Collections.unmodifiableMap(result);
        this.m_attributes = immutableResult;
        return immutableResult;
    }

    public String getBasePath() {
        return this.m_data.getBasePath();
    }

    public CmsFormatterConfigurationCacheState getCachedFormatters() {
        if (this.m_cachedFormatters == null) {
            this.m_cachedFormatters = OpenCms.getADEManager().getCachedFormatters(this.getCms().getRequestContext().getCurrentProject().isOnlineProject());
        }
        return this.m_cachedFormatters;
    }

    public List<String> getConfigPaths() {
        return this.m_configSequence.getConfigPaths();
    }

    public Set<String> getConfiguredWorkplaceBundles() {
        HashSet<String> result = new HashSet<String>();
        for (CmsResourceTypeConfig config : this.internalGetResourceTypes(false)) {
            String bundlename = config.getConfiguredWorkplaceBundle();
            if (null == bundlename) continue;
            result.add(bundlename);
        }
        return result;
    }

    public String getContentFolderPath() {
        return CmsStringUtil.joinPaths(this.m_data.getBasePath(), ".content");
    }

    public List<CmsResourceTypeConfig> getCreatableTypes(CmsObject cms, String pageFolderRootPath) throws CmsException {
        ArrayList<CmsResourceTypeConfig> result = new ArrayList<CmsResourceTypeConfig>();
        for (CmsResourceTypeConfig typeConfig : this.getResourceTypes()) {
            if (!typeConfig.checkCreatable(cms, pageFolderRootPath)) continue;
            result.add(typeConfig);
        }
        return result;
    }

    public CmsDetailPageInfo getDefaultDetailPage() {
        for (CmsDetailPageInfo detailpage : this.getAllDetailPages(true)) {
            if (!"##DEFAULT##".equals(detailpage.getType())) continue;
            return detailpage;
        }
        return null;
    }

    public CmsModelPageConfig getDefaultModelPage() {
        List<CmsModelPageConfig> modelPages = this.getModelPages();
        for (CmsModelPageConfig modelPageConfig : this.getModelPages()) {
            if (!modelPageConfig.isDefault()) continue;
            return modelPageConfig;
        }
        if (modelPages.isEmpty()) {
            return null;
        }
        return modelPages.get(0);
    }

    public List<DetailInfo> getDetailInfos(CmsObject cms) {
        ArrayList result = Lists.newArrayList();
        List<CmsDetailPageInfo> detailPages = this.getAllDetailPages(true);
        Collections.reverse(detailPages);
        HashMap primaryDetailPageMapByType = Maps.newHashMap();
        for (CmsDetailPageInfo pageInfo : detailPages) {
            primaryDetailPageMapByType.put(pageInfo.getType(), pageInfo);
        }
        for (CmsResourceTypeConfig typeConfig : this.getResourceTypes()) {
            String typeName = typeConfig.getTypeName();
            if (typeConfig.getFolderOrName() != null && typeConfig.getFolderOrName().isPageRelative() || !primaryDetailPageMapByType.containsKey(typeName)) continue;
            String folderPath = typeConfig.getFolderPath(cms, null);
            CmsDetailPageInfo pageInfo = (CmsDetailPageInfo)primaryDetailPageMapByType.get(typeName);
            result.add(new DetailInfo(folderPath, pageInfo, typeName, this.getBasePath()));
        }
        return result;
    }

    public List<CmsDetailPageInfo> getDetailPagesForType(String type) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        CmsResourceTypeConfig typeConfig = this.getResourceType(type);
        if (type.startsWith("function@") || typeConfig != null && !typeConfig.isDetailPagesDisabled()) {
            ArrayList<CmsDetailPageInfo> defaultPages = new ArrayList<CmsDetailPageInfo>();
            for (CmsDetailPageInfo detailpage : this.getAllDetailPages(true)) {
                if (detailpage.getType().equals(type)) {
                    result.add(detailpage);
                    continue;
                }
                if (!"##DEFAULT##".equals(detailpage.getType())) continue;
                defaultPages.add(detailpage);
            }
            result.addAll(defaultPages);
        }
        return result;
    }

    public CmsAdvancedDirectEditProvider.SitemapDirectEditPermissions getDirectEditPermissions(String type) {
        if (type == null) {
            LOG.error((Object)"Null type in checkListEdit");
            return CmsAdvancedDirectEditProvider.SitemapDirectEditPermissions.all;
        }
        if (!this.getAncestorTypeNames().contains(type)) {
            return CmsAdvancedDirectEditProvider.SitemapDirectEditPermissions.editAndCreate;
        }
        CmsResourceTypeConfig typeConfig = this.getResourceType(type);
        if (typeConfig == null) {
            return CmsAdvancedDirectEditProvider.SitemapDirectEditPermissions.none;
        }
        if (typeConfig.isEnabledInLists()) {
            return CmsAdvancedDirectEditProvider.SitemapDirectEditPermissions.editAndCreate;
        }
        if (typeConfig.isCreateDisabled() || typeConfig.isAddDisabled()) {
            return CmsAdvancedDirectEditProvider.SitemapDirectEditPermissions.editOnly;
        }
        return CmsAdvancedDirectEditProvider.SitemapDirectEditPermissions.all;
    }

    public CmsGalleryDisabledTypesMode getDisabledFunctionsMode(CmsGalleryDisabledTypesMode defaultValue) {
        CmsADEConfigData parentData = this.parent();
        if (this.m_data.getGalleryDisabledFunctionsMode() != null) {
            return this.m_data.getGalleryDisabledFunctionsMode();
        }
        if (parentData != null) {
            return parentData.getDisabledFunctionsMode(defaultValue);
        }
        return defaultValue;
    }

    public CmsGalleryDisabledTypesMode getDisabledTypeMode(CmsGalleryDisabledTypesMode defaultValue) {
        CmsADEConfigData parentData = this.parent();
        if (this.m_data.getDisabledTypeMode() != null) {
            return this.m_data.getDisabledTypeMode();
        }
        if (parentData != null) {
            return parentData.getDisabledTypeMode(defaultValue);
        }
        return defaultValue;
    }

    public List<I_CmsFormatterBean> getDisplayFormatters(CmsObject cms) {
        ArrayList<I_CmsFormatterBean> result = new ArrayList<I_CmsFormatterBean>();
        for (I_CmsFormatterBean formatter : this.getCachedFormatters().getFormatters().values()) {
            if (!formatter.isDisplayFormatter()) continue;
            result.add(formatter);
        }
        return result;
    }

    public CmsFunctionAvailability getDynamicFunctionAvailability(CmsFormatterConfigurationCacheState formatterConfig) {
        CmsADEConfigData parentData = this.parent();
        CmsFunctionAvailability result = parentData == null ? new CmsFunctionAvailability(formatterConfig) : parentData.getDynamicFunctionAvailability(formatterConfig);
        Collection<CmsUUID> enabledIds = this.m_data.getDynamicFunctions();
        Collection<CmsUUID> disabledIds = this.m_data.getFunctionsToRemove();
        if (this.m_data.isRemoveAllFunctions() && !this.m_configSequence.getMeta().isSkipRemovals()) {
            result.removeAll();
        }
        if (enabledIds != null) {
            result.addAll(enabledIds);
        }
        if (disabledIds != null) {
            for (CmsUUID id : disabledIds) {
                result.remove(id);
            }
        }
        return result;
    }

    public String getExternalDetailContentExclusionFolder() {
        if (this.m_data.isExcludeExternalDetailContents()) {
            String basePath = this.m_data.getBasePath();
            if (basePath == null) {
                return "/";
            }
            return basePath;
        }
        CmsADEConfigData parent = this.parent();
        if (parent != null) {
            return parent.getExternalDetailContentExclusionFolder();
        }
        return "/";
    }

    public List<CmsFormatterChangeSet> getFormatterChangeSets() {
        ArrayList result = Lists.newArrayList();
        for (CmsADEConfigData currentConfig = this; currentConfig != null; currentConfig = currentConfig.parent()) {
            CmsFormatterChangeSet changes = currentConfig.getOwnFormatterChangeSet();
            if (changes == null) continue;
            if (currentConfig.getMeta().isSkipRemovals()) {
                changes = changes.cloneWithNoRemovals();
            }
            result.add(changes);
        }
        Collections.reverse(result);
        return result;
    }

    public CmsFormatterConfiguration getFormatters(CmsObject cms, CmsResource res) {
        if (CmsResourceTypeFunctionConfig.isFunction(res)) {
            CmsFormatterConfigurationCacheState formatters = this.getCachedFormatters();
            I_CmsFormatterBean function = this.findFormatter(res.getStructureId());
            if (function != null) {
                return CmsFormatterConfiguration.create(cms, Collections.singletonList(function));
            }
            if (!res.getStructureId().isNullUUID() && cms.existsResource(res.getStructureId(), CmsResourceFilter.IGNORE_EXPIRATION)) {
                CmsFormatterBeanParser parser = new CmsFormatterBeanParser(cms, new HashMap<CmsUUID, Map<CmsSharedSettingKey, CmsXmlContentProperty>>());
                try {
                    function = parser.parse(CmsXmlContentFactory.unmarshal(cms, cms.readFile(res)), res.getRootPath(), "" + res.getStructureId());
                    return CmsFormatterConfiguration.create(cms, Collections.singletonList(function));
                }
                catch (Exception e) {
                    LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
                }
            }
            CmsResource defaultFormatter = CmsFunctionRenderer.getDefaultFunctionInstance(cms);
            if (defaultFormatter != null) {
                I_CmsFormatterBean defaultFormatterBean = formatters.getFormatters().get(defaultFormatter.getStructureId());
                return CmsFormatterConfiguration.create(cms, Collections.singletonList(defaultFormatterBean));
            }
            LOG.warn((Object)"Could not read default formatter for functions.");
            return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
        try {
            int resTypeId = res.getTypeId();
            return this.getFormatters(cms, OpenCms.getResourceManager().getResourceType(resTypeId), this.getFormattersFromSchema(cms, res));
        }
        catch (CmsLoaderException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
    }

    public CmsFunctionReference getFunctionReference(String name) {
        List<CmsFunctionReference> functionReferences = this.getFunctionReferences();
        for (CmsFunctionReference functionRef : functionReferences) {
            if (!functionRef.getName().equals(name)) continue;
            return functionRef;
        }
        return null;
    }

    public List<CmsFunctionReference> getFunctionReferences() {
        return this.internalGetFunctionReferences();
    }

    public Map<CmsUUID, I_CmsFormatterBean> getInactiveFormatters() {
        CmsFormatterConfigurationCacheState cacheState = this.getCachedFormatters();
        HashMap result = Maps.newHashMap(cacheState.getFormatters());
        result.keySet().removeAll(this.getActiveFormatters().keySet());
        return result;
    }

    public List<CmsModelPageConfig> getModelPages() {
        return this.getModelPages(false);
    }

    public List<CmsModelPageConfig> getModelPages(boolean includeDisable) {
        CmsADEConfigData parentData = this.parent();
        List<Object> parentModelPages = parentData != null && !this.m_data.isDiscardInheritedModelPages() ? parentData.getModelPages() : Collections.emptyList();
        List<CmsModelPageConfig> result = CmsADEConfigData.combineConfigurationElements(parentModelPages, this.m_data.getOwnModelPageConfig(), includeDisable);
        return result;
    }

    public CmsFormatterChangeSet getOwnFormatterChangeSet() {
        return this.m_data.getFormatterChangeSet();
    }

    public List<CmsPropertyConfig> getPropertyConfiguration() {
        CmsADEConfigData parentData = this.parent();
        boolean removeInherited = this.m_data.isDiscardInheritedProperties() && !this.getMeta().isSkipRemovals();
        List<Object> parentProperties = parentData != null && !removeInherited ? parentData.getPropertyConfiguration() : Collections.emptyList();
        LinkedHashMap<String, CmsPropertyConfig> propMap = new LinkedHashMap<String, CmsPropertyConfig>();
        for (CmsPropertyConfig cmsPropertyConfig : parentProperties) {
            if (cmsPropertyConfig.isDisabled()) continue;
            propMap.put(cmsPropertyConfig.getName(), cmsPropertyConfig);
        }
        for (CmsPropertyConfig cmsPropertyConfig : this.m_data.getOwnPropertyConfigurations()) {
            if (cmsPropertyConfig.isDisabled()) {
                propMap.remove(cmsPropertyConfig.getName());
                continue;
            }
            if (propMap.containsKey(cmsPropertyConfig.getName())) {
                propMap.put(cmsPropertyConfig.getName(), ((CmsPropertyConfig)propMap.get(cmsPropertyConfig.getName())).merge(cmsPropertyConfig));
                continue;
            }
            propMap.put(cmsPropertyConfig.getName(), cmsPropertyConfig);
        }
        ArrayList<CmsPropertyConfig> result = new ArrayList<CmsPropertyConfig>(propMap.values());
        return result;
    }

    public Map<String, CmsXmlContentProperty> getPropertyConfiguration(Map<String, CmsXmlContentProperty> defaultProperties) {
        List<CmsPropertyConfig> myPropConfigs = this.getPropertyConfiguration();
        LinkedHashMap<String, CmsXmlContentProperty> allProps = new LinkedHashMap<String, CmsXmlContentProperty>(defaultProperties);
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        for (CmsPropertyConfig cmsPropertyConfig : myPropConfigs) {
            allProps.put(cmsPropertyConfig.getName(), cmsPropertyConfig.getPropertyData());
            if (!cmsPropertyConfig.isTop()) continue;
            result.put(cmsPropertyConfig.getName(), cmsPropertyConfig.getPropertyData());
        }
        for (Map.Entry entry : allProps.entrySet()) {
            if (result.containsKey(entry.getKey())) continue;
            result.put((String)entry.getKey(), (CmsXmlContentProperty)entry.getValue());
        }
        return result;
    }

    public Map<String, CmsXmlContentProperty> getPropertyConfigurationAsMap() {
        LinkedHashMap<String, CmsXmlContentProperty> result = new LinkedHashMap<String, CmsXmlContentProperty>();
        for (CmsPropertyConfig propConf : this.getPropertyConfiguration()) {
            result.put(propConf.getName(), propConf.getPropertyData());
        }
        return result;
    }

    public CmsResource getResource() {
        return this.m_data.getResource();
    }

    public CmsResourceTypeConfig getResourceType(String typeName) {
        for (CmsResourceTypeConfig type : this.getResourceTypes()) {
            if (!typeName.equals(type.getTypeName())) continue;
            return type;
        }
        return null;
    }

    public List<CmsResourceTypeConfig> getResourceTypes() {
        List<CmsResourceTypeConfig> result = this.internalGetResourceTypes(true);
        for (CmsResourceTypeConfig config : result) {
            config.initialize(this.getCms());
        }
        return result;
    }

    public Collection<CmsResourceTypeConfig> getSearchableTypes(CmsObject cms) {
        return this.getResourceTypes();
    }

    public ImmutableList<CmsUUID> getSharedSettingOverrides() {
        ImmutableList result;
        if (this.m_sharedSettingOverrides != null) {
            return this.m_sharedSettingOverrides;
        }
        ArrayList<CmsADEConfigData> relevantConfigurations = new ArrayList<CmsADEConfigData>();
        for (CmsADEConfigData currentConfig = this; currentConfig != null; currentConfig = currentConfig.parent()) {
            relevantConfigurations.add(currentConfig);
            if (currentConfig.m_data.isRemoveSharedSettingOverrides() && !currentConfig.m_configSequence.getMeta().isSkipRemovals()) break;
        }
        Collections.reverse(relevantConfigurations);
        ArrayList<CmsUUID> ids = new ArrayList<CmsUUID>();
        for (CmsADEConfigData config : relevantConfigurations) {
            CmsUUID id = config.m_data.getSharedSettingOverride();
            if (id == null) continue;
            ids.add(id);
        }
        this.m_sharedSettingOverrides = result = ImmutableList.copyOf(ids);
        return result;
    }

    public Set<CmsUUID> getSitePluginIds() {
        CmsADEConfigData parent = this.parent();
        Set<Object> result = parent == null || this.m_data.isRemoveAllPlugins() && !this.getMeta().isSkipRemovals() ? new HashSet() : parent.getSitePluginIds();
        result.removeAll(this.m_data.getRemovedPlugins());
        result.addAll(this.m_data.getAddedPlugins());
        return result;
    }

    public List<CmsSitePlugin> getSitePlugins() {
        Set<CmsUUID> pluginIds = this.getSitePluginIds();
        ArrayList<CmsSitePlugin> result = new ArrayList<CmsSitePlugin>();
        Map<CmsUUID, CmsSitePlugin> plugins = this.m_cache.getSitePlugins();
        for (CmsUUID id : pluginIds) {
            CmsSitePlugin sitePlugin = plugins.get(id);
            if (sitePlugin == null) continue;
            result.add(sitePlugin);
        }
        return result;
    }

    public CmsTypeOrderingMode getTypeOrderingMode() {
        CmsTypeOrderingMode ownOrderingMode = this.m_data.getTypeOrderingMode();
        if (ownOrderingMode != null) {
            return ownOrderingMode;
        }
        CmsADEConfigData parentConfig = this.parent();
        CmsTypeOrderingMode parentMode = null;
        parentMode = parentConfig == null ? CmsTypeOrderingMode.latestOnTop : parentConfig.getTypeOrderingMode();
        return parentMode;
    }

    public Map<String, CmsResourceTypeConfig> getTypesByName() {
        if (this.m_typesByName != null) {
            return this.m_typesByName;
        }
        HashMap<String, CmsResourceTypeConfig> result = new HashMap();
        for (CmsResourceTypeConfig type : this.getResourceTypes()) {
            result.put(type.getTypeName(), type);
        }
        result = Collections.unmodifiableMap(result);
        this.m_typesByName = result;
        return result;
    }

    public Set<String> getTypesWithActiveSchemaFormatters() {
        HashSet result = Sets.newHashSet(this.getTypesWithModifiableFormatters());
        for (CmsFormatterChangeSet changeSet : this.getFormatterChangeSets()) {
            changeSet.applyToTypes(result);
        }
        return result;
    }

    public Set<String> getTypesWithModifiableFormatters() {
        HashSet<String> result = new HashSet<String>();
        for (I_CmsResourceType type : OpenCms.getResourceManager().getResourceTypes()) {
            if (!(type instanceof CmsResourceTypeXmlContent)) continue;
            CmsXmlContentDefinition contentDef = null;
            try {
                contentDef = CmsXmlContentDefinition.getContentDefinitionForType(this.getCms(), type.getTypeName());
                if (contentDef == null || !contentDef.getContentHandler().hasModifiableFormatters()) continue;
                result.add(type.getTypeName());
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public boolean hasFormatters(CmsObject cms, I_CmsResourceType resType, Collection<CmsContainer> containers) {
        try {
            if ("function".equals(resType.getTypeName()) || "function_config".equals(resType.getTypeName())) {
                return true;
            }
            CmsXmlContentDefinition def = CmsXmlContentDefinition.getContentDefinitionForType(cms, resType.getTypeName());
            CmsFormatterConfiguration schemaFormatters = def.getContentHandler().getFormatterConfiguration(cms, null);
            CmsFormatterConfiguration formatters = this.getFormatters(cms, resType, schemaFormatters);
            for (CmsContainer cont : containers) {
                if (!cont.isEditable() || formatters.getAllMatchingFormatters(cont.getType(), cont.getWidth()).size() <= 0) continue;
                return true;
            }
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return false;
    }

    public boolean isCreateContentsLocally() {
        return this.m_data.isCreateContentsLocally();
    }

    public boolean isDiscardInheritedModelPages() {
        return this.m_data.isDiscardInheritedModelPages();
    }

    public boolean isDiscardInheritedProperties() {
        return this.m_data.isDiscardInheritedProperties();
    }

    public boolean isDiscardInheritedTypes() {
        return this.m_data.isDiscardInheritedTypes();
    }

    public boolean isExcludeExternalDetailContents() {
        return this.m_data.isExcludeExternalDetailContents();
    }

    public boolean isHideNonMatchingFunctions() {
        return this.getDisabledFunctionsMode(CmsGalleryDisabledTypesMode.hide) == CmsGalleryDisabledTypesMode.hide;
    }

    public boolean isIncludeInSiteSelector() {
        return this.m_configSequence.getConfig().isIncludeInSiteSelector();
    }

    public boolean isModuleConfiguration() {
        return this.m_data.isModuleConfig();
    }

    public boolean isPreferDetailPagesForLocalContents() {
        return this.m_data.isPreferDetailPagesForLocalContents();
    }

    public boolean isSearchContentFormatter(CmsUUID jspId) {
        for (I_CmsFormatterBean formatter : this.getFormattersByJspId().get((Object)jspId)) {
            if (!formatter.isSearchContent()) continue;
            return true;
        }
        return false;
    }

    public boolean isUseFormatterKeys() {
        Boolean result = this.m_data.getUseFormatterKeys();
        if (result != null) {
            LOG.debug((Object)("isUseFormatterKeys - found value " + result + " at " + this.getBasePath()));
            return result;
        }
        CmsADEConfigData parent = this.parent();
        if (parent != null) {
            return parent.isUseFormatterKeys();
        }
        boolean defaultValue = true;
        LOG.debug((Object)("isUseFormatterKeys - using defaultValue " + defaultValue));
        return defaultValue;
    }

    public CmsADEConfigData parent() {
        Optional<CmsADEConfigurationSequence> parentPath = this.m_configSequence.getParent();
        if (parentPath.isPresent()) {
            CmsADEConfigDataInternal internalData = ((CmsADEConfigurationSequence)parentPath.get()).getConfig();
            return new CmsADEConfigData(internalData, this.m_cache, (CmsADEConfigurationSequence)parentPath.get());
        }
        return null;
    }

    public boolean shouldShowSitemapAttributeDialog() {
        return this.getAttributeEditorConfiguration().getAttributeDefinitions().size() > 0;
    }

    protected void clearCaches() {
        this.m_activeFormatters = null;
        this.m_activeFormattersByKey = null;
        this.m_formattersByKey = null;
        this.m_formattersByJspId = null;
        this.m_formattersByTypeCache.invalidateAll();
    }

    protected void createContentDirectory() throws CmsException {
        if (!this.isModuleConfiguration()) {
            String contentFolder = this.getContentFolderPath();
            if (!this.getCms().existsResource(contentFolder)) {
                this.getCms().createResource(contentFolder, OpenCms.getResourceManager().getResourceType(CmsResourceTypeFolder.getStaticTypeName()));
            }
        }
    }

    protected CmsObject getCms() {
        return this.m_cache.getCms();
    }

    protected CmsObject getCmsObject() {
        return this.getCms();
    }

    protected Map<String, List<CmsDetailPageInfo>> getDetailPagesMap(List<CmsDetailPageInfo> detailPages) {
        HashMap result = Maps.newHashMap();
        for (CmsDetailPageInfo detailpage : detailPages) {
            String type = detailpage.getType();
            if (!result.containsKey(type)) {
                result.put(type, new ArrayList());
            }
            ((List)result.get(type)).add(detailpage);
        }
        return result;
    }

    protected Map<String, String> getFolderTypes() throws CmsException {
        HashMap<String, String> result = new HashMap<String, String>();
        CmsObject cms = OpenCms.initCmsObject(this.getCms());
        if (this.m_data.isModuleConfig()) {
            Set<String> siteRoots = OpenCms.getSiteManager().getSiteRoots();
            for (String siteRoot : siteRoots) {
                cms.getRequestContext().setSiteRoot(siteRoot);
                for (CmsResourceTypeConfig config : this.getResourceTypes()) {
                    if (config.isDetailPagesDisabled()) continue;
                    String typeName = config.getTypeName();
                    if (config.isPageRelative()) continue;
                    String folderPath = config.getFolderPath(cms, null);
                    result.put(CmsStringUtil.joinPaths(folderPath, "/"), typeName);
                }
            }
        } else {
            for (CmsResourceTypeConfig config : this.getResourceTypes()) {
                if (config.isDetailPagesDisabled()) continue;
                String typeName = config.getTypeName();
                if (config.isPageRelative()) continue;
                String folderPath = config.getFolderPath(this.getCms(), null);
                result.put(CmsStringUtil.joinPaths(folderPath, "/"), typeName);
            }
        }
        return result;
    }

    protected CmsFormatterConfiguration getFormatters(CmsObject cms, I_CmsResourceType resType, CmsFormatterConfiguration schemaFormatters) {
        String typeName = resType.getTypeName();
        ArrayList<I_CmsFormatterBean> formatters = new ArrayList<I_CmsFormatterBean>();
        HashSet<String> types = new HashSet<String>();
        types.add(typeName);
        for (CmsFormatterChangeSet changeSet : this.getFormatterChangeSets()) {
            if (changeSet == null) continue;
            changeSet.applyToTypes(types);
        }
        if (schemaFormatters != null && types.contains(typeName)) {
            for (I_CmsFormatterBean formatter : schemaFormatters.getAllFormatters()) {
                formatters.add(formatter);
            }
        }
        try {
            List formattersForType = (List)this.m_formattersByTypeCache.get((Object)typeName);
            formatters.addAll(formattersForType);
        }
        catch (ExecutionException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return CmsFormatterConfiguration.create(cms, formatters);
    }

    protected CmsFormatterConfiguration getFormattersFromSchema(CmsObject cms, CmsResource res) {
        try {
            return OpenCms.getResourceManager().getResourceType(res.getTypeId()).getFormattersForResource(cms, res);
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
    }

    protected CmsADEConfigDataInternal.ConfigReferenceMeta getMeta() {
        return this.m_configSequence.getMeta();
    }

    protected List<CmsFunctionReference> internalGetFunctionReferences() {
        CmsADEConfigData parentData = this.parent();
        if (parentData == null) {
            if (this.m_data.isModuleConfig()) {
                return Collections.unmodifiableList(this.m_data.getFunctionReferences());
            }
            return Lists.newArrayList();
        }
        return parentData.internalGetFunctionReferences();
    }

    protected List<CmsResourceTypeConfig> internalGetResourceTypes(boolean filterDisabled) {
        CmsADEConfigData parentData = this.parent();
        ArrayList parentResourceTypes = null;
        if (parentData == null) {
            parentResourceTypes = Lists.newArrayList();
        } else {
            parentResourceTypes = Lists.newArrayList();
            for (CmsResourceTypeConfig typeConfig : parentData.internalGetResourceTypes(false)) {
                CmsResourceTypeConfig copiedType = typeConfig.copy(this.m_data.isDiscardInheritedTypes() && !this.getMeta().isSkipRemovals());
                parentResourceTypes.add(copiedType);
            }
        }
        String template = this.getMeta().getTemplate();
        List<CmsResourceTypeConfig> result = CmsADEConfigData.combineConfigurationElements(parentResourceTypes, this.m_data.getOwnResourceTypes().stream().map(type -> type.markWithTemplate(template)).collect(Collectors.toList()), true);
        if (this.m_data.isCreateContentsLocally()) {
            for (CmsResourceTypeConfig typeConfig : result) {
                typeConfig.updateBasePath(CmsStringUtil.joinPaths(this.m_data.getBasePath(), ".content"));
            }
        }
        if (filterDisabled) {
            Iterator iter = result.iterator();
            while (iter.hasNext()) {
                CmsResourceTypeConfig typeConfig;
                typeConfig = (CmsResourceTypeConfig)iter.next();
                if (!typeConfig.isDisabled()) continue;
                iter.remove();
            }
        }
        if (this.getTypeOrderingMode() == CmsTypeOrderingMode.byDisplayOrder) {
            Collections.sort(result, (a, b) -> Integer.compare(a.getOrder(), b.getOrder()));
        }
        return result;
    }

    protected List<CmsDetailPageInfo> mergeDetailPages(List<CmsDetailPageInfo> parentDetailPages, List<CmsDetailPageInfo> ownDetailPages) {
        ArrayList parentDetailPageCopies = Lists.newArrayList();
        for (CmsDetailPageInfo info : parentDetailPages) {
            parentDetailPageCopies.add(info.copyAsInherited());
        }
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        HashMap resultDetailPageMap = Maps.newHashMap();
        resultDetailPageMap.putAll(this.getDetailPagesMap(parentDetailPageCopies));
        resultDetailPageMap.putAll(this.getDetailPagesMap(ownDetailPages));
        result = new ArrayList();
        for (List pages : resultDetailPageMap.values()) {
            result.addAll(pages);
        }
        return result;
    }

    protected List<CmsDetailPageInfo> updateUris(List<CmsDetailPageInfo> detailPages) {
        ArrayList<CmsDetailPageInfo> result = new ArrayList<CmsDetailPageInfo>();
        for (CmsDetailPageInfo page : detailPages) {
            CmsUUID structureId = page.getId();
            try {
                String rootPath = OpenCms.getADEManager().getRootPath(structureId, this.getCms().getRequestContext().getCurrentProject().isOnlineProject());
                String iconClasses = page.getType().startsWith("function@") ? CmsIconUtil.getIconClasses("function", null, false) : CmsIconUtil.getIconClasses(page.getType(), null, false);
                CmsDetailPageInfo correctedPage = new CmsDetailPageInfo(structureId, rootPath, page.getType(), page.getQualifier(), iconClasses);
                result.add(page.isInherited() ? correctedPage.copyAsInherited() : correctedPage);
            }
            catch (CmsException e) {
                LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }

    private Multimap<String, I_CmsFormatterBean> getActiveFormattersByKey() {
        if (this.m_activeFormattersByKey == null) {
            ArrayListMultimap activeFormattersByKey = ArrayListMultimap.create();
            for (I_CmsFormatterBean formatter : this.getActiveFormatters().values()) {
                for (String key : formatter.getAllKeys()) {
                    activeFormattersByKey.put((Object)key, (Object)formatter);
                }
            }
            this.m_activeFormattersByKey = activeFormattersByKey;
        }
        return this.m_activeFormattersByKey;
    }

    private I_CmsFormatterBean getFormatterAndWarnIfAmbiguous(Multimap<String, I_CmsFormatterBean> formatterMap, String name, boolean noWarn) {
        I_CmsFormatterBean result = null;
        Collection activeForKey = formatterMap.get((Object)name);
        if (activeForKey.size() > 0) {
            if (activeForKey.size() > 1 && !noWarn) {
                String labels = "" + activeForKey.stream().map(this::getFormatterLabel).collect(Collectors.toList());
                String message = "Ambiguous formatter for key '" + name + "' at '" + this.getBasePath() + "': found " + labels;
                LOG.warn((Object)message);
                OpenCmsServlet.withRequestCache(rc -> rc.addLog(REQUEST_LOG_CHANNEL, "warn", REQ_LOG_PREFIX + message));
            }
            result = (I_CmsFormatterBean)activeForKey.iterator().next();
        }
        return result;
    }

    private String getFormatterLabel(I_CmsFormatterBean formatter) {
        return formatter.getLocation() != null ? formatter.getLocation() : formatter.getId();
    }

    private Multimap<CmsUUID, I_CmsFormatterBean> getFormattersByJspId() {
        if (this.m_formattersByJspId == null) {
            ArrayListMultimap formattersByJspId = ArrayListMultimap.create();
            for (I_CmsFormatterBean formatter : this.getCachedFormatters().getFormatters().values()) {
                formattersByJspId.put((Object)formatter.getJspStructureId(), (Object)formatter);
            }
            this.m_formattersByJspId = formattersByJspId;
        }
        return this.m_formattersByJspId;
    }

    private Multimap<String, I_CmsFormatterBean> getFormattersByKey() {
        if (this.m_formattersByKey == null) {
            ArrayListMultimap formattersByKey = ArrayListMultimap.create();
            for (I_CmsFormatterBean formatter : this.getCachedFormatters().getFormatters().values()) {
                for (String key : formatter.getAllKeys()) {
                    formattersByKey.put((Object)key, (Object)formatter);
                }
            }
            this.m_formattersByKey = formattersByKey;
        }
        return this.m_formattersByKey;
    }

    public class DetailInfo {
        private String m_basePath;
        private CmsDetailPageInfo m_detailPageInfo;
        private String m_folderPath;
        private String m_type;

        public DetailInfo(String folderPath, CmsDetailPageInfo detailPageInfo, String type, String basePath) {
            this.m_folderPath = folderPath;
            this.m_detailPageInfo = detailPageInfo;
            this.m_type = type;
            this.m_basePath = basePath;
        }

        public String getBasePath() {
            return this.m_basePath;
        }

        public CmsDetailPageInfo getDetailPageInfo() {
            return this.m_detailPageInfo;
        }

        public String getFolderPath() {
            return this.m_folderPath;
        }

        public String getType() {
            return this.m_type;
        }

        public void setBasePath(String basePath) {
            this.m_basePath = basePath;
        }

        public String toString() {
            return ReflectionToStringBuilder.toString((Object)this);
        }
    }
}

