/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;

public class CmsContentFolderDescriptor {
    public static final String ELEMENTS_FOLDER_NAME = ".elements";
    private static final Log LOG = CmsLog.getLog(CmsContentFolderDescriptor.class);
    private String m_basePath;
    private CmsResource m_folder;
    private String m_folderName;
    private boolean m_isPageRelative;

    public CmsContentFolderDescriptor(CmsResource folder) {
        this.m_folder = folder;
    }

    public CmsContentFolderDescriptor(String basePath, String name) {
        this.m_basePath = basePath;
        this.m_folderName = name;
    }

    private CmsContentFolderDescriptor() {
    }

    public static CmsContentFolderDescriptor createPageRelativeFolderDescriptor() {
        CmsContentFolderDescriptor result = new CmsContentFolderDescriptor();
        result.m_isPageRelative = true;
        return result;
    }

    public String getBasePath() {
        return this.m_basePath;
    }

    public CmsResource getFolder() {
        return this.m_folder;
    }

    public String getFolderName() {
        return this.m_folderName;
    }

    public String getFolderPath(CmsObject cms, String pageFolderPath) {
        if (this.m_folder != null) {
            try {
                return OpenCms.getADEManager().getRootPath(this.m_folder.getStructureId(), cms.getRequestContext().getCurrentProject().isOnlineProject());
            }
            catch (CmsException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                return this.m_folder.getRootPath();
            }
        }
        if (this.m_basePath != null) {
            return CmsStringUtil.joinPaths(this.m_basePath, this.m_folderName);
        }
        if (this.m_isPageRelative) {
            if (pageFolderPath == null) {
                throw new IllegalArgumentException("getFolderPath called without page folder, but pageRelative is enabled!");
            }
            try {
                CmsResource folder = cms.readResource(cms.getRequestContext().removeSiteRoot(pageFolderPath), CmsResourceFilter.IGNORE_EXPIRATION);
                if (folder.isFile()) {
                    pageFolderPath = CmsResource.getParentFolder(pageFolderPath);
                }
            }
            catch (CmsException cmsException) {
                // empty catch block
            }
            return CmsStringUtil.joinPaths(pageFolderPath, ELEMENTS_FOLDER_NAME);
        }
        return CmsStringUtil.joinPaths(cms.getRequestContext().getSiteRoot(), ".content", this.m_folderName);
    }

    public boolean isFolder() {
        return this.m_folder != null;
    }

    public boolean isName() {
        return this.m_folderName != null;
    }

    public boolean isPageRelative() {
        return this.m_isPageRelative;
    }
}

