/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsContentFolderDescriptor;
import org.opencms.ade.configuration.CmsElementView;
import org.opencms.ade.configuration.I_CmsConfigurationObject;
import org.opencms.ade.containerpage.shared.CmsCntPageData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.lock.CmsLock;
import org.opencms.lock.CmsLockException;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategoryService;
import org.opencms.security.CmsPermissionSet;
import org.opencms.security.CmsRole;
import org.opencms.ui.util.CmsNewResourceBuilder;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.util.CmsVfsUtil;
import org.opencms.workplace.explorer.CmsExplorerTypeSettings;

public class CmsResourceTypeConfig
implements I_CmsConfigurationObject<CmsResourceTypeConfig>,
Cloneable {
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeConfig.class);
    protected CmsObject m_cms;
    private boolean m_addDisabled;
    private boolean m_availabilityNotSet;
    private Boolean m_copyInModels;
    private boolean m_createDisabled;
    private boolean m_detailPagesDisabled;
    private boolean m_disabled;
    private boolean m_editDisabled;
    private CmsCntPageData.ElementDeleteMode m_elementDeleteMode;
    private CmsUUID m_elementView;
    private boolean m_enableInLists;
    private CmsContentFolderDescriptor m_folderOrName;
    private String m_localization;
    private String m_namePattern;
    private Integer m_order;
    private Boolean m_showInDefaultView;
    private Set<String> m_templates = new HashSet<String>();
    private String m_typeName;

    public CmsResourceTypeConfig(String typeName, boolean disabled, CmsContentFolderDescriptor folder, String pattern) {
        this(typeName, disabled, folder, pattern, false, false, false, false, false, false, CmsElementView.DEFAULT_ELEMENT_VIEW.getId(), null, null, null, 10000, null);
    }

    public CmsResourceTypeConfig(String typeName, boolean disabled, CmsContentFolderDescriptor folder, String pattern, boolean detailPagesDisabled, boolean addDisabled, boolean createDisabled, boolean editDisabled, boolean enableInLists, boolean availabilityNotSet, CmsUUID elementView, String localization, Boolean showInDefaultView, Boolean copyInModels, Integer order, CmsCntPageData.ElementDeleteMode elementDeleteMode) {
        this.m_typeName = typeName;
        this.m_disabled = disabled;
        this.m_folderOrName = folder;
        this.m_namePattern = pattern;
        this.m_detailPagesDisabled = detailPagesDisabled;
        this.m_addDisabled = addDisabled;
        this.m_createDisabled = createDisabled;
        this.m_availabilityNotSet = availabilityNotSet;
        this.m_elementView = elementView;
        this.m_editDisabled = editDisabled;
        this.m_enableInLists = enableInLists;
        this.m_localization = localization;
        this.m_showInDefaultView = showInDefaultView;
        this.m_copyInModels = copyInModels;
        this.m_order = order;
        this.m_elementDeleteMode = elementDeleteMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean checkCreatable(CmsObject cms, String pageFolderRootPath) throws CmsException {
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            return false;
        }
        if (OpenCms.getRoleManager().hasRole(cms, CmsRole.ROOT_ADMIN)) {
            return true;
        }
        if ("function".equals(this.m_typeName) || "function_config".equals(this.m_typeName)) {
            return OpenCms.getRoleManager().hasRole(cms, CmsRole.DEVELOPER);
        }
        this.checkInitialized();
        if (this.m_folderOrName != null && this.m_folderOrName.isPageRelative() && pageFolderRootPath == null) {
            LOG.info((Object)("type " + this.m_typeName + " not creatable for pageFolderRootPath=null because it is configured to be page-relative"));
            return false;
        }
        String folderPath = this.getFolderPath(cms, pageFolderRootPath);
        String oldSiteRoot = cms.getRequestContext().getSiteRoot();
        cms.getRequestContext().setSiteRoot("");
        CmsResource permissionCheckFolder = null;
        String currentPath2 = folderPath;
        while (currentPath2 != null) {
            try {
                permissionCheckFolder = cms.readResource(currentPath2);
                break;
            }
            catch (CmsVfsResourceNotFoundException cmsVfsResourceNotFoundException) {
                currentPath2 = CmsResource.getParentFolder(currentPath2);
            }
        }
        try {
            if (permissionCheckFolder == null) {
                boolean currentPath2 = false;
                return currentPath2;
            }
            LOG.info((Object)("Using " + permissionCheckFolder + " as a permission check folder for " + folderPath));
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_typeName);
            if (settings == null) {
                boolean bl = false;
                return bl;
            }
            boolean editable = settings.isEditable(cms, permissionCheckFolder);
            boolean controlPermission = settings.getAccess().getPermissions(cms, permissionCheckFolder).requiresControlPermission();
            boolean hasWritePermission = cms.hasPermissions(permissionCheckFolder, CmsPermissionSet.ACCESS_WRITE, false, CmsResourceFilter.ONLY_VISIBLE_NO_DELETED);
            boolean bl = editable && controlPermission && hasWritePermission;
            return bl;
        }
        catch (CmsVfsResourceNotFoundException e) {
            boolean bl = false;
            return bl;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            cms.getRequestContext().setSiteRoot(oldSiteRoot);
        }
    }

    public void checkInitialized() {
        if (this.m_cms == null) {
            throw new IllegalStateException();
        }
    }

    public void checkOffline(CmsObject cms) {
        if (cms.getRequestContext().getCurrentProject().isOnlineProject()) {
            throw new IllegalStateException();
        }
    }

    public boolean checkViewable(CmsObject cms, String referenceUri) {
        try {
            CmsExplorerTypeSettings settings = OpenCms.getWorkplaceManager().getExplorerTypeSetting(this.m_typeName);
            CmsResource referenceResource = cms.readResource(referenceUri, CmsResourceFilter.ignoreExpirationOffline(cms));
            if (settings == null) {
                return false;
            }
            return settings.getAccess().getPermissions(cms, referenceResource).requiresViewPermission();
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return false;
        }
    }

    public void configureCreateNewElement(CmsObject cms, String pageFolderRootPath, CmsNewResourceBuilder builder) throws CmsException {
        this.checkOffline(cms);
        this.checkInitialized();
        String folderPath = this.getFolderPath(cms, pageFolderRootPath);
        CmsVfsUtil.createFolder(cms, folderPath);
        String destination = CmsStringUtil.joinPaths(folderPath, this.getNamePattern(true));
        builder.setSiteRoot("");
        builder.setPatternPath(destination);
        builder.setType(this.getTypeName());
        builder.setLocale(cms.getRequestContext().getLocale());
    }

    public CmsResource createNewElement(CmsObject userCms, CmsResource modelResource, String pageFolderRootPath) throws CmsException {
        this.checkOffline(userCms);
        this.checkInitialized();
        CmsObject rootCms = this.rootCms(userCms);
        String folderPath = this.getFolderPath(userCms, pageFolderRootPath);
        CmsVfsUtil.createFolder(userCms, folderPath);
        String destination = CmsStringUtil.joinPaths(folderPath, this.getNamePattern(true));
        String creationPath = OpenCms.getResourceManager().getNameGenerator().getNewFileName(rootCms, destination, 5);
        Locale contentLocale = userCms.getRequestContext().getLocale();
        if (!OpenCms.getLocaleManager().getAvailableLocales(rootCms, folderPath).contains(contentLocale)) {
            contentLocale = OpenCms.getLocaleManager().getDefaultLocale(rootCms, folderPath);
        }
        rootCms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_NEW_RESOURCE_LOCALE, contentLocale);
        if (modelResource != null) {
            rootCms.getRequestContext().setAttribute(CmsRequestContext.ATTRIBUTE_MODEL, modelResource.getRootPath());
        }
        CmsResource createdResource = rootCms.createResource(creationPath, this.getType(), null, new ArrayList<CmsProperty>(0));
        if (modelResource != null) {
            CmsCategoryService.getInstance().copyCategories(rootCms, modelResource, creationPath);
        }
        try {
            rootCms.unlockResource(creationPath);
        }
        catch (CmsLockException e) {
            LOG.info((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return createdResource;
    }

    public CmsResource createNewElement(CmsObject userCms, String pageFolderRootPath) throws CmsException {
        return this.createNewElement(userCms, null, pageFolderRootPath);
    }

    public AddMenuVisibility getAddMenuVisibility(CmsUUID elementViewId, AddMenuType menuType) {
        if (this.isAddDisabled()) {
            return AddMenuVisibility.disabled;
        }
        if (elementViewId.equals(this.getElementView())) {
            if (this.isCreateDisabled() && menuType == AddMenuType.ade) {
                return AddMenuVisibility.createDisabled;
            }
            return AddMenuVisibility.visible;
        }
        if (this.isShowInDefaultView() && elementViewId.equals(CmsElementView.DEFAULT_ELEMENT_VIEW.getId())) {
            return AddMenuVisibility.fromOtherView;
        }
        return AddMenuVisibility.disabled;
    }

    public String getConfiguredWorkplaceBundle() {
        return this.m_localization;
    }

    public CmsCntPageData.ElementDeleteMode getElementDeleteMode() {
        return this.m_elementDeleteMode;
    }

    public CmsUUID getElementView() {
        return this.m_elementView == null ? CmsElementView.DEFAULT_ELEMENT_VIEW.getId() : this.m_elementView;
    }

    public String getFolderPath(CmsObject cms, String pageFolderRootPath) {
        this.checkInitialized();
        if (this.m_folderOrName != null) {
            return this.m_folderOrName.getFolderPath(cms, pageFolderRootPath);
        }
        String siteRoot = null;
        if (pageFolderRootPath != null) {
            siteRoot = OpenCms.getSiteManager().getSiteRoot(pageFolderRootPath);
        }
        if (siteRoot == null) {
            siteRoot = cms.getRequestContext().getSiteRoot();
        }
        return CmsStringUtil.joinPaths(siteRoot, ".content", this.m_typeName);
    }

    @Override
    public String getKey() {
        return this.m_typeName;
    }

    public String getNamePattern(boolean useDefaultIfEmpty) {
        if (this.m_namePattern != null) {
            return this.m_namePattern;
        }
        if (useDefaultIfEmpty) {
            return this.m_typeName + "-%(number).xml";
        }
        return null;
    }

    public int getOrder() {
        if (this.m_order == null) {
            return 10000;
        }
        return this.m_order;
    }

    public Integer getOrderObject() {
        return this.m_order;
    }

    public I_CmsResourceType getType() throws CmsException {
        return OpenCms.getResourceManager().getResourceType(this.m_typeName);
    }

    public String getTypeName() {
        return this.m_typeName;
    }

    public boolean isAvailableInTemplate(String template) {
        return template == null || this.m_templates.size() == 0 || this.m_templates.contains(template);
    }

    public void initialize(CmsObject cms) {
        this.m_cms = cms;
    }

    public boolean isAddDisabled() {
        return this.m_addDisabled;
    }

    public boolean isCopyInModels() {
        return this.m_copyInModels == null || this.m_copyInModels != false;
    }

    public boolean isCreateDisabled() {
        return this.m_createDisabled;
    }

    public boolean isDetailPagesDisabled() {
        return this.m_detailPagesDisabled;
    }

    @Override
    public boolean isDisabled() {
        return this.m_disabled;
    }

    public boolean isEditDisabled() {
        return this.m_editDisabled;
    }

    public boolean isEnabledInLists() {
        return this.m_enableInLists;
    }

    public boolean isPageRelative() {
        return this.m_folderOrName != null && this.m_folderOrName.isPageRelative();
    }

    public boolean isShowInDefaultView() {
        return this.m_showInDefaultView != null && this.m_showInDefaultView != false;
    }

    public CmsResourceTypeConfig markWithTemplate(String template) {
        try {
            if (template == null) {
                return this;
            }
            CmsResourceTypeConfig result = (CmsResourceTypeConfig)super.clone();
            HashSet<String> templates = new HashSet<String>();
            templates.add(template);
            result.m_templates = templates;
            return result;
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }

    @Override
    public CmsResourceTypeConfig merge(CmsResourceTypeConfig childConfig) {
        boolean mergedAddDisabled;
        CmsContentFolderDescriptor folderOrName = childConfig.m_folderOrName != null ? childConfig.m_folderOrName : this.m_folderOrName;
        String namePattern = childConfig.m_namePattern != null ? childConfig.m_namePattern : this.m_namePattern;
        CmsUUID elementView = childConfig.m_elementView != null ? childConfig.m_elementView : this.m_elementView;
        Boolean showInDefaultView = childConfig.m_showInDefaultView != null ? childConfig.m_showInDefaultView : this.m_showInDefaultView;
        Boolean copyInModels = childConfig.m_copyInModels != null ? childConfig.m_copyInModels : this.m_copyInModels;
        CmsCntPageData.ElementDeleteMode deleteMode = childConfig.m_elementDeleteMode != null ? childConfig.m_elementDeleteMode : this.m_elementDeleteMode;
        Integer order = childConfig.m_order != null ? childConfig.m_order : this.m_order;
        boolean mergedDisabled = childConfig.m_availabilityNotSet ? this.isDisabled() : childConfig.isDisabled();
        boolean bl = mergedAddDisabled = childConfig.m_availabilityNotSet ? this.isAddDisabled() : childConfig.isAddDisabled();
        boolean mergedCreateDisabled = childConfig.m_availabilityNotSet ? this.isCreateDisabled() : this.isCreateDisabled() || childConfig.isCreateDisabled();
        boolean mergedEnableInLists = childConfig.m_availabilityNotSet ? this.m_enableInLists : childConfig.m_enableInLists;
        boolean mergedDisableEdit = childConfig.m_availabilityNotSet ? this.m_editDisabled : childConfig.m_editDisabled;
        CmsResourceTypeConfig result = new CmsResourceTypeConfig(this.m_typeName, mergedDisabled, folderOrName, namePattern, this.isDetailPagesDisabled() || childConfig.isDetailPagesDisabled(), mergedAddDisabled, mergedCreateDisabled, mergedDisableEdit, mergedEnableInLists, false, elementView, this.m_localization, showInDefaultView, copyInModels, order, deleteMode);
        result.m_templates = new HashSet<String>(this.m_templates);
        result.m_templates.addAll(childConfig.m_templates);
        return result;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.m_typeName + "]";
    }

    protected CmsResourceTypeConfig copy() {
        return this.copy(false);
    }

    protected CmsResourceTypeConfig copy(boolean disabled) {
        CmsResourceTypeConfig result = new CmsResourceTypeConfig(this.m_typeName, this.m_disabled || disabled, this.getFolderOrName(), this.m_namePattern, this.m_detailPagesDisabled, this.isAddDisabled(), this.isCreateDisabled(), this.m_editDisabled, this.m_enableInLists, this.m_availabilityNotSet, this.m_elementView, this.m_localization, this.m_showInDefaultView, this.m_copyInModels, this.m_order, this.m_elementDeleteMode);
        result.m_templates = this.m_templates;
        return result;
    }

    protected CmsContentFolderDescriptor getFolderOrName() {
        return this.m_folderOrName;
    }

    protected String getNamePattern() {
        return this.m_namePattern;
    }

    protected CmsObject rootCms(CmsObject cms) throws CmsException {
        CmsObject result = OpenCms.initCmsObject(cms);
        result.getRequestContext().setSiteRoot("");
        return result;
    }

    protected void tryToUnlock(CmsObject cms, String folderPath) throws CmsException {
        while (!cms.existsResource(folderPath)) {
            folderPath = CmsResource.getParentFolder(folderPath);
        }
        CmsResource resource = cms.readResource(folderPath);
        CmsLock lock = cms.getLock(resource);
        if (lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
            while (lock.isInherited()) {
                folderPath = CmsResource.getParentFolder(folderPath);
                resource = cms.readResource(folderPath);
                lock = cms.getLock(resource);
            }
            cms.unlockResource(folderPath);
        }
    }

    protected void updateBasePath(String basePath) {
        if (this.m_folderOrName != null) {
            if (this.m_folderOrName.isName()) {
                this.m_folderOrName = new CmsContentFolderDescriptor(basePath, this.m_folderOrName.getFolderName());
            }
        } else {
            this.m_folderOrName = new CmsContentFolderDescriptor(basePath, this.m_typeName);
        }
    }

    public static enum AddMenuVisibility {
        createDisabled,
        disabled,
        fromOtherView,
        visible;

    }

    public static enum AddMenuType {
        ade,
        workplace;

    }
}

