/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.formatters;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.opencms.ade.configuration.CmsConfigurationReader;
import org.opencms.ade.configuration.CmsPropertyConfig;
import org.opencms.ade.configuration.formatters.CmsSettingConfiguration;
import org.opencms.ade.configuration.formatters.CmsSharedSettingKey;
import org.opencms.ade.configuration.plugins.CmsTemplatePlugin;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.jsp.util.CmsFunctionRenderer;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.Messages;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsFlexFormatterBean;
import org.opencms.xml.containerpage.CmsFormatterBean;
import org.opencms.xml.containerpage.CmsFunctionFormatterBean;
import org.opencms.xml.containerpage.CmsMacroFormatterBean;
import org.opencms.xml.containerpage.CmsMetaMapping;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentRootLocation;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsFormatterBeanParser {
    public static final String N_ALLOWS_SETTINGS_IN_EDITOR = "AllowsSettingsInEditor";
    public static final String N_ATTRIBUTE = "Attribute";
    public static final String N_AUTO_ENABLED = "AutoEnabled";
    public static final String N_CHOICE_NEW_LINK = "ChoiceNewLink";
    public static final String N_CONTAINER_TYPE = "ContainerType";
    public static final String N_CSS_INLINE = "CssInline";
    public static final String N_CSS_LINK = "CssLink";
    public static final String N_DEFAULT = "Default";
    public static final String N_DEFAULT_CONTENT = "DefaultContent";
    public static final String N_DESCRIPTION = "Description";
    public static final String N_DETAIL = "Detail";
    public static final String N_DISPLAY = "Display";
    public static final String N_ELEMENT = "Element";
    public static final String N_FORMATTER = "Formatter";
    public static final String N_FORMATTERS = "Formatters";
    public static final String N_GROUP = "Group";
    public static final String N_HEAD_INCLUDE_CSS = "HeadIncludeCss";
    public static final String N_HEAD_INCLUDE_JS = "HeadIncludeJs";
    public static final String N_INCLUDE_SETTINGS = "IncludeSettings";
    public static final String N_JAVASCRIPT_INLINE = "JavascriptInline";
    public static final String N_JAVASCRIPT_LINK = "JavascriptLink";
    public static final String N_JSP = "Jsp";
    public static final String N_KEY = "Key";
    public static final String N_KEY_ALIAS = "KeyAlias";
    public static final String N_MACRO = "Macro";
    public static final String N_MACRO_NAME = "MacroName";
    public static final String N_MATCH = "Match";
    public static final String N_MAX_WIDTH = "MaxWidth";
    public static final String N_META_MAPPING = "MetaMapping";
    public static final String N_NESTED_FORMATTER_SETTINGS = "NestedFormatterSettings";
    public static final String N_NICE_NAME = "NiceName";
    public static final String N_ORDER = "Order";
    public static final String N_PARAMETER = "Parameter";
    public static final String N_PLACEHOLDER_MACRO = "PlaceholderMacro";
    public static final String N_PLACEHOLDER_STRING_TEMPLATE = "PlaceholderStringTemplate";
    public static final String N_PLUGIN = "Plugin";
    public static final String N_PREVIEW = "Preview";
    public static final String N_RANK = "Rank";
    public static final String N_SEARCH_CONTENT = "SearchContent";
    public static final String N_SETTING = "Setting";
    public static final String N_STRICT_CONTAINERS = "StrictContainers";
    public static final String N_STRING_TEMPLATE = "StringTemplate";
    public static final String N_TARGET = "Target";
    public static final String N_TYPE = "Type";
    public static final String N_TYPES = "Types";
    public static final String N_USE_META_MAPPINGS_FOR_NORMAL_ELEMENTS = "AlwaysApplyMetaMappings";
    public static final String N_VALUE = "Value";
    public static final String N_WIDTH = "Width";
    public static final String SETTING_DISPLAY_TYPE = "displayType";
    private static final Log LOG = CmsLog.getLog(CmsFormatterBeanParser.class);
    int m_width;
    private Map<CmsUUID, Map<CmsSharedSettingKey, CmsXmlContentProperty>> m_additionalSettingConfigs = new HashMap<CmsUUID, Map<CmsSharedSettingKey, CmsXmlContentProperty>>();
    private boolean m_autoEnabled;
    private CmsObject m_cms;
    private Set<String> m_containerTypes;
    private List<String> m_cssPaths = new ArrayList<String>();
    private boolean m_extractContent;
    private CmsResource m_formatterResource;
    private StringBuffer m_inlineCss = new StringBuffer();
    private StringBuffer m_inlineJs = new StringBuffer();
    private List<String> m_jsPaths = new ArrayList<String>();
    private String m_key;
    private int m_maxWidth;
    private String m_niceName;
    private boolean m_preview;
    private int m_rank;
    private Set<String> m_resourceType;
    private List<CmsXmlContentProperty> m_settingList = new ArrayList<CmsXmlContentProperty>();

    public CmsFormatterBeanParser(CmsObject cms, Map<CmsUUID, Map<CmsSharedSettingKey, CmsXmlContentProperty>> settingConfigs) {
        this.m_cms = cms;
        this.m_additionalSettingConfigs = settingConfigs;
    }

    public static String path(String ... components) {
        return CmsStringUtil.joinPaths(components);
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public I_CmsFormatterBean parse(CmsXmlContent content, String location, String id) throws CmsException, ParseException {
        CmsResource formatterRes;
        void var34_54;
        String key;
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(content.getFile());
        boolean isMacroFromatter = "macro_formatter".equals(type.getTypeName());
        boolean isFlexFormatter = "flex_formatter".equals(type.getTypeName());
        boolean isFunction = OpenCms.getResourceManager().matchResourceType("function_config", content.getFile().getTypeId());
        Locale en = Locale.ENGLISH;
        I_CmsXmlContentValue niceName = content.getValue(N_NICE_NAME, en);
        this.m_niceName = niceName != null ? niceName.getStringValue(this.m_cms) : null;
        CmsXmlContentRootLocation root = new CmsXmlContentRootLocation(content, en);
        I_CmsXmlContentValueLocation rankLoc = root.getSubValue(N_RANK);
        if (rankLoc != null) {
            int rank;
            String rankStr = rankLoc.getValue().getStringValue(this.m_cms);
            if (rankStr != null) {
                rankStr = rankStr.trim();
            }
            try {
                rank = Integer.parseInt(rankStr);
            }
            catch (NumberFormatException e) {
                rank = 1000;
                LOG.debug((Object)"Error parsing formatter rank.", (Throwable)e);
            }
            this.m_rank = rank;
        }
        this.m_resourceType = this.getStringSet(root, N_TYPE);
        this.parseSettings(root);
        List settingIncludes = content.getValues(N_INCLUDE_SETTINGS, en);
        settingIncludes = Lists.reverse(settingIncludes);
        ArrayList<CmsUUID> includeIds = new ArrayList<CmsUUID>();
        for (I_CmsXmlContentValue settingInclude : settingIncludes) {
            try {
                CmsXmlVfsFileValue includeFileVal = (CmsXmlVfsFileValue)settingInclude;
                CmsUUID includeSettingsId = includeFileVal.getLink(this.m_cms).getStructureId();
                includeIds.add(includeSettingsId);
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        String isDetailStr = this.getString(root, N_DETAIL, "false");
        boolean isDetail = Boolean.parseBoolean(isDetailStr);
        String displayType = this.getString(root, N_DISPLAY, null);
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(displayType) || "false".equals(displayType)) {
            displayType = null;
        }
        if ((key = this.getString(root, N_KEY, "").trim()).equals("")) {
            key = null;
        }
        HashSet<String> aliasKeys = new HashSet<String>();
        for (I_CmsXmlContentValueLocation aliasKeyLoc : root.getSubValues(N_KEY_ALIAS)) {
            String aliasKey = aliasKeyLoc.getValue().getStringValue(this.m_cms);
            if ((aliasKey = aliasKey.trim()).equals("")) continue;
            aliasKeys.add(aliasKey);
        }
        CmsSettingConfiguration settingConfig = new CmsSettingConfiguration(this.m_settingList, this.m_additionalSettingConfigs, includeIds, key, displayType);
        String isAllowSettingsStr = this.getString(root, N_ALLOWS_SETTINGS_IN_EDITOR, "false");
        boolean isAllowSettings = Boolean.parseBoolean(isAllowSettingsStr);
        String isStrictContainersStr = this.getString(root, N_STRICT_CONTAINERS, "false");
        boolean isStrictContainers = Boolean.parseBoolean(isStrictContainersStr);
        String description = this.getString(root, N_DESCRIPTION, null);
        String autoEnabled = this.getString(root, N_AUTO_ENABLED, "false");
        this.m_autoEnabled = Boolean.parseBoolean(autoEnabled);
        String nestedFormatterSettings = this.getString(root, N_NESTED_FORMATTER_SETTINGS, "false");
        boolean nestedFormatters = Boolean.parseBoolean(nestedFormatterSettings);
        String useMetaMappinsForNormalElementsStr = this.getString(root, N_USE_META_MAPPINGS_FOR_NORMAL_ELEMENTS, "false");
        boolean useMetaMappingsForNormalElements = Boolean.parseBoolean(useMetaMappinsForNormalElementsStr);
        List<CmsTemplatePlugin> plugins = CmsTemplatePlugin.parsePlugins(this.m_cms, root, N_PLUGIN);
        boolean strictMode = !isFunction;
        this.parseMatch(root, strictMode);
        this.m_key = key;
        List<CmsMetaMapping> mappings = this.parseMetaMappings(root);
        Map<String, String> attributes = this.parseAttributes(root);
        if (isMacroFromatter || isFlexFormatter) {
            CmsXmlVfsFileValue defContentValue;
            CmsLink defContentLink;
            this.m_formatterResource = content.getFile();
            this.m_preview = false;
            this.m_extractContent = true;
            CmsResource defContentRes = null;
            I_CmsXmlContentValueLocation defContentLoc = root.getSubValue(N_DEFAULT_CONTENT);
            if (defContentLoc != null && (defContentLink = (defContentValue = (CmsXmlVfsFileValue)defContentLoc.getValue()).getLink(this.m_cms)) != null) {
                CmsUUID defContentID = defContentLink.getStructureId();
                defContentRes = this.m_cms.readResource(defContentID);
            }
            if (isMacroFromatter) {
                String macroInput = this.getString(root, N_MACRO, "");
                String placeholderMacroInput = this.getString(root, N_PLACEHOLDER_MACRO, "");
                Map<String, CmsUUID> referencedFormatters = this.readReferencedFormatters(content);
                CmsMacroFormatterBean cmsMacroFormatterBean = new CmsMacroFormatterBean(this.m_containerTypes, this.m_formatterResource.getRootPath(), this.m_formatterResource.getStructureId(), this.m_width, this.m_maxWidth, this.m_extractContent, location, this.m_niceName, description, this.m_resourceType, this.m_rank, id, defContentRes != null ? defContentRes.getRootPath() : null, defContentRes != null ? defContentRes.getStructureId() : null, settingConfig, this.m_autoEnabled, isDetail, displayType, isAllowSettings, macroInput, placeholderMacroInput, referencedFormatters, this.m_cms.getRequestContext().getCurrentProject().isOnlineProject(), mappings, useMetaMappingsForNormalElements);
                return var34_54;
            }
            String stringTemplate = this.getString(root, N_STRING_TEMPLATE, "");
            String placeholder = this.getString(root, N_PLACEHOLDER_STRING_TEMPLATE, "");
            CmsFlexFormatterBean cmsFlexFormatterBean = new CmsFlexFormatterBean(this.m_containerTypes, this.m_formatterResource.getRootPath(), this.m_formatterResource.getStructureId(), this.m_key, this.m_width, this.m_maxWidth, this.m_extractContent, location, this.m_niceName, description, this.m_resourceType, this.m_rank, id, defContentRes != null ? defContentRes.getRootPath() : null, defContentRes != null ? defContentRes.getStructureId() : null, settingConfig, this.m_autoEnabled, isDetail, displayType, isAllowSettings, stringTemplate, placeholder, mappings, useMetaMappingsForNormalElements);
            return var34_54;
        }
        I_CmsXmlContentValueLocation jspLoc = root.getSubValue(N_JSP);
        CmsXmlVfsFileValue jspValue = (CmsXmlVfsFileValue)jspLoc.getValue();
        CmsLink link = jspValue.getLink(this.m_cms);
        CmsUUID jspID = null;
        if (link == null) {
            if (!isFunction) {
                LOG.info((Object)("JSP link is null in formatter configuration: " + content.getFile().getRootPath()));
                return null;
            }
            CmsResource defaultFormatter = CmsFunctionRenderer.getDefaultFunctionJsp(this.m_cms);
            jspID = defaultFormatter.getStructureId();
        } else {
            jspID = link.getStructureId();
        }
        if (jspID == null) {
            throw new CmsConfigurationException(Messages.get().container("ERR_READ_FORMATTER_CONFIG_4", new Object[]{link != null ? link.getUri() : " ??? ", this.m_niceName, location, "" + this.m_resourceType}));
        }
        this.m_formatterResource = formatterRes = this.m_cms.readResource(jspID);
        String previewStr = this.getString(root, N_PREVIEW, "false");
        this.m_preview = Boolean.parseBoolean(previewStr);
        String searchableStr = this.getString(root, N_SEARCH_CONTENT, "true");
        this.m_extractContent = Boolean.parseBoolean(searchableStr);
        this.parseHeadIncludes(root);
        if (isFunction) {
            CmsResource functionFormatter = this.m_cms.readResource("/system/modules/org.opencms.base/formatters/function.jsp");
            Map<String, String[]> rparams = this.parseParams(root);
            CmsFunctionFormatterBean cmsFunctionFormatterBean = new CmsFunctionFormatterBean(this.m_containerTypes, this.m_formatterResource.getRootPath(), this.m_formatterResource.getStructureId(), this.m_key, aliasKeys, functionFormatter.getStructureId(), this.m_width, this.m_maxWidth, location, this.m_cssPaths, this.m_inlineCss.toString(), this.m_jsPaths, this.m_inlineJs.toString(), plugins, this.m_niceName, description, id, settingConfig, isAllowSettings, isStrictContainers, rparams);
            return var34_54;
        }
        CmsFormatterBean cmsFormatterBean = new CmsFormatterBean(this.m_containerTypes, this.m_formatterResource.getRootPath(), this.m_formatterResource.getStructureId(), this.m_key, aliasKeys, this.m_width, this.m_maxWidth, this.m_preview, this.m_extractContent, location, this.m_cssPaths, this.m_inlineCss.toString(), this.m_jsPaths, this.m_inlineJs.toString(), plugins, this.m_niceName, description, this.m_resourceType, this.m_rank, id, settingConfig, true, this.m_autoEnabled, isDetail, displayType, isAllowSettings, isStrictContainers, nestedFormatters, mappings, attributes, useMetaMappingsForNormalElements);
        return var34_54;
    }

    private String getString(I_CmsXmlContentLocation val, String path, String defaultValue) {
        I_CmsXmlContentValueLocation subVal;
        if (val != null && (subVal = val.getSubValue(path)) != null && subVal.getValue() != null) {
            return subVal.getValue().getStringValue(this.m_cms);
        }
        return defaultValue;
    }

    private Set<String> getStringSet(I_CmsXmlContentLocation val, String path) {
        HashSet<String> valueSet = new HashSet<String>();
        if (val != null) {
            List<I_CmsXmlContentValueLocation> singleValueLocs = val.getSubValues(path);
            for (I_CmsXmlContentValueLocation singleValueLoc : singleValueLocs) {
                String value = singleValueLoc.getValue().getStringValue(this.m_cms).trim();
                valueSet.add(value);
            }
        }
        return valueSet;
    }

    private Map<String, String> parseAttributes(I_CmsXmlContentLocation formatterLoc) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (I_CmsXmlContentValueLocation mappingLoc : formatterLoc.getSubValues(N_ATTRIBUTE)) {
            String key = CmsConfigurationReader.getString(this.m_cms, mappingLoc.getSubValue(N_KEY));
            String value = CmsConfigurationReader.getString(this.m_cms, mappingLoc.getSubValue(N_VALUE));
            result.put(key, value);
        }
        return Collections.unmodifiableMap(result);
    }

    private void parseHeadIncludes(I_CmsXmlContentLocation formatterLoc) {
        I_CmsXmlContentValueLocation headIncludeJs;
        I_CmsXmlContentValueLocation headIncludeCss = formatterLoc.getSubValue(N_HEAD_INCLUDE_CSS);
        if (headIncludeCss != null) {
            for (I_CmsXmlContentValueLocation inlineCssLoc : headIncludeCss.getSubValues(N_CSS_INLINE)) {
                String inlineCss = inlineCssLoc.getValue().getStringValue(this.m_cms);
                this.m_inlineCss.append(inlineCss);
            }
            for (I_CmsXmlContentValueLocation cssLinkLoc : headIncludeCss.getSubValues(N_CSS_LINK)) {
                CmsXmlVarLinkValue fileValue = (CmsXmlVarLinkValue)cssLinkLoc.getValue();
                CmsLink link = fileValue.getLink(this.m_cms);
                if (link == null) continue;
                String cssPath = link.getTargetWithQuery();
                this.m_cssPaths.add(cssPath);
            }
        }
        if ((headIncludeJs = formatterLoc.getSubValue(N_HEAD_INCLUDE_JS)) != null) {
            for (I_CmsXmlContentValueLocation inlineJsLoc : headIncludeJs.getSubValues(N_JAVASCRIPT_INLINE)) {
                String inlineJs = inlineJsLoc.getValue().getStringValue(this.m_cms);
                this.m_inlineJs.append(inlineJs);
            }
            for (I_CmsXmlContentValueLocation jsLinkLoc : headIncludeJs.getSubValues(N_JAVASCRIPT_LINK)) {
                CmsXmlVarLinkValue fileValue = (CmsXmlVarLinkValue)jsLinkLoc.getValue();
                CmsLink link = fileValue.getLink(this.m_cms);
                if (link == null) continue;
                String jsPath = link.getTargetWithQuery();
                this.m_jsPaths.add(jsPath);
            }
        }
    }

    private void parseMatch(I_CmsXmlContentLocation linkFormatterLoc, boolean strict) throws ParseException {
        HashSet<String> containerTypes = new HashSet<String>();
        I_CmsXmlContentValueLocation typesLoc = linkFormatterLoc.getSubValue(CmsFormatterBeanParser.path(N_MATCH, N_TYPES));
        I_CmsXmlContentValueLocation widthLoc = linkFormatterLoc.getSubValue(CmsFormatterBeanParser.path(N_MATCH, N_WIDTH));
        if (typesLoc != null) {
            List<I_CmsXmlContentValueLocation> singleTypeLocs = typesLoc.getSubValues(N_CONTAINER_TYPE);
            for (I_CmsXmlContentValueLocation singleTypeLoc : singleTypeLocs) {
                String containerType = singleTypeLoc.getValue().getStringValue(this.m_cms).trim();
                containerTypes.add(containerType);
            }
            this.m_containerTypes = containerTypes;
        } else if (widthLoc != null) {
            String widthStr = this.getString(widthLoc, N_WIDTH, null);
            String maxWidthStr = this.getString(widthLoc, N_MAX_WIDTH, null);
            try {
                this.m_width = Integer.parseInt(widthStr);
            }
            catch (Exception e) {
                throw new ParseException("Invalid container width: [" + widthStr + "]", e);
            }
            try {
                this.m_maxWidth = Integer.parseInt(maxWidthStr);
            }
            catch (Exception e) {
                this.m_maxWidth = Integer.MAX_VALUE;
                LOG.debug((Object)maxWidthStr, (Throwable)e);
            }
        } else {
            if (strict) {
                throw new ParseException("Neither container types nor container widths defined!");
            }
            this.m_width = -1;
            this.m_maxWidth = Integer.MAX_VALUE;
        }
    }

    private List<CmsMetaMapping> parseMetaMappings(I_CmsXmlContentLocation formatterLoc) {
        ArrayList<CmsMetaMapping> mappings = new ArrayList<CmsMetaMapping>();
        for (I_CmsXmlContentValueLocation mappingLoc : formatterLoc.getSubValues(N_META_MAPPING)) {
            String key = CmsConfigurationReader.getString(this.m_cms, mappingLoc.getSubValue(N_KEY));
            String element = CmsConfigurationReader.getString(this.m_cms, mappingLoc.getSubValue(N_ELEMENT));
            String defaultValue = CmsConfigurationReader.getString(this.m_cms, mappingLoc.getSubValue(N_DEFAULT));
            String orderStr = CmsConfigurationReader.getString(this.m_cms, mappingLoc.getSubValue(N_ORDER));
            int order = 1000;
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(orderStr)) {
                try {
                    order = Integer.parseInt(orderStr);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            CmsMetaMapping mapping = new CmsMetaMapping(key, element, order, defaultValue);
            mappings.add(mapping);
        }
        return mappings;
    }

    private Map<String, String[]> parseParams(I_CmsXmlContentLocation root) {
        ArrayListMultimap mmap = ArrayListMultimap.create();
        for (I_CmsXmlContentLocation i_CmsXmlContentLocation : root.getSubValues(N_PARAMETER)) {
            String key = i_CmsXmlContentLocation.getSubValue(N_KEY).getValue().getStringValue(this.m_cms);
            String value = i_CmsXmlContentLocation.getSubValue(N_VALUE).getValue().getStringValue(this.m_cms);
            mmap.put((Object)key, (Object)value);
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>();
        String[] stringArray = new String[]{};
        for (String key : mmap.keySet()) {
            List values = mmap.get((Object)key);
            String[] valuesArray = values.toArray(stringArray);
            result.put(key, valuesArray);
        }
        return result;
    }

    private void parseSettings(I_CmsXmlContentLocation formatterLoc) {
        for (I_CmsXmlContentValueLocation settingLoc : formatterLoc.getSubValues(N_SETTING)) {
            CmsPropertyConfig propConfig = CmsConfigurationReader.parseProperty(this.m_cms, settingLoc);
            CmsXmlContentProperty property = propConfig.getPropertyData();
            this.m_settingList.add(property);
        }
    }

    private Map<String, CmsUUID> readReferencedFormatters(CmsXmlContent xmlContent) {
        LinkedHashMap<String, CmsUUID> result = new LinkedHashMap<String, CmsUUID>();
        List<I_CmsXmlContentValue> formatters = xmlContent.getValues(N_FORMATTERS, CmsLocaleManager.MASTER_LOCALE);
        for (I_CmsXmlContentValue formatterValue : formatters) {
            CmsXmlVfsFileValue file = (CmsXmlVfsFileValue)xmlContent.getValue(formatterValue.getPath() + "/" + N_FORMATTER, CmsLocaleManager.MASTER_LOCALE);
            CmsUUID formatterId = file.getLink(this.m_cms).getStructureId();
            String macroName = xmlContent.getStringValue(this.m_cms, formatterValue.getPath() + "/" + N_MACRO_NAME, CmsLocaleManager.MASTER_LOCALE);
            result.put(macroName, formatterId);
        }
        return result;
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }

        public ParseException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

