/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.configuration.plugins;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.apache.commons.logging.Log;
import org.opencms.file.CmsObject;
import org.opencms.main.CmsLog;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsLinkInfo;
import org.opencms.xml.content.I_CmsXmlContentLocation;
import org.opencms.xml.content.I_CmsXmlContentValueLocation;
import org.opencms.xml.types.CmsXmlVarLinkValue;

public class CmsTemplatePlugin {
    public static final String N_ATTRIBUTE = "Attribute";
    public static final String N_GROUP = "Group";
    public static final String N_KEY = "Key";
    public static final String N_ORDER = "Order";
    public static final String N_TARGET = "Target";
    public static final String N_VALUE = "Value";
    private static final Log LOG = CmsLog.getLog(CmsTemplatePlugin.class);
    private Map<String, String> m_attributes;
    private String m_group;
    private int m_order;
    private String m_origin;
    private CmsLinkInfo m_target;

    public CmsTemplatePlugin(CmsLinkInfo target, String group, int order, String origin, Map<String, String> attributes) {
        this.m_target = target;
        this.m_group = group;
        this.m_order = order;
        this.m_origin = origin;
        this.m_attributes = Collections.unmodifiableMap(attributes);
    }

    public static List<CmsTemplatePlugin> parsePlugins(CmsObject cms, I_CmsXmlContentLocation parent, String subName) {
        ArrayList<CmsTemplatePlugin> result = new ArrayList<CmsTemplatePlugin>();
        for (I_CmsXmlContentValueLocation pluginLoc : parent.getSubValues(subName)) {
            try {
                CmsTemplatePlugin plugin = CmsTemplatePlugin.parsePlugin(cms, pluginLoc);
                if (plugin == null) continue;
                result.add(plugin);
            }
            catch (Exception e) {
                LOG.error((Object)("Error reading plugin in " + parent.getDocument().getFile().getRootPath() + ": " + e.getLocalizedMessage()), (Throwable)e);
            }
        }
        return result;
    }

    private static CmsTemplatePlugin parsePlugin(CmsObject cms, I_CmsXmlContentValueLocation pluginLocation) {
        String groupStr = pluginLocation.getSubValue(N_GROUP).getValue().getStringValue(cms).trim();
        String origin = pluginLocation.getValue().getDocument().getFile().getRootPath();
        I_CmsXmlContentValueLocation orderLoc = pluginLocation.getSubValue(N_ORDER);
        int order = 0;
        if (orderLoc != null) {
            order = Integer.parseInt(orderLoc.getValue().getStringValue(cms).trim());
        }
        CmsXmlVarLinkValue target = (CmsXmlVarLinkValue)pluginLocation.getSubValue(N_TARGET).getValue();
        CmsLink link = target.getLink(cms);
        HashMap<String, String> attributes = new HashMap<String, String>();
        for (I_CmsXmlContentValueLocation attrLoc : pluginLocation.getSubValues(N_ATTRIBUTE)) {
            String key = attrLoc.getSubValue(N_KEY).getValue().getStringValue(cms);
            String value = attrLoc.getSubValue(N_VALUE).getValue().getStringValue(cms);
            attributes.put(key, value);
        }
        CmsTemplatePlugin plugin = new CmsTemplatePlugin(link != null ? link.toLinkInfo() : CmsLinkInfo.EMPTY, groupStr, order, origin, Collections.unmodifiableMap(attributes));
        return plugin;
    }

    public Map<String, String> getAttributes() {
        return Collections.unmodifiableMap(this.m_attributes);
    }

    public String getGroup() {
        return this.m_group;
    }

    public int getOrder() {
        return this.m_order;
    }

    public String getOrigin() {
        return this.m_origin;
    }

    public CmsLinkInfo getTarget() {
        return this.m_target;
    }

    public String toString() {
        return ReflectionToStringBuilder.toString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }
}

