/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.containerpage;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.xml.containerpage.CmsContainerBean;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.CmsContainerPageBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;

public class CmsDetailOnlyContainerPageBuilder {
    private CmsObject m_cms;
    private CmsADEConfigData m_config;
    private TreeMap<String, ContainerInfo> m_containerInfos = Maps.newTreeMap();

    public CmsDetailOnlyContainerPageBuilder(CmsObject cms, CmsADEConfigData config) {
        this.m_cms = cms;
        this.m_config = config;
    }

    public void addContainerElement(String name, CmsResource resource) {
        this.getContainerInfo(name).getResources().add(resource);
    }

    public CmsContainerPageBean build() {
        ArrayList containers = Lists.newArrayList();
        for (String containerName : this.m_containerInfos.keySet()) {
            CmsContainerBean containerBean = this.buildContainerBean(this.m_containerInfos.get(containerName));
            containers.add(containerBean);
        }
        return new CmsContainerPageBean(containers);
    }

    public void setContainerType(String name, String type) {
        this.getContainerInfo(name).setType(type);
    }

    public void setContainerWidth(String name, String width) {
        this.getContainerInfo(name).setWidth(width);
    }

    private CmsContainerBean buildContainerBean(ContainerInfo cnt) {
        ArrayList elements = Lists.newArrayList();
        for (CmsResource resource : cnt.getResources()) {
            CmsContainerElementBean elementBean = this.buildContainerElementBean(cnt, resource);
            elements.add(elementBean);
        }
        CmsContainerBean result = new CmsContainerBean(cnt.getName(), cnt.getType(), null, true, elements);
        return result;
    }

    private CmsContainerElementBean buildContainerElementBean(ContainerInfo cnt, CmsResource resource) {
        I_CmsFormatterBean formatter = this.m_config.getFormatters(this.m_cms, resource).getDefaultFormatter(cnt.getEffectiveType(), cnt.getEffectiveWidth());
        CmsUUID formatterId = formatter.getJspStructureId();
        CmsContainerElementBean elementBean = new CmsContainerElementBean(resource.getStructureId(), formatterId, new HashMap<String, String>(), false);
        return elementBean;
    }

    private ContainerInfo getContainerInfo(String name) {
        if (!this.m_containerInfos.containsKey(name)) {
            this.m_containerInfos.put(name, new ContainerInfo(name));
        }
        return this.m_containerInfos.get(name);
    }

    public static class ContainerInfo {
        private List<CmsResource> m_elements = Lists.newArrayList();
        private String m_name;
        private String m_type;
        private String m_width;

        public ContainerInfo(String name) {
            this.m_name = name;
        }

        public void addResource(CmsResource resource) {
            this.m_elements.add(resource);
        }

        public String getEffectiveType() {
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(this.m_type)) {
                return this.m_name;
            }
            return this.m_type;
        }

        public int getEffectiveWidth() {
            try {
                return Integer.parseInt(this.m_width);
            }
            catch (Exception e) {
                return -1;
            }
        }

        public String getName() {
            return this.m_name;
        }

        public List<CmsResource> getResources() {
            return this.m_elements;
        }

        public String getType() {
            return this.m_type;
        }

        public String getWidth() {
            return this.m_width;
        }

        public void setType(String type) {
            this.m_type = type;
        }

        public void setWidth(String width) {
            this.m_width = width;
        }
    }
}

