/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.opencms.ade.contenteditor.CmsWidgetUtil;
import org.opencms.file.CmsGroup;
import org.opencms.file.CmsObject;
import org.opencms.json.JSONObject;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.security.CmsRole;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.types.CmsXmlAccessRestrictionValue;
import org.opencms.xml.types.CmsXmlNestedContentDefinition;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsAccessRestrictionInfo {
    public static final CmsRole ROLE_CAN_IGNORE_GROUP = CmsRole.ROOT_ADMIN;
    private static final Log LOG = CmsLog.getLog(CmsAccessRestrictionInfo.class);
    private CmsGroup m_group;
    private String m_path;

    public CmsAccessRestrictionInfo(String path, CmsGroup group) {
        this.m_path = path;
        this.m_group = group;
    }

    public static void collectTypesByPath(CmsXmlContentDefinition definition, String path, Map<String, I_CmsXmlSchemaType> typesByPath) {
        for (I_CmsXmlSchemaType schemaType : definition.getTypeSequence()) {
            CmsXmlContentDefinition nestedDef;
            String name = schemaType.getName();
            String subPath = path + "/" + name;
            typesByPath.put(CmsFileUtil.removeLeadingSeparator(subPath), schemaType);
            if (!(schemaType instanceof CmsXmlNestedContentDefinition) || (nestedDef = ((CmsXmlNestedContentDefinition)schemaType).getNestedContentDefinition()) == null) continue;
            CmsAccessRestrictionInfo.collectTypesByPath(nestedDef, subPath, typesByPath);
        }
    }

    public static CmsAccessRestrictionInfo getRestrictionInfo(CmsObject cms, CmsXmlContentDefinition contentDef) {
        HashMap<String, I_CmsXmlSchemaType> typesByPath = new HashMap<String, I_CmsXmlSchemaType>();
        CmsAccessRestrictionInfo.collectTypesByPath(contentDef, "", typesByPath);
        for (Map.Entry entry : typesByPath.entrySet()) {
            I_CmsXmlSchemaType type = (I_CmsXmlSchemaType)entry.getValue();
            try {
                JSONObject json;
                String groupName;
                if (!(type instanceof CmsXmlAccessRestrictionValue)) continue;
                CmsWidgetUtil.WidgetInfo widgetInfo = CmsWidgetUtil.collectWidgetInfo(cms, contentDef, (String)entry.getKey(), null);
                String widgetConfig = widgetInfo.getWidget().getConfiguration();
                if (widgetConfig == null || CmsStringUtil.isEmptyOrWhitespaceOnly(groupName = (json = new JSONObject(widgetConfig)).optString("group"))) break;
                groupName = groupName.trim();
                if (OpenCms.getRoleManager().hasRole(cms, ROLE_CAN_IGNORE_GROUP) || cms.userInGroup(cms.getRequestContext().getCurrentUser().getName(), groupName)) {
                    return new CmsAccessRestrictionInfo((String)entry.getKey(), cms.readGroup(groupName));
                }
                break;
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public CmsGroup getGroup() {
        return this.m_group;
    }

    public String getPath() {
        return this.m_path;
    }
}

