/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import java.util.HashSet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.opencms.ade.contenteditor.CmsContentService;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsContentDefinition;
import org.opencms.ade.contenteditor.shared.CmsExternalWidgetConfiguration;
import org.opencms.ade.contenteditor.shared.rpc.I_CmsContentService;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.shared.CmsCoreData;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsContentEditorActionElement
extends CmsGwtActionElement {
    public static final String CMS_MODULE_NAME = "org.opencms.ade.contenteditor";
    public static final String GWT_MODULE_NAME = CmsCoreData.ModuleKey.contenteditor.name();

    public CmsContentEditorActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    @Override
    public String export() throws Exception {
        return "";
    }

    @Override
    public String exportAll() throws Exception {
        CmsRequestUtil.disableCrossSiteFrameEmbedding(this.getResponse());
        StringBuffer sb = new StringBuffer();
        sb.append(super.export());
        sb.append(this.exportModuleScriptTag(GWT_MODULE_NAME));
        sb.append(this.getPrefetch());
        return sb.toString();
    }

    private void addExternalResourceTags(StringBuffer sb, CmsContentDefinition definition) {
        HashSet<String> includedScripts = new HashSet<String>();
        HashSet<String> includedStyles = new HashSet<String>();
        for (CmsExternalWidgetConfiguration configuration : definition.getExternalWidgetConfigurations()) {
            for (String css : configuration.getCssResourceLinks()) {
                if (includedStyles.contains(css)) continue;
                sb.append("<link type=\"text/css\" rel=\"stylesheet\" href=\"").append(css).append("\"></link>");
                includedStyles.add(css);
            }
            for (String script : configuration.getJavaScriptResourceLinks()) {
                if (includedScripts.contains(script)) continue;
                sb.append("<script src=\"").append(script).append("\"></script>");
                includedScripts.add(script);
            }
        }
    }

    private String getPrefetch() throws Exception {
        long timer = 0L;
        if (CmsContentService.LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        CmsContentDefinition definition = CmsContentService.prefetch(this.getRequest());
        StringBuffer sb = new StringBuffer();
        String backlink = this.getRequest().getParameter("backlink");
        backlink = CmsStringUtil.isEmptyOrWhitespaceOnly(backlink) || !CmsRequestUtil.checkBacklink(backlink, this.getRequest()) ? CmsVaadinUtils.getWorkplaceLink() : this.link(backlink);
        sb.append(CmsContentEditorActionElement.wrapScript("backlink", "='", CmsStringUtil.escapeJavaScript(backlink) + "';\n"));
        String prefetchedData = CmsContentEditorActionElement.exportDictionary("com_alkacon_acacia_shared_ContentDefinition", I_CmsContentService.class.getMethod("prefetch", new Class[0]), definition);
        sb.append(prefetchedData);
        this.addExternalResourceTags(sb, definition);
        if (CmsContentService.LOG.isDebugEnabled()) {
            CmsContentService.LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_PREFETCHING_TIME_FOR_RESOURCE_2", definition.getSitePath(), "" + (System.currentTimeMillis() - timer)));
        }
        return sb.toString();
    }
}

