/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.contenteditor;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Sets;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.dom4j.Element;
import org.dom4j.Node;
import org.opencms.acacia.shared.CmsAttributeConfiguration;
import org.opencms.acacia.shared.CmsEntity;
import org.opencms.acacia.shared.CmsEntityAttribute;
import org.opencms.acacia.shared.CmsEntityHtml;
import org.opencms.acacia.shared.CmsTabInfo;
import org.opencms.acacia.shared.CmsType;
import org.opencms.acacia.shared.CmsValidationResult;
import org.opencms.ade.configuration.CmsADEConfigData;
import org.opencms.ade.containerpage.CmsContainerpageService;
import org.opencms.ade.containerpage.CmsElementUtil;
import org.opencms.ade.containerpage.shared.CmsContainer;
import org.opencms.ade.contenteditor.CmsAccessRestrictionInfo;
import org.opencms.ade.contenteditor.CmsContentTypeVisitor;
import org.opencms.ade.contenteditor.CmsDynamicCategoryFieldList;
import org.opencms.ade.contenteditor.CmsWidgetUtil;
import org.opencms.ade.contenteditor.Messages;
import org.opencms.ade.contenteditor.shared.CmsContentDefinition;
import org.opencms.ade.contenteditor.shared.CmsEditHandlerData;
import org.opencms.ade.contenteditor.shared.CmsSaveResult;
import org.opencms.ade.contenteditor.shared.rpc.I_CmsContentService;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.collectors.A_CmsResourceCollector;
import org.opencms.file.types.CmsResourceTypeXmlContent;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.flex.CmsFlexController;
import org.opencms.gwt.CmsGwtService;
import org.opencms.gwt.CmsIconUtil;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.shared.CmsModelResourceInfo;
import org.opencms.i18n.CmsEncoder;
import org.opencms.i18n.CmsLocaleManager;
import org.opencms.i18n.CmsMessages;
import org.opencms.json.JSONObject;
import org.opencms.jsp.CmsJspTagEdit;
import org.opencms.main.CmsException;
import org.opencms.main.CmsLog;
import org.opencms.main.CmsRuntimeException;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;
import org.opencms.search.galleries.CmsGallerySearch;
import org.opencms.search.galleries.CmsGallerySearchResult;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.util.CmsFileUtil;
import org.opencms.util.CmsPair;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;
import org.opencms.widgets.CmsCalendarWidget;
import org.opencms.widgets.CmsCategoryWidget;
import org.opencms.widgets.CmsCheckboxWidget;
import org.opencms.widgets.CmsComboWidget;
import org.opencms.widgets.CmsGroupWidget;
import org.opencms.widgets.CmsInputWidget;
import org.opencms.widgets.CmsMultiSelectWidget;
import org.opencms.widgets.CmsRadioSelectWidget;
import org.opencms.widgets.CmsSelectComboWidget;
import org.opencms.widgets.CmsSelectWidget;
import org.opencms.widgets.CmsVfsFileWidget;
import org.opencms.widgets.I_CmsADEWidget;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.workplace.CmsWorkplaceMessages;
import org.opencms.workplace.editors.CmsXmlContentEditor;
import org.opencms.workplace.editors.directedit.I_CmsEditHandler;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.CmsXmlUtils;
import org.opencms.xml.I_CmsXmlDocument;
import org.opencms.xml.containerpage.CmsADESessionCache;
import org.opencms.xml.containerpage.CmsContainerElementBean;
import org.opencms.xml.containerpage.I_CmsFormatterBean;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentErrorHandler;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.CmsXmlContentProperty;
import org.opencms.xml.content.CmsXmlContentPropertyHelper;
import org.opencms.xml.content.I_CmsXmlContentEditorChangeHandler;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.I_CmsXmlContentValue;
import org.opencms.xml.types.I_CmsXmlSchemaType;

public class CmsContentService
extends CmsGwtService
implements I_CmsContentService {
    public static final String ATTR_EDITOR_SAVING = "__EDITOR_SAVING";
    protected static final Log LOG = CmsLog.getLog(CmsContentService.class);
    static final String TYPE_NAME_PREFIX = "http://opencms.org/types/";
    private static final String RDFA_ATTRIBUTES = "data-oc-id=\"%1$s\" data-oc-field=\"%2$s\"";
    private static final long serialVersionUID = 7873052619331296648L;
    private static final String SETTING_TYPE_NAME = "###SETTING_TYPE###";
    private static final String SETTINGS_ATTRIBUTE_NAME_PREFIX = "SETTING:::";
    private static final String SETTINGS_CLIENT_ID_ATTRIBUTE = "/SETTING:::CLIENT_ID:::";
    private static final String SETTINGS_RULE_TYPE_ERROR = "error";
    private static final Map<String, Class<? extends I_CmsADEWidget>> WIDGET_MAPPINGS = new HashMap<String, Class<? extends I_CmsADEWidget>>();
    private CmsADESessionCache m_sessionCache;
    private Locale m_workplaceLocale;

    public static String defaultCreateResourceToEdit(CmsObject cms, String newLink, Locale locale, String referenceSitePath, String modelFileSitePath, String mode, String postCreateHandler) throws CmsException {
        String newFileName = newLink.startsWith("__edit__") ? CmsJspTagEdit.createResource(cms, newLink, locale, referenceSitePath, modelFileSitePath, mode, postCreateHandler) : A_CmsResourceCollector.createResourceForCollector(cms, newLink, locale, referenceSitePath, modelFileSitePath, mode, postCreateHandler);
        return newFileName;
    }

    public static String getAttributeName(I_CmsXmlContentValue contentValue) {
        return CmsContentService.getTypeUri(contentValue.getContentDefinition()) + "/" + contentValue.getName();
    }

    public static String getAttributeName(String elementName, String parentType) {
        return parentType + "/" + elementName;
    }

    public static String getEntityId(I_CmsXmlContentValue contentValue) {
        String result = CmsContentDefinition.uuidToEntityId(contentValue.getDocument().getFile().getStructureId(), contentValue.getLocale().toString());
        String valuePath = contentValue.getPath();
        if (valuePath.contains("/")) {
            result = result + "/" + valuePath.substring(0, valuePath.lastIndexOf("/"));
        }
        if (contentValue.isChoiceOption()) {
            result = result + "/ATTRIBUTE_CHOICE_" + contentValue.getName() + "[" + contentValue.getXmlIndex() + "]";
        }
        return result;
    }

    public static String getRdfaAttributes(I_CmsXmlContentValue value) {
        String path = "";
        String elementPath = value.getPath();
        if (elementPath.contains("/")) {
            path = path + "/" + CmsContentService.removePathIndexes(elementPath.substring(0, elementPath.lastIndexOf("/")) + ":");
        }
        path = path + CmsContentService.getAttributeName(value);
        return String.format(RDFA_ATTRIBUTES, CmsContentService.getEntityId(value), path);
    }

    public static String getRdfaAttributes(I_CmsXmlContentValue parentValue, String childNames) {
        String id = CmsContentDefinition.uuidToEntityId(parentValue.getDocument().getFile().getStructureId(), parentValue.getLocale().toString()) + "/" + parentValue.getPath();
        String path = "";
        String[] children = childNames.split("\\|");
        for (int i = 0; i < children.length; ++i) {
            I_CmsXmlSchemaType schemaType = parentValue.getContentDefinition().getSchemaType(parentValue.getName() + "/" + children[i]);
            if (schemaType == null) continue;
            if (i > 0) {
                path = path + " ";
            }
            String typePath = parentValue.getPath();
            path = path + "/" + CmsContentService.removePathIndexes(typePath) + ":";
            path = path + CmsContentService.getTypeUri(schemaType.getContentDefinition()) + "/" + children[i];
        }
        return String.format(RDFA_ATTRIBUTES, id, path);
    }

    public static String getRdfaAttributes(I_CmsXmlDocument document, Locale contentLocale, String elementPath) {
        I_CmsXmlSchemaType schemaType = document.getContentDefinition().getSchemaType(elementPath);
        if (schemaType != null) {
            String path = "";
            if (elementPath.contains("/")) {
                path = path + "/" + CmsContentService.removePathIndexes(elementPath.substring(0, elementPath.lastIndexOf("/")) + ":");
            }
            path = path + CmsContentService.getTypeUri(schemaType.getContentDefinition()) + "/" + elementPath;
            return String.format(RDFA_ATTRIBUTES, CmsContentDefinition.uuidToEntityId(document.getFile().getStructureId(), contentLocale.toString()), path);
        }
        return "";
    }

    public static String getTypeUri(CmsXmlContentDefinition xmlContentDefinition) {
        return xmlContentDefinition.getSchemaLocation() + "/" + xmlContentDefinition.getTypeName();
    }

    public static CmsContentDefinition prefetch(HttpServletRequest request) throws CmsRpcException {
        CmsContentService srv = new CmsContentService();
        srv.setCms(CmsFlexController.getCmsObject((ServletRequest)request));
        srv.setRequest(request);
        CmsContentDefinition result = null;
        try {
            result = srv.prefetch();
        }
        finally {
            srv.clearThreadStorage();
        }
        return result;
    }

    private static String removePathIndexes(String path) {
        return path.replaceAll("\\[.*\\]", "");
    }

    @Override
    public CmsContentDefinition callEditorChangeHandlers(String entityId, CmsEntity editedLocaleEntity, Collection<String> skipPaths, Collection<String> changedScopes) throws CmsRpcException {
        CmsContentDefinition result = null;
        CmsObject cms = this.getCmsObject();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        CmsUUID structureId = CmsContentDefinition.entityIdToUuid(editedLocaleEntity.getId());
        if (structureId != null) {
            CmsResource resource = null;
            Locale locale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            try {
                resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                this.ensureLock(resource);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = this.getContentDocument(file, true).clone();
                this.checkAutoCorrection(cms, content);
                this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, editedLocaleEntity);
                for (I_CmsXmlContentEditorChangeHandler handler : content.getContentDefinition().getContentHandler().getEditorChangeHandlers(false)) {
                    Set<String> handlerScopes = this.evaluateScope(handler.getScope(), content.getContentDefinition());
                    if (Collections.disjoint(changedScopes, handlerScopes)) continue;
                    handler.handleChange(cms, content, locale, changedScopes);
                }
                result = this.readContentDefinition(file, content, entityId, null, locale, false, null, editedLocaleEntity, Collections.emptyMap(), config);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return result;
    }

    @Override
    public void copyLocale(Collection<String> locales, CmsEntity sourceLocale) throws CmsRpcException {
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(sourceLocale.getId());
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsFile file = this.getCmsObject().readFile(resource);
            CmsXmlContent content = this.getSessionCache().getCacheXmlContent(structureId);
            this.synchronizeLocaleIndependentForEntity(file, content, Collections.emptyList(), sourceLocale);
            Locale sourceContentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(sourceLocale.getId()));
            for (String loc : locales) {
                Locale targetLocale = CmsLocaleManager.getLocale(loc);
                if (content.hasLocale(targetLocale)) {
                    content.removeLocale(targetLocale);
                }
                content.copyLocale(sourceContentLocale, targetLocale);
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
    }

    @Override
    public CmsObject getCmsObject() {
        CmsObject result = super.getCmsObject();
        result.getRequestContext().setRequestTime(Long.MIN_VALUE);
        return result;
    }

    @Override
    public CmsContentDefinition loadContentDefinition(String entityId) throws CmsRpcException {
        throw new CmsRpcException(new UnsupportedOperationException());
    }

    @Override
    public CmsContentDefinition loadDefinition(String entityId, String clientId, CmsEntity editedLocaleEntity, Collection<String> skipPaths, Map<String, String> settingPresets) throws CmsRpcException {
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), this.getCmsObject().getRequestContext().getRootUri());
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            CmsFile file = this.getCmsObject().readFile(resource);
            CmsXmlContent content = this.getContentDocument(file, true);
            if (editedLocaleEntity != null) {
                this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, editedLocaleEntity);
            }
            definition = this.readContentDefinition(file, content, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), clientId, contentLocale, false, null, editedLocaleEntity, settingPresets, config);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition loadInitialDefinition(String entityId, String clientId, String newLink, CmsUUID modelFileId, String editContext, String mainLocale, String mode, String postCreateHandler, CmsEditHandlerData editHandlerDataForNew, Map<String, String> settingPresets, String editorStylesheet) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        CmsContentDefinition result = null;
        this.getCmsObject().getRequestContext().setAttribute(CmsXmlContentEditor.ATTRIBUTE_EDITCONTEXT, editContext);
        if (editorStylesheet != null) {
            this.getCmsObject().getRequestContext().setAttribute("cms-editor-stylesheet", editorStylesheet);
        }
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            this.getSessionCache().clearDynamicValues();
            this.getSessionCache().uncacheXmlContent(structureId);
            if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(newLink)) {
                result = this.readContentDefinitionForNew(newLink, resource, modelFileId, contentLocale, mode, postCreateHandler, editHandlerDataForNew, settingPresets);
            } else {
                CmsFile file = this.getCmsObject().readFile(resource);
                CmsXmlContent content = this.getContentDocument(file, false);
                result = this.readContentDefinition(file, content, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), clientId, contentLocale, false, mainLocale != null ? CmsLocaleManager.getLocale(mainLocale) : null, null, settingPresets, config);
            }
        }
        catch (Throwable t) {
            this.error(t);
        }
        return result;
    }

    @Override
    public CmsContentDefinition loadNewDefinition(String entityId, String clientId, CmsEntity editedLocaleEntity, Collection<String> skipPaths, Map<String, String> settingPresets) throws CmsRpcException {
        CmsObject cms = this.getCmsObject();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        CmsContentDefinition definition = null;
        try {
            CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entityId);
            CmsResource resource = this.getCmsObject().readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
            Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
            CmsFile file = this.getCmsObject().readFile(resource);
            CmsXmlContent content = this.getContentDocument(file, true);
            this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, editedLocaleEntity);
            definition = this.readContentDefinition(file, content, CmsContentDefinition.uuidToEntityId(structureId, contentLocale.toString()), clientId, contentLocale, true, null, editedLocaleEntity, settingPresets, config);
        }
        catch (Exception e) {
            this.error(e);
        }
        return definition;
    }

    @Override
    public CmsContentDefinition prefetch() throws CmsRpcException {
        String paramResource = this.getRequest().getParameter("resource");
        String paramDirectEdit = this.getRequest().getParameter("directedit");
        boolean isDirectEdit = false;
        if (paramDirectEdit != null) {
            isDirectEdit = Boolean.parseBoolean(paramDirectEdit);
        }
        String paramNewLink = this.getRequest().getParameter("newlink");
        boolean createNew = false;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramNewLink)) {
            createNew = true;
            paramNewLink = this.decodeNewLink(paramNewLink);
        }
        String paramLocale = this.getRequest().getParameter("elementlanguage");
        Locale locale = null;
        CmsObject cms = this.getCmsObject();
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramResource)) {
            paramResource = CmsEncoder.decode(paramResource);
            try {
                CmsResource resource = cms.readResource(paramResource, CmsResourceFilter.IGNORE_EXPIRATION);
                if (OpenCms.getADEManager().isEditorRestricted(cms, resource)) {
                    throw new CmsRuntimeException(Messages.get().container("ERR_EDITOR_RESTRICTED_0"));
                }
                if (CmsResourceTypeXmlContent.isXmlContent(resource) || createNew) {
                    CmsContentDefinition result;
                    if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramLocale)) {
                        locale = CmsLocaleManager.getLocale(paramLocale);
                    }
                    this.getSessionCache().clearDynamicValues();
                    if (createNew) {
                        if (locale == null) {
                            locale = OpenCms.getLocaleManager().getDefaultLocale(cms, paramResource);
                        }
                        CmsUUID modelFileId = null;
                        String paramModelFile = this.getRequest().getParameter("modelfile");
                        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(paramModelFile)) {
                            modelFileId = cms.readResource(paramModelFile).getStructureId();
                        }
                        String mode = this.getRequest().getParameter("mode");
                        String postCreateHandler = this.getRequest().getParameter("postCreateHandler");
                        result = this.readContentDefinitionForNew(paramNewLink, resource, modelFileId, locale, mode, postCreateHandler, null, Collections.emptyMap());
                    } else {
                        CmsFile file = cms.readFile(resource);
                        CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                        this.getSessionCache().setCacheXmlContent(resource.getStructureId(), content);
                        if (locale == null) {
                            locale = OpenCms.getLocaleManager().getBestAvailableLocaleForXmlContent(this.getCmsObject(), resource, content);
                        }
                        result = this.readContentDefinition(file, content, null, null, locale, false, null, null, Collections.emptyMap(), null);
                    }
                    result.setDirectEdit(isDirectEdit);
                    return result;
                }
            }
            catch (Throwable e) {
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public CmsSaveResult saveAndDeleteEntities(CmsEntity lastEditedEntity, String clientId, List<String> deletedEntities, Collection<String> skipPaths, String lastEditedLocale, boolean clearOnSuccess) throws CmsRpcException {
        CmsUUID structureId = null;
        if (lastEditedEntity != null) {
            structureId = CmsContentDefinition.entityIdToUuid(lastEditedEntity.getId());
        }
        if (structureId == null && !deletedEntities.isEmpty()) {
            structureId = CmsContentDefinition.entityIdToUuid(deletedEntities.get(0));
        }
        CmsADEConfigData configData = OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), this.getCmsObject().getRequestContext().getRootUri());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            CmsResource resource = null;
            try {
                CmsAccessRestrictionInfo restrictionInfo;
                CmsContainerElementBean containerElement;
                I_CmsFormatterBean formatter;
                resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                this.ensureLock(resource);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = this.getContentDocument(file, true);
                this.checkAutoCorrection(cms, content);
                if (lastEditedEntity != null) {
                    this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, lastEditedEntity);
                }
                for (String deleteId : deletedEntities) {
                    Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(deleteId));
                    if (!content.hasLocale(contentLocale)) continue;
                    content.removeLocale(contentLocale);
                }
                CmsValidationResult validationResult = this.validateContent(cms, structureId, content);
                if (validationResult.hasErrors()) {
                    return new CmsSaveResult(false, validationResult);
                }
                boolean hasChangedSettings = false;
                if (clientId != null && lastEditedEntity != null && (formatter = this.getFormatterForElement(configData, containerElement = this.getSessionCache().getCacheContainerElement(clientId))) != null && formatter.isAllowsSettingsInEditor() && !formatter.getSettings(configData).isEmpty()) {
                    Locale locale = CmsLocaleManager.getLocale(lastEditedLocale);
                    Map<String, CmsXmlContentProperty> settingsConfig = OpenCms.getADEManager().getFormatterSettings(cms, configData, formatter, containerElement.getResource(), locale, (ServletRequest)this.getRequest());
                    this.validateSettings(lastEditedEntity, validationResult, settingsConfig);
                    if (validationResult.hasErrors()) {
                        return new CmsSaveResult(false, validationResult);
                    }
                    List<I_CmsFormatterBean> nestedFormatters = OpenCms.getADEManager().getNestedFormatters(cms, configData, containerElement.getResource(), locale, (ServletRequest)this.getRequest());
                    hasChangedSettings = this.saveSettings(lastEditedEntity, containerElement, settingsConfig, nestedFormatters);
                }
                if ((restrictionInfo = CmsAccessRestrictionInfo.getRestrictionInfo(cms, content.getContentDefinition())) != null) {
                    I_CmsXmlContentValue restrictionValue = content.getValue(restrictionInfo.getPath(), CmsLocaleManager.getLocale(lastEditedLocale));
                    boolean restricted = false;
                    if (restrictionValue != null) {
                        restricted = Boolean.parseBoolean(restrictionValue.getStringValue(cms));
                    }
                    cms.setRestricted(content.getFile(), restrictionInfo.getGroup().getName(), restricted);
                }
                this.writeCategories(file, content, lastEditedEntity);
                this.writeContent(cms, file, content, this.getFileEncoding(cms, file));
                OpenCms.getSearchManager().updateOfflineIndexes();
                if (clearOnSuccess) {
                    this.tryUnlock(resource);
                    this.getSessionCache().uncacheXmlContent(structureId);
                }
                return new CmsSaveResult(hasChangedSettings, null);
            }
            catch (Exception e) {
                if (resource != null) {
                    this.tryUnlock(resource);
                    this.getSessionCache().uncacheXmlContent(structureId);
                }
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public CmsValidationResult saveEntities(List<CmsEntity> entities) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CmsValidationResult saveEntity(CmsEntity entity) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String saveValue(String contentId, String contentPath, String localeString, String newValue) throws CmsRpcException {
        OpenCms.getLocaleManager();
        Locale locale = CmsLocaleManager.getLocale(localeString);
        try {
            CmsObject cms = this.getCmsObject();
            CmsResource element = cms.readResource(new CmsUUID(contentId), CmsResourceFilter.IGNORE_EXPIRATION);
            this.ensureLock(element);
            CmsFile elementFile = cms.readFile(element);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, elementFile);
            I_CmsXmlContentValue value = content.getValue(contentPath, locale);
            value.setStringValue(cms, newValue);
            for (I_CmsXmlContentEditorChangeHandler handler : content.getContentDefinition().getContentHandler().getEditorChangeHandlers(false)) {
                Set<String> handlerScopes = this.evaluateScope(handler.getScope(), content.getContentDefinition());
                if (!handlerScopes.contains(contentPath)) continue;
                handler.handleChange(cms, content, locale, Collections.singletonList(contentPath));
            }
            content.synchronizeLocaleIndependentValues(cms, Collections.emptyList(), locale);
            byte[] newData = content.marshal();
            elementFile.setContents(newData);
            cms.writeFile(elementFile);
            this.tryUnlock(elementFile);
            return "";
        }
        catch (Exception e) {
            this.error(e);
            return null;
        }
    }

    @Override
    public CmsEntityHtml updateEntityHtml(CmsEntity entity, String contextUri, String htmlContextInfo) throws Exception {
        CmsUUID structureId = CmsContentDefinition.entityIdToUuid(entity.getId());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            try {
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                String entityId = entity.getId();
                Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                if (content.hasLocale(contentLocale)) {
                    content.removeLocale(contentLocale);
                }
                content.addLocale(cms, contentLocale);
                this.addEntityAttributes(cms, content, "", entity, contentLocale);
                CmsValidationResult validationResult = this.validateContent(cms, structureId, content);
                String htmlContent = null;
                if (!validationResult.hasErrors()) {
                    file.setContents(content.marshal());
                    JSONObject contextInfo = new JSONObject(htmlContextInfo);
                    String containerName = contextInfo.getString("name");
                    String containerType = contextInfo.getString("type");
                    int containerWidth = contextInfo.getInt("width");
                    int maxElements = contextInfo.getInt("maxElements");
                    boolean detailView = contextInfo.getBoolean("isDetailView");
                    boolean isDetailViewContainer = contextInfo.getBoolean("isDetailViewContainer");
                    JSONObject presets = contextInfo.getJSONObject("presets");
                    HashMap<String, String> presetsMap = new HashMap<String, String>();
                    for (String key : presets.keySet()) {
                        String val = presets.getString(key);
                        presetsMap.put(key, val);
                    }
                    CmsContainer container = new CmsContainer(containerName, containerType, null, containerWidth, maxElements, isDetailViewContainer, detailView, true, Collections.emptyList(), null, null, presetsMap);
                    CmsUUID detailContentId = null;
                    if (contextInfo.has("detailElementId")) {
                        detailContentId = new CmsUUID(contextInfo.getString("detailElementId"));
                    }
                    CmsElementUtil elementUtil = new CmsElementUtil(cms, contextUri, detailContentId, this.getThreadLocalRequest(), this.getThreadLocalResponse(), contentLocale);
                    htmlContent = elementUtil.getContentByContainer(file, contextInfo.getString("elementId"), container);
                }
                return new CmsEntityHtml(htmlContent, validationResult);
            }
            catch (Exception e) {
                this.error(e);
            }
        }
        return null;
    }

    @Override
    public CmsValidationResult validateEntity(CmsEntity changedEntity) throws CmsRpcException {
        CmsUUID structureId = null;
        if (changedEntity == null) {
            return new CmsValidationResult(null, null);
        }
        structureId = CmsContentDefinition.entityIdToUuid(changedEntity.getId());
        if (structureId != null) {
            CmsObject cms = this.getCmsObject();
            CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
            HashSet setFieldNames = Sets.newHashSet();
            try {
                CmsResource resource = cms.readResource(structureId, CmsResourceFilter.IGNORE_EXPIRATION);
                CmsFile file = cms.readFile(resource);
                CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
                String entityId = changedEntity.getId();
                Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
                if (content.hasLocale(contentLocale)) {
                    content.removeLocale(contentLocale);
                }
                content.addLocale(cms, contentLocale);
                setFieldNames.addAll(this.addEntityAttributes(cms, content, "", changedEntity, contentLocale));
                CmsValidationResult result = this.validateContent(cms, structureId, content, setFieldNames);
                CmsEntityAttribute clientIdAttr = changedEntity.getAttribute(SETTINGS_CLIENT_ID_ATTRIBUTE);
                if (clientIdAttr != null) {
                    String clientId = clientIdAttr.getSimpleValue();
                    CmsContainerElementBean containerElement = this.getSessionCache().getCacheContainerElement(clientId);
                    I_CmsFormatterBean formatter = this.getFormatterForElement(config, containerElement);
                    if (formatter != null && formatter.isAllowsSettingsInEditor() && !formatter.getSettings(config).isEmpty()) {
                        Map<String, CmsXmlContentProperty> settingsConfig = OpenCms.getADEManager().getFormatterSettings(cms, config, formatter, containerElement.getResource(), contentLocale, (ServletRequest)this.getRequest());
                        this.validateSettings(changedEntity, result, settingsConfig);
                    }
                }
                return result;
            }
            catch (Throwable e) {
                this.error(e);
            }
        }
        return new CmsValidationResult(null, null);
    }

    protected String decodeNewLink(String newLink) {
        String result = newLink;
        if (result == null) {
            return null;
        }
        try {
            result = CmsEncoder.decode(result);
            try {
                result = CmsEncoder.decode(result);
            }
            catch (Throwable e) {
                LOG.info((Object)e.getLocalizedMessage(), e);
            }
        }
        catch (Throwable e) {
            LOG.info((Object)e.getLocalizedMessage(), e);
        }
        return result;
    }

    protected String getElementName(String attributeName) {
        if (attributeName.contains("/")) {
            return attributeName.substring(attributeName.lastIndexOf("/") + 1);
        }
        return attributeName;
    }

    protected String getFileEncoding(CmsObject cms, CmsResource file) {
        String result;
        try {
            result = cms.readPropertyObject(file, "content-encoding", true).getValue(OpenCms.getSystemInfo().getDefaultEncoding());
        }
        catch (CmsException e) {
            result = OpenCms.getSystemInfo().getDefaultEncoding();
        }
        return CmsEncoder.lookupEncoding(result, OpenCms.getSystemInfo().getDefaultEncoding());
    }

    protected CmsEntity readEntity(CmsXmlContent content, Element element, Locale locale, String entityId, String parentPath, String typeName, CmsContentTypeVisitor visitor, boolean includeInvisible, CmsEntity editedLocalEntity) {
        CmsEntity newEntity;
        String newEntityId = entityId + (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath) ? "/" + parentPath : "");
        CmsEntity result = newEntity = new CmsEntity(newEntityId, typeName);
        List elements = element.elements();
        CmsType type = visitor.getTypes().get(typeName);
        boolean isChoice = type.isChoice();
        String choiceTypeName = null;
        HashMap<String, Integer> attributeCounter = null;
        if (isChoice) {
            choiceTypeName = type.getAttributeTypeName("ATTRIBUTE_CHOICE");
            type = visitor.getTypes().get(type.getAttributeTypeName("ATTRIBUTE_CHOICE"));
            attributeCounter = new HashMap<String, Integer>();
        }
        int counter = 0;
        CmsObject cms = this.getCmsObject();
        String previousName = null;
        if (CmsStringUtil.isNotEmptyOrWhitespaceOnly(parentPath)) {
            parentPath = parentPath + "/";
        }
        for (Element child : elements) {
            I_CmsXmlContentValue value;
            String attributeName = CmsContentService.getAttributeName(child.getName(), typeName);
            String subTypeName = type.getAttributeTypeName(attributeName);
            if (visitor.getTypes().get(subTypeName) == null || !includeInvisible && !visitor.getAttributeConfigurations().get(attributeName).isVisible()) continue;
            if (isChoice && attributeCounter != null) {
                if (!attributeName.equals(previousName)) {
                    counter = attributeCounter.get(attributeName) != null ? (Integer)attributeCounter.get(attributeName) : 0;
                    previousName = attributeName;
                }
                attributeCounter.put(attributeName, counter + 1);
            } else if (!attributeName.equals(previousName)) {
                counter = 0;
                previousName = attributeName;
            }
            if (isChoice) {
                result = new CmsEntity(newEntityId + "/" + "ATTRIBUTE_CHOICE" + "_" + child.getName() + "[" + counter + "]", choiceTypeName);
                newEntity.addAttributeValue("ATTRIBUTE_CHOICE", result);
            }
            String path = parentPath + child.getName();
            if (visitor.isDynamicallyLoaded(attributeName)) {
                value = content.getValue(path, locale, counter);
                String attributeValue = this.getDynamicAttributeValue(content.getFile(), value, attributeName, editedLocalEntity);
                result.addAttributeValue(attributeName, attributeValue);
            } else if (visitor.getTypes().get(subTypeName).isSimpleType()) {
                value = content.getValue(path, locale, counter);
                result.addAttributeValue(attributeName, value.getStringValue(cms));
            } else {
                CmsEntity editedSubEntity = null;
                if (editedLocalEntity != null && editedLocalEntity.getAttribute(attributeName) != null) {
                    editedSubEntity = editedLocalEntity.getAttribute(attributeName).getComplexValue();
                }
                CmsEntity subEntity = this.readEntity(content, child, locale, entityId, path + "[" + (counter + 1) + "]", subTypeName, visitor, includeInvisible, editedSubEntity);
                result.addAttributeValue(attributeName, subEntity);
            }
            ++counter;
        }
        return newEntity;
    }

    protected Map<String, CmsType> readTypes(CmsXmlContentDefinition xmlContentDefinition, Locale locale) {
        CmsContentTypeVisitor visitor = new CmsContentTypeVisitor(this.getCmsObject(), null, locale);
        visitor.visitTypes(xmlContentDefinition, locale);
        return visitor.getTypes();
    }

    protected void synchronizeLocaleIndependentFields(CmsFile file, CmsXmlContent content, Collection<String> skipPaths, Collection<CmsEntity> entities, Locale lastEdited) throws CmsXmlException {
        CmsEntity lastEditedEntity = null;
        for (CmsEntity entity : entities) {
            if (lastEdited.equals(CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entity.getId())))) {
                lastEditedEntity = entity;
                continue;
            }
            this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, entity);
        }
        if (lastEditedEntity != null) {
            this.synchronizeLocaleIndependentForEntity(file, content, skipPaths, lastEditedEntity);
        }
    }

    protected void transferInvisibleValues(CmsEntity original, CmsEntity target, CmsContentTypeVisitor visitor) {
        ArrayList<String> invisibleAttributes = new ArrayList<String>();
        for (Map.Entry<String, CmsAttributeConfiguration> configEntry : visitor.getAttributeConfigurations().entrySet()) {
            if (configEntry.getValue().isVisible()) continue;
            invisibleAttributes.add(configEntry.getKey());
        }
        CmsContentDefinition.transferValues(original, target, invisibleAttributes, visitor.getTypes(), visitor.getAttributeConfigurations(), true);
    }

    private Set<String> addEntityAttributes(CmsObject cms, CmsXmlContent content, String parentPath, CmsEntity entity, Locale contentLocale) {
        HashSet fieldsSet = Sets.newHashSet();
        this.addEntityAttributes(cms, content, parentPath, entity, contentLocale, fieldsSet);
        return fieldsSet;
    }

    private void addEntityAttributes(CmsObject cms, CmsXmlContent content, String parentPath, CmsEntity entity, Locale contentLocale, Set<String> fieldsSet) {
        for (CmsEntityAttribute attribute : entity.getAttributes()) {
            I_CmsXmlContentValue field;
            int i;
            if (this.isSettingsAttribute(attribute.getAttributeName())) continue;
            if ("ATTRIBUTE_CHOICE".equals(attribute.getAttributeName())) {
                List<CmsEntity> choiceEntities = attribute.getComplexValues();
                for (int i2 = 0; i2 < choiceEntities.size(); ++i2) {
                    I_CmsXmlContentValue field2;
                    List<CmsEntityAttribute> choiceAttributes = choiceEntities.get(i2).getAttributes();
                    assert (choiceAttributes.size() == 1 && choiceAttributes.get(0).isSingleValue()) : "each choice entity may only have a single attribute with a single value";
                    CmsEntityAttribute choiceAttribute = choiceAttributes.get(0);
                    String elementPath = parentPath + this.getElementName(choiceAttribute.getAttributeName());
                    if (choiceAttribute.isSimpleValue()) {
                        String value = choiceAttribute.getSimpleValue();
                        field2 = content.getValue(elementPath, contentLocale, i2);
                        if (field2 == null) {
                            field2 = content.addValue(cms, elementPath, contentLocale, i2);
                        }
                        field2.setStringValue(cms, value);
                        fieldsSet.add(field2.getPath());
                        continue;
                    }
                    CmsEntity child = choiceAttribute.getComplexValue();
                    field2 = content.getValue(elementPath, contentLocale, i2);
                    if (field2 == null) {
                        field2 = content.addValue(cms, elementPath, contentLocale, i2);
                    }
                    this.addEntityAttributes(cms, content, field2.getPath() + "/", child, contentLocale, fieldsSet);
                }
                continue;
            }
            String elementPath = parentPath + this.getElementName(attribute.getAttributeName());
            if (attribute.isSimpleValue()) {
                List<String> values = attribute.getSimpleValues();
                for (i = 0; i < values.size(); ++i) {
                    String value = values.get(i);
                    field = content.getValue(elementPath, contentLocale, i);
                    if (field == null) {
                        field = content.addValue(cms, elementPath, contentLocale, i);
                    }
                    field.setStringValue(cms, value);
                    fieldsSet.add(field.getPath());
                }
                continue;
            }
            List<CmsEntity> entities = attribute.getComplexValues();
            for (i = 0; i < entities.size(); ++i) {
                CmsEntity child = entities.get(i);
                field = content.getValue(elementPath, contentLocale, i);
                if (field == null) {
                    field = content.addValue(cms, elementPath, contentLocale, i);
                }
                this.addEntityAttributes(cms, content, field.getPath() + "/", child, contentLocale, fieldsSet);
            }
        }
    }

    private List<String> addSettingsAttributes(Map<String, CmsAttributeConfiguration> attributeConfiguration, Map<String, CmsXmlContentProperty> settingsConfig, List<I_CmsFormatterBean> nestedFormatters, CmsMessages messages, Locale contentLocale, Map<String, String> settingPresets) {
        String attrName;
        ArrayList<String> attributes = new ArrayList<String>();
        attributeConfiguration.put(SETTINGS_CLIENT_ID_ATTRIBUTE, new CmsAttributeConfiguration("internal_client_id", "", null, null, null, I_CmsXmlContentHandler.DisplayType.none.name(), false, false, false));
        for (Map.Entry<String, CmsXmlContentProperty> entry : settingsConfig.entrySet()) {
            boolean visible;
            CmsXmlContentProperty prop = entry.getValue();
            String niceName = prop.getNiceName();
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(niceName)) {
                niceName = prop.getName();
            }
            attrName = this.getSettingsAttributeName(entry.getKey());
            boolean bl = visible = !"hidden".equals(prop.getWidget()) && !settingPresets.containsKey(prop.getName());
            if (visible) {
                attributes.add(attrName);
            }
            attributeConfiguration.put(attrName, new CmsAttributeConfiguration(niceName, prop.getDescription(), this.getWidgetName(prop.getWidget()), this.getWidgetConfig(prop.getWidget(), prop.getWidgetConfiguration(), messages, contentLocale), prop.getDefault(), I_CmsXmlContentHandler.DisplayType.singleline.name(), visible, false, false));
        }
        if (nestedFormatters != null) {
            for (I_CmsFormatterBean formatter : nestedFormatters) {
                attrName = this.getSettingsAttributeName(formatter.getId());
                attributes.add(attrName);
                attributeConfiguration.put(attrName, new CmsAttributeConfiguration(formatter.getNiceName(this.m_workplaceLocale), "", null, null, null, I_CmsXmlContentHandler.DisplayType.none.name(), true, false, false));
            }
        }
        return attributes;
    }

    private void addSettingsTypes(String entityType, Map<String, CmsType> types, Map<String, CmsXmlContentProperty> settingsConfig, List<I_CmsFormatterBean> nestedFormatters) {
        CmsType baseType = types.get(entityType);
        CmsType settingType = new CmsType(SETTING_TYPE_NAME);
        types.put(settingType.getId(), settingType);
        baseType.addAttribute(SETTINGS_CLIENT_ID_ATTRIBUTE, settingType, 1, 1);
        for (Map.Entry<String, CmsXmlContentProperty> entry : settingsConfig.entrySet()) {
            boolean nested = false;
            if (nestedFormatters != null) {
                for (I_CmsFormatterBean formatter : nestedFormatters) {
                    if (!entry.getKey().startsWith(formatter.getId())) continue;
                    nested = true;
                    break;
                }
            }
            if (nested) continue;
            baseType.addAttribute(this.getSettingsAttributeName(entry.getKey()), settingType, 0, 1);
        }
        block2: for (Map.Entry<String, CmsXmlContentProperty> entry : settingsConfig.entrySet()) {
            if (nestedFormatters == null) continue;
            for (I_CmsFormatterBean formatter : nestedFormatters) {
                if (!entry.getKey().startsWith(formatter.getId()) || "hidden".equals(entry.getValue().getWidget())) continue;
                CmsType parent = types.get(formatter.getId());
                if (parent == null) {
                    parent = new CmsType(formatter.getId());
                    types.put(parent.getId(), parent);
                    baseType.addAttribute(this.getSettingsAttributeName(formatter.getId()), parent, 1, 1);
                }
                parent.addAttribute(this.getSettingsAttributeName(entry.getKey()), settingType, 0, 1);
                continue block2;
            }
        }
    }

    private void addSettingsValues(CmsEntity entity, CmsContainerElementBean containerElement, List<I_CmsFormatterBean> nestedFormatters) {
        entity.addAttributeValue(SETTINGS_CLIENT_ID_ATTRIBUTE, containerElement.editorHash());
        for (Map.Entry<String, String> settingEntry : containerElement.getIndividualSettings().entrySet()) {
            boolean nested = false;
            if (nestedFormatters != null) {
                for (I_CmsFormatterBean formatter : nestedFormatters) {
                    if (!settingEntry.getKey().startsWith(formatter.getId())) continue;
                    String nestedSettingAttributeName = this.getSettingsAttributeName(formatter.getId());
                    CmsEntity nestedEntity = null;
                    CmsEntityAttribute attribute = entity.getAttribute(nestedSettingAttributeName);
                    if (attribute != null) {
                        nestedEntity = attribute.getComplexValue();
                    } else {
                        nestedEntity = new CmsEntity(nestedSettingAttributeName + "[1]", formatter.getId());
                        entity.addAttributeValue(nestedSettingAttributeName, nestedEntity);
                    }
                    nestedEntity.addAttributeValue(this.getSettingsAttributeName(settingEntry.getKey()), settingEntry.getValue());
                    nested = true;
                    break;
                }
            }
            if (nested) continue;
            entity.addAttributeValue(this.getSettingsAttributeName(settingEntry.getKey()), settingEntry.getValue());
        }
    }

    private boolean checkAutoCorrection(CmsObject cms, CmsXmlContent content) throws CmsXmlException {
        boolean performedAutoCorrection = content.isTransformedVersion();
        try {
            content.validateXmlStructure(new CmsXmlEntityResolver(cms));
        }
        catch (CmsXmlException eXml) {
            content.setAutoCorrectionEnabled(true);
            content.correctXmlStructure(cms);
            performedAutoCorrection = true;
        }
        return performedAutoCorrection;
    }

    private String createResourceToEdit(String newLink, Locale locale, String referenceSitePath, String modelFileSitePath, String mode, String postCreateHandler, CmsEditHandlerData editHandlerData) throws CmsException {
        CmsObject cms = this.getCmsObject();
        HttpServletRequest request = this.getRequest();
        if (editHandlerData != null) {
            CmsContainerpageService containerpageService = new CmsContainerpageService();
            containerpageService.setCms(cms);
            containerpageService.setRequest(request);
            CmsResource page = cms.readResource(editHandlerData.getPageContextId(), CmsResourceFilter.ALL);
            CmsContainerElementBean elementBean = containerpageService.getCachedElement(editHandlerData.getClientId(), page.getRootPath());
            Map<String, String[]> params = CmsRequestUtil.createParameterMap(CmsEncoder.decode(editHandlerData.getRequestParams()), true, "UTF-8");
            elementBean.initResource(cms);
            CmsResource elementResource = elementBean.getResource();
            I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(elementResource);
            if (type instanceof CmsResourceTypeXmlContent) {
                CmsResourceTypeXmlContent xmlType = (CmsResourceTypeXmlContent)type;
                I_CmsEditHandler handler = xmlType.getEditHandler(cms);
                if (handler != null) {
                    return handler.handleNew(cms, newLink, locale, referenceSitePath, modelFileSitePath, postCreateHandler, elementBean, editHandlerData.getPageContextId(), params, editHandlerData.getOption());
                }
                LOG.warn((Object)("Invalid state: edit handler data passed in, but edit handler is undefined. type = " + type.getTypeName()));
            } else {
                LOG.warn((Object)"Invalid state: edit handler data passed in for non-XML content type.");
            }
        }
        return CmsContentService.defaultCreateResourceToEdit(cms, newLink, locale, referenceSitePath, modelFileSitePath, mode, postCreateHandler);
    }

    private Set<String> evaluateScope(String scope, CmsXmlContentDefinition definition) {
        HashSet<String> evaluatedScopes = new HashSet<String>();
        if (scope.contains("*")) {
            String[] pathElements = scope.split("/");
            String parentPath = "";
            for (int i = 0; i < pathElements.length; ++i) {
                String elementName = pathElements[i];
                boolean hasWildCard = elementName.endsWith("*");
                if (hasWildCard) {
                    elementName = elementName.substring(0, elementName.length() - 1);
                    parentPath = CmsStringUtil.joinPaths(parentPath, elementName);
                    I_CmsXmlSchemaType type = definition.getSchemaType(parentPath);
                    HashSet<String> tempScopes = new HashSet<String>();
                    if (type.getMaxOccurs() == Integer.MAX_VALUE) {
                        throw new IllegalStateException("Can not use fields with unbounded maxOccurs in scopes for editor change handler.");
                    }
                    for (int j = 0; j < type.getMaxOccurs(); ++j) {
                        if (evaluatedScopes.isEmpty()) {
                            tempScopes.add(elementName + "[" + (j + 1) + "]");
                            continue;
                        }
                        for (String evScope : evaluatedScopes) {
                            tempScopes.add(CmsStringUtil.joinPaths(evScope, elementName + "[" + (j + 1) + "]"));
                        }
                    }
                    evaluatedScopes = tempScopes;
                    continue;
                }
                parentPath = CmsStringUtil.joinPaths(parentPath, elementName);
                HashSet<String> tempScopes = new HashSet<String>();
                if (evaluatedScopes.isEmpty()) {
                    tempScopes.add(elementName);
                } else {
                    for (String evScope : evaluatedScopes) {
                        tempScopes.add(CmsStringUtil.joinPaths(evScope, elementName));
                    }
                }
                evaluatedScopes = tempScopes;
            }
        } else {
            evaluatedScopes.add(scope);
        }
        return evaluatedScopes;
    }

    private void evaluateSyncLocaleValues(CmsXmlContent content, Map<String, String> syncValues, Collection<String> skipPaths) {
        CmsObject cms = this.getCmsObject();
        for (Locale locale : content.getLocales()) {
            for (String elementPath : content.getContentDefinition().getContentHandler().getSynchronizations(true).getSynchronizationPaths()) {
                for (I_CmsXmlContentValue contentValue : content.getSimpleValuesBelowPath(elementPath, locale)) {
                    String valuePath = contentValue.getPath();
                    boolean skip = false;
                    for (String skipPath : skipPaths) {
                        if (!valuePath.startsWith(skipPath)) continue;
                        skip = true;
                        break;
                    }
                    if (skip) continue;
                    String value = contentValue.getStringValue(cms);
                    if (syncValues.containsKey(valuePath)) {
                        if (syncValues.get(valuePath).equals(value)) continue;
                        syncValues.remove(valuePath);
                        int pathLevelDiff = CmsResource.getPathLevel(valuePath) - CmsResource.getPathLevel(elementPath) + 1;
                        for (int i = 0; i < pathLevelDiff; ++i) {
                            valuePath = CmsXmlUtils.removeLastXpathElement(valuePath);
                        }
                        skipPaths.add(valuePath);
                        continue;
                    }
                    syncValues.put(valuePath, value);
                }
            }
        }
    }

    private Set<String> getChangeHandlerScopes(CmsXmlContentDefinition definition) {
        List<I_CmsXmlContentEditorChangeHandler> changeHandlers = definition.getContentHandler().getEditorChangeHandlers(false);
        HashSet<String> scopes = new HashSet<String>();
        for (I_CmsXmlContentEditorChangeHandler handler : changeHandlers) {
            String scope = handler.getScope();
            scopes.addAll(this.evaluateScope(scope, definition));
        }
        return scopes;
    }

    private CmsXmlContent getContentDocument(CmsFile file, boolean fromCache) throws CmsXmlException {
        CmsXmlContent content = null;
        if (fromCache) {
            content = this.getSessionCache().getCacheXmlContent(file.getStructureId());
        }
        if (content == null) {
            content = CmsXmlContentFactory.unmarshal(this.getCmsObject(), file);
            this.getSessionCache().setCacheXmlContent(file.getStructureId(), content);
        }
        CmsContentTypeVisitor visitor = new CmsContentTypeVisitor(this.getCmsObject(), file, Locale.ENGLISH);
        visitor.visitTypes(content.getContentDefinition(), Locale.ENGLISH);
        CmsDynamicCategoryFieldList dynCatFields = visitor.getOptionalDynamicCategoryFields();
        dynCatFields.ensureFields(this.getCmsObject(), content);
        return content;
    }

    private String getDynamicAttributeValue(CmsFile file, I_CmsXmlContentValue value, String attributeName, CmsEntity editedLocalEntity) {
        String currentValue;
        if (null != editedLocalEntity && editedLocalEntity.getAttribute(attributeName) != null) {
            this.getSessionCache().setDynamicValue(attributeName, editedLocalEntity.getAttribute(attributeName).getSimpleValue());
        }
        if (null != (currentValue = this.getSessionCache().getDynamicValue(attributeName))) {
            return currentValue;
        }
        if (null != file) {
            CmsAccessRestrictionInfo restrictionInfo;
            if (value.getTypeName().equals("OpenCmsDynamicCategory")) {
                List<Object> categories = new ArrayList(0);
                try {
                    categories = CmsCategoryService.getInstance().readResourceCategories(this.getCmsObject(), file);
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERROR_FAILED_READING_CATEGORIES_1"), (Throwable)e);
                }
                I_CmsWidget widget = null;
                widget = CmsWidgetUtil.collectWidgetInfo(this.getCmsObject(), value).getWidget();
                if (null != widget && widget instanceof CmsCategoryWidget) {
                    String mainCategoryPath = ((CmsCategoryWidget)widget).getStartingCategory(this.getCmsObject(), this.getCmsObject().getSitePath(file));
                    StringBuffer pathes = new StringBuffer();
                    for (CmsCategory cmsCategory : categories) {
                        if (!cmsCategory.getPath().startsWith(mainCategoryPath)) continue;
                        String path = cmsCategory.getBasePath() + cmsCategory.getPath();
                        path = this.getCmsObject().getRequestContext().removeSiteRoot(path);
                        pathes.append(path).append(',');
                    }
                    String dynamicConfigString = pathes.length() > 0 ? pathes.substring(0, pathes.length() - 1) : "";
                    this.getSessionCache().setDynamicValue(attributeName, dynamicConfigString);
                    return dynamicConfigString;
                }
            } else if (value.getTypeName().equals("OpenCmsAccessRestriction") && (restrictionInfo = CmsAccessRestrictionInfo.getRestrictionInfo(this.getCmsObject(), value.getDocument().getContentDefinition())) != null) {
                try {
                    List<CmsAccessControlEntry> aces = this.getCmsObject().getAccessControlEntries(this.getCmsObject().getSitePath(value.getDocument().getFile()));
                    boolean hasEntry = aces.stream().anyMatch(ace -> ace.getPrincipal().equals(restrictionInfo.getGroup().getId()) && ace.isResponsible());
                    return "" + hasEntry;
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return "false";
                }
            }
        }
        return "";
    }

    private I_CmsFormatterBean getFormatterForElement(CmsADEConfigData config, CmsContainerElementBean containerElement) {
        if (containerElement != null && containerElement.getFormatterId() != null && !containerElement.getFormatterId().isNullUUID()) {
            CmsUUID formatterId = containerElement.getFormatterId();
            for (Map.Entry<String, String> settingEntry : containerElement.getIndividualSettings().entrySet()) {
                String formatterConfigId;
                I_CmsFormatterBean dynamicFmt;
                if (!settingEntry.getKey().startsWith("formatterSettings#") || (dynamicFmt = config.findFormatter(formatterConfigId = settingEntry.getValue())) == null || !dynamicFmt.getJspStructureId().equals(formatterId)) continue;
                return dynamicFmt;
            }
        }
        return null;
    }

    private String[] getPathElements(CmsXmlContent content, I_CmsXmlContentValue value) {
        ArrayList<String> pathElements = new ArrayList<String>();
        String[] paths = value.getPath().split("/");
        String path = "";
        for (int i = 0; i < paths.length; ++i) {
            path = path + paths[i];
            I_CmsXmlContentValue ancestor = content.getValue(path, value.getLocale());
            int valueIndex = ancestor.getXmlIndex();
            if (ancestor.isChoiceOption()) {
                Element parent = ancestor.getElement().getParent();
                valueIndex = parent.indexOf((Node)ancestor.getElement());
            }
            String pathElement = CmsContentService.getAttributeName(ancestor);
            pathElements.add(pathElement + "[" + valueIndex + "]");
            if (ancestor.isChoiceType()) {
                pathElements.add("ATTRIBUTE_CHOICE");
            }
            path = path + "/";
        }
        return pathElements.toArray(new String[pathElements.size()]);
    }

    private CmsADESessionCache getSessionCache() {
        if (this.m_sessionCache == null) {
            this.m_sessionCache = CmsADESessionCache.getCache(this.getRequest(), this.getCmsObject());
        }
        return this.m_sessionCache;
    }

    private String getSettingsAttributeName(String settingName) {
        return "/SETTING:::" + settingName;
    }

    private String getWidgetConfig(String settingsWidget, String settingsConfig, CmsMessages messages, Locale contentLocale) {
        Class<? extends I_CmsADEWidget> widgetClass = WIDGET_MAPPINGS.get(settingsWidget);
        String config = "";
        if (widgetClass == null) {
            widgetClass = CmsInputWidget.class;
        }
        try {
            I_CmsADEWidget widget = widgetClass.newInstance();
            widget.setConfiguration(settingsConfig);
            config = widget.getConfiguration(this.getCmsObject(), null, messages, null, contentLocale);
        }
        catch (Exception e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        return config;
    }

    private String getWidgetName(String settingsWidget) {
        if (WIDGET_MAPPINGS.containsKey(settingsWidget)) {
            return WIDGET_MAPPINGS.get(settingsWidget).getName();
        }
        return CmsInputWidget.class.getName();
    }

    private Locale getWorkplaceLocale(CmsObject cms) {
        if (this.m_workplaceLocale == null) {
            this.m_workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        }
        return this.m_workplaceLocale;
    }

    private boolean isSettingsAttribute(String attributeName) {
        return attributeName.startsWith("/SETTING:::");
    }

    private CmsADEConfigData readConfig(CmsUUID pageId) {
        if (pageId == null) {
            return null;
        }
        try {
            CmsResource resource = this.getCmsObject().readResource(pageId, CmsResourceFilter.IGNORE_EXPIRATION);
            return OpenCms.getADEManager().lookupConfiguration(this.getCmsObject(), resource.getRootPath());
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    private CmsContentDefinition readContentDefinition(CmsFile file, CmsXmlContent content, String entityId, String clientId, Locale locale, boolean newLocale, Locale mainLocale, CmsEntity editedLocaleEntity, Map<String, String> settingPresets, CmsADEConfigData configData) throws CmsException {
        CmsContainerElementBean containerElement;
        I_CmsFormatterBean formatter;
        boolean performedAutoCorrection;
        long timer = 0L;
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        CmsObject cms = this.getCmsObject();
        CmsADEConfigData config = OpenCms.getADEManager().lookupConfiguration(cms, cms.getRequestContext().getRootUri());
        List<Locale> availableLocalesList = OpenCms.getLocaleManager().getAvailableLocales(cms, file);
        if (!availableLocalesList.contains(locale)) {
            availableLocalesList.retainAll(content.getLocales());
            List<Locale> defaultLocales = OpenCms.getLocaleManager().getDefaultLocales(cms, file);
            Locale replacementLocale = OpenCms.getLocaleManager().getBestMatchingLocale(locale, defaultLocales, availableLocalesList);
            LOG.info((Object)("Can't edit locale " + locale + " of file " + file.getRootPath() + " because it is not configured as available locale. Using locale " + replacementLocale + " instead."));
            locale = replacementLocale;
            entityId = CmsContentDefinition.uuidToEntityId(file.getStructureId(), locale.toString());
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(entityId)) {
            entityId = CmsContentDefinition.uuidToEntityId(file.getStructureId(), locale.toString());
        }
        if (performedAutoCorrection = this.checkAutoCorrection(cms, content)) {
            content.initDocument();
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_UNMARSHALING_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        CmsContentTypeVisitor visitor = new CmsContentTypeVisitor(cms, file, locale);
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        visitor.visitTypes(content.getContentDefinition(), this.getWorkplaceLocale(cms));
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_VISITING_TYPES_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        CmsEntity entity = null;
        HashMap<String, String> syncValues = new HashMap<String, String>();
        HashSet<String> skipPaths = new HashSet<String>();
        this.evaluateSyncLocaleValues(content, syncValues, skipPaths);
        if (content.hasLocale(locale) && newLocale) {
            content.removeLocale(locale);
        }
        if (!content.hasLocale(locale)) {
            if (mainLocale != null && content.hasLocale(mainLocale)) {
                content.copyLocale(mainLocale, locale);
            } else {
                content.addLocale(cms, locale);
            }
            if (!visitor.getLocaleSynchronizations().isEmpty() && content.getLocales().size() > 1) {
                for (Locale contentLocale : content.getLocales()) {
                    if (contentLocale.equals(locale)) continue;
                    content.synchronizeLocaleIndependentValues(cms, skipPaths, contentLocale);
                }
            }
        }
        visitor.getOptionalDynamicCategoryFields().ensureFields(cms, content, locale);
        Element element = content.getLocaleNode(locale);
        if (LOG.isDebugEnabled()) {
            timer = System.currentTimeMillis();
        }
        entity = this.readEntity(content, element, locale, entityId, "", CmsContentService.getTypeUri(content.getContentDefinition()), visitor, false, editedLocaleEntity);
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)Messages.get().getBundle().key("LOG_TAKE_READING_ENTITY_TIME_1", "" + (System.currentTimeMillis() - timer)));
        }
        ArrayList<String> contentLocales = new ArrayList<String>();
        for (Locale contentLocale : content.getLocales()) {
            contentLocales.add(contentLocale.toString());
        }
        Locale workplaceLocale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        TreeMap<String, String> availableLocales = new TreeMap<String, String>();
        for (Locale availableLocale : OpenCms.getLocaleManager().getAvailableLocales(cms, file)) {
            availableLocales.put(availableLocale.toString(), availableLocale.getDisplayName(workplaceLocale));
        }
        String title = cms.readPropertyObject(file, "Title", false).getValue();
        try {
            CmsGallerySearchResult searchResult = CmsGallerySearch.searchById(cms, file.getStructureId(), locale);
            title = searchResult.getTitle();
        }
        catch (CmsException e) {
            LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
        }
        String typeName = OpenCms.getResourceManager().getResourceType(file.getTypeId()).getTypeName();
        boolean autoUnlock = OpenCms.getWorkplaceManager().shouldAcaciaUnlock();
        HashMap<String, CmsEntity> entities = new HashMap<String, CmsEntity>();
        entities.put(entityId, entity);
        Map<String, CmsAttributeConfiguration> attrConfig = visitor.getAttributeConfigurations();
        Map<String, CmsType> types = visitor.getTypes();
        List<CmsTabInfo> tabInfos = visitor.getTabInfos();
        if (clientId != null && (formatter = this.getFormatterForElement(configData, containerElement = this.getSessionCache().getCacheContainerElement(clientId))) != null && formatter.isAllowsSettingsInEditor() && !formatter.getSettings(config).isEmpty()) {
            Map<String, CmsXmlContentProperty> settingsConfig = OpenCms.getADEManager().getFormatterSettings(cms, config, formatter, containerElement.getResource(), locale, (ServletRequest)this.getRequest());
            Supplier contentSupplier = Suppliers.memoize(() -> {
                try {
                    return CmsXmlContentFactory.unmarshal(cms, cms.readFile(containerElement.getResource()));
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    return null;
                }
            });
            settingsConfig = CmsXmlContentPropertyHelper.resolveMacrosForPropertyInfo(cms, null, containerElement.getResource(), (Supplier<CmsXmlContent>)contentSupplier, CmsElementUtil.createStringTemplateSource(formatter, (Supplier<CmsXmlContent>)contentSupplier), settingsConfig);
            CmsWorkplaceMessages messages = OpenCms.getWorkplaceManager().getMessages(this.m_workplaceLocale);
            List<I_CmsFormatterBean> nestedFormatters = formatter.hasNestedFormatterSettings() ? OpenCms.getADEManager().getNestedFormatters(cms, config, containerElement.getResource(), locale, (ServletRequest)this.getRequest()) : Collections.emptyList();
            String firstContentAttributeName = types.get(entity.getTypeName()).getAttributeNames().iterator().next();
            List<String> addedVisibleAttrs = this.addSettingsAttributes(attrConfig, settingsConfig, nestedFormatters, messages, locale, settingPresets);
            this.addSettingsTypes(entity.getTypeName(), types, settingsConfig, nestedFormatters);
            if (editedLocaleEntity != null) {
                this.transferSettingValues(editedLocaleEntity, entity);
            } else {
                this.addSettingsValues(entity, containerElement, nestedFormatters);
            }
            if (tabInfos.isEmpty()) {
                tabInfos.add(new CmsTabInfo(Messages.get().getBundle(workplaceLocale).key("GUI_CONTENT_TAB_LABEL_0"), "GUI_CONTENT_TAB_LABEL_0", "content", firstContentAttributeName.substring(entity.getTypeName().length() + 1), false, null, null));
            }
            if (addedVisibleAttrs.size() > 0) {
                tabInfos.add(new CmsTabInfo(Messages.get().getBundle(workplaceLocale).key("GUI_SETTINGS_TAB_LABEL_0"), "GUI_SETTINGS_TAB_LABEL_0", "###formattersettings###", CmsFileUtil.removeLeadingSeparator(addedVisibleAttrs.iterator().next()), false, Messages.get().getBundle(workplaceLocale).key("GUI_SETTINGS_TAB_DESCRIPTION_0"), null));
            }
        }
        return new CmsContentDefinition(entityId, entities, visitor.getAttributeConfigurations(), visitor.getWidgetConfigurations(), visitor.getComplexWidgetData(), visitor.getTypes(), visitor.getTabInfos(), locale.toString(), contentLocales, availableLocales, visitor.getLocaleSynchronizations(), syncValues, skipPaths, title, cms.getSitePath(file), typeName, CmsIconUtil.getIconClasses(CmsIconUtil.getDisplayType(cms, file), file.getName(), false), performedAutoCorrection, autoUnlock, this.getChangeHandlerScopes(content.getContentDefinition()));
    }

    private CmsContentDefinition readContentDefinitionForNew(String newLink, CmsResource referenceResource, CmsUUID modelFileId, Locale locale, String mode, String postCreateHandler, CmsEditHandlerData editHandlerData, Map<String, String> settingPresets) throws CmsException {
        String sitePath = this.getCmsObject().getSitePath(referenceResource);
        String resourceType = newLink.startsWith("__edit__") ? CmsJspTagEdit.getTypeFromNewLink(newLink) : OpenCms.getResourceManager().getResourceType(referenceResource.getTypeId()).getTypeName();
        String modelFile = null;
        if (modelFileId == null) {
            List<CmsResource> modelResources = CmsResourceTypeXmlContent.getModelFiles(this.getCmsObject(), CmsResource.getFolderPath(sitePath), resourceType);
            if (!modelResources.isEmpty()) {
                List<CmsModelResourceInfo> modelInfos = CmsContainerpageService.generateModelResourceList(this.getCmsObject(), resourceType, modelResources, locale);
                return new CmsContentDefinition(modelInfos, newLink, referenceResource.getStructureId(), locale.toString());
            }
        } else if (!modelFileId.isNullUUID()) {
            modelFile = this.getCmsObject().getSitePath(this.getCmsObject().readResource(modelFileId, CmsResourceFilter.IGNORE_EXPIRATION));
        }
        String newFileName = this.createResourceToEdit(newLink, locale, sitePath, modelFile, mode, postCreateHandler, editHandlerData);
        CmsResource resource = this.getCmsObject().readResource(newFileName, CmsResourceFilter.IGNORE_EXPIRATION);
        CmsFile file = this.getCmsObject().readFile(resource);
        CmsXmlContent content = this.getContentDocument(file, false);
        CmsContentDefinition contentDefinition = this.readContentDefinition(file, content, null, null, locale, false, null, null, settingPresets, null);
        contentDefinition.setDeleteOnCancel(true);
        return contentDefinition;
    }

    private boolean saveSettings(CmsEntity entity, CmsContainerElementBean containerElement, Map<String, CmsXmlContentProperty> settingsConfig, List<I_CmsFormatterBean> nestedFormatters) {
        boolean hasChangedSettings = false;
        HashMap<String, String> values = new HashMap<String, String>(containerElement.getIndividualSettings());
        for (Map.Entry<String, CmsXmlContentProperty> settingsEntry : settingsConfig.entrySet()) {
            CmsEntityAttribute valueAttribute;
            String value = null;
            boolean nested = false;
            if (nestedFormatters != null) {
                for (I_CmsFormatterBean formatter : nestedFormatters) {
                    CmsEntityAttribute valueAttribute2;
                    if (!settingsEntry.getKey().startsWith(formatter.getId())) continue;
                    CmsEntity nestedEntity = null;
                    CmsEntityAttribute attribute = entity.getAttribute(this.getSettingsAttributeName(formatter.getId()));
                    if (attribute != null && (valueAttribute2 = (nestedEntity = attribute.getComplexValue()).getAttribute(this.getSettingsAttributeName(settingsEntry.getKey()))) != null) {
                        value = valueAttribute2.getSimpleValue();
                    }
                    nested = true;
                    break;
                }
            }
            if (!nested && (valueAttribute = entity.getAttribute(this.getSettingsAttributeName(settingsEntry.getKey()))) != null) {
                value = valueAttribute.getSimpleValue();
            }
            if (CmsStringUtil.isEmptyOrWhitespaceOnly(value) && !"hidden".equals(settingsEntry.getValue().getWidget()) && values.containsKey(settingsEntry.getKey())) {
                values.remove(settingsEntry.getKey());
                hasChangedSettings = true;
                continue;
            }
            if (!CmsStringUtil.isNotEmptyOrWhitespaceOnly(value) || "hidden".equals(settingsEntry.getValue().getWidget()) || value.equals(values.get(settingsEntry.getKey()))) continue;
            values.put(settingsEntry.getKey(), value);
            hasChangedSettings = true;
        }
        if (hasChangedSettings) {
            containerElement.updateIndividualSettings(values);
            this.getSessionCache().setCacheContainerElement(containerElement.editorHash(), containerElement);
        }
        return hasChangedSettings;
    }

    private void synchronizeLocaleIndependentForEntity(CmsFile file, CmsXmlContent content, Collection<String> skipPaths, CmsEntity entity) throws CmsXmlException {
        CmsObject cms = this.getCmsObject();
        String entityId = entity.getId();
        Locale contentLocale = CmsLocaleManager.getLocale(CmsContentDefinition.getLocaleFromId(entityId));
        CmsContentTypeVisitor visitor = null;
        CmsEntity originalEntity = null;
        if (content.getHandler().hasVisibilityHandlers()) {
            visitor = new CmsContentTypeVisitor(cms, file, contentLocale);
            visitor.visitTypes(content.getContentDefinition(), this.getWorkplaceLocale(cms));
        }
        if (content.hasLocale(contentLocale)) {
            if (visitor != null && visitor.hasInvisibleFields()) {
                Element element = content.getLocaleNode(contentLocale);
                originalEntity = this.readEntity(content, element, contentLocale, entityId, "", CmsContentService.getTypeUri(content.getContentDefinition()), visitor, true, entity);
            }
            content.removeLocale(contentLocale);
        }
        content.addLocale(cms, contentLocale);
        if (visitor != null && visitor.hasInvisibleFields()) {
            this.transferInvisibleValues(originalEntity, entity, visitor);
        }
        this.addEntityAttributes(cms, content, "", entity, contentLocale);
        content.synchronizeLocaleIndependentValues(cms, skipPaths, contentLocale);
    }

    private void transferSettingValues(CmsEntity source, CmsEntity target) {
        for (CmsEntityAttribute attr : source.getAttributes()) {
            if (!this.isSettingsAttribute(attr.getAttributeName())) continue;
            if (attr.isSimpleValue()) {
                target.addAttributeValue(attr.getAttributeName(), attr.getSimpleValue());
                continue;
            }
            CmsEntity nestedSource = attr.getComplexValue();
            CmsEntity nested = new CmsEntity(nestedSource.getId(), nestedSource.getTypeName());
            for (CmsEntityAttribute nestedAttr : nestedSource.getAttributes()) {
                nested.addAttributeValue(nestedAttr.getAttributeName(), nestedAttr.getSimpleValue());
            }
            target.addAttributeValue(attr.getAttributeName(), nested);
        }
    }

    private CmsValidationResult validateContent(CmsObject cms, CmsUUID structureId, CmsXmlContent content) {
        return this.validateContent(cms, structureId, content, null);
    }

    private CmsValidationResult validateContent(CmsObject cms, CmsUUID structureId, CmsXmlContent content, Set<String> fieldNames) {
        CmsXmlContentErrorHandler errorHandler = content.validate(cms);
        HashMap<String, Map<String[], CmsPair<String, String>>> errorsByEntity = new HashMap<String, Map<String[], CmsPair<String, String>>>();
        if (errorHandler.hasErrors()) {
            boolean reallyHasErrors = false;
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getErrors().entrySet()) {
                HashMap<String[], CmsPair<String, String>> errors = new HashMap<String[], CmsPair<String, String>>();
                for (Map.Entry<String, String> error : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(error.getKey(), localeEntry.getKey());
                    if (fieldNames != null && !fieldNames.contains(value.getPath())) continue;
                    errors.put(this.getPathElements(content, value), new CmsPair<String, String>(error.getValue(), error.getKey()));
                    reallyHasErrors = true;
                }
                if (!reallyHasErrors) continue;
                errorsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), errors);
            }
        }
        HashMap<String, Map<String[], CmsPair<String, String>>> warningsByEntity = new HashMap<String, Map<String[], CmsPair<String, String>>>();
        if (errorHandler.hasWarnings()) {
            boolean reallyHasErrors = false;
            for (Map.Entry<Locale, Map<String, String>> localeEntry : errorHandler.getWarnings().entrySet()) {
                HashMap<String[], CmsPair<String, String>> warnings = new HashMap<String[], CmsPair<String, String>>();
                for (Map.Entry<String, String> warning : localeEntry.getValue().entrySet()) {
                    I_CmsXmlContentValue value = content.getValue(warning.getKey(), localeEntry.getKey());
                    if (fieldNames != null && !fieldNames.contains(value.getPath())) continue;
                    warnings.put(this.getPathElements(content, value), new CmsPair<String, String>(warning.getValue(), warning.getKey()));
                    reallyHasErrors = true;
                }
                if (!reallyHasErrors) continue;
                warningsByEntity.put(CmsContentDefinition.uuidToEntityId(structureId, localeEntry.getKey().toString()), warnings);
            }
        }
        return new CmsValidationResult(errorsByEntity, warningsByEntity);
    }

    private void validateSettings(CmsEntity entity, CmsValidationResult validationResult, Map<String, CmsXmlContentProperty> settingsConfig) {
        Map<String, Map<String[], CmsPair<String, String>>> warnings;
        Map<String[], CmsPair<String, String>> entityWarnings;
        Map<String, Map<String[], CmsPair<String, String>>> errors = validationResult.getErrors();
        Map<String[], CmsPair<String, String>> entityErrors = errors.get(entity.getId());
        if (entityErrors == null) {
            entityErrors = new HashMap<String[], CmsPair<String, String>>();
        }
        if ((entityWarnings = (warnings = validationResult.getWarnings()).get(entity.getId())) == null) {
            entityWarnings = new HashMap<String[], CmsPair<String, String>>();
        }
        for (CmsEntityAttribute attribute : entity.getAttributes()) {
            if (!this.isSettingsAttribute(attribute.getAttributeName())) continue;
            if (attribute.isSimpleValue()) {
                String regex;
                String settingsKey = attribute.getAttributeName().substring(SETTINGS_ATTRIBUTE_NAME_PREFIX.length() + 1);
                CmsXmlContentProperty prop = settingsConfig.get(settingsKey);
                if (prop == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(regex = prop.getRuleRegex()) || attribute.getSimpleValue().matches(regex)) continue;
                String[] path = new String[]{attribute.getAttributeName()};
                if (SETTINGS_RULE_TYPE_ERROR.equals(prop.getRuleType())) {
                    entityErrors.put(path, new CmsPair<String, String>(prop.getError(), prop.getNiceName()));
                    continue;
                }
                entityWarnings.put(path, new CmsPair<String, String>(prop.getError(), prop.getNiceName()));
                continue;
            }
            CmsEntity nested = attribute.getComplexValue();
            for (CmsEntityAttribute nestedAttribute : nested.getAttributes()) {
                String regex;
                String settingsKey = nestedAttribute.getAttributeName().substring(SETTINGS_ATTRIBUTE_NAME_PREFIX.length() + 1);
                CmsXmlContentProperty prop = settingsConfig.get(settingsKey);
                if (prop == null || !CmsStringUtil.isNotEmptyOrWhitespaceOnly(regex = prop.getRuleRegex()) || nestedAttribute.getSimpleValue().matches(regex)) continue;
                String[] path = new String[]{attribute.getAttributeName(), nestedAttribute.getAttributeName()};
                if (SETTINGS_RULE_TYPE_ERROR.equals(prop.getRuleType())) {
                    entityErrors.put(path, new CmsPair<String, String>(prop.getError(), prop.getNiceName()));
                    continue;
                }
                entityWarnings.put(path, new CmsPair<String, String>(prop.getError(), prop.getNiceName()));
            }
        }
        if (!entityErrors.isEmpty()) {
            errors.put(entity.getId(), entityErrors);
        }
        if (!entityWarnings.isEmpty()) {
            warnings.put(entity.getId(), entityWarnings);
        }
    }

    private void writeCategories(CmsFile file, CmsXmlContent content, CmsEntity lastEditedEntity) {
        if (null == content || null == file) {
            return;
        }
        CmsObject cms = this.getCmsObject();
        if (!content.getLocales().isEmpty()) {
            Locale locale = content.getLocales().iterator().next();
            CmsEntity entity = lastEditedEntity;
            List<I_CmsXmlContentValue> values = content.getValues(locale);
            for (I_CmsXmlContentValue value : values) {
                if (!value.getTypeName().equals("OpenCmsDynamicCategory")) continue;
                I_CmsWidget widget = CmsWidgetUtil.collectWidgetInfo(cms, value).getWidget();
                List<Object> categories = new ArrayList(0);
                try {
                    categories = CmsCategoryService.getInstance().readResourceCategories(cms, file);
                }
                catch (CmsException e) {
                    LOG.error((Object)Messages.get().getBundle().key("ERROR_FAILED_READING_CATEGORIES_1"), (Throwable)e);
                }
                if (null == widget || !(widget instanceof CmsCategoryWidget)) continue;
                String mainCategoryPath = ((CmsCategoryWidget)widget).getStartingCategory(cms, cms.getSitePath(file));
                for (CmsCategory cmsCategory : categories) {
                    if (!cmsCategory.getPath().startsWith(mainCategoryPath)) continue;
                    try {
                        CmsCategoryService.getInstance().removeResourceFromCategory(cms, cms.getSitePath(file), cmsCategory);
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                if (null == entity) {
                    try {
                        CmsContentDefinition definition = this.readContentDefinition(file, content, "dummy", null, locale, false, null, null, Collections.emptyMap(), null);
                        entity = definition.getEntity();
                    }
                    catch (CmsException e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
                String checkedCategories = "";
                if (null != entity) {
                    checkedCategories = CmsEntity.getValueForPath(entity, new String[]{value.getPath()});
                }
                List<String> list = Arrays.asList(checkedCategories.split(","));
                for (String category : list) {
                    try {
                        CmsCategoryService.getInstance().addResourceToCategory(cms, cms.getSitePath(file), CmsCategoryService.getInstance().getCategory(cms, category));
                    }
                    catch (CmsException e) {
                        if (!LOG.isWarnEnabled()) continue;
                        LOG.warn((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CmsXmlContent writeContent(CmsObject cms, CmsFile file, CmsXmlContent content, String encoding) throws CmsException {
        String decodedContent = content.toString();
        try {
            file.setContents(decodedContent.getBytes(encoding));
        }
        catch (UnsupportedEncodingException e) {
            throw new CmsException(org.opencms.workplace.editors.Messages.get().container("ERR_INVALID_CONTENT_ENC_1", file.getRootPath()), (Throwable)e);
        }
        cms.getRequestContext().setAttribute(ATTR_EDITOR_SAVING, "true");
        try {
            file = cms.writeFile(file);
        }
        finally {
            cms.getRequestContext().removeAttribute(ATTR_EDITOR_SAVING);
        }
        return CmsXmlContentFactory.unmarshal(cms, file);
    }

    static {
        WIDGET_MAPPINGS.put("string", CmsInputWidget.class);
        WIDGET_MAPPINGS.put("select", CmsSelectWidget.class);
        WIDGET_MAPPINGS.put("multicheck", CmsMultiSelectWidget.class);
        WIDGET_MAPPINGS.put("selectcombo", CmsSelectComboWidget.class);
        WIDGET_MAPPINGS.put("checkbox", CmsCheckboxWidget.class);
        WIDGET_MAPPINGS.put("combo", CmsComboWidget.class);
        WIDGET_MAPPINGS.put("datebox", CmsCalendarWidget.class);
        WIDGET_MAPPINGS.put("gallery", CmsVfsFileWidget.class);
        WIDGET_MAPPINGS.put("multiselectbox", CmsMultiSelectWidget.class);
        WIDGET_MAPPINGS.put("radio", CmsRadioSelectWidget.class);
        WIDGET_MAPPINGS.put("groupselection", CmsGroupWidget.class);
    }
}

