/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.jsp.PageContext;
import org.apache.commons.logging.Log;
import org.opencms.ade.sitemap.CmsVfsSitemapService;
import org.opencms.ade.sitemap.Messages;
import org.opencms.ade.sitemap.shared.CmsClientSitemapEntry;
import org.opencms.ade.sitemap.shared.CmsSitemapData;
import org.opencms.ade.sitemap.shared.rpc.I_CmsSitemapService;
import org.opencms.gwt.CmsGwtActionElement;
import org.opencms.gwt.CmsRpcException;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.ui.CmsVaadinUtils;
import org.opencms.util.CmsRequestUtil;
import org.opencms.util.CmsStringUtil;

public class CmsSitemapActionElement
extends CmsGwtActionElement {
    public static final String CMS_MODULE_NAME = "org.opencms.ade.sitemap";
    public static final String GWT_MODULE_NAME = "sitemap";
    private static final Log LOG = CmsLog.getLog(CmsSitemapActionElement.class);
    private CmsSitemapData m_sitemapData;

    public CmsSitemapActionElement(PageContext context, HttpServletRequest req, HttpServletResponse res) {
        super(context, req, res);
    }

    @Override
    public String export() throws Exception {
        return "";
    }

    @Override
    public String exportAll() throws Exception {
        CmsRequestUtil.disableCrossSiteFrameEmbedding(this.getResponse());
        StringBuffer sb = new StringBuffer();
        sb.append(this.export(false));
        sb.append(CmsSitemapActionElement.exportDictionary("org_opencms_ade_sitemap", I_CmsSitemapService.class.getMethod("prefetch", String.class), this.getSitemapData()));
        sb.append(this.exportModuleScriptTag(GWT_MODULE_NAME));
        String vaadinBootstrap = CmsStringUtil.joinPaths(OpenCms.getSystemInfo().getContextPath(), "VAADIN/vaadinBootstrap.js");
        sb.append("  <script \n          src=\"" + vaadinBootstrap + "\"></script>");
        sb.append("<script>    \nfunction initVaadin() { " + CmsVaadinUtils.getBootstrapScript(this.getCmsObject(), "sitemap-ui", "workplace/sitemap/") + " } </script>");
        return sb.toString();
    }

    public CmsSitemapData getSitemapData() {
        if (this.m_sitemapData == null) {
            try {
                this.m_sitemapData = CmsVfsSitemapService.prefetch(this.getRequest(), this.getCmsObject().getRequestContext().getUri());
            }
            catch (CmsRpcException e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return this.m_sitemapData;
    }

    public String getTitle() {
        CmsSitemapData data = this.getSitemapData();
        String folderTitle = "";
        if (data != null) {
            folderTitle = this.getSitemapData().getOpenPath();
            CmsClientSitemapEntry root = this.getSitemapData().getRoot();
            if (root != null) {
                CmsClientProperty titleProp = root.getOwnProperties().get("Title");
                folderTitle = titleProp != null && !titleProp.isEmpty() ? root.getOwnProperties().get("Title").getEffectiveValue() : root.getName();
            }
        }
        return Messages.get().getBundle(this.getWorkplaceLocale()).key("GUI_EDITOR_TITLE_1", folderTitle);
    }
}

