/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.ade.sitemap.shared.I_CmsSitemapController;
import org.opencms.db.CmsResourceState;
import org.opencms.file.CmsResource;
import org.opencms.gwt.shared.CmsClientLock;
import org.opencms.gwt.shared.CmsPermissionInfo;
import org.opencms.gwt.shared.property.CmsClientProperty;
import org.opencms.util.CmsStringUtil;
import org.opencms.util.CmsUUID;

public class CmsClientSitemapEntry
implements IsSerializable {
    public static final String HIDDEN_NAVIGATION_ENTRY = "ignoreInDefaultNav";
    private List<String> m_aliases;
    private String m_cachedExportName;
    private boolean m_childrenLoadedInitially;
    private String m_dateExpired;
    private String m_dateReleased;
    private CmsUUID m_defaultFileId;
    private Map<String, CmsClientProperty> m_defaultFileProperties = new HashMap<String, CmsClientProperty>();
    private boolean m_defaultFileReleased = true;
    private String m_defaultFileType;
    private String m_detailpageTypeName;
    private EntryType m_entryType;
    private boolean m_hasBlockingLockedChildren;
    private boolean m_hasForeignFolderLock;
    private CmsUUID m_id;
    private boolean m_inNavigation;
    private boolean m_isFolderDefaultPage;
    private boolean m_isResleasedAndNotExpired;
    private CmsClientLock m_lock;
    private String m_name;
    private String m_navModeIcon;
    private boolean m_new;
    private Map<String, CmsClientProperty> m_ownProperties = new HashMap<String, CmsClientProperty>();
    private CmsPermissionInfo m_permissionInfo;
    private int m_position = -1;
    private String m_redirectTarget;
    private CmsResourceState m_resourceState;
    private int m_resourceTypeId;
    private String m_resourceTypeName;
    private String m_sitePath;
    private List<CmsClientSitemapEntry> m_subEntries = new ArrayList<CmsClientSitemapEntry>();
    private String m_vfsModeIcon;
    private String m_vfsPath;

    public CmsClientSitemapEntry() {
        this.m_entryType = EntryType.folder;
    }

    public CmsClientSitemapEntry(CmsClientSitemapEntry clone) {
        this();
        this.copyMembers(clone);
        this.setPosition(clone.getPosition());
    }

    public void addSubEntry(CmsClientSitemapEntry entry, I_CmsSitemapController controller) {
        entry.setPosition(this.m_subEntries.size());
        entry.updateSitePath(CmsStringUtil.joinPaths(this.m_sitePath, entry.getName()), controller);
        entry.setFolderDefaultPage(entry.isLeafType() && this.getVfsPath().equals(entry.getVfsPath()));
        this.m_subEntries.add(entry);
    }

    public List<String> getAliases() {
        return this.m_aliases;
    }

    public boolean getChildrenLoadedInitially() {
        return this.m_childrenLoadedInitially;
    }

    public String getDateExpired() {
        return this.m_dateExpired;
    }

    public String getDateReleased() {
        return this.m_dateReleased;
    }

    public CmsUUID getDefaultFileId() {
        return this.m_defaultFileId;
    }

    public Map<String, CmsClientProperty> getDefaultFileProperties() {
        return this.m_defaultFileProperties;
    }

    public String getDefaultFileType() {
        return this.m_defaultFileType;
    }

    public String getDetailpageTypeName() {
        return this.m_detailpageTypeName;
    }

    public EntryType getEntryType() {
        return this.m_entryType;
    }

    public String getExportName() {
        return this.m_cachedExportName;
    }

    public CmsUUID getId() {
        return this.m_id;
    }

    public CmsClientLock getLock() {
        return this.m_lock;
    }

    public String getName() {
        return this.m_name;
    }

    public String getNavModeIcon() {
        return this.m_navModeIcon != null ? this.m_navModeIcon : this.m_vfsModeIcon;
    }

    public String getNoEditReason() {
        return this.m_permissionInfo.getNoEditReason();
    }

    public Map<String, CmsClientProperty> getOwnProperties() {
        return this.m_ownProperties;
    }

    public int getPosition() {
        return this.m_position;
    }

    public String getPropertyValue(String propertyName) {
        if (this.m_ownProperties.containsKey(propertyName)) {
            return this.m_ownProperties.get(propertyName).getEffectiveValue();
        }
        return null;
    }

    public String getRedirectTarget() {
        return this.m_redirectTarget;
    }

    public CmsResourceState getResourceState() {
        return this.m_resourceState;
    }

    public int getResourceTypeId() {
        return this.m_resourceTypeId;
    }

    public String getResourceTypeName() {
        return this.m_resourceTypeName;
    }

    public String getSitePath() {
        return this.m_sitePath;
    }

    public List<CmsClientSitemapEntry> getSubEntries() {
        return this.m_subEntries;
    }

    public String getTitle() {
        String title = this.getPropertyValue("NavText");
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
            title = this.getPropertyValue("Title");
        }
        if (CmsStringUtil.isEmptyOrWhitespaceOnly(title)) {
            title = this.m_name;
        }
        return title;
    }

    public String getVfsModeIcon() {
        return this.m_vfsModeIcon;
    }

    public String getVfsPath() {
        return this.m_vfsPath;
    }

    public boolean hasBlockingLockedChildren() {
        return this.m_hasBlockingLockedChildren;
    }

    public boolean hasForeignFolderLock() {
        return this.m_hasForeignFolderLock;
    }

    public void initialize(I_CmsSitemapController controller) {
        this.m_ownProperties = controller.replaceProperties(this.m_id, this.m_ownProperties);
        this.m_defaultFileProperties = controller.replaceProperties(this.m_defaultFileId, this.m_defaultFileProperties);
        controller.registerEntry(this);
    }

    public void initializeAll(I_CmsSitemapController controller) {
        this.initialize(controller);
        for (CmsClientSitemapEntry child : this.m_subEntries) {
            child.initializeAll(controller);
        }
    }

    public void insertSubEntry(CmsClientSitemapEntry entry, int position, I_CmsSitemapController controller) {
        entry.updateSitePath(CmsStringUtil.joinPaths(this.m_sitePath, entry.getName()), controller);
        this.m_subEntries.add(position, entry);
        this.updatePositions(position);
    }

    public boolean isDefaultFileReleased() {
        return this.m_defaultFileReleased;
    }

    public boolean isEditable() {
        return this.m_permissionInfo.hasWritePermission() && CmsStringUtil.isEmptyOrWhitespaceOnly(this.getNoEditReason()) && !this.hasForeignFolderLock() && !this.hasBlockingLockedChildren() && (this.getLock() == null || this.getLock().getLockOwner() == null || this.getLock().isOwnedByUser());
    }

    public boolean isFolderDefaultPage() {
        return this.m_isFolderDefaultPage;
    }

    public boolean isFolderType() {
        return EntryType.folder == this.m_entryType || EntryType.navigationLevel == this.m_entryType;
    }

    public boolean isHiddenNavigationEntry() {
        CmsClientProperty property = this.m_ownProperties.get("NavInfo");
        return property != null && HIDDEN_NAVIGATION_ENTRY.equals(property.getEffectiveValue());
    }

    public boolean isInNavigation() {
        return this.m_inNavigation;
    }

    public boolean isLeafType() {
        return EntryType.leaf == this.m_entryType || EntryType.redirect == this.m_entryType;
    }

    public boolean isNavigationLevelType() {
        return EntryType.navigationLevel == this.m_entryType;
    }

    public boolean isNew() {
        return this.m_new;
    }

    public boolean isResleasedAndNotExpired() {
        return this.m_isResleasedAndNotExpired;
    }

    public boolean isRoot() {
        return this.m_name.equals("");
    }

    public boolean isSubSitemapType() {
        return EntryType.subSitemap == this.m_entryType;
    }

    public void normalizeProperties() {
        CmsClientProperty.removeEmptyProperties(this.m_ownProperties);
        if (this.m_defaultFileProperties != null) {
            CmsClientProperty.removeEmptyProperties(this.m_defaultFileProperties);
        }
    }

    public CmsClientSitemapEntry removeSubEntry(CmsUUID entryId) {
        CmsClientSitemapEntry removed = null;
        int position = -1;
        if (!this.m_subEntries.isEmpty()) {
            for (int i = 0; i < this.m_subEntries.size(); ++i) {
                if (!this.m_subEntries.get(i).getId().equals(entryId)) continue;
                position = i;
            }
            if (position != -1) {
                removed = this.m_subEntries.remove(position);
                this.updatePositions(position);
            }
        }
        return removed;
    }

    public CmsClientSitemapEntry removeSubEntry(int position) {
        CmsClientSitemapEntry removed = this.m_subEntries.remove(position);
        this.updatePositions(position);
        return removed;
    }

    public void setAliases(List<String> aliases) {
        this.m_aliases = aliases;
    }

    public void setBlockingLockedChildren(boolean hasBlockingLockedChildren) {
        this.m_hasBlockingLockedChildren = hasBlockingLockedChildren;
    }

    public void setChildrenLoadedInitially(boolean childrenLoaded) {
        this.m_childrenLoadedInitially = childrenLoaded;
    }

    public void setDateExpired(String dateExpired) {
        this.m_dateExpired = dateExpired;
    }

    public void setDateReleased(String dateReleased) {
        this.m_dateReleased = dateReleased;
    }

    public void setDefaultFileId(CmsUUID defaultFileId) {
        this.m_defaultFileId = defaultFileId;
    }

    public void setDefaultFileProperties(Map<String, CmsClientProperty> properties) {
        this.m_defaultFileProperties = properties;
    }

    public void setDefaultFileReleased(boolean defaultFileReleased) {
        this.m_defaultFileReleased = defaultFileReleased;
    }

    public void setDefaultFileType(String defaultFileType) {
        this.m_defaultFileType = defaultFileType;
    }

    public void setDetailpageTypeName(String detailpageTypeName) {
        this.m_detailpageTypeName = detailpageTypeName;
    }

    public void setEntryType(EntryType entryType) {
        this.m_entryType = entryType;
    }

    public void setExportName(String exportName) {
        this.m_cachedExportName = exportName;
    }

    public void setFolderDefaultPage(boolean isFolderDefaultPage) {
        this.m_isFolderDefaultPage = isFolderDefaultPage;
    }

    public void setHasForeignFolderLock(boolean hasForeignFolderLock) {
        this.m_hasForeignFolderLock = hasForeignFolderLock;
    }

    public void setId(CmsUUID id) {
        this.m_id = id;
    }

    public void setInNavigation(boolean inNavigation) {
        this.m_inNavigation = inNavigation;
    }

    public void setLock(CmsClientLock lock) {
        this.m_lock = lock;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public void setNavModeIcon(String iconClasses) {
        this.m_navModeIcon = iconClasses;
    }

    public void setNew(boolean isNew) {
        this.m_new = isNew;
    }

    public void setOwnProperties(Map<String, CmsClientProperty> properties) {
        this.m_ownProperties = properties;
    }

    public void setPermissionInfo(CmsPermissionInfo permissionInfo) {
        this.m_permissionInfo = permissionInfo;
    }

    public void setPosition(int position) {
        this.m_position = position;
    }

    public void setRedirectTarget(String redirectTarget) {
        this.m_redirectTarget = redirectTarget;
    }

    public void setResleasedAndNotExpired(boolean isResleasedAndNotExpired) {
        this.m_isResleasedAndNotExpired = isResleasedAndNotExpired;
    }

    public void setResourceState(CmsResourceState resourceState) {
        this.m_resourceState = resourceState;
    }

    public void setResourceTypeId(int resourceTypeId) {
        this.m_resourceTypeId = resourceTypeId;
    }

    public void setResourceTypeName(String typeName) {
        this.m_resourceTypeName = typeName;
    }

    public void setSitePath(String sitepath) {
        if (!this.isLeafType() && !sitepath.endsWith("/")) {
            sitepath = sitepath + "/";
        }
        this.m_sitePath = sitepath;
    }

    public void setSubEntries(List<CmsClientSitemapEntry> children, I_CmsSitemapController controller) {
        this.m_childrenLoadedInitially = true;
        this.m_subEntries.clear();
        if (children != null) {
            this.m_subEntries.addAll(children);
            for (CmsClientSitemapEntry child : children) {
                child.updateSitePath(CmsStringUtil.joinPaths(this.m_sitePath, child.getName()), controller);
            }
        }
    }

    public void setVfsModeIcon(String iconClasses) {
        this.m_vfsModeIcon = iconClasses;
    }

    public void setVfsPath(String path) {
        this.m_vfsPath = path;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.m_sitePath).append("\n");
        for (CmsClientSitemapEntry child : this.m_subEntries) {
            sb.append(child.toString());
        }
        return sb.toString();
    }

    public void update(CmsClientSitemapEntry source) {
        this.copyMembers(source);
        if (source.getPosition() >= 0) {
            this.setPosition(source.getPosition());
        }
    }

    public void updateSitePath(String sitepath, I_CmsSitemapController controller) {
        if (!this.isLeafType() && !sitepath.endsWith("/")) {
            sitepath = sitepath + "/";
        }
        if (!this.m_sitePath.equals(sitepath)) {
            int start = this.m_vfsPath.lastIndexOf(this.m_sitePath);
            int stop = start + this.m_sitePath.length();
            this.m_vfsPath = CmsStringUtil.joinPaths(this.m_vfsPath.substring(0, start), sitepath, this.m_vfsPath.substring(stop));
            if (this.isLeafType() && this.m_vfsPath.endsWith("/")) {
                this.m_vfsPath = this.m_vfsPath.substring(0, this.m_vfsPath.length() - 1);
            }
            String oldPath = this.m_sitePath;
            this.m_sitePath = sitepath;
            String name = CmsResource.getName(sitepath);
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            this.m_name = name;
            for (CmsClientSitemapEntry child : this.m_subEntries) {
                child.updateSitePath(CmsStringUtil.joinPaths(sitepath, child.getName()), controller);
            }
            if (controller != null) {
                controller.registerPathChange(this, oldPath);
            }
        }
    }

    private void copyMembers(CmsClientSitemapEntry source) {
        this.setId(source.getId());
        this.setName(source.getName());
        this.setOwnProperties(new HashMap<String, CmsClientProperty>(source.getOwnProperties()));
        this.setDefaultFileId(source.getDefaultFileId());
        this.setDefaultFileType(source.getDefaultFileType());
        Map<String, CmsClientProperty> defaultFileProperties = source.getDefaultFileProperties();
        if (defaultFileProperties == null) {
            defaultFileProperties = new HashMap<String, CmsClientProperty>();
        }
        this.setDefaultFileProperties(new HashMap<String, CmsClientProperty>(defaultFileProperties));
        if (source.getDetailpageTypeName() != null) {
            this.setDetailpageTypeName(source.getDetailpageTypeName());
        }
        this.setSitePath(source.getSitePath());
        this.setVfsPath(source.getVfsPath());
        this.setLock(source.getLock());
        this.setEntryType(source.getEntryType());
        this.setInNavigation(source.isInNavigation());
        this.setHasForeignFolderLock(source.hasForeignFolderLock());
        this.setBlockingLockedChildren(source.hasBlockingLockedChildren());
        this.setFolderDefaultPage(source.isFolderDefaultPage());
        this.setResourceTypeName(source.getResourceTypeName());
        this.setChildrenLoadedInitially(source.getChildrenLoadedInitially());
        this.setFolderDefaultPage(source.isFolderDefaultPage());
        this.setDateExpired(source.getDateExpired());
        this.setDateReleased(source.getDateReleased());
        this.setResleasedAndNotExpired(source.isResleasedAndNotExpired());
        this.setDefaultFileReleased(source.isDefaultFileReleased());
        this.setAliases(source.getAliases());
        this.setRedirectTarget(source.getRedirectTarget());
        this.setResourceState(source.getResourceState());
        this.setPermissionInfo(source.m_permissionInfo);
    }

    private void updatePositions(int position) {
        for (int i = position; i < this.m_subEntries.size(); ++i) {
            this.m_subEntries.get(i).setPosition(i);
        }
    }

    public static enum EntryType {
        folder,
        leaf,
        navigationLevel,
        redirect,
        subSitemap;

    }

    public static enum EditStatus {
        created,
        edited,
        normal;

    }
}

