/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.ade.sitemap.shared;

import com.google.common.base.Function;
import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.opencms.gwt.shared.CmsCategoryTreeEntry;
import org.opencms.util.CmsUUID;

public class CmsSitemapCategoryData
implements IsSerializable {
    private String m_basePath;
    private List<CmsCategoryTreeEntry> m_categoryEntries = Lists.newArrayList();

    public void add(CmsCategoryTreeEntry item) {
        this.m_categoryEntries.add(item);
    }

    public Multimap<Boolean, CmsCategoryTreeEntry> getEntriesIndexedByLocality() {
        return ArrayListMultimap.create((Multimap)Multimaps.index(this.m_categoryEntries, (Function)new Function<CmsCategoryTreeEntry, Boolean>(){

            public Boolean apply(CmsCategoryTreeEntry entry) {
                return entry.getBasePath().equals(CmsSitemapCategoryData.this.m_basePath);
            }
        }));
    }

    public CmsCategoryTreeEntry getEntryById(CmsUUID id) {
        for (CmsCategoryTreeEntry entry : this.getFlatList()) {
            if (!id.equals(entry.getId())) continue;
            return entry;
        }
        return null;
    }

    public void setBasePath(String basePath) {
        this.m_basePath = basePath;
    }

    List<CmsCategoryTreeEntry> getFlatList() {
        ArrayList toProcess = Lists.newArrayList(this.m_categoryEntries);
        ArrayList result = Lists.newArrayList();
        HashSet visited = Sets.newHashSet();
        while (!toProcess.isEmpty()) {
            Iterator iter = toProcess.iterator();
            CmsCategoryTreeEntry entry = (CmsCategoryTreeEntry)iter.next();
            iter.remove();
            if (visited.contains(entry.getId())) continue;
            result.add(entry);
            visited.add(entry.getId());
            toProcess.addAll(entry.getChildren());
        }
        return result;
    }

    List<CmsCategoryTreeEntry> getRootEntries() {
        return this.m_categoryEntries;
    }
}

