/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.util.HashSet;
import java.util.Set;

public class CmsCmisRenditionFilter {
    private boolean m_includeAll;
    private Set<String> m_kinds = new HashSet<String>();
    private Set<String> m_supertypes = new HashSet<String>();
    private Set<String> m_types = new HashSet<String>();

    public CmsCmisRenditionFilter(String filterStr) {
        if (filterStr == null || filterStr.equals("cmis:none")) {
            return;
        }
        if ("*".equals(filterStr)) {
            this.m_includeAll = true;
        } else {
            String[] tokens;
            for (String token : tokens = filterStr.split(",")) {
                int slashPos = token.indexOf("/");
                if (slashPos > -1) {
                    String supertype = token.substring(0, slashPos);
                    String subtype = token.substring(slashPos + 1);
                    if ("*".equals(subtype)) {
                        this.m_supertypes.add(supertype);
                        continue;
                    }
                    this.m_types.add(token);
                    continue;
                }
                this.m_kinds.add(token);
            }
        }
    }

    public boolean accept(String kind, String mimetype) {
        if (this.m_includeAll) {
            return true;
        }
        int slashpos = mimetype.indexOf("/");
        String supertype = mimetype.substring(0, slashpos);
        return this.m_kinds.contains(kind) || this.m_types.contains(mimetype) || this.m_supertypes.contains(supertype);
    }
}

