/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.chemistry.opencmis.commons.impl.server.AbstractServiceFactory;
import org.apache.chemistry.opencmis.commons.server.CallContext;
import org.apache.chemistry.opencmis.commons.server.CmisService;
import org.apache.chemistry.opencmis.server.support.wrapper.ConformanceCmisServiceWrapper;
import org.apache.commons.logging.Log;
import org.opencms.cmis.CmsCmisService;
import org.opencms.main.CmsLog;
import org.opencms.util.CmsStringUtil;

public class CmsCmisServiceFactory
extends AbstractServiceFactory {
    protected static final Log LOG = CmsLog.getLog(CmsCmisServiceFactory.class);
    private static final BigInteger DEFAULT_DEPTH_OBJECTS = BigInteger.valueOf(100L);
    private static final BigInteger DEFAULT_DEPTH_TYPES = BigInteger.valueOf(-1L);
    private static final BigInteger DEFAULT_MAX_ITEMS_OBJECTS = BigInteger.valueOf(200L);
    private static final BigInteger DEFAULT_MAX_ITEMS_TYPES = BigInteger.valueOf(50L);

    public void destroy() {
    }

    public CmisService getService(CallContext context) {
        CmsCmisService service = new CmsCmisService(context);
        CmisService proxyService = (CmisService)Proxy.newProxyInstance(((Object)((Object)this)).getClass().getClassLoader(), new Class[]{CmisService.class}, (InvocationHandler)new LoggingServiceProxy((CmisService)service));
        ConformanceCmisServiceWrapper wrapperService = new ConformanceCmisServiceWrapper(proxyService, DEFAULT_MAX_ITEMS_TYPES, DEFAULT_DEPTH_TYPES, DEFAULT_MAX_ITEMS_OBJECTS, DEFAULT_DEPTH_OBJECTS);
        return wrapperService;
    }

    public void init(Map<String, String> parameters) {
    }

    static class LoggingServiceProxy
    implements InvocationHandler {
        private static Set<Class<?>> m_serviceInterfaces = new HashSet();
        private CmisService m_service;

        public LoggingServiceProxy(CmisService service) {
            this.m_service = service;
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                boolean isServiceCall = m_serviceInterfaces.contains(method.getDeclaringClass());
                if (isServiceCall) {
                    LOG.info((Object)("CMIS service call: " + this.getCallString(method, args)));
                }
                Object result = method.invoke((Object)this.m_service, args);
                if (isServiceCall && LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Returned '" + result + "'"));
                }
                return result;
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                LOG.info((Object)cause.getLocalizedMessage(), cause);
                throw cause;
            }
        }

        private String getCallString(Method method, Object[] args) {
            ArrayList<String> tokens = new ArrayList<String>();
            tokens.add(method.getName());
            if (args != null && args.length > 0) {
                tokens.add("=>");
                for (Object arg : args) {
                    tokens.add("'" + arg + "'");
                }
            }
            return CmsStringUtil.listAsString(tokens, " ");
        }

        static {
            for (Class<?> svcInterface : CmisService.class.getInterfaces()) {
                m_serviceInterfaces.add(svcInterface);
            }
        }
    }
}

