/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.cmis;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import org.apache.chemistry.opencmis.commons.data.Properties;
import org.apache.chemistry.opencmis.commons.data.PropertyData;
import org.apache.chemistry.opencmis.commons.definitions.PropertyDefinition;
import org.apache.chemistry.opencmis.commons.definitions.TypeDefinition;
import org.apache.chemistry.opencmis.commons.enums.Action;
import org.apache.chemistry.opencmis.commons.exceptions.CmisNameConstraintViolationException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisObjectNotFoundException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisRuntimeException;
import org.apache.chemistry.opencmis.commons.exceptions.CmisUnauthorizedException;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertiesImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyBooleanImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDateTimeImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyDecimalImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyHtmlImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIdImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyIntegerImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyStringImpl;
import org.apache.chemistry.opencmis.commons.impl.dataobjects.PropertyUriImpl;
import org.opencms.cmis.CmsCmisTypeManager;
import org.opencms.cmis.I_CmsPropertyProvider;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.CmsVfsResourceNotFoundException;
import org.opencms.lock.CmsLock;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.security.CmsAccessControlEntry;
import org.opencms.security.CmsPrincipal;
import org.opencms.security.CmsRole;
import org.opencms.security.CmsSecurityException;
import org.opencms.util.CmsUUID;

public final class CmsCmisUtil {
    private CmsCmisUtil() {
    }

    public static void addAction(Set<Action> aas, Action action, boolean condition) {
        if (condition) {
            aas.add(action);
        }
    }

    public static void addDynamicProperties(CmsObject cms, CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, CmsResource resource, Set<String> filter) {
        List<I_CmsPropertyProvider> providers = typeManager.getPropertyProviders();
        for (I_CmsPropertyProvider provider : providers) {
            String propertyName = "opencms-dynamic:" + provider.getName();
            if (!CmsCmisUtil.checkAddProperty(typeManager, (Properties)props, typeId, filter, propertyName)) continue;
            try {
                String value = provider.getPropertyValue(cms, resource);
                CmsCmisUtil.addPropertyString(typeManager, props, typeId, filter, propertyName, value);
            }
            catch (Throwable t) {
                CmsCmisUtil.addPropertyString(typeManager, props, typeId, filter, propertyName, null);
            }
        }
    }

    public static void addPropertyBigInteger(CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, Set<String> filter, String id, BigInteger value) {
        if (!CmsCmisUtil.checkAddProperty(typeManager, (Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyIntegerImpl(id, value));
    }

    public static void addPropertyBoolean(CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, Set<String> filter, String id, boolean value) {
        if (!CmsCmisUtil.checkAddProperty(typeManager, (Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyBooleanImpl(id, Boolean.valueOf(value)));
    }

    public static void addPropertyDateTime(CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, Set<String> filter, String id, GregorianCalendar value) {
        if (!CmsCmisUtil.checkAddProperty(typeManager, (Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyDateTimeImpl(id, value));
    }

    public static boolean addPropertyDefault(PropertiesImpl props, PropertyDefinition<?> propDef) {
        if (props == null || props.getProperties() == null) {
            throw new IllegalArgumentException("Props must not be null!");
        }
        if (propDef == null) {
            return false;
        }
        List defaultValue = propDef.getDefaultValue();
        if (defaultValue != null && !defaultValue.isEmpty()) {
            switch (propDef.getPropertyType()) {
                case BOOLEAN: {
                    props.addProperty((PropertyData)new PropertyBooleanImpl(propDef.getId(), defaultValue));
                    break;
                }
                case DATETIME: {
                    props.addProperty((PropertyData)new PropertyDateTimeImpl(propDef.getId(), defaultValue));
                    break;
                }
                case DECIMAL: {
                    props.addProperty((PropertyData)new PropertyDecimalImpl(propDef.getId(), defaultValue));
                    break;
                }
                case HTML: {
                    props.addProperty((PropertyData)new PropertyHtmlImpl(propDef.getId(), defaultValue));
                    break;
                }
                case ID: {
                    props.addProperty((PropertyData)new PropertyIdImpl(propDef.getId(), defaultValue));
                    break;
                }
                case INTEGER: {
                    props.addProperty((PropertyData)new PropertyIntegerImpl(propDef.getId(), defaultValue));
                    break;
                }
                case STRING: {
                    props.addProperty((PropertyData)new PropertyStringImpl(propDef.getId(), defaultValue));
                    break;
                }
                case URI: {
                    props.addProperty((PropertyData)new PropertyUriImpl(propDef.getId(), defaultValue));
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown datatype! Spec change?");
                }
            }
            return true;
        }
        return false;
    }

    public static void addPropertyId(CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, Set<String> filter, String id, String value) {
        if (!CmsCmisUtil.checkAddProperty(typeManager, (Properties)props, typeId, filter, id)) {
            return;
        }
        PropertyIdImpl result = new PropertyIdImpl(id, value);
        result.setQueryName(id);
        props.addProperty((PropertyData)result);
    }

    public static void addPropertyIdList(CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, Set<String> filter, String id, List<String> value) {
        if (!CmsCmisUtil.checkAddProperty(typeManager, (Properties)props, typeId, filter, id)) {
            return;
        }
        props.addProperty((PropertyData)new PropertyIdImpl(id, value));
    }

    public static void addPropertyInteger(CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, Set<String> filter, String id, long value) {
        CmsCmisUtil.addPropertyBigInteger(typeManager, props, typeId, filter, id, BigInteger.valueOf(value));
    }

    public static void addPropertyString(CmsCmisTypeManager typeManager, PropertiesImpl props, String typeId, Set<String> filter, String id, String value) {
        if (!CmsCmisUtil.checkAddProperty(typeManager, (Properties)props, typeId, filter, id)) {
            return;
        }
        PropertyStringImpl result = new PropertyStringImpl(id, value);
        result.setQueryName(id);
        props.addProperty((PropertyData)result);
    }

    public static boolean checkAddProperty(CmsCmisTypeManager typeManager, Properties properties, String typeId, Set<String> filter, String id) {
        if (properties == null || properties.getProperties() == null) {
            throw new IllegalArgumentException("Properties must not be null!");
        }
        if (id == null) {
            throw new IllegalArgumentException("Id must not be null!");
        }
        TypeDefinition type = typeManager.getType(typeId);
        if (type == null) {
            throw new IllegalArgumentException("Unknown type: " + typeId);
        }
        if (!type.getPropertyDefinitions().containsKey(id)) {
            throw new IllegalArgumentException("Unknown property: " + id);
        }
        String queryName = ((PropertyDefinition)type.getPropertyDefinitions().get(id)).getQueryName();
        if (queryName != null && filter != null) {
            if (!filter.contains(queryName)) {
                return false;
            }
            filter.remove(queryName);
        }
        return true;
    }

    public static void checkResourceName(String name) {
        try {
            CmsResource.checkResourceName(name);
        }
        catch (CmsIllegalArgumentException e) {
            throw new CmisNameConstraintViolationException(e.getLocalizedMessage(), (Throwable)e);
        }
    }

    public static boolean ensureLock(CmsObject cms, CmsResource resource) throws CmsException {
        CmsLock lock = cms.getLock(resource);
        if (lock.isOwnedBy(cms.getRequestContext().getCurrentUser())) {
            return false;
        }
        cms.lockResourceTemporary(resource);
        return true;
    }

    public static String getAcePrincipalName(CmsObject cms, CmsUUID principalId) {
        if (CmsAccessControlEntry.PRINCIPAL_ALL_OTHERS_ID.equals(principalId)) {
            return "ALL_OTHERS";
        }
        if (CmsAccessControlEntry.PRINCIPAL_OVERWRITE_ALL_ID.equals(principalId)) {
            return "OVERWRITE_ALL";
        }
        CmsRole role = CmsRole.valueOfId(principalId);
        if (role != null) {
            return role.getRoleName();
        }
        try {
            return CmsPrincipal.readPrincipalIncludingHistory(cms, principalId).getName();
        }
        catch (CmsException e) {
            return "" + principalId;
        }
    }

    public static List<String> getCmisPermissions(CmsAccessControlEntry ace) {
        int all;
        int permissionBits = ace.getPermissions().getPermissions();
        ArrayList<String> result = new ArrayList<String>();
        if (0 != (permissionBits & 1)) {
            result.add("cmis:read");
        }
        if (0 != (permissionBits & 2)) {
            result.add("cmis:write");
        }
        if ((permissionBits & (all = 27)) == all) {
            result.add("cmis:all");
        }
        return result;
    }

    public static List<String> getNativePermissions(CmsAccessControlEntry ace) {
        List<String> result = CmsCmisUtil.getNativePermissions(ace.getPermissions().getAllowedPermissions(), false);
        result.addAll(CmsCmisUtil.getNativePermissions(ace.getPermissions().getDeniedPermissions(), true));
        return result;
    }

    public static List<String> getNativePermissions(int permissionBits, boolean denied) {
        String prefix;
        ArrayList<String> result = new ArrayList<String>();
        String string = prefix = denied ? "opencms:deny-" : "opencms:";
        if ((permissionBits & 1) != 0) {
            result.add(prefix + "read");
        }
        if ((permissionBits & 2) != 0) {
            result.add(prefix + "write");
        }
        if ((permissionBits & 4) != 0) {
            result.add(prefix + "view");
        }
        if ((permissionBits & 8) != 0) {
            result.add(prefix + "control");
        }
        if ((permissionBits & 0x10) != 0) {
            result.add(prefix + "publish");
        }
        return result;
    }

    public static void handleCmsException(CmsException e) {
        if (e instanceof CmsVfsResourceNotFoundException) {
            throw new CmisObjectNotFoundException(e.getLocalizedMessage(), (Throwable)e);
        }
        if (e instanceof CmsSecurityException) {
            throw new CmisUnauthorizedException(e.getLocalizedMessage(), (Throwable)e);
        }
        throw new CmisRuntimeException(e.getLocalizedMessage(), (Throwable)e);
    }

    public static boolean hasChildren(CmsObject cms, CmsResource resource) throws CmsException {
        return !cms.getResourcesInFolder(cms.getSitePath(resource), CmsResourceFilter.ALL).isEmpty();
    }

    public static GregorianCalendar millisToCalendar(long millis) {
        GregorianCalendar result = new GregorianCalendar();
        result.setTimeZone(TimeZone.getTimeZone("GMT"));
        result.setTimeInMillis((long)(Math.ceil(millis / 1000L) * 1000.0));
        return result;
    }

    public static Set<String> splitFilter(String filter) {
        if (filter == null) {
            return null;
        }
        if (filter.trim().length() == 0) {
            return null;
        }
        LinkedHashSet<String> result = new LinkedHashSet<String>();
        for (String s : filter.split(",")) {
            if ((s = s.trim()).equals("*")) {
                return null;
            }
            if (s.length() <= 0) continue;
            result.add(s);
        }
        result.add("cmis:objectId");
        result.add("cmis:objectTypeId");
        result.add("cmis:baseTypeId");
        return result;
    }
}

