/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.io.Serializable;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsMacroResolver;

public class CmsConfigurationCopyResource
implements Serializable {
    public static final String COPY_AS_NEW = "new";
    public static final String COPY_AS_PRESERVE = "preserve";
    public static final String COPY_AS_SIBLING = "sibling";
    private static final long serialVersionUID = 3698327414935524194L;
    private String m_source;
    private String m_target;
    private boolean m_targetWasNull;
    private CmsResource.CmsResourceCopyMode m_type;
    private boolean m_typeWasNull;

    public CmsConfigurationCopyResource(String source, String target, String type) {
        this.m_source = source;
        if (target == null) {
            this.m_target = CmsMacroResolver.formatMacro("resource.folder.path");
            this.m_targetWasNull = true;
        } else {
            this.m_target = target;
        }
        this.m_type = CmsResource.COPY_AS_NEW;
        if (type != null) {
            if (type.equalsIgnoreCase(COPY_AS_SIBLING)) {
                this.m_type = CmsResource.COPY_AS_SIBLING;
            } else if (type.equalsIgnoreCase(COPY_AS_PRESERVE)) {
                this.m_type = CmsResource.COPY_PRESERVE_SIBLING;
            }
        } else {
            this.m_typeWasNull = true;
        }
    }

    public String getSource() {
        return this.m_source;
    }

    public String getTarget() {
        return this.m_target;
    }

    public CmsResource.CmsResourceCopyMode getType() {
        return this.m_type;
    }

    public String getTypeString() {
        if (CmsResource.COPY_AS_SIBLING == this.m_type) {
            return COPY_AS_SIBLING;
        }
        if (CmsResource.COPY_PRESERVE_SIBLING == this.m_type) {
            return COPY_AS_PRESERVE;
        }
        return COPY_AS_NEW;
    }

    public boolean isTargetWasNull() {
        return this.m_targetWasNull;
    }

    public boolean isTypeWasNull() {
        return this.m_typeWasNull;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("[");
        result.append(this.getClass().getName());
        result.append(", source=");
        result.append(this.getSource());
        result.append(", target=");
        result.append(this.getTarget());
        result.append(", type=");
        result.append(this.getTypeString());
        result.append("]");
        return result.toString();
    }
}

