/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.digester3.Digester;
import org.apache.commons.digester3.Rule;
import org.dom4j.Element;
import org.opencms.configuration.A_CmsXmlConfiguration;
import org.opencms.configuration.CmsConfigurationCopyResource;
import org.opencms.configuration.CmsConfigurationException;
import org.opencms.configuration.CmsDigesterResourceTypeCreationFactory;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.configuration.Messages;
import org.opencms.file.CmsProperty;
import org.opencms.file.collectors.I_CmsResourceCollector;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.loader.CmsDefaultFileNameGenerator;
import org.opencms.loader.CmsMimeType;
import org.opencms.loader.CmsResourceManager;
import org.opencms.loader.I_CmsResourceLoader;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsRelationType;
import org.opencms.util.CmsHtmlConverterOption;
import org.opencms.util.CmsResourceTranslator;
import org.opencms.util.CmsStringUtil;
import org.opencms.widgets.I_CmsWidget;
import org.opencms.xml.CmsXmlContentTypeManager;
import org.opencms.xml.types.I_CmsXmlSchemaType;
import org.xml.sax.Attributes;

public class CmsVfsConfiguration
extends A_CmsXmlConfiguration {
    public static final String A_ADJUST_LINKS_FOLDER = "adjust-links-folder";
    public static final String A_CONFIGURATION = "configuration";
    public static final String A_DEFAULTWIDGET = "defaultwidget";
    public static final String A_EXTENSION = "extension";
    public static final String A_SOURCE = "source";
    public static final String A_TARGET = "target";
    public static final String CONFIGURATION_DTD_NAME = "opencms-vfs.dtd";
    public static final String DEFAULT_XML_FILE_NAME = "opencms-vfs.xml";
    public static final String N_COLLECTOR = "collector";
    public static final String N_COLLECTORS = "collectors";
    public static final String N_COPY_RESOURCE = "copy-resource";
    public static final String N_COPY_RESOURCES = "copy-resources";
    public static final String N_DEFAULTFILE = "defaultfile";
    public static final String N_DEFAULTFILES = "defaultfiles";
    public static final String N_FILETRANSLATIONS = "filetranslations";
    public static final String N_FOLDERTRANSLATIONS = "foldertranslations";
    public static final String N_HTML_CONVERTER = "html-converter";
    public static final String N_HTML_CONVERTERS = "html-converters";
    public static final String N_LOADER = "loader";
    public static final String N_MAPPING = "mapping";
    public static final String N_MAPPINGS = "mappings";
    public static final String N_MIMETYPE = "mimetype";
    public static final String N_MIMETYPES = "mimetypes";
    public static final String N_PROPERTIES = "properties";
    public static final String N_RELATIONTYPE = "relationtype";
    public static final String N_RELATIONTYPES = "relationtypes";
    public static final String N_RESOURCELOADERS = "resourceloaders";
    public static final String N_RESOURCES = "resources";
    public static final String N_RESOURCETYPES = "resourcetypes";
    public static final String N_SCHEMATYPE = "schematype";
    public static final String N_SCHEMATYPES = "schematypes";
    public static final String N_TRANSLATION = "translation";
    public static final String N_TRANSLATIONS = "translations";
    public static final String N_TYPE = "type";
    public static final String N_VERSIONHISTORY = "versionhistory";
    public static final String N_VFS = "vfs";
    public static final String N_WIDGET = "widget";
    public static final String N_WIDGET_ALIAS = "widget-alias";
    public static final String N_WIDGETS = "widgets";
    public static final String N_XMLCONTENT = "xmlcontent";
    public static final String N_XMLCONTENTS = "xmlcontents";
    public static final String N_XSDTRANSLATIONS = "xsdtranslations";
    private static final String N_NAMEGENERATOR = "namegenerator";
    CmsXmlContentTypeManager m_xmlContentTypeManager;
    private List<String> m_defaultFiles;
    private boolean m_fileTranslationEnabled;
    private List<String> m_fileTranslations;
    private boolean m_folderTranslationEnabled;
    private List<String> m_folderTranslations;
    private CmsResourceManager m_resourceManager;
    private boolean m_xsdTranslationEnabled;
    private List<String> m_xsdTranslations;

    public static void addResourceTypeXmlRules(Digester digester) {
        digester.addFactoryCreate("*/resourcetypes/type", CmsDigesterResourceTypeCreationFactory.class);
        digester.addSetNext("*/resourcetypes/type", "addResourceType");
        digester.addCallMethod("*/resourcetypes/type", "initConfiguration", 3);
        digester.addCallParam("*/resourcetypes/type", 0, "name");
        digester.addCallParam("*/resourcetypes/type", 1, "id");
        digester.addCallParam("*/resourcetypes/type", 2, "class");
        digester.addObjectCreate("*/resourcetypes/type/properties/property", CmsProperty.class);
        digester.addCallMethod("*/resourcetypes/type/properties/property/name", "setName", 1);
        digester.addCallParam("*/resourcetypes/type/properties/property/name", 0);
        digester.addCallMethod("*/resourcetypes/type/properties/property/value", "setValue", 2);
        digester.addCallParam("*/resourcetypes/type/properties/property/value", 0);
        digester.addCallParam("*/resourcetypes/type/properties/property/value", 1, N_TYPE);
        digester.addSetNext("*/resourcetypes/type/properties/property", "addDefaultProperty");
        digester.addCallMethod("*/resourcetypes/type/mappings/mapping", "addMappingType", 1);
        digester.addCallParam("*/resourcetypes/type/mappings/mapping", 0, "suffix");
        digester.addCallMethod("*/resourcetypes/type/copy-resources", "setAdjustLinksFolder", 1);
        digester.addCallParam("*/resourcetypes/type/copy-resources", 0, A_ADJUST_LINKS_FOLDER);
        digester.addCallMethod("*/resourcetypes/type/copy-resources/copy-resource", "addCopyResource", 3);
        digester.addCallParam("*/resourcetypes/type/copy-resources/copy-resource", 0, A_SOURCE);
        digester.addCallParam("*/resourcetypes/type/copy-resources/copy-resource", 1, A_TARGET);
        digester.addCallParam("*/resourcetypes/type/copy-resources/copy-resource", 2, N_TYPE);
    }

    public static void generateResourceTypeXml(Element startNode, List<I_CmsResourceType> resourceTypes, boolean module) {
        for (int i = 0; i < resourceTypes.size(); ++i) {
            CmsParameterConfiguration configuration;
            List<CmsConfigurationCopyResource> copyRes;
            List<CmsProperty> properties;
            I_CmsResourceType resType = resourceTypes.get(i);
            if (resType.isAdditionalModuleResourceType() != module) continue;
            Element resourceType = startNode.addElement(N_TYPE).addAttribute("class", resType.getClassName());
            resourceType.addAttribute("name", resType.getTypeName());
            resourceType.addAttribute("id", String.valueOf(resType.getTypeId()));
            List<String> mappings = resType.getConfiguredMappings();
            if (mappings != null && mappings.size() > 0) {
                Element mappingsNode = resourceType.addElement(N_MAPPINGS);
                for (int j = 0; j < mappings.size(); ++j) {
                    Element mapping = mappingsNode.addElement(N_MAPPING);
                    mapping.addAttribute("suffix", mappings.get(j));
                }
            }
            if ((properties = resType.getConfiguredDefaultProperties()) != null && properties.size() > 0) {
                Element propertiesNode = resourceType.addElement(N_PROPERTIES);
                for (CmsProperty property : properties) {
                    Element propertyNode = propertiesNode.addElement("property");
                    propertyNode.addElement("name").addText(property.getName());
                    if (property.getStructureValue() != null) {
                        propertyNode.addElement("value").addCDATA(property.getStructureValue());
                    }
                    if (property.getResourceValue() == null) continue;
                    propertyNode.addElement("value").addAttribute(N_TYPE, "shared").addCDATA(property.getResourceValue());
                }
            }
            if ((copyRes = resType.getConfiguredCopyResources()) != null && copyRes.size() > 0) {
                Element copyResNode = resourceType.addElement(N_COPY_RESOURCES);
                Iterator<CmsConfigurationCopyResource> p = copyRes.iterator();
                String adjustLinksFolder = resType.getAdjustLinksFolder();
                if (adjustLinksFolder != null) {
                    copyResNode.addAttribute(A_ADJUST_LINKS_FOLDER, adjustLinksFolder);
                }
                while (p.hasNext()) {
                    CmsConfigurationCopyResource cRes = p.next();
                    Element cNode = copyResNode.addElement(N_COPY_RESOURCE);
                    cNode.addAttribute(A_SOURCE, cRes.getSource());
                    if (!cRes.isTargetWasNull()) {
                        cNode.addAttribute(A_TARGET, cRes.getTarget());
                    }
                    if (cRes.isTypeWasNull()) continue;
                    cNode.addAttribute(N_TYPE, cRes.getTypeString());
                }
            }
            if ((configuration = resType.getConfiguration()) == null) continue;
            ArrayList<String> ignore = null;
            if (resType instanceof CmsResourceTypeXmlContainerPage) {
                ignore = new ArrayList<String>(1);
                ignore.add("schema");
            }
            configuration.appendToXml(resourceType, ignore);
        }
    }

    public void addDefaultFile(String defaultFile) {
        this.m_defaultFiles.add(defaultFile);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_DEFAULT_FILE_2", this.m_defaultFiles.size(), defaultFile));
        }
    }

    public void addFileTranslation(String translation) {
        this.m_fileTranslations.add(translation);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_ADD_FILE_TRANSLATION_1", translation));
        }
    }

    public void addFolderTranslation(String translation) {
        this.m_folderTranslations.add(translation);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_ADD_FOLDER_TRANSLATION_1", translation));
        }
    }

    @Override
    public void addXmlDigesterRules(Digester digester) {
        digester.addCallMethod("*/vfs", "initializeFinished");
        digester.addObjectCreate("*/vfs/resources", CmsResourceManager.class);
        digester.addCallMethod("*/vfs/resources", "initConfiguration");
        digester.addSetNext("*/vfs/resources", "setResourceManager");
        digester.addObjectCreate("*/vfs/resources/resourceloaders/loader", CmsConfigurationException.class.getName(), "class");
        digester.addCallMethod("*/vfs/resources/resourceloaders/loader", "initConfiguration");
        digester.addSetNext("*/vfs/resources/resourceloaders/loader", "addLoader");
        CmsVfsConfiguration.addResourceTypeXmlRules(digester);
        digester.addCallMethod("*/vfs/resources/collectors/collector", "addContentCollector", 2);
        digester.addCallParam("*/vfs/resources/collectors/collector", 0, "class");
        digester.addCallParam("*/vfs/resources/collectors/collector", 1, "order");
        digester.addObjectCreate("*/vfs/resources/namegenerator", CmsDefaultFileNameGenerator.class.getName(), "class");
        digester.addSetNext("*/vfs/resources/namegenerator", "setNameGenerator");
        digester.addCallMethod("*/vfs/resources/mimetypes/mimetype", "addMimeType", 2);
        digester.addCallParam("*/vfs/resources/mimetypes/mimetype", 0, A_EXTENSION);
        digester.addCallParam("*/vfs/resources/mimetypes/mimetype", 1, N_TYPE);
        digester.addCallMethod("*/vfs/resources/relationtypes/relationtype", "addRelationType", 2);
        digester.addCallParam("*/vfs/resources/relationtypes/relationtype", 0, "name");
        digester.addCallParam("*/vfs/resources/relationtypes/relationtype", 1, N_TYPE);
        digester.addCallMethod("*/vfs/resources/html-converters/html-converter", "addHtmlConverter", 2);
        digester.addCallParam("*/vfs/resources/html-converters/html-converter", 0, "name");
        digester.addCallParam("*/vfs/resources/html-converters/html-converter", 1, "class");
        digester.addCallMethod("*/param", "addConfigurationParameter", 2);
        digester.addCallParam("*/param", 0, "name");
        digester.addCallParam("*/param", 1);
        digester.addCallMethod("*/vfs/defaultfiles/defaultfile", "addDefaultFile", 1);
        digester.addCallParam("*/vfs/defaultfiles/defaultfile", 0, "name");
        digester.addCallMethod("*/vfs/translations/filetranslations/translation", "addFileTranslation", 0);
        digester.addCallMethod("*/vfs/translations/filetranslations", "setFileTranslationEnabled", 1);
        digester.addCallParam("*/vfs/translations/filetranslations", 0, "enabled");
        digester.addCallMethod("*/vfs/translations/foldertranslations/translation", "addFolderTranslation", 0);
        digester.addCallMethod("*/vfs/translations/foldertranslations", "setFolderTranslationEnabled", 1);
        digester.addCallParam("*/vfs/translations/foldertranslations", 0, "enabled");
        digester.addCallMethod("*/vfs/translations/xsdtranslations/translation", "addXsdTranslation", 0);
        digester.addCallMethod("*/vfs/translations/xsdtranslations", "setXsdTranslationEnabled", 1);
        digester.addCallParam("*/vfs/translations/xsdtranslations", 0, "enabled");
        digester.addObjectCreate("*/vfs/xmlcontent", CmsXmlContentTypeManager.class);
        digester.addSetNext("*/vfs/xmlcontent", "setXmlContentTypeManager");
        final ArrayList aliases = new ArrayList();
        digester.addRule("*/vfs/xmlcontent/widgets/widget", new Rule(){
            private String m_className;
            private String m_config;

            public void begin(String namespace, String name, Attributes attributes) throws Exception {
                this.m_className = attributes.getValue("class");
                this.m_config = attributes.getValue(CmsVfsConfiguration.A_CONFIGURATION);
                String alias = attributes.getValue("alias");
                aliases.clear();
                if (alias != null) {
                    aliases.add(alias.trim());
                }
            }

            public void end(String namespace, String name) throws Exception {
                CmsXmlContentTypeManager manager = (CmsXmlContentTypeManager)this.getDigester().peek();
                ArrayList<String> aliasesCopy = new ArrayList<String>(aliases);
                manager.addWidget(this.m_className, aliasesCopy, this.m_config);
            }
        });
        digester.addRule("*/vfs/xmlcontent/widgets/widget/widget-alias", new Rule(){

            public void body(String namespace, String name, String text) throws Exception {
                aliases.add(text.trim());
            }
        });
        digester.addCallMethod("*/vfs/xmlcontent/schematypes/schematype", "addSchemaType", 2);
        digester.addCallParam("*/vfs/xmlcontent/schematypes/schematype", 0, "class");
        digester.addCallParam("*/vfs/xmlcontent/schematypes/schematype", 1, A_DEFAULTWIDGET);
    }

    public void addXsdTranslation(String translation) {
        this.m_xsdTranslations.add(translation);
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_ADD_XSD_TRANSLATION_1", translation));
        }
    }

    @Override
    public Element generateXml(Element parent) {
        boolean bl;
        if (OpenCms.getRunLevel() >= 3) {
            this.m_resourceManager = OpenCms.getResourceManager();
            this.m_xmlContentTypeManager = OpenCms.getXmlContentTypeManager();
            this.m_defaultFiles = OpenCms.getDefaultFiles();
        }
        Element vfs = parent.addElement(N_VFS);
        Element resources = vfs.addElement(N_RESOURCES);
        Element resourceloadersElement = resources.addElement(N_RESOURCELOADERS);
        for (I_CmsResourceLoader loader : this.m_resourceManager.getLoaders()) {
            Element loaderNode = resourceloadersElement.addElement(N_LOADER);
            loaderNode.addAttribute("class", loader.getClass().getName());
            CmsParameterConfiguration loaderConfiguration = loader.getConfiguration();
            if (loaderConfiguration == null) continue;
            loaderConfiguration.appendToXml(loaderNode);
        }
        Element resourcetypesElement = resources.addElement(N_RESOURCETYPES);
        ArrayList<I_CmsResourceType> resourceTypes = new ArrayList<I_CmsResourceType>();
        if (this.m_resourceManager.getResTypeUnknownFolder() != null) {
            resourceTypes.add(this.m_resourceManager.getResTypeUnknownFolder());
        }
        if (this.m_resourceManager.getResTypeUnknownFile() != null) {
            resourceTypes.add(this.m_resourceManager.getResTypeUnknownFile());
        }
        resourceTypes.addAll(this.m_resourceManager.getResourceTypes());
        CmsVfsConfiguration.generateResourceTypeXml(resourcetypesElement, resourceTypes, false);
        Element collectorsElement = resources.addElement(N_COLLECTORS);
        for (I_CmsResourceCollector collector : this.m_resourceManager.getRegisteredContentCollectors()) {
            collectorsElement.addElement(N_COLLECTOR).addAttribute("class", collector.getClass().getName()).addAttribute("order", String.valueOf(collector.getOrder()));
        }
        Element namegeneratorElement = resources.addElement(N_NAMEGENERATOR);
        String nameGeneratorClass = this.m_resourceManager.getNameGenerator().getClass().getName();
        namegeneratorElement.addAttribute("class", nameGeneratorClass);
        Element mimeTypesElement = resources.addElement(N_MIMETYPES);
        for (CmsMimeType cmsMimeType : this.m_resourceManager.getMimeTypes()) {
            mimeTypesElement.addElement(N_MIMETYPE).addAttribute(A_EXTENSION, cmsMimeType.getExtension()).addAttribute(N_TYPE, cmsMimeType.getType());
        }
        Element relationTypesElement = resources.addElement(N_RELATIONTYPES);
        for (CmsRelationType cmsRelationType : this.m_resourceManager.getRelationTypes()) {
            relationTypesElement.addElement(N_RELATIONTYPE).addAttribute("name", cmsRelationType.getName()).addAttribute(N_TYPE, cmsRelationType.getType());
        }
        boolean bl2 = false;
        for (CmsHtmlConverterOption cmsHtmlConverterOption : this.m_resourceManager.getHtmlConverters()) {
            if (cmsHtmlConverterOption.isDefault()) continue;
            bl = true;
            break;
        }
        if (bl) {
            Element element = resources.addElement(N_HTML_CONVERTERS);
            for (CmsHtmlConverterOption converter : this.m_resourceManager.getHtmlConverters()) {
                Element converterElement = element.addElement(N_HTML_CONVERTER).addAttribute("name", converter.getName());
                converterElement.addAttribute("class", converter.getClassName());
            }
        }
        Element element = vfs.addElement(N_DEFAULTFILES);
        for (String element2 : this.m_defaultFiles) {
            element.addElement(N_DEFAULTFILE).addAttribute("name", element2);
        }
        Element element3 = vfs.addElement(N_TRANSLATIONS);
        Element fileTransElement = element3.addElement(N_FILETRANSLATIONS).addAttribute("enabled", String.valueOf(this.m_fileTranslationEnabled));
        for (String string : this.m_fileTranslations) {
            fileTransElement.addElement(N_TRANSLATION).setText(string);
        }
        Element folderTransElement = element3.addElement(N_FOLDERTRANSLATIONS).addAttribute("enabled", String.valueOf(this.m_folderTranslationEnabled));
        for (String string : this.m_folderTranslations) {
            folderTransElement.addElement(N_TRANSLATION).setText(string);
        }
        Element element4 = element3.addElement(N_XSDTRANSLATIONS).addAttribute("enabled", String.valueOf(this.m_xsdTranslationEnabled));
        for (String translation : this.m_xsdTranslations) {
            element4.addElement(N_TRANSLATION).setText(translation);
        }
        Element element5 = vfs.addElement(N_XMLCONTENT);
        Element xmlWidgetsElement = element5.addElement(N_WIDGETS);
        for (String widget : this.m_xmlContentTypeManager.getRegisteredWidgetNames()) {
            Element widgetElement = xmlWidgetsElement.addElement(N_WIDGET).addAttribute("class", widget);
            for (String alias : this.m_xmlContentTypeManager.getRegisteredWidgetAliases(widget)) {
                widgetElement.addElement(N_WIDGET_ALIAS).addText(alias);
            }
            String defaultConfiguration = this.m_xmlContentTypeManager.getWidgetDefaultConfiguration(widget);
            if (!CmsStringUtil.isNotEmpty(defaultConfiguration)) continue;
            widgetElement.addAttribute(A_CONFIGURATION, defaultConfiguration);
        }
        Element xmlSchemaTypesElement = element5.addElement(N_SCHEMATYPES);
        for (I_CmsXmlSchemaType type : this.m_xmlContentTypeManager.getRegisteredSchemaTypes()) {
            I_CmsWidget widget = this.m_xmlContentTypeManager.getWidgetDefault(type.getTypeName());
            xmlSchemaTypesElement.addElement(N_SCHEMATYPE).addAttribute("class", type.getClass().getName()).addAttribute(A_DEFAULTWIDGET, widget.getClass().getName());
        }
        return vfs;
    }

    public List<String> getDefaultFiles() {
        return Collections.unmodifiableList(this.m_defaultFiles);
    }

    @Override
    public String getDtdFilename() {
        return CONFIGURATION_DTD_NAME;
    }

    public CmsResourceTranslator getFileTranslator() {
        String[] array = new String[]{};
        if (this.m_fileTranslationEnabled) {
            array = new String[this.m_fileTranslations.size()];
            for (int i = 0; i < this.m_fileTranslations.size(); ++i) {
                array[i] = this.m_fileTranslations.get(i);
            }
        }
        return new CmsResourceTranslator(array, true);
    }

    public CmsResourceTranslator getFolderTranslator() {
        String[] array = new String[]{};
        if (this.m_folderTranslationEnabled) {
            array = new String[this.m_folderTranslations.size()];
            for (int i = 0; i < this.m_folderTranslations.size(); ++i) {
                array[i] = this.m_folderTranslations.get(i);
            }
        }
        return new CmsResourceTranslator(array, false);
    }

    public CmsResourceManager getResourceManager() {
        return this.m_resourceManager;
    }

    public CmsXmlContentTypeManager getXmlContentTypeManager() {
        return this.m_xmlContentTypeManager;
    }

    public CmsResourceTranslator getXsdTranslator() {
        String[] array = this.m_xsdTranslationEnabled ? new String[this.m_xsdTranslations.size()] : new String[]{};
        for (int i = 0; i < this.m_xsdTranslations.size(); ++i) {
            array[i] = this.m_xsdTranslations.get(i);
        }
        return new CmsResourceTranslator(array, true);
    }

    public void initializeFinished() {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_CONFIG_FINISHED_0"));
        }
    }

    public void setFileTranslationEnabled(String value) {
        this.m_fileTranslationEnabled = Boolean.valueOf(value);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_fileTranslationEnabled) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FILE_TRANSLATION_ENABLE_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FILE_TRANSLATION_DISABLE_0"));
            }
        }
    }

    public void setFolderTranslationEnabled(String value) {
        this.m_folderTranslationEnabled = Boolean.valueOf(value);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_folderTranslationEnabled) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FOLDER_TRANSLATION_ENABLE_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_FOLDER_TRANSLATION_DISABLE_0"));
            }
        }
    }

    public void setResourceManager(CmsResourceManager manager) {
        this.m_resourceManager = manager;
    }

    public void setXmlContentTypeManager(CmsXmlContentTypeManager manager) {
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_XML_CONTENT_FINISHED_0"));
        }
        this.m_xmlContentTypeManager = manager;
    }

    public void setXsdTranslationEnabled(String value) {
        this.m_xsdTranslationEnabled = Boolean.valueOf(value);
        if (CmsLog.INIT.isInfoEnabled()) {
            if (this.m_xsdTranslationEnabled) {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_XSD_TRANSLATION_ENABLE_0"));
            } else {
                CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_XSD_TRANSLATION_DISABLE_0"));
            }
        }
    }

    @Override
    protected void initMembers() {
        this.setXmlFileName(DEFAULT_XML_FILE_NAME);
        this.m_fileTranslations = new ArrayList<String>();
        this.m_folderTranslations = new ArrayList<String>();
        this.m_xsdTranslations = new ArrayList<String>();
        this.m_defaultFiles = new ArrayList<String>();
        if (CmsLog.INIT.isInfoEnabled()) {
            CmsLog.INIT.info((Object)Messages.get().getBundle().key("INIT_VFS_CONFIG_INIT_0"));
        }
    }
}

