/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.configuration.preferences;

import com.google.common.collect.ComparisonChain;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.opencms.configuration.preferences.CmsBuiltinPreference;
import org.opencms.file.CmsObject;
import org.opencms.main.OpenCms;
import org.opencms.util.CmsStringUtil;
import org.opencms.xml.content.CmsXmlContentProperty;

public class CmsLanguagePreference
extends CmsBuiltinPreference {
    private static final String NICE_NAME = "%(key.GUI_LABEL_LANGUAGE_0)";

    public CmsLanguagePreference(String name) {
        super(name);
        this.m_basic = true;
    }

    public static Map<Locale, String> getOptionMapForLanguage() {
        ArrayList<Locale> locales = new ArrayList<Locale>(OpenCms.getWorkplaceManager().getLocales());
        List<Locale> contentLocales = OpenCms.getLocaleManager().getAvailableLocales();
        Collections.sort(locales, (a, b) -> {
            int indexA = contentLocales.indexOf(a);
            int indexB = contentLocales.indexOf(b);
            return ComparisonChain.start().compareTrueFirst(indexA != -1, indexB != -1).compare(indexA, indexB).compare((Comparable)((Object)a.toString()), (Comparable)((Object)b.toString())).result();
        });
        Iterator i = locales.iterator();
        LinkedHashMap<Locale, String> result = new LinkedHashMap<Locale, String>();
        for (Locale currentLocale : locales) {
            String language = currentLocale.getDisplayLanguage(currentLocale);
            if (CmsStringUtil.isNotEmpty(currentLocale.getCountry())) {
                language = language + " (" + currentLocale.getDisplayCountry(currentLocale) + ")";
            }
            if (CmsStringUtil.isNotEmpty(currentLocale.getVariant())) {
                language = language + " (" + currentLocale.getDisplayVariant(currentLocale) + ")";
            }
            language = StringUtils.capitalize((String)language);
            result.put(currentLocale, language);
        }
        return result;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition() {
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", null, null, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    @Override
    public CmsXmlContentProperty getPropertyDefinition(CmsObject cms) {
        Locale locale = OpenCms.getWorkplaceManager().getWorkplaceLocale(cms);
        String options = this.getOptionsForLanguage(locale);
        CmsXmlContentProperty prop = new CmsXmlContentProperty(this.getName(), "string", "select_notnull", options, null, null, null, NICE_NAME, null, null, null);
        return prop;
    }

    private String getOptionsForLanguage(Locale setLocale) {
        Map<Locale, String> options = CmsLanguagePreference.getOptionMapForLanguage();
        String result = options.entrySet().stream().map(entry -> entry.getKey() + ":" + (String)entry.getValue()).collect(Collectors.joining("|"));
        return result;
    }
}

