/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.userpublishlist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.opencms.db.CmsDbContext;
import org.opencms.db.I_CmsProjectDriver;
import org.opencms.db.log.CmsLogEntry;
import org.opencms.db.userpublishlist.CmsPublishListResourceState;
import org.opencms.db.userpublishlist.CmsUserPublishListEntry;
import org.opencms.file.CmsDataAccessException;
import org.opencms.util.CmsUUID;

public abstract class A_CmsLogPublishListConverter {
    protected Map<CmsUUID, CmsPublishListResourceState> m_entries = new HashMap<CmsUUID, CmsPublishListResourceState>();

    public abstract void add(CmsLogEntry var1);

    public CmsPublishListResourceState getEntry(CmsUUID key) {
        CmsPublishListResourceState result = this.m_entries.get(key);
        if (result == null) {
            result = new CmsPublishListResourceState();
            this.m_entries.put(key, result);
        }
        return result;
    }

    public void writeChangesToDatabase(CmsDbContext dbc, I_CmsProjectDriver projectDriver) throws CmsDataAccessException {
        ArrayList<CmsUserPublishListEntry> entriesToWrite = new ArrayList<CmsUserPublishListEntry>();
        for (CmsUUID structureId : this.m_entries.keySet()) {
            if (this.m_entries.get(structureId).isRemoveAll()) {
                entriesToWrite.add(new CmsUserPublishListEntry(null, structureId, 0L));
                continue;
            }
            for (CmsUUID userId : this.m_entries.get(structureId).getRemoveUsers()) {
                entriesToWrite.add(new CmsUserPublishListEntry(userId, structureId, 0L));
            }
        }
        if (entriesToWrite.size() > 0) {
            projectDriver.deleteUserPublishListEntries(dbc, entriesToWrite);
        }
        entriesToWrite.clear();
        for (CmsUUID structureId : this.m_entries.keySet()) {
            CmsPublishListResourceState state = this.m_entries.get(structureId);
            for (CmsUUID userId : state.getUpdateUsers()) {
                entriesToWrite.add(new CmsUserPublishListEntry(userId, structureId, state.getTimestamp(userId)));
            }
        }
        if (entriesToWrite.size() > 0) {
            projectDriver.writeUserPublishListEntries(dbc, entriesToWrite);
        }
    }
}

