/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.db.userpublishlist;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.opencms.util.CmsUUID;

public class CmsPublishListResourceState {
    private boolean m_removeAll;
    private Map<CmsUUID, Long> m_timestamps = new HashMap<CmsUUID, Long>();
    private Map<CmsUUID, StateChange> m_userChanges = new HashMap<CmsUUID, StateChange>();

    public void addRemove(CmsUUID userId) {
        this.m_userChanges.put(userId, StateChange.delete);
    }

    public void addUpdate(CmsUUID userId, long timestamp) {
        this.m_userChanges.put(userId, StateChange.update);
        this.m_timestamps.put(userId, timestamp);
    }

    public List<CmsUUID> getRemoveUsers() {
        ArrayList<CmsUUID> result = new ArrayList<CmsUUID>();
        for (Map.Entry<CmsUUID, StateChange> entry : this.m_userChanges.entrySet()) {
            if (entry.getValue() != StateChange.delete) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public long getTimestamp(CmsUUID userId) {
        Long timestamp = this.m_timestamps.get(userId);
        if (timestamp == null) {
            return 0L;
        }
        return timestamp;
    }

    public List<CmsUUID> getUpdateUsers() {
        ArrayList<CmsUUID> result = new ArrayList<CmsUUID>();
        for (Map.Entry<CmsUUID, StateChange> entry : this.m_userChanges.entrySet()) {
            if (entry.getValue() != StateChange.update) continue;
            result.add(entry.getKey());
        }
        return result;
    }

    public boolean isRemoveAll() {
        return this.m_removeAll;
    }

    public void setRemoveAll() {
        this.m_removeAll = true;
        this.m_userChanges.clear();
    }

    static enum StateChange {
        delete,
        update;

    }
}

