/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.collectors;

import java.util.Arrays;
import java.util.List;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsResource;
import org.opencms.file.collectors.I_CmsCollectorPostCreateHandler;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.relations.CmsCategory;
import org.opencms.relations.CmsCategoryService;

public class CmsAddCategoriesPostCreateHandler
implements I_CmsCollectorPostCreateHandler {
    @Override
    public void onCreate(CmsObject cms, CmsResource createdResource, boolean copyMode) {
    }

    @Override
    public void onCreate(CmsObject cms, CmsResource createdResource, boolean copyMode, String config) {
        if (null != config && !copyMode) {
            List<String> cats = Arrays.asList(config.split(","));
            CmsCategoryService catService = CmsCategoryService.getInstance();
            try (AutoCloseable c = CmsLockUtil.withLockedResources(cms, createdResource);){
                String sitePath = cms.getRequestContext().getSitePath(createdResource);
                for (String catPath : cats) {
                    if (catPath.isEmpty()) continue;
                    try {
                        CmsCategory cat = catPath.startsWith("/") ? catService.getCategory(cms, catPath) : catService.readCategory(cms, catPath, sitePath);
                        if (null == cat) continue;
                        catService.addResourceToCategory(cms, sitePath, cat);
                    }
                    catch (CmsException e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }
}

