/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.file.types;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import org.apache.commons.logging.Log;
import org.opencms.configuration.CmsParameterConfiguration;
import org.opencms.db.CmsSecurityManager;
import org.opencms.file.CmsFile;
import org.opencms.file.CmsObject;
import org.opencms.file.CmsProperty;
import org.opencms.file.CmsRequestContext;
import org.opencms.file.CmsResource;
import org.opencms.file.CmsResourceFilter;
import org.opencms.file.types.A_CmsResourceTypeLinkParseable;
import org.opencms.file.types.CmsResourceTypeXmlAdeConfiguration;
import org.opencms.file.types.CmsResourceTypeXmlContainerPage;
import org.opencms.file.types.I_CmsResourceType;
import org.opencms.file.types.Messages;
import org.opencms.lock.CmsLockActionRecord;
import org.opencms.lock.CmsLockUtil;
import org.opencms.main.CmsException;
import org.opencms.main.CmsIllegalArgumentException;
import org.opencms.main.CmsLog;
import org.opencms.main.OpenCms;
import org.opencms.relations.CmsLink;
import org.opencms.relations.CmsRelation;
import org.opencms.relations.CmsRelationFilter;
import org.opencms.relations.CmsRelationType;
import org.opencms.security.CmsPermissionSet;
import org.opencms.staticexport.CmsLinkTable;
import org.opencms.util.CmsMacroResolver;
import org.opencms.util.CmsStringUtil;
import org.opencms.workplace.editors.I_CmsPreEditorActionDefinition;
import org.opencms.workplace.editors.directedit.I_CmsEditHandler;
import org.opencms.xml.CmsXmlContentDefinition;
import org.opencms.xml.CmsXmlEntityResolver;
import org.opencms.xml.CmsXmlException;
import org.opencms.xml.containerpage.CmsFormatterConfiguration;
import org.opencms.xml.content.CmsMappingResolutionContext;
import org.opencms.xml.content.CmsXmlContent;
import org.opencms.xml.content.CmsXmlContentFactory;
import org.opencms.xml.content.I_CmsXmlContentHandler;
import org.opencms.xml.types.A_CmsXmlContentValue;
import org.opencms.xml.types.CmsXmlHtmlValue;
import org.opencms.xml.types.CmsXmlVarLinkValue;
import org.opencms.xml.types.CmsXmlVfsFileValue;
import org.opencms.xml.types.I_CmsXmlContentValue;

public class CmsResourceTypeXmlContent
extends A_CmsResourceTypeLinkParseable {
    public static final String ATTR_REVERSE_AVAILABILITY_MAPPING = "REVERSE_AVAILABILITY_MAPPING";
    public static final String CONFIGURATION_SCHEMA = "schema";
    public static final String DIALOG_CHOOSEMODEL = "choosemodel";
    public static final String RESOURCE_TYPE_NAME = "xmlcontent";
    private static final Log LOG = CmsLog.getLog(CmsResourceTypeXmlContent.class);
    private static final long serialVersionUID = 2271469830431937731L;
    private String m_schema;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<CmsResource> getModelFiles(CmsObject cms, String currentFolder, String newResourceTypeName) {
        block7: {
            try {
                I_CmsResourceType resType = OpenCms.getResourceManager().getResourceType(newResourceTypeName);
                I_CmsPreEditorActionDefinition preEditorAction = OpenCms.getWorkplaceManager().getPreEditorConditionDefinition(resType);
                String masterFolder = preEditorAction.getConfiguration().getString("modelfolder", null);
                String schema = resType.getConfiguration().get(CONFIGURATION_SCHEMA);
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, schema);
                I_CmsXmlContentHandler handler = contentDefinition.getContentHandler();
                String individualModelFolder = handler.getModelFolder();
                if (CmsStringUtil.isNotEmpty(individualModelFolder)) {
                    masterFolder = individualModelFolder;
                }
                if (!CmsStringUtil.isNotEmpty(masterFolder)) break block7;
                String uri = cms.getRequestContext().getUri();
                try {
                    cms.getRequestContext().setUri(currentFolder);
                    CmsMacroResolver resolver = CmsMacroResolver.newInstance().setCmsObject(cms);
                    masterFolder = resolver.resolveMacros(masterFolder);
                }
                finally {
                    cms.getRequestContext().setUri(uri);
                }
                if (CmsStringUtil.isNotEmpty(masterFolder) && cms.existsResource(masterFolder)) {
                    CmsResourceFilter filter = CmsResourceFilter.ONLY_VISIBLE_NO_DELETED.addRequireType(resType.getTypeId());
                    return cms.readResources(masterFolder, filter, false);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return Collections.emptyList();
    }

    public static String getStaticTypeName() {
        return RESOURCE_TYPE_NAME;
    }

    public static boolean isXmlContent(CmsResource resource) {
        boolean result = false;
        if (resource != null && !resource.isFolder()) {
            result = OpenCms.getResourceManager().getResourceType(resource) instanceof CmsResourceTypeXmlContent;
        }
        return result;
    }

    @Override
    public void addConfigurationParameter(String paramName, String paramValue) {
        super.addConfigurationParameter(paramName, paramValue);
        if (CONFIGURATION_SCHEMA.equalsIgnoreCase(paramName)) {
            this.m_schema = paramValue.trim();
        }
    }

    @Override
    public CmsResource createResource(CmsObject cms, CmsSecurityManager securityManager, String resourcename, byte[] content, List<CmsProperty> properties) throws CmsException {
        boolean hasModelUri = false;
        CmsXmlContent newContent = null;
        if (content == null || content.length == 0) {
            Locale locale = this.getLocaleForNewContent(cms, securityManager, resourcename, properties);
            String modelUri = (String)cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_MODEL);
            CmsObject newCms = OpenCms.initCmsObject(cms);
            newCms.getRequestContext().setUri(CmsResource.getParentFolder(resourcename));
            if (modelUri != null) {
                newContent = CmsXmlContentFactory.createDocument(newCms, locale, modelUri);
                hasModelUri = true;
            } else if (this.m_schema != null) {
                CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, this.m_schema);
                newContent = CmsXmlContentFactory.createDocument(newCms, locale, OpenCms.getSystemInfo().getDefaultEncoding(), contentDefinition);
            }
            if (newContent != null) {
                content = newContent.marshal();
            }
        }
        CmsResource resource = super.createResource(cms, securityManager, resourcename, content, properties);
        if (hasModelUri) {
            CmsFile file = cms.readFile(resource);
            newContent = CmsXmlContentFactory.unmarshal(cms, file);
            newContent.setAutoCorrectionEnabled(true);
            resource = newContent.getHandler().prepareForWrite(cms, newContent, file);
        }
        return resource;
    }

    @Override
    public void deleteResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, CmsResource.CmsResourceDeleteMode siblingMode) throws CmsException {
        List<CmsResource> detailOnlyPages = null;
        if (this.isPossiblyDetailContent(resource)) {
            detailOnlyPages = this.getDetailContainerResources(cms, resource);
        }
        super.deleteResource(cms, securityManager, resource, siblingMode);
        if (detailOnlyPages != null) {
            for (CmsResource page : detailOnlyPages) {
                if (page.getState().isDeleted()) continue;
                try {
                    CmsLockUtil.ensureLock(cms, page);
                    cms.deleteResource(page, CmsResource.DELETE_PRESERVE_SIBLINGS);
                }
                catch (CmsException e) {
                    LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String getCachePropertyDefault() {
        return "element;locale;";
    }

    @Override
    public CmsParameterConfiguration getConfiguration() {
        CmsParameterConfiguration result = new CmsParameterConfiguration();
        CmsParameterConfiguration additional = super.getConfiguration();
        if (additional != null) {
            result.putAll(additional);
        }
        if (this.m_schema != null) {
            result.put(CONFIGURATION_SCHEMA, this.m_schema);
        }
        return result;
    }

    public I_CmsEditHandler getEditHandler(CmsObject cms) {
        String schema = this.getSchema();
        try {
            CmsXmlContentDefinition contentDefinition = CmsXmlContentDefinition.unmarshal(cms, schema);
            I_CmsXmlContentHandler handler = contentDefinition.getContentHandler();
            return handler.getEditHandler();
        }
        catch (CmsXmlException e) {
            LOG.error((Object)e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public CmsFormatterConfiguration getFormattersForResource(CmsObject cms, CmsResource resource) {
        CmsFormatterConfiguration result = null;
        CmsXmlContentDefinition cd = null;
        try {
            cd = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
            result = cd.getContentHandler().getFormatterConfiguration(cms, resource);
        }
        catch (CmsException cmsException) {
            // empty catch block
        }
        if (result == null) {
            LOG.warn((Object)Messages.get().getBundle().key("LOG_WARN_NO_FORMATTERS_DEFINED_1", cd == null ? resource.getRootPath() : cd.getSchemaLocation()));
            result = CmsFormatterConfiguration.EMPTY_CONFIGURATION;
        }
        return result;
    }

    @Override
    public String getGalleryPreviewProvider() {
        if (this.m_galleryPreviewProvider == null) {
            this.m_galleryPreviewProvider = this.getConfiguration().getString("gallery.preview.provider", "org.opencms.ade.galleries.preview.CmsBinaryPreviewProvider");
        }
        return this.m_galleryPreviewProvider;
    }

    @Override
    public int getLoaderId() {
        return 10;
    }

    public String getSchema() {
        return this.m_schema;
    }

    @Override
    public void initialize(CmsObject cms) {
        super.initialize(cms);
        if (this.m_schema != null) {
            try {
                if (cms.existsResource(this.m_schema)) {
                    CmsXmlContentDefinition.unmarshal(cms, this.m_schema);
                } else {
                    LOG.debug((Object)Messages.get().getBundle().key("LOG_WARN_SCHEMA_RESOURCE_DOES_NOT_EXIST_2", this.m_schema, this.getTypeName()));
                }
            }
            catch (Throwable e) {
                LOG.error((Object)Messages.get().getBundle().key("ERR_BAD_XML_SCHEMA_2", this.m_schema, this.getTypeName()), e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void moveResource(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, String destination) throws CmsException, CmsIllegalArgumentException {
        super.moveResource(cms, securityManager, resource, destination);
        if (this.isPossiblyDetailContent(resource)) {
            String rootDest = cms.getRequestContext().addSiteRoot(destination);
            CmsObject rootCms = OpenCms.initCmsObject(cms);
            rootCms.getRequestContext().setSiteRoot("");
            String srcParent = CmsResource.getParentFolder(resource.getRootPath());
            String srcName = CmsResource.getName(resource.getRootPath());
            String destParent = CmsResource.getParentFolder(rootDest);
            String destName = CmsResource.getName(rootDest);
            if (srcParent.equals(destParent) && !srcName.equals(destName)) {
                List<CmsResource> detailOnlyPages = this.getDetailContainerResources(cms, resource);
                for (CmsResource page : detailOnlyPages) {
                    if (page.getState().isDeleted()) continue;
                    String newPath = CmsStringUtil.joinPaths(CmsResource.getParentFolder(page.getRootPath()), destName);
                    CmsLockActionRecord lockRecord = null;
                    try {
                        lockRecord = CmsLockUtil.ensureLock(cms, page);
                        rootCms.moveResource(page.getRootPath(), newPath);
                    }
                    catch (Exception e) {
                        LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                    }
                    finally {
                        if (lockRecord == null || lockRecord.getChange() != CmsLockActionRecord.LockChange.locked) continue;
                        try {
                            CmsLockUtil.tryUnlock(rootCms, rootCms.readResource(page.getStructureId(), CmsResourceFilter.ALL));
                        }
                        catch (Exception e) {
                            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
                        }
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<CmsLink> parseLinks(CmsObject cms, CmsFile file) {
        CmsXmlContent xmlContent;
        if (file.getLength() == 0) {
            return Collections.emptyList();
        }
        long requestTime = cms.getRequestContext().getRequestTime();
        try {
            cms.getRequestContext().setRequestTime(Long.MIN_VALUE);
            xmlContent = CmsXmlContentFactory.unmarshal(cms, file);
        }
        catch (CmsException e) {
            if (LOG.isErrorEnabled()) {
                LOG.error((Object)org.opencms.db.Messages.get().getBundle().key("ERR_READ_RESOURCE_1", cms.getSitePath(file)), (Throwable)e);
            }
            List<CmsLink> list = Collections.emptyList();
            return list;
        }
        finally {
            cms.getRequestContext().setRequestTime(requestTime);
        }
        LinkedHashSet<CmsLink> links = new LinkedHashSet<CmsLink>();
        CmsLink xsdLink = this.getXsdLink(cms, xmlContent);
        if (xsdLink != null) {
            links.add(xsdLink);
        }
        List<Locale> locales = xmlContent.getLocales();
        for (Locale locale : locales) {
            List<I_CmsXmlContentValue> values = xmlContent.getValues(locale);
            for (I_CmsXmlContentValue value : values) {
                CmsLink link;
                A_CmsXmlContentValue refValue;
                if (value instanceof CmsXmlHtmlValue) {
                    CmsXmlHtmlValue htmlValue = (CmsXmlHtmlValue)value;
                    CmsLinkTable linkTable = htmlValue.getLinkTable();
                    Iterator<CmsLink> k = linkTable.iterator();
                    while (k.hasNext()) {
                        CmsLink link2 = k.next();
                        if (!link2.isInternal()) continue;
                        link2.checkConsistency(cms);
                        links.add(link2);
                    }
                } else if (value instanceof CmsXmlVfsFileValue) {
                    refValue = (CmsXmlVfsFileValue)value;
                    link = ((CmsXmlVfsFileValue)refValue).getLink(cms);
                    if (link != null) {
                        links.add(link);
                    }
                } else if (value instanceof CmsXmlVarLinkValue && (link = ((CmsXmlVarLinkValue)(refValue = (CmsXmlVarLinkValue)value)).getLink(cms)) != null && link.isInternal()) {
                    links.add(link);
                }
                if (!I_CmsXmlContentValue.SearchContentType.CONTENT.equals((Object)xmlContent.getHandler().getSearchContentType(value))) continue;
                String stringValue = value.getStringValue(cms);
                try {
                    CmsResource res;
                    if (null == stringValue || stringValue.trim().isEmpty() || !cms.existsResource(stringValue) || !CmsResourceTypeXmlContent.isXmlContent(res = cms.readResource(stringValue))) continue;
                    CmsLink link3 = new CmsLink("", CmsRelationType.INDEX_CONTENT, res.getStructureId(), res.getRootPath(), true);
                    links.add(link3);
                }
                catch (Throwable t) {
                    if (!LOG.isErrorEnabled()) continue;
                    LOG.error((Object)("Failed to add INDEX_CONTENT relation from resource " + file.getRootPath() + " to linked resource " + stringValue + "."), t);
                }
            }
        }
        return new ArrayList<CmsLink>(links);
    }

    @Override
    public void setDateExpired(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateExpired, boolean recursive) throws CmsException {
        try {
            this.applyReverseAvailabilityMapping(cms, resource, CmsMappingResolutionContext.AttributeType.expiration, dateExpired);
        }
        catch (Exception e) {
            LOG.error((Object)("Reverse availability mapping failed: " + e.getLocalizedMessage()), (Throwable)e);
        }
        super.setDateExpired(cms, securityManager, resource, dateExpired, recursive);
    }

    @Override
    public void setDateReleased(CmsObject cms, CmsSecurityManager securityManager, CmsResource resource, long dateReleased, boolean recursive) throws CmsException {
        try {
            this.applyReverseAvailabilityMapping(cms, resource, CmsMappingResolutionContext.AttributeType.release, dateReleased);
        }
        catch (Exception e) {
            LOG.error((Object)("Reverse availability mapping failed: " + e.getLocalizedMessage()), (Throwable)e);
        }
        super.setDateReleased(cms, securityManager, resource, dateReleased, recursive);
    }

    @Override
    public CmsFile writeFile(CmsObject cms, CmsSecurityManager securityManager, CmsFile resource) throws CmsException {
        securityManager.checkPermissions(cms.getRequestContext(), (CmsResource)resource, CmsPermissionSet.ACCESS_WRITE, true, CmsResourceFilter.ALL);
        CmsXmlContent xmlContent = CmsXmlContentFactory.unmarshal(cms, resource, true);
        resource = xmlContent.getHandler().prepareForWrite(cms, xmlContent, resource);
        return super.writeFile(cms, securityManager, resource);
    }

    protected Locale getLocaleForNewContent(CmsObject cms, CmsSecurityManager securityManager, String resourcename, List<CmsProperty> properties) {
        Locale locale = (Locale)cms.getRequestContext().getAttribute(CmsRequestContext.ATTRIBUTE_NEW_RESOURCE_LOCALE);
        if (locale != null) {
            return locale;
        }
        List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, CmsResource.getParentFolder(resourcename));
        return locales.get(0);
    }

    protected CmsLink getXsdLink(CmsObject cms, CmsXmlContent xmlContent) {
        String schema = xmlContent.getContentDefinition().getSchemaLocation();
        if (schema.startsWith("opencms://")) {
            if (CmsXmlEntityResolver.isInternalId(schema)) {
                return null;
            }
            schema = schema.substring("opencms://".length() - 1);
        } else if (CmsXmlEntityResolver.isCachedSystemId(schema)) {
            return null;
        }
        try {
            CmsResource schemaRes = cms.readResource(cms.getRequestContext().removeSiteRoot(schema));
            CmsLink xsdLink = new CmsLink(null, CmsRelationType.XSD, schemaRes.getStructureId(), schemaRes.getRootPath(), true);
            return xsdLink;
        }
        catch (CmsException e) {
            LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            return null;
        }
    }

    boolean isPossiblyDetailContent(CmsResource resource) {
        if (CmsResourceTypeXmlContainerPage.isContainerPage(resource)) {
            return false;
        }
        I_CmsResourceType type = OpenCms.getResourceManager().getResourceType(resource);
        return !(type instanceof CmsResourceTypeXmlAdeConfiguration);
    }

    private boolean applyReverseAvailabilityMapping(CmsObject cms, CmsResource resource, CmsMappingResolutionContext.AttributeType attr, long date) throws CmsException {
        Object obj = cms.getRequestContext().getAttribute(ATTR_REVERSE_AVAILABILITY_MAPPING);
        if (obj == null || !Boolean.TRUE.equals(obj)) {
            return false;
        }
        CmsXmlContentDefinition contentDef = CmsXmlContentDefinition.getContentDefinitionForResource(cms, resource);
        I_CmsXmlContentHandler handler = contentDef.getContentHandler();
        if (handler.canUseReverseAvailabilityMapping(attr)) {
            CmsFile file = cms.readFile(resource);
            CmsXmlContent content = CmsXmlContentFactory.unmarshal(cms, file);
            List<Locale> locales = OpenCms.getLocaleManager().getDefaultLocales(cms, resource);
            handler.applyReverseAvailabilityMapping(cms, content, attr, locales, date);
            CmsObject writeCms = OpenCms.initCmsObject(cms);
            file.setContents(content.marshal());
            writeCms.writeFile(file);
            return true;
        }
        LOG.debug((Object)"No reverse availability mapping.");
        return false;
    }

    private List<CmsResource> getDetailContainerResources(CmsObject cms, CmsResource res) throws CmsException {
        CmsRelationFilter filter = CmsRelationFilter.relationsFromStructureId(res.getStructureId()).filterType(CmsRelationType.DETAIL_ONLY);
        ArrayList result = Lists.newArrayList();
        List<CmsRelation> relations = cms.readRelations(filter);
        for (CmsRelation relation : relations) {
            try {
                result.add(relation.getTarget(cms, CmsResourceFilter.ALL));
            }
            catch (Exception e) {
                LOG.error((Object)e.getLocalizedMessage(), (Throwable)e);
            }
        }
        return result;
    }
}

