/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.List;
import org.opencms.util.CmsStringUtil;

public class CmsHistoryVersion
implements IsSerializable {
    private OfflineOnline m_offlineOnline;
    private Integer m_versionNumber;

    public CmsHistoryVersion(Integer versionNumber, OfflineOnline offlineOnline) {
        this.m_offlineOnline = offlineOnline;
        this.m_versionNumber = versionNumber;
    }

    protected CmsHistoryVersion() {
    }

    public static CmsHistoryVersion fromString(String s) {
        List<String> l = CmsStringUtil.splitAsList(s, ":");
        if (l.size() == 2) {
            Integer ver = null;
            try {
                ver = Integer.valueOf(l.get(0));
            }
            catch (Exception exception) {
                // empty catch block
            }
            OfflineOnline onlineStatus = "null".equals("" + l.get(1)) ? null : OfflineOnline.valueOf(l.get(1));
            return new CmsHistoryVersion(ver, onlineStatus);
        }
        return null;
    }

    public Integer getVersionNumber() {
        return this.m_versionNumber;
    }

    public boolean isOffline() {
        return OfflineOnline.offline.equals((Object)this.m_offlineOnline);
    }

    public boolean isOnline() {
        return OfflineOnline.online.equals((Object)this.m_offlineOnline);
    }

    public String toString() {
        return this.m_versionNumber + ":" + (Object)((Object)this.m_offlineOnline);
    }

    public static enum OfflineOnline {
        offline,
        online;

    }
}

