/*
 * Decompiled with CFR 0.152.
 */
package org.opencms.gwt.shared;

import com.google.common.base.Joiner;
import com.google.gwt.user.client.rpc.IsSerializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.opencms.file.CmsResource;
import org.opencms.util.CmsStringUtil;

public class CmsUploadRestrictionInfo
implements IsSerializable {
    public static final String KEY_ENABLED = "enabled";
    public static final String KEY_TYPES = "types";
    public static final String UNRESTRICTED_UPLOADS = "enabled:true|types:*";
    private Map<String, Boolean> m_uploadEnabledMap = new HashMap<String, Boolean>();
    private Map<String, Set<String>> m_uploadTypesMap = new HashMap<String, Set<String>>();

    protected CmsUploadRestrictionInfo() {
    }

    static String normalizePath(String path) {
        if (!path.endsWith("/")) {
            path = path + "/";
        }
        return path;
    }

    public boolean checkTypeAllowed(String path, String extension) {
        Set<String> types = this.getTypes(path);
        if (extension.startsWith(".")) {
            extension = extension.substring(1);
        }
        boolean result = types.contains(extension = extension.toLowerCase()) || types.contains("*");
        return result;
    }

    public String getAcceptAttribute(String path) {
        Set<String> types = this.getTypes(path);
        ArrayList<String> suffixes = new ArrayList<String>();
        for (String type : types) {
            if ("*".equals(type)) {
                return "";
            }
            suffixes.add("." + type);
        }
        return Joiner.on((String)",").join(suffixes);
    }

    public boolean isUploadEnabled(String originalPath) {
        String path = originalPath;
        while (path != null) {
            Boolean value = this.m_uploadEnabledMap.get(path = CmsUploadRestrictionInfo.normalizePath(path));
            if (value != null) {
                return value;
            }
            path = CmsResource.getParentFolder(path);
        }
        return true;
    }

    protected Set<String> getTypes(String path) {
        while (path != null) {
            Set<String> value = this.m_uploadTypesMap.get(path = CmsUploadRestrictionInfo.normalizePath(path));
            if (value != null) {
                return value;
            }
            path = CmsResource.getParentFolder(path);
        }
        return Collections.emptySet();
    }

    public static class Builder {
        private Map<String, Boolean> m_tempUploadEnabledMap = new HashMap<String, Boolean>();
        private Map<String, Set<String>> uploadTypesMap = new HashMap<String, Set<String>>();

        public Builder add(String path, String info) {
            String typesStr;
            Map<String, String> parsedInfo = CmsStringUtil.splitAsMap(info, "|", ":");
            path = CmsUploadRestrictionInfo.normalizePath(path);
            String enabledStr = parsedInfo.get(CmsUploadRestrictionInfo.KEY_ENABLED);
            if (enabledStr != null) {
                this.m_tempUploadEnabledMap.put(path, Boolean.valueOf(enabledStr));
            }
            if ((typesStr = parsedInfo.get(CmsUploadRestrictionInfo.KEY_TYPES)) != null) {
                HashSet<String> types = new HashSet<String>();
                for (String type : typesStr.split(",")) {
                    if ((type = type.trim().toLowerCase()).startsWith(".")) {
                        type = type.substring(1);
                    }
                    if (type.length() <= 0) continue;
                    types.add(type);
                }
                this.uploadTypesMap.put(path, types);
            }
            return this;
        }

        public CmsUploadRestrictionInfo build() {
            CmsUploadRestrictionInfo result = new CmsUploadRestrictionInfo();
            result.m_uploadEnabledMap = this.m_tempUploadEnabledMap;
            result.m_uploadTypesMap = this.uploadTypesMap;
            return result;
        }
    }
}

